/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager m_cacheManagerInstance = null;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = " ";
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected int m_failoverEnabledCacheCount = 0;
    protected OracleFailoverEventHandlerThread m_failoverEventHandlerThread = null;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] m_fatalErrorCodes = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    private OracleConnectionCacheManager() {
    }

    protected void checkAndStartThread(Thread thread) throws SQLException {
        try {
            if (!thread.isAlive()) {
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        if (this.m_failoverEventHandlerThread != null) {
            try {
                this.m_failoverEventHandlerThread.interrupt();
                this.m_failoverEventHandlerThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.m_failoverEventHandlerThread = null;
        }
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        this.cleanupFCFWorkerThread(oracleImplicitConnectionCache);
        if (this.m_failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.m_failoverEnabledCacheCount;
    }

    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        if (oracleImplicitConnectionCache.m_failoverWorkerThread != null) {
            try {
                if (oracleImplicitConnectionCache.m_failoverWorkerThread.isAlive()) {
                    oracleImplicitConnectionCache.m_failoverWorkerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {}
            oracleImplicitConnectionCache.m_failoverWorkerThread = null;
        }
    }

    public void createCache(String string, OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        if (string == null) {
            DatabaseError.throwSqlException(138);
        }
        if (this.m_connCache.containsKey(string)) {
            DatabaseError.throwSqlException(140);
        }
        OracleImplicitConnectionCache oracleImplicitConnectionCache = new OracleImplicitConnectionCache(oracleDataSource, properties);
        oracleImplicitConnectionCache.m_cacheName = string;
        oracleDataSource.m_odsCache = oracleImplicitConnectionCache;
        this.m_connCache.put(string, oracleImplicitConnectionCache);
        if (oracleDataSource.getFastConnectionFailoverEnabled()) {
            if (this.m_failoverEventHandlerThread == null) {
                this.m_failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
            }
            ++this.m_failoverEnabledCacheCount;
            this.checkAndStartThread(this.m_failoverEventHandlerThread);
        }
    }

    public String createCache(OracleDataSource oracleDataSource, Properties properties) throws SQLException {
        String string = null;
        if (oracleDataSource == null || !oracleDataSource.getConnectionCachingEnabled()) {
            DatabaseError.throwSqlException(137);
        }
        string = oracleDataSource.m_connCacheName != null ? oracleDataSource.m_connCacheName : String.valueOf(oracleDataSource.m_dataSourceName) + "#0x" + Integer.toHexString(this.m_connCache.size());
        this.createCache(string, oracleDataSource, properties);
        return string;
    }

    public void disableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.disableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void enableCache(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.enableConnectionCache();
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public boolean existsCache(String string) throws SQLException {
        return this.m_connCache.containsKey(string);
    }

    protected boolean failoverEnabledCacheExists() {
        return this.m_failoverEnabledCacheCount > 0;
    }

    public String[] getCacheNameList() throws SQLException {
        return this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
    }

    public Properties getCacheProperties(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getConnectionCacheProperties();
        }
        DatabaseError.throwSqlException(141);
        return null;
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        try {
            if (m_cacheManagerInstance == null) {
                m_cacheManagerInstance = new OracleConnectionCacheManager();
            }
        }
        catch (RuntimeException runtimeException) {}
        return m_cacheManagerInstance;
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.m_fatalErrorCodes;
    }

    public int getNumberOfActiveConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.getNumberOfCheckedOutConnections();
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public int getNumberOfAvailableConnections(String string) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            return oracleImplicitConnectionCache.m_cacheSize;
        }
        DatabaseError.throwSqlException(141);
        return 0;
    }

    public Map getStatistics(String string) throws SQLException {
        Map map = null;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        if (this.m_connCache != null && (oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string)) != null) {
            map = oracleImplicitConnectionCache.getStatistics();
        }
        return map;
    }

    private void invokeFailoverProcessingThreads(int n, String string, String string2, String string3, String string4, String string5, int n2) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<OracleFailoverWorkerThread> arrayList = new ArrayList<OracleFailoverWorkerThread>();
        if (n == 256) {
            bl = true;
        }
        if (n == 512) {
            bl2 = true;
        }
        Iterator iterator = this.m_connCache.values().iterator();
        while (iterator.hasNext()) {
            oracleImplicitConnectionCache = (OracleImplicitConnectionCache)iterator.next();
            if ((!bl || !string.equalsIgnoreCase(oracleImplicitConnectionCache.m_dataSourceServiceName)) && !bl2) continue;
            OracleFailoverWorkerThread oracleFailoverWorkerThread = new OracleFailoverWorkerThread(oracleImplicitConnectionCache, n, string2, string3, string4, string5, n2);
            this.checkAndStartThread(oracleFailoverWorkerThread);
            oracleImplicitConnectionCache.m_failoverWorkerThread = oracleFailoverWorkerThread;
            arrayList.add(oracleFailoverWorkerThread);
        }
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            OracleFailoverWorkerThread oracleFailoverWorkerThread = (OracleFailoverWorkerThread)arrayList.get(n4);
            try {
                oracleFailoverWorkerThread.join();
            }
            catch (InterruptedException interruptedException) {}
            oracleFailoverWorkerThread = null;
            ++n4;
        }
        arrayList.clear();
    }

    public boolean isFatalConnectionError(SQLException sQLException) {
        boolean bl = false;
        int n = sQLException.getErrorCode();
        if (n == 3113 || n == 3114 || n == 1033 || n == 1034 || n == 1089 || n == 1090 || n == 17002) {
            bl = true;
        }
        if (!bl && this.m_fatalErrorCodes != null) {
            int n2 = 0;
            while (n2 < this.m_fatalErrorCodes.length) {
                if (n == this.m_fatalErrorCodes[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public void purgeCache(String string, boolean bl) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.purgeCacheConnections(bl);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void refreshCache(String string, int n) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            if (n == 4096 || n == 8192) {
                oracleImplicitConnectionCache.refreshCacheConnections(n);
            } else {
                DatabaseError.throwSqlException(68);
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void reinitializeCache(String string, Properties properties) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            this.disableCache(string);
            oracleImplicitConnectionCache.reinitializeCacheConnections(properties);
            this.enableCache(string);
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public void removeCache(String string, long l) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.remove(string);
        if (oracleImplicitConnectionCache != null) {
            oracleImplicitConnectionCache.disableConnectionCache();
            if (l > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (oracleImplicitConnectionCache.m_cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.cleanupFCFThreads(oracleImplicitConnectionCache);
            }
            oracleImplicitConnectionCache.closeConnectionCache();
            oracleImplicitConnectionCache = null;
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        if (nArray != null) {
            this.m_fatalErrorCodes = nArray;
        }
    }

    public synchronized void setConnectionPoolDataSource(String string, ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        OracleImplicitConnectionCache oracleImplicitConnectionCache = (OracleImplicitConnectionCache)this.m_connCache.get(string);
        if (oracleImplicitConnectionCache != null) {
            if (oracleImplicitConnectionCache.m_cacheSize > 0) {
                DatabaseError.throwSqlException(78);
            } else {
                ((OracleConnectionPoolDataSource)connectionPoolDataSource).makeURL();
                ((OracleConnectionPoolDataSource)connectionPoolDataSource).setURL(((OracleConnectionPoolDataSource)connectionPoolDataSource).m_url);
                oracleImplicitConnectionCache.m_cpds = (OracleConnectionPoolDataSource)connectionPoolDataSource;
            }
        } else {
            DatabaseError.throwSqlException(141);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void verifyAndHandleEvent(int n, byte[] byArray) throws SQLException {
        StringTokenizer stringTokenizer;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        StringTokenizer stringTokenizer2 = stringTokenizer = new StringTokenizer(new String(byArray), EVENT_DELIMITER);
        synchronized (stringTokenizer2) {
            while (true) {
                if (!stringTokenizer.hasMoreTokens()) {
                    this.invokeFailoverProcessingThreads(n, string, string2, string3, string4, string5, n2);
                    return;
                }
                String string6 = stringTokenizer.nextToken();
                int n3 = string6.length();
                int n4 = string6.indexOf("=");
                if (n3 < 0 || n4 < 0) continue;
                String string7 = string6.substring(0, n4).trim();
                String string8 = string6.substring(n4 + 1, n3).trim();
                if (string7.equalsIgnoreCase("version") && !string8.equals("1.0")) {
                    DatabaseError.throwSqlException(146);
                }
                if (string7.equalsIgnoreCase("service")) {
                    string = string8;
                }
                if (string7.equalsIgnoreCase("instance") && string8.length() > 0) {
                    string2 = string8;
                }
                if (string7.equalsIgnoreCase("database") && string8.length() > 0) {
                    string3 = string8;
                }
                if (string7.equalsIgnoreCase("host")) {
                    string4 = string8;
                }
                if (string7.equalsIgnoreCase("status")) {
                    string5 = string8;
                }
                if (!string7.equalsIgnoreCase("card")) continue;
                try {
                    n2 = Integer.parseInt(string8);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

