/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(oracleTypeCOLLECTION, connection);
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super(sQLName, oracleTypeCOLLECTION, connection);
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        ArrayDescriptor arrayDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.check_error(60, "Invalid arguments");
        }
        if ((arrayDescriptor = (ArrayDescriptor)((OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (OracleConnection)connection)).getName())) == null) {
            arrayDescriptor = new ArrayDescriptor(sQLName, connection);
            ((OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
        }
        return arrayDescriptor;
    }

    public String descType() throws SQLException {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        string = this.descType(stringBuffer, 0);
        return string;
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        Object object;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "  ";
            ++n2;
        }
        String string2 = String.valueOf(string) + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            object = StructDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            ((StructDescriptor)object).descType(stringBuffer, n + 1);
        } else if (n3 == 2003) {
            object = ArrayDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            ((ArrayDescriptor)object).descType(stringBuffer, n + 1);
        } else if (n3 == 2007) {
            object = OpaqueDescriptor.createDescriptor(this.getBaseName(), this.m_conn);
            ((OpaqueDescriptor)object).descType(stringBuffer, n + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        object = stringBuffer.substring(0, stringBuffer.length());
        return object;
    }

    public int getArrayType() throws SQLException {
        int n = ((OracleTypeCOLLECTION)this.m_pickler).getUserCode();
        return n;
    }

    public String getBaseName() throws SQLException {
        String string = null;
        switch (this.getBaseType()) {
            case 12: {
                string = "VARCHAR";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case -2: {
                string = "RAW";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 2: {
                string = "NUMBER";
                break;
            }
            case 8: {
                string = "DOUBLE";
                break;
            }
            case 3: {
                string = "DECIMAL";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case -101: {
                string = "TIMESTAMPTZ";
                break;
            }
            case -102: {
                string = "TIMESTAMPLTZ";
                break;
            }
            case 2004: {
                string = "BLOB";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case -13: {
                string = "BFILE";
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                string = oracleNamedType.getFullName();
                break;
            }
            case 2006: {
                OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                string = "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public int getBaseType() throws SQLException {
        int n = ((OracleTypeCOLLECTION)this.m_pickler).getElementType().getTypeCode();
        return n;
    }

    public static int getCacheStyle(ARRAY aRRAY) throws SQLException {
        int n = 2;
        if (aRRAY.getAutoIndexing() && (aRRAY.getAccessDirection() == 2 || aRRAY.getAccessDirection() == 3)) {
            n = 1;
        }
        return n;
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.m_pickler).getElementType();
        return oracleType;
    }

    public long getMaxLength() throws SQLException {
        long l = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.m_pickler).getMaxLength() : 0L;
        return l;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.m_pickler;
    }

    public int getTypeCode() throws SQLException {
        int n = 2003;
        return n;
    }

    private void initPickler() throws SQLException {
        try {
            OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            oracleTypeADT.init(this.m_conn);
            this.m_pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type: \"" + this.getName() + "\"");
        }
    }

    public int length(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, byArray);
        int n = this.toLength(aRRAY);
        return n;
    }

    public static Object[] makeJavaArray(int n, int n2) throws SQLException {
        Object[] objectArray = null;
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = new BigDecimal[n];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new String[n];
                break;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = new Timestamp[n];
                break;
            }
            case 2002: 
            case 2008: {
                objectArray = new Object[n];
                break;
            }
            case -13: {
                objectArray = new BFILE[n];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n];
                break;
            }
            case -3: 
            case -2: {
                objectArray = (Object[])new byte[n][];
                break;
            }
            case 2006: {
                objectArray = new REF[n];
                break;
            }
            case 2003: {
                objectArray = new Object[n];
                break;
            }
            default: {
                DatabaseError.check_error(1, "makeJavaArray doesn't support type " + n2);
            }
        }
        return objectArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public Datum[] toArray(Object object) throws SQLException {
        Datum[] datumArray = this.toOracleArray(object, 1L, -1);
        return datumArray;
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        Datum[] datumArray = null;
        if (byArray != null) {
            ARRAY aRRAY = new ARRAY(this, this.m_conn, byArray);
            datumArray = this.toOracleArray(aRRAY, 1L, -1, false);
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        Object[] objectArray = null;
        if (n3 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
            int n4 = 0;
            while (resultSet.next()) {
                objectArray[n4] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n4;
            }
            resultSet.close();
        }
        return objectArray;
    }

    byte[] toBytes(ARRAY aRRAY, boolean bl) throws SQLException {
        byte[] byArray = aRRAY.shareBytes();
        if (byArray == null) {
            if (aRRAY.m_datumArray != null || aRRAY.m_locator != null) {
                byArray = this.m_pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.setShareBytes(null);
                }
            } else if (aRRAY.m_objArray != null) {
                aRRAY.m_datumArray = this.toOracleArray(aRRAY.m_objArray, 1L, -1);
                byArray = this.m_pickler.linearize(aRRAY);
                if (!bl) {
                    aRRAY.m_datumArray = null;
                    aRRAY.setShareBytes(null);
                }
            } else {
                DatabaseError.throwSqlException(1, "Array is in inconsistent status");
            }
        } else if (aRRAY.m_imgLength != 0L && (aRRAY.m_imgOffset != 0L || aRRAY.m_imgLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)aRRAY.m_imgLength];
            System.arraycopy(byArray, (int)aRRAY.m_imgOffset, byArray2, 0, (int)aRRAY.m_imgLength);
            aRRAY.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toArray(objectArray);
        byte[] byArray = this.toBytes(datumArray);
        return byArray;
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, datumArray);
        return this.m_pickler.linearize(aRRAY);
    }

    Object[] toJavaArray(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (aRRAY.m_objArray != null) {
            objectArray = (Object[])((Object[])aRRAY.m_objArray).clone();
            int n2 = objectArray.length;
            int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
            if (n3 <= 0) {
                Object[] objectArray2 = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
                return objectArray2;
            }
            objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
            System.arraycopy(aRRAY.m_objArray, (int)l - 1, objectArray, 0, n3);
        } else {
            if (aRRAY.m_datumArray != null) {
                objectArray = (Object[])this.toJavaArray(aRRAY.m_datumArray, l, n, map);
            } else if (aRRAY.m_locator != null) {
                objectArray = this.toArrayFromLocator(aRRAY.m_locator, l, n, map);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, 2, map);
                objectArray = aRRAY.m_locator != null ? this.toArrayFromLocator(aRRAY.m_locator, l, n, map) : (Object[])aRRAY.m_objArray;
            } else {
                DatabaseError.throwSqlException(1);
            }
            aRRAY.m_objArray = bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null ? objectArray.clone() : null;
        }
        return objectArray;
    }

    private Object toJavaArray(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n2 < 0) {
            n2 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n2, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT sTRUCT = null;
            int n3 = 0;
            while (n3 < n2) {
                sTRUCT = (STRUCT)datumArray[(int)l + n3 - 1];
                objectArray[n3] = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
                ++n3;
            }
        } else {
            Datum datum = null;
            int n4 = 0;
            while (n4 < n2) {
                datum = datumArray[(int)l + n4 - 1];
                objectArray[n4] = datum != null ? datum.toJdbc() : null;
                ++n4;
            }
        }
        return objectArray;
    }

    int toLength(ARRAY aRRAY) throws SQLException {
        if (aRRAY.m_numElems == -1) {
            if (aRRAY.m_datumArray != null) {
                aRRAY.m_numElems = aRRAY.m_datumArray.length;
            } else if (aRRAY.m_objArray != null) {
                if (aRRAY.m_objArray instanceof Object[]) {
                    aRRAY.m_numElems = ((Object[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof int[]) {
                    aRRAY.m_numElems = ((long[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof long[]) {
                    aRRAY.m_numElems = ((float[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof float[]) {
                    aRRAY.m_numElems = ((double[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof double[]) {
                    aRRAY.m_numElems = ((boolean[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof boolean[]) {
                    aRRAY.m_numElems = ((int[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof byte[]) {
                    aRRAY.m_numElems = ((byte[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof short[]) {
                    aRRAY.m_numElems = ((short[])aRRAY.m_objArray).length;
                } else if (aRRAY.m_objArray instanceof char[]) {
                    aRRAY.m_numElems = ((char[])aRRAY.m_objArray).length;
                }
            } else if (aRRAY.m_locator != null) {
                aRRAY.m_numElems = this.toLengthFromLocator(aRRAY.m_locator);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, 0, null);
                if (aRRAY.m_numElems == -1) {
                    if (aRRAY.m_locator != null) {
                        aRRAY.m_numElems = this.toLengthFromLocator(aRRAY.m_locator);
                    } else {
                        DatabaseError.throwSqlException(1, "Unable to get array length");
                    }
                }
            } else {
                DatabaseError.check_error(1, "Array is in inconsistent status");
            }
        }
        int n = aRRAY.m_numElems;
        return n;
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.m_conn, null);
        aRRAY.setLocator(byArray);
        int n = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.m_conn.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (oracleResultSet.next()) {
            n = oracleResultSet.getInt(1);
        } else {
            DatabaseError.check_error(1, "Fail to access array storage table");
        }
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n;
    }

    Object toNumericArray(ARRAY aRRAY, long l, int n, int n2, boolean bl) throws SQLException {
        if (!(this.getElementType() instanceof OracleTypeNUMBER) && !(this.getElementType() instanceof OracleTypeFLOAT)) {
            DatabaseError.throwSqlException(23);
        }
        Object object = null;
        if (aRRAY.m_objArray != null) {
            if (n2 == 4 && aRRAY.m_objArray instanceof int[]) {
                int n3 = ((int[])aRRAY.m_objArray).length;
                if (l > (long)n3) {
                    return new int[0];
                }
                n3 = (int)(n == -1 ? (long)n3 - l + 1L : Math.min((long)n3 - l + 1L, (long)n));
                int[] nArray = new int[n3];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, nArray, 0, n3);
                object = nArray;
            } else if (n2 == 5 && aRRAY.m_objArray instanceof double[]) {
                int n4 = ((double[])aRRAY.m_objArray).length;
                if (l > (long)n4) {
                    return new double[0];
                }
                n4 = (int)(n == -1 ? (long)n4 - l + 1L : Math.min((long)n4 - l + 1L, (long)n));
                double[] dArray = new double[n4];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, dArray, 0, n4);
                object = dArray;
            } else if (n2 == 6 && aRRAY.m_objArray instanceof float[]) {
                int n5 = ((float[])aRRAY.m_objArray).length;
                if (l > (long)n5) {
                    return new float[0];
                }
                n5 = (int)(n == -1 ? (long)n5 - l + 1L : Math.min((long)n5 - l + 1L, (long)n));
                float[] fArray = new float[n5];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, fArray, 0, n5);
                object = fArray;
            } else if (n2 == 7 && aRRAY.m_objArray instanceof long[]) {
                int n6 = ((long[])aRRAY.m_objArray).length;
                if (l > (long)n6) {
                    return new long[0];
                }
                n6 = (int)(n == -1 ? (long)n6 - l + 1L : Math.min((long)n6 - l + 1L, (long)n));
                long[] lArray = new long[n6];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, lArray, 0, n6);
                object = lArray;
            } else if (n2 == 8 && aRRAY.m_objArray instanceof short[]) {
                int n7 = ((short[])aRRAY.m_objArray).length;
                if (l > (long)n7) {
                    return new short[0];
                }
                n7 = (int)(n == -1 ? (long)n7 - l + 1L : Math.min((long)n7 - l + 1L, (long)n));
                short[] sArray = new short[n7];
                System.arraycopy(aRRAY.m_objArray, (int)l - 1, sArray, 0, n7);
                object = sArray;
            }
        } else {
            if (aRRAY.m_datumArray != null) {
                object = this.toNumericArray(aRRAY.m_datumArray, l, n, n2);
            } else if (aRRAY.m_locator != null) {
                object = this.toNumericArrayFromLocator(aRRAY.m_locator, l, n, n2);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, n2, null);
                object = aRRAY.m_locator != null ? this.toNumericArrayFromLocator(aRRAY.m_locator, l, n, n2) : aRRAY.m_objArray;
            } else {
                DatabaseError.throwSqlException(1);
            }
            if (!bl) {
                aRRAY.m_objArray = null;
            }
        }
        return object;
    }

    private Object toNumericArray(Datum[] datumArray, long l, int n, int n2) throws SQLException {
        Object[] objectArray = null;
        int n3 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 == 4) {
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                Datum datum = datumArray[(int)l + n4 - 1];
                if (datum != null) {
                    nArray[n4] = datum.intValue();
                }
                ++n4;
            }
            objectArray = nArray;
        } else if (n2 == 5) {
            double[] dArray = new double[n3];
            int n5 = 0;
            while (n5 < n3) {
                Datum datum = datumArray[(int)l + n5 - 1];
                if (datum != null) {
                    dArray[n5] = datum.doubleValue();
                }
                ++n5;
            }
            objectArray = dArray;
        } else if (n2 == 6) {
            float[] fArray = new float[n3];
            int n6 = 0;
            while (n6 < n3) {
                Datum datum = datumArray[(int)l + n6 - 1];
                if (datum != null) {
                    fArray[n6] = datum.floatValue();
                }
                ++n6;
            }
            objectArray = fArray;
        } else if (n2 == 7) {
            long[] lArray = new long[n3];
            int n7 = 0;
            while (n7 < n3) {
                Datum datum = datumArray[(int)l + n7 - 1];
                if (datum != null) {
                    lArray[n7] = datum.longValue();
                }
                ++n7;
            }
            objectArray = lArray;
        } else if (n2 == 8) {
            short[] sArray = new short[n3];
            int n8 = 0;
            while (n8 < n3) {
                Datum datum = datumArray[(int)l + n8 - 1];
                if (datum != null) {
                    sArray[n8] = ((NUMBER)datum).shortValue();
                }
                ++n8;
            }
            objectArray = sArray;
        } else {
            DatabaseError.throwSqlException(23);
        }
        return objectArray;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l, int n, int n2) throws SQLException {
        Object[] objectArray = null;
        int n3 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, null);
        int n4 = 0;
        if (n2 == 4) {
            int[] nArray = new int[n3];
            while (resultSet.next() && n4 < n3) {
                nArray[n4++] = ((OracleResultSet)resultSet).getInt(2);
            }
            resultSet.close();
            objectArray = nArray;
        } else if (n2 == 5) {
            double[] dArray = new double[n3];
            while (resultSet.next() && n4 < n3) {
                dArray[n4++] = ((OracleResultSet)resultSet).getDouble(2);
            }
            resultSet.close();
            objectArray = dArray;
        } else if (n2 == 6) {
            float[] fArray = new float[n3];
            while (resultSet.next() && n4 < n3) {
                fArray[n4++] = ((OracleResultSet)resultSet).getFloat(2);
            }
            resultSet.close();
            objectArray = fArray;
        } else if (n2 == 7) {
            long[] lArray = new long[n3];
            while (resultSet.next() && n4 < n3) {
                lArray[n4++] = ((OracleResultSet)resultSet).getLong(2);
            }
            resultSet.close();
            objectArray = lArray;
        } else if (n2 == 8) {
            short[] sArray = new short[n3];
            while (resultSet.next() && n4 < n3) {
                sArray[n4++] = ((OracleResultSet)resultSet).getShort(2);
            }
            resultSet.close();
            objectArray = sArray;
        } else {
            DatabaseError.throwSqlException(23);
        }
        return objectArray;
    }

    Datum[] toOracleArray(Object object, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            OracleType oracleType = this.getElementType();
            datumArray = oracleType.toDatumArray(object, this.m_conn, l, n);
        }
        return datumArray;
    }

    Datum[] toOracleArray(ARRAY aRRAY, long l, int n, boolean bl) throws SQLException {
        Datum[] datumArray = aRRAY.m_datumArray;
        if (datumArray == null) {
            if (aRRAY.m_objArray != null) {
                datumArray = this.toOracleArray(aRRAY.m_objArray, l, n);
            } else if (aRRAY.m_locator != null) {
                datumArray = this.toOracleArrayFromLocator(aRRAY.m_locator, l, n, null);
            } else if (aRRAY.shareBytes() != null) {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, l, n, 1, null);
                datumArray = aRRAY.m_locator != null ? this.toOracleArrayFromLocator(aRRAY.m_locator, l, n, null) : aRRAY.m_datumArray;
                if (!bl) {
                    aRRAY.m_datumArray = null;
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else {
            if (l > (long)datumArray.length) {
                return new Datum[0];
            }
            int n2 = (int)(n == -1 ? (long)datumArray.length - l + 1L : Math.min((long)datumArray.length - l + 1L, (long)n));
            datumArray = new Datum[n2];
            System.arraycopy(aRRAY.m_datumArray, (int)l - 1, datumArray, 0, n2);
        }
        Datum[] datumArray2 = null;
        if (bl) {
            aRRAY.m_datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        int n2 = this.toLengthFromLocator(byArray);
        int n3 = (int)(n == -1 ? (long)n2 - l + 1L : Math.min((long)n2 - l + 1L, (long)n));
        Datum[] datumArray = null;
        if (n3 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n3];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l, n, map);
            int n4 = 0;
            while (resultSet.next()) {
                datumArray[n4] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n4;
            }
            resultSet.close();
        }
        return datumArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l, int n, Map map, boolean bl) throws SQLException {
        ResultSet resultSet = null;
        if (aRRAY.m_datumArray != null) {
            resultSet = this.toResultSet(aRRAY.m_datumArray, l, n, map);
        } else if (aRRAY.m_locator != null) {
            resultSet = this.toResultSetFromLocator(aRRAY.m_locator, l, n, map);
        } else if (aRRAY.m_objArray != null) {
            resultSet = this.toResultSet(this.toOracleArray(aRRAY.m_objArray, l, n), 1L, -1, map);
        } else if (aRRAY.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.m_pickler).isInlineImage(aRRAY.shareBytes(), (int)aRRAY.m_imgOffset)) {
                resultSet = this.toResultSetFromImage(aRRAY, l, n, map);
            } else {
                this.m_pickler.unlinearize(aRRAY.shareBytes(), aRRAY.m_imgOffset, aRRAY, 1, null);
                if (aRRAY.m_locator != null) {
                    resultSet = this.toResultSetFromLocator(aRRAY.m_locator, l, n, map);
                } else {
                    DatabaseError.throwSqlException(1);
                }
            }
        }
        if (resultSet == null) {
            DatabaseError.check_error(1, "Unable to create array ResultSet");
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.m_pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, l, n, map, false);
        }
        return resultSet;
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        ResultSet resultSet = null;
        if (byArray != null) {
            ARRAY aRRAY = (ARRAY)this.m_pickler.unlinearize(byArray, 0L, null, 1, null);
            resultSet = this.toResultSet(aRRAY, 1L, -1, map, false);
        }
        return resultSet;
    }

    public ResultSet toResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = null;
        resultSet = n == -1 ? this.m_conn.newArrayDataResultSet(datumArray, l, datumArray.length, map) : this.m_conn.newArrayDataResultSet(datumArray, l, n, map);
        return resultSet;
    }

    public ResultSet toResultSetFromImage(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = this.m_conn.newArrayDataResultSet(aRRAY, l, n, map);
        return resultSet;
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l, int n, Map map) throws SQLException {
        ResultSet resultSet = this.m_conn.newArrayLocatorResultSet(this, byArray, l, n, map);
        return resultSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

