/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleResultSet;
import oracle.sql.SQLName;

public class OracleDatabaseMetaData
implements DatabaseMetaData {
    private static String DRIVER_NAME = "Oracle JDBC driver";
    private static String DRIVER_VERSION = "10.1.0.5.0";
    private static int DRIVER_MAJOR_VERSION = 10;
    private static int DRIVER_MINOR_VERSION = 1;
    private static String LOB_MAXSIZE = "4294967295";
    private static String GET_LOB_PRECISION = "oracledatabasemetadata.get_lob_precision";
    protected OracleConnection connection;
    static Boolean s_getLobPrecision = null;
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    static final int bestRowTemporary = 0;
    static final int bestRowTransaction = 1;
    static final int bestRowSession = 2;
    static final int bestRowUnknown = 0;
    static final int bestRowNotPseudo = 1;
    static final int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int sqlStateXOpen = 1;
    int sqlStateSQL99 = 2;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    public OracleDatabaseMetaData(oracle.jdbc.OracleConnection oracleConnection) {
        this.connection = oracleConnection.physicalConnectionWithin();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        this.connection.trace("allProceduresAreCallable");
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        this.connection.trace("allTablesAreSelectable");
        return false;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        this.connection.trace("getUserName");
        return this.connection.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        this.connection.trace("isReadOnly");
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.connection.trace("nullsAreSortedHigh");
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.connection.trace("nullsAreSortedLow");
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.connection.trace("nullsAreSortedAtStart");
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.connection.trace("nullsAreSortedAtEnd");
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "Oracle";
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.connection.trace("getDatabaseProductVersion");
        return this.connection.getDatabaseProductVersion();
    }

    public String getDriverName() throws SQLException {
        this.connection.trace("getDriverName");
        return DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        this.connection.trace("getDriverVersion");
        return DRIVER_VERSION;
    }

    public int getDriverMajorVersion() {
        this.connection.trace("getDriverMajorVersion");
        return DRIVER_MAJOR_VERSION;
    }

    public int getDriverMinorVersion() {
        this.connection.trace("getDriverMinorVersion");
        return DRIVER_MINOR_VERSION;
    }

    public boolean usesLocalFiles() throws SQLException {
        this.connection.trace("usesLocalFiles");
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.connection.trace("usesLocalFilePerTable");
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.connection.trace("supportsMixedCaseIdentifiers");
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.connection.trace("storesUpperCaseIdentifiers");
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.connection.trace("storesLowerCaseIdentifiers");
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.connection.trace("storesMixedCaseIdentifiers");
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("supportsMixedCaseQuotedIdentifiers");
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesUpperCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesLowerCaseQuotedIdentifiers");
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.connection.trace("storesMixedCaseQuotedIdentifiers");
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.connection.trace("getIdentifierQuoteString");
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        this.connection.trace("getSQLKeywords");
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_ words";
    }

    public String getNumericFunctions() throws SQLException {
        this.connection.trace("getNumericFunctions");
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        this.connection.trace("getStringFunctions");
        return "ASCII,CHAR,CONCAT,LCASE,LENGTH,LTRIM,REPLACE,RTRIM,SOUNDEX,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        this.connection.trace("getSystemFunctions");
        return "USER";
    }

    public String getTimeDateFunctions() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public String getSearchStringEscape() throws SQLException {
        this.connection.trace("getSearchStringEscape");
        return "//";
    }

    public String getExtraNameCharacters() throws SQLException {
        this.connection.trace("getExtraNameCharacters");
        return "$#";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.connection.trace("supportsAlterTableWithAddColumn");
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.connection.trace("supportsAlterTableWithDropColumn");
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.connection.trace("supportsColumnAliasing");
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.connection.trace("nullPlusNonNullIsNull");
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        this.connection.trace("supportsConvert");
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        this.connection.trace("supportsConvert");
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.connection.trace("supportsTableCorrelationNames");
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.connection.trace("supportsDifferentTableCorrelationNames");
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.connection.trace("supportsExpressionsInOrderBy");
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.connection.trace("supportsOrderByUnrelated");
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        this.connection.trace("supportsGroupBy");
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.connection.trace("supportsGroupByUnrelated");
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.connection.trace("supportsGroupByBeyondSelect");
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.connection.trace("supportsLikeEscapeClause");
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.connection.trace("supportsMultipleResultSets");
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.connection.trace("supportsMultipleTransactions");
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.connection.trace("supportsNonNullableColumns");
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.connection.trace("supportsMinimumSQLGrammar");
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.connection.trace("supportsCoreSQLGrammar");
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.connection.trace("supportsExtendedSQLGrammar");
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.connection.trace("supportsANSI92EntryLevelSQL");
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.connection.trace("supportsANSI92IntermediateSQL");
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.connection.trace("supportsANSI92FullSQL");
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.connection.trace("supportsIntegrityEnhancementFacility");
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.connection.trace("supportsOuterJoins");
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.connection.trace("supportsFullOuterJoins");
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.connection.trace("supportsLimitedOuterJoins");
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        this.connection.trace("getSchemaTerm");
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        this.connection.trace("getProcedureTerm");
        return "procedure";
    }

    public String getCatalogTerm() throws SQLException {
        this.connection.trace("getCatalogTerm");
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.connection.trace("isCatalogAtStart");
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        this.connection.trace("getCatalogSeparator");
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.connection.trace("supportsSchemasInDataManipulation");
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.connection.trace("supportsSchemasInProcedureCalls");
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInTableDefinitions");
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInIndexDefinitions");
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.connection.trace("supportsSchemasInPrivilegeDefinitions");
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.connection.trace("supportsCatalogsInDataManipulation");
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.connection.trace("supportsCatalogsInProcedureCalls");
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInTableDefinitions");
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInIndexDefinitions");
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.connection.trace("supportsCatalogsInPrivilegeDefinitions");
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.connection.trace("supportsPositionedDelete");
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.connection.trace("supportsPositionedUpdate");
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.connection.trace("supportsSelectForUpdate");
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.connection.trace("supportsStoredProcedures");
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.connection.trace("supportsSubqueriesInComparisons");
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.connection.trace("supportsSubqueriesInExists");
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.connection.trace("supportsSubqueriesInIns");
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.connection.trace("supportsSubqueriesInQuantifieds");
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.connection.trace("supportsCorrelatedSubqueries");
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        this.connection.trace("supportsUnion");
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        this.connection.trace("supportsUnionAll");
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.connection.trace("supportsOpenCursorsAcrossCommit");
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.connection.trace("supportsOpenCursorsAcrossRollback");
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.connection.trace("supportsOpenStatementsAcrossCommit");
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.connection.trace("supportsOpenStatementsAcrossRollback");
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.connection.trace("getMaxBinaryLiteralLength");
        return 1000;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.connection.trace("getMaxCharLiteralLength");
        return 2000;
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.connection.trace("getMaxColumnNameLength");
        return 30;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.connection.trace("getMaxColumnsInGroupBy");
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.connection.trace("getMaxColumnsInIndex");
        return 32;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.connection.trace("getMaxColumnsInOrderBy");
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.connection.trace("getMaxColumnsInSelect");
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.connection.trace("getMaxColumnsInTable");
        return 1000;
    }

    public int getMaxConnections() throws SQLException {
        this.connection.trace("getMaxConnections");
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.connection.trace("getMaxCursorNameLength");
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        this.connection.trace("getMaxIndexLength");
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.connection.trace("getMaxSchemaNameLength");
        return 30;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.connection.trace("getMaxProcedureNameLength");
        return 30;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.connection.trace("getMaxCatalogNameLength");
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        this.connection.trace("getMaxRowSize");
        return 2000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.connection.trace("doesMaxRowSizeIncludeBlobs");
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        this.connection.trace("getMaxStatementLength");
        return 65535;
    }

    public int getMaxStatements() throws SQLException {
        this.connection.trace("getMaxStatements");
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        this.connection.trace("getMaxTableNameLength");
        return 30;
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.connection.trace("getMaxTablesInSelect");
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        this.connection.trace("getMaxUserNameLength");
        return 30;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.connection.trace("getDefaultTransactionIsolation");
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        this.connection.trace("supportsTransactions");
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.connection.trace("supportsTransactionIsolationLevel");
        return n == 2 || n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.connection.trace("supportsDataDefinitionAndDataManipulationTransactions");
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.connection.trace("supportsDataManipulationTransactionsOnly");
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.connection.trace("dataDefinitionCausesTransactionCommit");
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.connection.trace("dataDefinitionIgnoredInTransactions");
        return false;
    }

    public synchronized ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT\n  -- Standalone procedures and functions\n  NULL AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Standalone procedure or function' AS remarks,\n  DECODE(object_type, 'PROCEDURE', 1,\n                      'FUNCTION', 2,\n                      0) AS procedure_type\nFROM all_objects\nWHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION')\n  AND owner LIKE :1 ESCAPE '/'\n  AND object_name LIKE :2 ESCAPE '/'\n";
        String string5 = "SELECT\n  -- Packaged procedures with no arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND data_type IS NULL\n  AND ";
        String string6 = "SELECT\n  -- Packaged procedures with arguments\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged procedure' AS remarks,\n  1 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NOT NULL\n  AND position = 1\n  AND position = sequence\n  AND ";
        String string7 = "SELECT\n  -- Packaged functions\n  package_name AS procedure_cat,\n  owner AS procedure_schem,\n  object_name AS procedure_name,\n  NULL,\n  NULL,\n  NULL,\n  'Packaged function' AS remarks,\n  2 AS procedure_type\nFROM all_arguments\nWHERE argument_name IS NULL\n  AND in_out = 'OUT'\n  AND ";
        String string8 = "package_name LIKE :3 ESCAPE '/'\n  AND owner LIKE :4 ESCAPE '/'\n  AND object_name LIKE :5 ESCAPE '/'\n";
        String string9 = "package_name IS NOT NULL\n  AND owner LIKE :6 ESCAPE '/'\n  AND object_name LIKE :7 ESCAPE '/'\n";
        String string10 = "ORDER BY procedure_schem, procedure_name\n";
        PreparedStatement preparedStatement = null;
        String string11 = null;
        String string12 = string2;
        if (string2 == null) {
            string12 = "%";
        } else if (string2.equals("")) {
            string12 = this.getUserName().toUpperCase();
        }
        String string13 = string3;
        if (string3 == null) {
            string13 = "%";
        } else if (string3.equals("")) {
            DatabaseError.throwSqlException(74);
        }
        if (string == null) {
            string11 = string4 + "UNION ALL " + string5 + string9 + "UNION ALL " + string6 + string9 + "UNION ALL " + string7 + string9 + string10;
            this.connection.trace("getProcedures Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string12);
            preparedStatement.setString(2, string13);
            preparedStatement.setString(3, string12);
            preparedStatement.setString(4, string13);
            preparedStatement.setString(5, string12);
            preparedStatement.setString(6, string13);
            preparedStatement.setString(7, string12);
            preparedStatement.setString(8, string13);
        } else if (string.equals("")) {
            string11 = string4;
            this.connection.trace("getProcedures Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string12);
            preparedStatement.setString(2, string13);
        } else {
            string11 = string5 + string8 + "UNION ALL " + string6 + string8 + "UNION ALL " + string7 + string8 + string10;
            this.connection.trace("getProcedures Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string12);
            preparedStatement.setString(3, string13);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, string12);
            preparedStatement.setString(6, string13);
            preparedStatement.setString(7, string);
            preparedStatement.setString(8, string12);
            preparedStatement.setString(9, string13);
        }
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT package_name AS procedure_cat,\n       owner AS procedure_schem,\n       object_name AS procedure_name,\n       argument_name AS column_name,\n       DECODE(position, 0, 5,\n                        DECODE(in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', " + (this.connection.isV8Compatible() ? "93,\n" : "91,\n") + "                          'RAW', -3,\n" + "                          'LONG RAW', -4,\n" + "                          'TIMESTAMP', 93, \n" + "                          'TIMESTAMP WITH TIME ZONE', -101, \n" + "               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n" + "               'INTERVAL YEAR TO MONTH', -103, \n" + "               'INTERVAL DAY TO SECOND', -104, \n" + "               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101," + "                          1111) AS data_type,\n" + "       DECODE(data_type, 'OBJECT', type_owner || '.' || type_name, " + "              data_type) AS type_name,\n" + "       DECODE (data_precision, NULL, data_length,\n" + "                               data_precision) AS precision,\n" + "       data_length AS length,\n" + "       data_scale AS scale,\n" + "       10 AS radix,\n" + "       1 AS nullable,\n" + "       NULL AS remarks,\n" + "       sequence,\n" + "       overload,\n" + "       default_value\n" + " FROM all_arguments\n" + "WHERE owner LIKE :1 ESCAPE '/'\n" + "  AND object_name LIKE :2 ESCAPE '/'\n";
        String string6 = "  AND package_name LIKE :3 ESCAPE '/'\n";
        String string7 = "  AND package_name IS NULL\n";
        String string8 = "  AND argument_name LIKE :4 ESCAPE '/'\n";
        String string9 = "  AND (argument_name LIKE :5 ESCAPE '/'\n       OR (argument_name IS NULL\n           AND data_type IS NOT NULL))\n";
        String string10 = "ORDER BY procedure_schem, procedure_name, overload, sequence\n";
        String string11 = null;
        PreparedStatement preparedStatement = null;
        String string12 = null;
        String string13 = string2;
        if (string2 == null) {
            string13 = "%";
        } else if (string2.equals("")) {
            string13 = this.getUserName().toUpperCase();
        }
        String string14 = string3;
        if (string3 == null) {
            string14 = "%";
        } else if (string3.equals("")) {
            DatabaseError.throwSqlException(74);
        }
        String string15 = string4;
        if (string4 == null || string4.equals("%")) {
            string15 = "%";
            string12 = string9;
        } else if (string4.equals("")) {
            DatabaseError.throwSqlException(74);
        } else {
            string12 = string8;
        }
        if (string == null) {
            string11 = string5 + string12 + string10;
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string13);
            preparedStatement.setString(2, string14);
            preparedStatement.setString(3, string15);
        } else if (string.equals("")) {
            string11 = string5 + string7 + string12 + string10;
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string13);
            preparedStatement.setString(2, string14);
            preparedStatement.setString(3, string15);
        } else {
            string11 = string5 + string6 + string12 + string10;
            this.connection.trace("getProcedureColumns Final SQL statement:\n" + string11);
            preparedStatement = this.connection.prepareStatement(string11);
            preparedStatement.setString(1, string13);
            preparedStatement.setString(2, string14);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string15);
        }
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "SELECT NULL AS table_cat,\n       o.owner AS table_schem,\n       o.object_name AS table_name,\n       o.object_type AS table_type,\n";
        String string5 = "       c.comments AS remarks\n";
        String string6 = "       NULL AS remarks\n";
        String string7 = "  FROM all_objects o, all_tab_comments c\n";
        String string8 = "  FROM all_objects o\n";
        String string9 = "  WHERE o.owner LIKE :1 ESCAPE '/'\n    AND o.object_name LIKE :2 ESCAPE '/'\n";
        String string10 = "    AND o.owner = c.owner (+)\n    AND o.object_name = c.table_name (+)\n";
        boolean bl = false;
        String string11 = "";
        String string12 = "";
        if (stringArray != null) {
            string11 = "    AND o.object_type IN ('xxx'";
            string12 = "    AND o.object_type IN ('xxx'";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("SYNONYM")) {
                    string11 = string11 + ", '" + stringArray[i] + "'";
                    bl = true;
                    continue;
                }
                string11 = string11 + ", '" + stringArray[i] + "'";
                string12 = string12 + ", '" + stringArray[i] + "'";
            }
            string11 = string11 + ")\n";
            string12 = string12 + ")\n";
        } else {
            bl = true;
            string11 = "    AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW')\n";
            string12 = "    AND o.object_type IN ('TABLE', 'VIEW')\n";
        }
        String string13 = "  ORDER BY table_type, table_schem, table_name\n";
        String string14 = "SELECT NULL AS table_cat,\n       s.owner AS table_schem,\n       s.synonym_name AS table_name,\n       'SYNONYM' AS table_table_type,\n";
        String string15 = "       c.comments AS remarks\n";
        String string16 = "       NULL AS remarks\n";
        String string17 = "  FROM all_synonyms s, all_objects o, all_tab_comments c\n";
        String string18 = "  FROM all_synonyms s, all_objects o\n";
        String string19 = "  WHERE s.owner LIKE :3 ESCAPE '/'\n    AND s.synonym_name LIKE :4 ESCAPE '/'\n    AND s.table_owner = o.owner\n    AND s.table_name = o.object_name\n    AND o.object_type IN ('TABLE', 'VIEW')\n";
        String string20 = "";
        string20 = string20 + string4;
        string20 = this.connection.getRemarksReporting() ? string20 + string5 + string7 : string20 + string6 + string8;
        string20 = string20 + string9;
        string20 = this.connection.getRestrictGetTables() ? string20 + string12 : string20 + string11;
        if (this.connection.getRemarksReporting()) {
            string20 = string20 + string10;
        }
        if (bl && this.connection.getRestrictGetTables()) {
            string20 = string20 + "UNION\n" + string14;
            string20 = this.connection.getRemarksReporting() ? string20 + string15 + string17 : string20 + string16 + string18;
            string20 = string20 + string19;
            if (this.connection.getRemarksReporting()) {
                string20 = string20 + string10;
            }
        }
        string20 = string20 + string13;
        this.connection.trace("getTables final SQL statement is:\n" + string20);
        PreparedStatement preparedStatement = this.connection.prepareStatement(string20);
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        if (bl && this.connection.getRestrictGetTables()) {
            preparedStatement.setString(3, string2 == null ? "%" : string2);
            preparedStatement.setString(4, string3 == null ? "%" : string3);
        }
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "SELECT username AS table_schem FROM all_users ORDER BY table_schem";
        OracleResultSet oracleResultSet = (OracleResultSet)statement.executeQuery(string);
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        this.connection.trace("getCatalogs");
        Statement statement = this.connection.createStatement();
        String string = "select 'nothing' as table_cat from dual where 1 = 2";
        OracleResultSet oracleResultSet = (OracleResultSet)statement.executeQuery(string);
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        String string = "select 'TABLE' as table_type from dual\nunion select 'VIEW' as table_type from dual\nunion select 'SYNONYM' as table_type from dual\n";
        OracleResultSet oracleResultSet = (OracleResultSet)statement.executeQuery(string);
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       column_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_col_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\n  AND column_name LIKE :3 ESCAPE '/'\nORDER BY column_name, privilege\n");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        preparedStatement.setString(3, string4 == null ? "%" : string4);
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       table_schema AS table_schem,\n       table_name,\n       grantor,\n       grantee,\n       privilege,\n       grantable AS is_grantable\nFROM all_tab_privs\nWHERE table_schema LIKE :1 ESCAPE '/'\n  AND table_name LIKE :2 ESCAPE '/'\nORDER BY table_schem, table_name, privilege\n");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.connection.trace("getBestRowIdentifier");
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE :1 = 1\nUNION\nSELECT 2 AS scope,\n  t.column_name,\n DECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n 'LONG', -1, 'DATE', " + (this.connection.isV8Compatible() ? "93,\n" : "91,\n") + " 'RAW', -3, 'LONG RAW', -4, \n" + " 'TIMESTAMP(6)', 93, " + " 'TIMESTAMP(6) WITH TIME ZONE', -101, \n" + " 'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n" + " 'INTERVAL YEAR(2) TO MONTH', -103, \n" + " 'INTERVAL DAY(2) TO SECOND(6)', -104, \n" + " 'BINARY_FLOAT', 100, " + " 'BINARY_DOUBLE', 101," + " 1111)\n" + " AS data_type,\n" + " t.data_type AS type_name,\n" + " DECODE (t.data_precision, null, t.data_length, t.data_precision)\n" + "  AS column_size,\n" + "  0 AS buffer_length,\n" + "  t.data_scale AS decimal_digits,\n" + "       1 AS pseudo_column\n" + "FROM all_tab_columns t, all_ind_columns i\n" + "WHERE :2 = 1\n" + "  AND t.table_name = :3\n" + "  AND t.owner like :4 escape '/'\n" + "  AND t.nullable != :5\n" + "  AND t.owner = i.table_owner\n" + "  AND t.table_name = i.table_name\n" + "  AND t.column_name = i.column_name\n");
        switch (n) {
            case 0: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 0);
                break;
            }
            case 1: {
                preparedStatement.setInt(1, 1);
                preparedStatement.setInt(2, 1);
                break;
            }
            case 2: {
                preparedStatement.setInt(1, 0);
                preparedStatement.setInt(2, 1);
            }
        }
        preparedStatement.setString(3, string3);
        preparedStatement.setString(4, string2 == null ? "%" : string2);
        preparedStatement.setString(5, bl ? "X" : "Y");
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT 0 AS scope,\n t.column_name,\n DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3,\n  'LONG', -1, 'DATE',  " + (this.connection.isV8Compatible() ? "93,\n" : "91,\n") + "  'RAW', -3, 'LONG RAW', -4, " + "  'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n" + "  'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n" + "  'INTERVAL YEAR(2) TO MONTH', -103, \n" + "  'INTERVAL DAY(2) TO SECOND(6)', -104, \n" + "  'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101," + "   1111)\n " + " AS data_type,\n" + "       c.data_type AS type_name,\n" + " DECODE (c.data_precision, null, c.data_length, c.data_precision)\n" + "   AS column_size,\n" + "       0 as buffer_length,\n" + "   c.data_scale as decimal_digits,\n" + "   0 as pseudo_column\n" + "FROM all_trigger_cols t, all_tab_columns c\n" + "WHERE t.table_name = :1\n" + "  AND c.owner like :2 escape '/'\n" + " AND t.table_owner = c.owner\n" + "  AND t.table_name = c.table_name\n" + " AND t.column_name = c.column_name\n");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 == null ? "%" : string2);
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS table_cat,\n       c.owner AS table_schem,\n       c.table_name,\n       c.column_name,\n       c.position AS key_seq,\n       c.constraint_name AS pk_name\nFROM all_cons_columns c, all_constraints k\nWHERE k.constraint_type = 'P'\n  AND k.table_name = :1\n  AND k.owner like :2 escape '/'\n  AND k.constraint_name = c.constraint_name \n  AND k.table_name = c.table_name \n  AND k.owner = c.owner \nORDER BY column_name\n");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2 == null ? "%" : string2);
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    ResultSet keys_query(String string, String string2, String string3, String string4, String string5) throws SQLException {
        int n = 1;
        int n2 = string2 != null ? n++ : 0;
        int n3 = string4 != null ? n++ : 0;
        int n4 = string != null && string.length() > 0 ? n++ : 0;
        int n5 = string3 != null && string3.length() > 0 ? n++ : 0;
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT NULL AS pktable_cat,\n       p.owner as pktable_schem,\n       p.table_name as pktable_name,\n       pc.column_name as pkcolumn_name,\n       NULL as fktable_cat,\n       f.owner as fktable_schem,\n       f.table_name as fktable_name,\n       fc.column_name as fkcolumn_name,\n       fc.position as key_seq,\n       NULL as update_rule,\n       decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,\n       f.constraint_name as fk_name,\n       p.constraint_name as pk_name,\n       decode(f.deferrable,       'DEFERRABLE',5      ,'NOT DEFERRABLE',7      , 'DEFERRED', 6      ) deferrability \n      FROM all_cons_columns pc, all_constraints p,\n      all_cons_columns fc, all_constraints f\nWHERE 1 = 1\n" + (n2 != 0 ? "  AND p.table_name = :1\n" : "") + (n3 != 0 ? "  AND f.table_name = :2\n" : "") + (n4 != 0 ? "  AND p.owner = :3\n" : "") + (n5 != 0 ? "  AND f.owner = :4\n" : "") + "  AND f.constraint_type = 'R'\n" + "  AND p.owner = f.r_owner\n" + "  AND p.constraint_name = f.r_constraint_name\n" + "  AND p.constraint_type = 'P'\n" + "  AND pc.owner = p.owner\n" + "  AND pc.constraint_name = p.constraint_name\n" + "  AND pc.table_name = p.table_name\n" + "  AND fc.owner = f.owner\n" + "  AND fc.constraint_name = f.constraint_name\n" + "  AND fc.table_name = f.table_name\n" + "  AND fc.position = pc.position\n" + string5);
        if (n2 != 0) {
            preparedStatement.setString(n2, string2);
        }
        if (n3 != 0) {
            preparedStatement.setString(n3, string4);
        }
        if (n4 != 0) {
            preparedStatement.setString(n4, string);
        }
        if (n5 != 0) {
            preparedStatement.setString(n5, string3);
        }
        OracleResultSet oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    public synchronized ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.trace("getImportedKeys");
        return this.keys_query(null, null, string2, string3, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.connection.trace("getExportedKeys");
        return this.keys_query(string2, string3, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.connection.trace("getCrossReference");
        return this.keys_query(string2, string3, string5, string6, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    public ResultSet getTypeInfo() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.connection.trace("getIndexInfo");
        Statement statement = this.connection.createStatement();
        String string4 = "analyze table " + (string2 == null ? "" : string2 + ".") + string3 + (bl2 ? " estimate statistics" : " compute statistics");
        this.connection.trace(string4);
        statement.executeUpdate(string4);
        String string5 = "select null as table_cat,\n       owner as table_schem,\n       table_name,\n       0 as NON_UNIQUE,\n       null as index_qualifier,\n       null as index_name, 0 as type,\n       0 as ordinal_position, null as column_name,\n       null as asc_or_desc,\n       num_rows as cardinality,\n       blocks as pages,\n       null as filter_condition\nfrom all_tables\nwhere table_name = '" + string3 + "'\n";
        String string6 = "";
        if (string2 != null && string2.length() > 0) {
            string6 = "  and owner = '" + string2 + "'\n";
        }
        String string7 = "select null as table_cat,\n       i.owner as table_schem,\n       i.table_name,\n       decode (i.uniqueness, 'UNIQUE', 0, 1),\n       null as index_qualifier,\n       i.index_name,\n       1 as type,\n       c.column_position as ordinal_position,\n       c.column_name,\n       null as asc_or_desc,\n       i.distinct_keys as cardinality,\n       i.leaf_blocks as pages,\n       null as filter_condition\nfrom all_indexes i, all_ind_columns c\nwhere i.table_name = '" + string3 + "'\n";
        String string8 = "";
        if (string2 != null && string2.length() > 0) {
            string8 = "  and i.owner = '" + string2 + "'\n";
        }
        String string9 = "";
        if (bl) {
            string9 = "  and i.uniqueness = 'UNIQUE'\n";
        }
        String string10 = "  and i.index_name = c.index_name\n  and i.table_owner = c.table_owner\n  and i.table_name = c.table_name\n  and i.owner = c.index_owner\n";
        String string11 = "order by non_unique, type, index_name, ordinal_position\n";
        String string12 = string5 + string6 + "union\n" + string7 + string8 + string9 + string10 + string11;
        OracleResultSet oracleResultSet = (OracleResultSet)statement.executeQuery(string12);
        oracleResultSet.closeStatementOnClose();
        return oracleResultSet;
    }

    SQLException fail() {
        SQLException sQLException = new SQLException("Not implemented yet");
        return sQLException;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return n != 1003;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return n != 1003;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return n == 1005;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Object object;
        boolean bl = false;
        if (string3 == null || string3.length() == 0) {
            bl = false;
        } else if (nArray == null) {
            bl = true;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 2002) continue;
                bl = true;
                break;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT NULL AS TYPE_CAT, owner AS TYPE_SCHEM, type_name, NULL AS CLASS_NAME, 'STRUCT' AS DATA_TYPE, NULL AS REMARKS FROM all_types ");
        if (bl) {
            stringBuffer.append("WHERE typecode = 'OBJECT' AND owner LIKE :1 ESCAPE '/' AND type_name LIKE :2 ESCAPE '/'");
        } else {
            stringBuffer.append("WHERE 1 = 2");
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
        if (bl) {
            object = new String[1];
            String[] stringArray = new String[1];
            if (SQLName.parse(string3, (String[])object, stringArray)) {
                preparedStatement.setString(1, (String)object[0]);
                preparedStatement.setString(2, stringArray[0]);
            } else {
                if (string2 != null) {
                    preparedStatement.setString(1, string2);
                } else {
                    preparedStatement.setNull(1, 12);
                }
                preparedStatement.setString(2, string3);
            }
        }
        object = (OracleResultSet)preparedStatement.executeQuery();
        object.closeStatementOnClose();
        return object;
    }

    public Connection getConnection() throws SQLException {
        return this.connection.getWrapper();
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getVersionNumber() / 1000;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getVersionNumber() % 1000 / 100;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return DRIVER_MAJOR_VERSION;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return DRIVER_MINOR_VERSION;
    }

    public int getSQLStateType() throws SQLException {
        return 0;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    public static String getDriverNameInfo() throws SQLException {
        return DRIVER_NAME;
    }

    public static String getDriverVersionInfo() throws SQLException {
        return DRIVER_VERSION;
    }

    public static int getDriverMajorVersionInfo() {
        return DRIVER_MAJOR_VERSION;
    }

    public static int getDriverMinorVersionInfo() {
        return DRIVER_MINOR_VERSION;
    }

    public static void setGetLobPrecision(boolean bl) throws SQLException {
        s_getLobPrecision = new Boolean(bl);
    }

    public static boolean getGetLobPrecision() throws SQLException {
        if (s_getLobPrecision == null) {
            try {
                String string;
                Properties properties = System.getProperties();
                s_getLobPrecision = properties != null ? ((string = properties.getProperty(GET_LOB_PRECISION)) != null ? new Boolean(string) : new Boolean(true)) : new Boolean(true);
            }
            catch (SecurityException securityException) {
                s_getLobPrecision = new Boolean(true);
            }
        }
        return s_getLobPrecision;
    }

    public static String getLobPrecision() throws SQLException {
        return OracleDatabaseMetaData.getGetLobPrecision() ? LOB_MAXSIZE : "-1";
    }
}

