/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CLOB;

public class OracleClobInputStream
extends OracleBufferedStream {
    protected long m_lobOffset;
    protected CLOB m_clob;
    protected long m_markedByte;
    protected boolean m_endOfStream;
    protected char[] m_charBuf;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n) throws SQLException {
        this(cLOB, n, 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n, long l) throws SQLException {
        super(n);
        if (cLOB == null || n <= 0 || l < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_lobOffset = l;
        this.m_clob = cLOB;
        this.m_markedByte = -1L;
        this.m_endOfStream = false;
        this.m_charBuf = new char[n];
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.m_endOfStream) {
                try {
                    this.count = this.m_clob.getChars(this.m_lobOffset, this.chunkSize, this.m_charBuf);
                    for (int i = 0; i < this.count; ++i) {
                        this.buf[i] = (byte)this.m_charBuf[i];
                    }
                    if (this.count < this.chunkSize) {
                        this.m_endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.m_lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    DatabaseError.SQLToIOException(sQLException);
                }
            }
            return false;
        }
        return true;
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DatabaseError.check_error(57, null);
            }
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.m_markedByte = this.m_lobOffset - (long)this.count + (long)this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.m_markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.m_lobOffset = this.m_markedByte;
        this.pos = this.count;
        this.m_endOfStream = false;
    }

    public long skip(long l) throws IOException {
        this.ensureOpen();
        long l2 = 0L;
        if ((long)(this.count - this.pos) >= l) {
            this.pos = (int)((long)this.pos + l);
            l2 += l;
        } else {
            l2 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l3 = 0L;
                l3 = this.m_clob.length() - this.m_lobOffset + 1L;
                if (l3 >= l - l2) {
                    this.m_lobOffset += l - l2;
                    l2 += l - l2;
                } else {
                    this.m_lobOffset += l3;
                    l2 += l3;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
        return l2;
    }
}

