/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.PhysicalConnection;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    public static final String oracle_string = "oracle";
    public static final String protocol_string = "protocol";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    public static final String server_string = "server";
    public static final String access_string = "access";
    public static final String protocolFullName_string = "protocolFullName";
    public static final String logon_as_internal_str = "internal_logon";
    public static final String prefetch_string = "prefetch";
    public static final String row_prefetch_string = "rowPrefetch";
    public static final String default_row_prefetch_string = "defaultRowPrefetch";
    public static final String batch_string = "batch";
    public static final String execute_batch_string = "executeBatch";
    public static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "oracle.jdbc.V8Compatible";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    public static final String SetFloatAndDoubleUseBinary_string = "SetFloatAndDoubleUseBinary";
    public static final String xa_trans_loose = "oracle.jdbc.XATransLoose";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String read_timeout = "oracle.jdbc.ReadTimeout";
    public static final String defaultnchar_string = "oracle.jdbc.defaultNChar";
    public static final String defaultncharprop_string = "defaultNChar";
    public static final String useFetchSizeWithLongColumn_prop_string = "useFetchSizeWithLongColumn";
    public static final String useFetchSizeWithLongColumn_string = "oracle.jdbc.useFetchSizeWithLongColumn";
    public static final String remarks_string = "remarks";
    public static final String report_remarks_string = "remarksReporting";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String dll_string = "oracle.jdbc.ocinativelibrary";
    public static final String nls_lang_backdoor = "oracle.jdbc.ociNlsLangBackwardCompatible";
    public static final String disable_defineColumnType_string = "disableDefineColumnType";
    public static final String dataSizeUnitsPropertyName = "";
    public static final String dataSizeBytes = "";
    public static final String dataSizeChars = "";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    public static final String retain_v9_bind_behavior_string = "oracle.jdbc.RetainV9LongBindBehavior";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    public static final String set_new_password_string = "OCINewPassword";
    static final int EXTENSION_TYPE_ORACLE_ERROR = -3;
    static final int EXTENSION_TYPE_GEN_ERROR = -2;
    static final int EXTENSION_TYPE_TYPE4_CLIENT = 0;
    static final int EXTENSION_TYPE_TYPE4_SERVER = 1;
    static final int EXTENSION_TYPE_TYPE2_CLIENT = 2;
    static final int EXTENSION_TYPE_TYPE2_SERVER = 3;
    private static final int NUMBER_OF_EXTENSION_TYPES = 4;
    private OracleDriverExtension[] driverExtensions = new OracleDriverExtension[4];
    private static final String DRIVER_PACKAGE_STRING = "driver";
    private static final String[] driverExtensionClassNames = new String[]{"oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T4CDriverExtension", "oracle.jdbc.driver.T2CDriverExtension", "oracle.jdbc.driver.T2SDriverExtension"};
    private static Properties m_driverAccess;
    protected static Connection m_defaultConn;
    private static OracleDriver m_defaultDriver;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        int n;
        String string12;
        Hashtable hashtable;
        int n2;
        if (string.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String string13 = "jdbc:oracle:kprb";
            int n3 = string.length();
            string = n3 > 23 ? string13.concat(string.substring(23, string.length())) : string13.concat(":");
            string13 = null;
        }
        if ((n2 = this.oracleDriverExtensionTypeFromURL(string)) == -2) {
            return null;
        }
        if (n2 == -3) {
            DatabaseError.throwSqlException(67);
        }
        OracleDriverExtension oracleDriverExtension = null;
        oracleDriverExtension = this.driverExtensions[n2];
        if (oracleDriverExtension == null) {
            try {
                oracleDriverExtension = (OracleDriverExtension)Class.forName(driverExtensionClassNames[n2]).newInstance();
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
            this.driverExtensions[n2] = oracleDriverExtension;
        }
        if ((hashtable = this.parseUrl(string)) == null) {
            return null;
        }
        String string14 = properties.getProperty(user_string);
        String string15 = properties.getProperty(password_string);
        String string16 = properties.getProperty(database_string);
        if (string16 == null) {
            string16 = properties.getProperty(server_string);
        }
        if (string14 == null) {
            string14 = (String)hashtable.get(user_string);
        }
        string14 = this.parseLoginOption(string14, properties);
        if (string15 == null) {
            string15 = (String)hashtable.get(password_string);
        }
        if (string16 == null) {
            string16 = (String)hashtable.get(database_string);
        }
        String string17 = (String)hashtable.get(protocol_string);
        properties.put(protocol_string, string17);
        if (string17 == null) {
            DatabaseError.throwSqlException(40, "Protocol is not specified in URL");
            return null;
        }
        if (string17.equals("oci8") || string17.equals("oci")) {
            string16 = this.translateConnStr(string16);
        }
        if ((string12 = properties.getProperty(tcp_no_delay)) == null) {
            string12 = OracleDriver.getSystemProperty(tcp_no_delay);
        }
        if (string12 != null && string12.equalsIgnoreCase("true")) {
            properties.put("TCP.NODELAY", "YES");
        }
        if ((n = DriverManager.getLoginTimeout()) != 0 && properties.get("oracle.net.CONNECT_TIMEOUT") == null) {
            properties.put("oracle.net.CONNECT_TIMEOUT", "" + n * 1000);
        }
        if ((string11 = properties.getProperty(read_timeout)) != null) {
            properties.put("oracle.net.READ_TIMEOUT", string11);
        }
        if ((string10 = properties.getProperty(prefetch_string)) == null) {
            string10 = properties.getProperty(row_prefetch_string);
        }
        if (string10 == null) {
            string10 = properties.getProperty(default_row_prefetch_string);
        }
        if (string10 != null && Integer.parseInt(string10) <= 0) {
            string10 = null;
        }
        if ((string9 = properties.getProperty(batch_string)) == null) {
            string9 = properties.getProperty(execute_batch_string);
        }
        if (string9 == null) {
            string9 = properties.getProperty(default_execute_batch_string);
        }
        if (string9 != null && Integer.parseInt(string9) <= 0) {
            string9 = null;
        }
        if ((string8 = properties.getProperty(defaultncharprop_string)) == null) {
            string8 = OracleDriver.getSystemProperty(defaultnchar_string);
        }
        if ((string7 = properties.getProperty(useFetchSizeWithLongColumn_prop_string)) == null) {
            string7 = OracleDriver.getSystemProperty(useFetchSizeWithLongColumn_string);
        }
        if ((string6 = properties.getProperty(remarks_string)) == null) {
            string6 = properties.getProperty(report_remarks_string);
        }
        if ((string5 = properties.getProperty(synonyms_string)) == null) {
            string5 = properties.getProperty(include_synonyms_string);
        }
        String string18 = properties.getProperty(restrict_getTables_string);
        String string19 = properties.getProperty(fixed_string_string);
        String string20 = properties.getProperty(accumulate_batch_result);
        if (string20 == null) {
            string20 = "true";
        }
        if ((string4 = properties.getProperty(disable_defineColumnType_string)) == null) {
            string4 = "false";
        }
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements() && !((object = enumeration.nextElement()) instanceof OracleDriver)) {
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver((Driver)object);
        }
        object = (PhysicalConnection)oracleDriverExtension.getConnection(string, string14, string15, string16, properties);
        if (string10 != null) {
            ((PhysicalConnection)object).setDefaultRowPrefetch(Integer.parseInt(string10));
        }
        if (string9 != null) {
            ((PhysicalConnection)object).setDefaultExecuteBatch(Integer.parseInt(string9));
        }
        if (string6 != null) {
            ((PhysicalConnection)object).setRemarksReporting(string6.equalsIgnoreCase("true"));
        }
        if (string5 != null) {
            ((PhysicalConnection)object).setIncludeSynonyms(string5.equalsIgnoreCase("true"));
        }
        if (string18 != null) {
            ((PhysicalConnection)object).setRestrictGetTables(string18.equalsIgnoreCase("true"));
        }
        if (string19 != null) {
            ((PhysicalConnection)object).setDefaultFixedString(string19.equalsIgnoreCase("true"));
        }
        if (string8 != null) {
            ((PhysicalConnection)object).setDefaultNChar(string8.equalsIgnoreCase("true"));
        }
        if (string7 != null) {
            ((PhysicalConnection)object).useFetchSizeWithLongColumn = string7.equalsIgnoreCase("true");
        }
        if (string20 != null) {
            ((PhysicalConnection)object).setAccumulateBatchResult(string20.equalsIgnoreCase("true"));
        }
        if ((string3 = OracleDriver.getSystemProperty(j2ee_compliance)) == null) {
            string2 = properties.getProperty(j2ee_compliance);
            if (string2 == null) {
                string2 = "false";
            }
        } else {
            string2 = string3;
        }
        ((PhysicalConnection)object).setJ2EE13Compliant(string2.equalsIgnoreCase("true"));
        ((PhysicalConnection)object).disableDefineColumnType = string4.equalsIgnoreCase("true");
        hashtable = null;
        ((PhysicalConnection)object).protocolId = n2;
        return object;
    }

    public Connection defaultConnection() throws SQLException {
        if (m_defaultConn == null || m_defaultConn.isClosed()) {
            m_defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return m_defaultConn;
    }

    private int oracleDriverExtensionTypeFromURL(String string) {
        int n;
        int n2 = string.indexOf(58) + 1;
        if (n2 == 0) {
            return -2;
        }
        int n3 = string.indexOf(58, n2);
        if (n3 == -1) {
            return -2;
        }
        if (!string.regionMatches(true, n2, oracle_string, 0, n3 - n2)) {
            return -2;
        }
        if ((n = string.indexOf(58, ++n3)) == -1) {
            return -3;
        }
        String string2 = string.substring(n3, n);
        if (string2.equals("thin")) {
            return 0;
        }
        if (string2.equals("oci8") || string2.equals("oci")) {
            return 2;
        }
        return -3;
    }

    public boolean acceptsURL(String string) {
        if (string.startsWith("jdbc:oracle:")) {
            return this.oracleDriverExtensionTypeFromURL(string) > -2;
        }
        return false;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public String processSqlEscapes(String string) throws SQLException {
        OracleSql oracleSql = new OracleSql(null);
        oracleSql.initialize(string);
        return oracleSql.parse(string);
    }

    private String parseLoginOption(String string, Properties properties) {
        int n = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        n = string3.lastIndexOf(" as ");
        if (n == -1 || n < string3.lastIndexOf("\"")) {
            return string;
        }
        string2 = string.substring(0, n);
        n += 4;
        while (n < n2 && string3.charAt(n) == ' ') {
            ++n;
        }
        if (n == n2) {
            return string;
        }
        String string4 = string3.substring(n).trim();
        if (string4.length() > 0) {
            properties.put(logon_as_internal_str, string4);
        }
        return string2;
    }

    private Hashtable parseUrl(String string) throws SQLException {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        int n2 = string.indexOf(58, string.indexOf(58) + 1) + 1;
        if (n2 == (n = string.length())) {
            return hashtable;
        }
        int n3 = string.indexOf(58, n2);
        if (n3 == -1) {
            return hashtable;
        }
        hashtable.put(protocol_string, string.substring(n2, n3));
        int n4 = n3 + 1;
        int n5 = string.indexOf(47, n4);
        int n6 = string.indexOf(64, n4);
        if (n6 > n4 && n4 > n2 && n5 == -1) {
            return null;
        }
        if (n6 == -1) {
            n6 = n;
        }
        if (n5 == -1) {
            n5 = n6;
        }
        if (n5 < n6) {
            hashtable.put(user_string, string.substring(n4, n5));
            hashtable.put(password_string, string.substring(n5 + 1, n6));
        }
        if (n6 < n) {
            hashtable.put(database_string, string.substring(n6 + 1));
        }
        return hashtable;
    }

    public static String getCompileTime() {
        return BUILD_DATE;
    }

    private String translateConnStr(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return string;
        }
        n = string.indexOf(58);
        if (n == -1 || (n2 = string.indexOf(58, n + 1)) == -1) {
            return string;
        }
        if (string.indexOf(58, n2 + 1) != -1) {
            DatabaseError.throwSqlException(67, string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1, string.length());
        String string5 = "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + string2 + ")(PORT=" + string3 + "))(CONNECT_DATA=(SID=" + string4 + ")))";
        return string5;
    }

    public static String getSystemProperty(String string) {
        return OracleDriver.getSystemProperty(string, null);
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    static {
        m_defaultConn = null;
        m_defaultDriver = null;
        Timestamp timestamp = Timestamp.valueOf("2000-01-01 00:00:00.0");
        try {
            if (m_defaultDriver == null) {
                m_defaultDriver = new OracleDriver();
                DriverManager.registerDriver(m_defaultDriver);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    }
}

