/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OracleResultSetImpl
extends BaseResultSet {
    PhysicalConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    boolean m_emptyRset;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    OracleResultSetImpl(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        this.internal_close(false);
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.explicitly_closed = true;
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.statement.wasNullValue();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.explicitly_closed) {
            DatabaseError.check_error(10, "getMetaData");
        }
        if (this.statement.closed) {
            DatabaseError.check_error(9, "getMetaData");
        }
        if (!this.statement.m_isOpen) {
            DatabaseError.check_error(144, "getMetaData");
        }
        return new OracleResultSetMetaData(this.connection, this.statement);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized boolean next() throws SQLException {
        boolean bl = true;
        PhysicalConnection physicalConnection = this.statement.connection;
        if (this.explicitly_closed) {
            DatabaseError.check_error(10, "next");
        }
        if (physicalConnection == null || physicalConnection.lifecycle != 1) {
            DatabaseError.check_error(8, "next");
        }
        if (this.statement.closed) {
            DatabaseError.check_error(9, "next");
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.current_row;
        ++this.statement.total_rows_visited;
        if (this.statement.max_rows != 0 && this.statement.total_rows_visited > this.statement.max_rows) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.current_row >= this.statement.valid_rows) {
            bl = this.close_or_fetch_from_next(false);
        }
        if (bl && physicalConnection.useFetchSizeWithLongColumn) {
            this.statement.reopenStreams();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close_or_fetch_from_next(boolean bl) throws SQLException {
        if (bl) {
            this.internal_close(false);
            return false;
        }
        if (this.statement.got_last_batch) {
            this.internal_close(false);
            return false;
        }
        this.statement.check_row_prefetch_changed();
        PhysicalConnection physicalConnection = this.statement.connection;
        if (physicalConnection.protocolId == 3) {
            this.m_warning = null;
        } else {
            if (this.statement.streamList != null) {
                while (this.statement.nextStream != null) {
                    try {
                        this.statement.nextStream.close();
                    }
                    catch (IOException iOException) {
                        DatabaseError.throwSqlException(iOException);
                    }
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
            }
            this.clearWarnings();
            physicalConnection.needLine();
        }
        PhysicalConnection physicalConnection2 = physicalConnection;
        synchronized (physicalConnection2) {
            this.statement.fetch();
        }
        if (this.statement.valid_rows == 0) {
            this.internal_close(false);
            return false;
        }
        this.statement.current_row = 0;
        this.statement.checkValidRowsStatus();
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        DatabaseError.throwSqlException(75, "isLast");
        return false;
    }

    public int getRow() throws SQLException {
        return this.statement.total_rows_visited;
    }

    public synchronized String getString(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getString(n2);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBoolean(n2);
    }

    public synchronized byte getByte(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getByte(n2);
    }

    public synchronized short getShort(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getShort(n2);
    }

    public synchronized int getInt(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getInt(n2);
    }

    public synchronized long getLong(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getLong(n2);
    }

    public synchronized float getFloat(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getFloat(n2);
    }

    public synchronized double getDouble(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getDouble(n2);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        int n3;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n3 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBigDecimal(this.statement.current_row, n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBytes(n2);
    }

    public synchronized Date getDate(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getDate(n2);
    }

    public synchronized Time getTime(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTime(n2);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTimestamp(n2);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getAsciiStream(n2);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getUnicodeStream(n2);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBinaryStream(n2);
    }

    public synchronized Object getObject(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getObject(n2);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getCursor(n2);
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getOracleObject(n2);
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getROWID(n2);
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getNUMBER(n2);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getDATE(n2);
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getARRAY(n2);
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getSTRUCT(n2);
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getOPAQUE(n2);
    }

    public synchronized REF getREF(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getREF(n2);
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getCHAR(n2);
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getRAW(n2);
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBLOB(n2);
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getCLOB(n2);
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBFILE(n2);
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getCustomDatum(this.statement.current_row, customDatumFactory);
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getORAData(this.statement.current_row, oRADataFactory);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getObject(this.statement.current_row, map);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getCharacterStream(n2);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getBigDecimal(n2);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getDate(this.statement.current_row, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTime(this.statement.current_row, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTimestamp(this.statement.current_row, calendar);
    }

    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getINTERVALYM(n2);
    }

    public INTERVALDS getINTERVALDS(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getINTERVALDS(n2);
    }

    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTIMESTAMP(n2);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTIMESTAMPTZ(n2);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getTIMESTAMPLTZ(n2);
    }

    public synchronized URL getURL(int n) throws SQLException {
        int n2;
        if (n <= 0 || n > this.statement.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if ((n2 = this.statement.current_row) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.last_index = n;
        if (this.statement.streamList != null) {
            this.statement.closeUsedStreams(n);
        }
        return this.statement.accessors[n - 1].getURL(n2);
    }

    public void setFetchSize(int n) throws SQLException {
        this.statement.setPrefetchInternal(n, false, false);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getPrefetchInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internal_close(boolean bl) throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.got_last_batch && this.statement.valid_rows == 0) {
            this.m_emptyRset = true;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        try {
            physicalConnection.needLine();
            PhysicalConnection physicalConnection2 = physicalConnection;
            synchronized (physicalConnection2) {
                this.statement.closeQuery();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement.end_of_result_set(bl);
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.statement.get_column_index(string);
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.got_last_batch && this.statement.valid_rows == 0;
    }

    int getValidRows() {
        return this.statement.valid_rows;
    }
}

