/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;

class T4CResultSetAccessor
extends ResultSetAccessor {
    T4CMAREngine mare;
    OracleStatement[] newstmt = new OracleStatement[10];
    byte[] empty = new byte[]{0};
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    T4CResultSetAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, s, n2, bl);
        this.mare = t4CMAREngine;
    }

    T4CResultSetAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n == -1 ? n8 : n, bl, n2, n3, n4, n5, n6, s);
        this.mare = t4CMAREngine;
        this.definedColumnType = n7;
        this.definedColumnSize = n8;
        if (n == -1) {
            this.underlyingLongRaw = true;
        }
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.stmt.sql_kind != 1 && this.stmt.sql_kind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.stmt.sql_kind == 1 || this.stmt.sql_kind == 4) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        Object object;
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n2 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
            ++this.lastRowProcessed;
            this.processIndicator(0);
            return false;
        }
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (this.newstmt.length <= this.lastRowProcessed) {
            object = new OracleStatement[this.newstmt.length * 4];
            System.arraycopy(this.newstmt, 0, object, 0, this.newstmt.length);
            this.newstmt = object;
        }
        this.newstmt[this.lastRowProcessed] = this.stmt.connection.RefCursorBytesToStatement(this.empty, this.stmt);
        this.newstmt[this.lastRowProcessed].needToSendOalToFetch = true;
        object = new T4CTTIdcb(this.mare);
        ((T4CTTIdcb)object).init(this.newstmt[this.lastRowProcessed], 0);
        this.newstmt[this.lastRowProcessed].accessors = ((T4CTTIdcb)object).receiveFromRefCursor(this.newstmt[this.lastRowProcessed].accessors);
        this.newstmt[this.lastRowProcessed].number_of_define_positions = this.newstmt[this.lastRowProcessed].accessors.length;
        this.newstmt[this.lastRowProcessed].describedWithNames = true;
        this.newstmt[this.lastRowProcessed].described = true;
        int n4 = (int)this.mare.unmarshalUB4();
        this.newstmt[this.lastRowProcessed].setCursorId(n4);
        if (n4 > 0) {
            this.rowSpaceByte[n3] = 1;
            this.rowSpaceByte[n3 + 1] = (byte)n4;
            this.meta[0] = 2;
        } else {
            this.newstmt[this.lastRowProcessed].close();
            this.newstmt[this.lastRowProcessed] = null;
            this.meta[0] = 0;
        }
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
        } else {
            this.rowSpaceIndicator[n2] = (short)this.meta[0];
            this.rowSpaceIndicator[n] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int n = this.lastRowProcessed == 0 ? this.stmt.row_prefetch : this.lastRowProcessed;
        int n2 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n3 = this.columnIndex + (n - 1) * this.byteLength;
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.indicatorIndex + n - 1;
        int n6 = this.lengthIndex + this.lastRowProcessed;
        int n7 = this.lengthIndex + n - 1;
        short s = this.rowSpaceIndicator[n7];
        this.rowSpaceIndicator[n6] = s;
        this.rowSpaceIndicator[n4] = this.rowSpaceIndicator[n5];
        System.arraycopy(this.rowSpaceByte, n3, this.rowSpaceByte, n2, s);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n, int n2) throws SQLException {
        int n3 = this.columnIndex + (n2 - 1) * this.byteLength;
        int n4 = this.columnIndexLastRow + (n - 1) * this.byteLength;
        int n5 = this.indicatorIndex + n2 - 1;
        int n6 = this.indicatorIndexLastRow + n - 1;
        int n7 = this.lengthIndex + n2 - 1;
        int n8 = this.lengthIndexLastRow + n - 1;
        short s = sArray[n8];
        this.rowSpaceIndicator[n7] = s;
        this.rowSpaceIndicator[n5] = sArray[n6];
        if (s != 0) {
            System.arraycopy(byArray, n4, this.rowSpaceByte, n3, s);
        }
    }

    ResultSet getCursor(int n) throws SQLException {
        if (this.newstmt[n] != null) {
            for (int i = 0; i < this.newstmt[n].number_of_define_positions; ++i) {
                this.newstmt[n].accessors[i].initMetadata();
            }
        } else {
            throw new SQLException("Cursor is closed.");
        }
        this.newstmt[n].prepareAccessors();
        OracleResultSetImpl oracleResultSetImpl = new OracleResultSetImpl(this.newstmt[n].connection, this.newstmt[n]);
        oracleResultSetImpl.close_statement_on_close = true;
        this.newstmt[n].current_result_set = oracleResultSetImpl;
        OracleResultSetImpl oracleResultSetImpl2 = oracleResultSetImpl;
        return oracleResultSetImpl2;
    }
}

