/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int m_precision;
    int m_scale;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int n) {
        super(n);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l, n);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset++;
        this.m_precision = streamInfo.readUnsignedByte();
        this.m_scale = streamInfo.readByte();
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.size_for_lds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.size_for_lds == 0) {
            this.size_for_lds = Util.FDO_get_size(byArray, 12);
            this.align_for_lds = Util.FDO_get_align(byArray, 12);
        }
        return this.align_for_lds;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.lds_offset, this.null_offset, unpickleContext, n, n2, map);
    }

    protected static Object numericUnpickle80rec(int n, int n2, UnpickleContext unpickleContext, int n3, int n4, Map map) throws SQLException {
        switch (n3) {
            case 1: {
                if (unpickleContext.is_null(n2)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[n]);
                break;
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) != 1) break;
                unpickleContext.skip_bytes(22);
                return null;
            }
            case 3: {
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + n3);
            }
        }
        if (n4 == 9) {
            unpickleContext.skip_bytes(22);
            return null;
        }
        return OracleTypeNUMBER.toNumericObject(unpickleContext.read_varNumBytes(), n4, map);
    }

    protected static Object unpickle80_nativeArray(UnpickleContext unpickleContext, long l, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        switch (n3) {
            case 2: {
                n4 = 23;
                break;
            }
            case 3: {
                n4 = 22;
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + n3);
            }
        }
        if (n > 0) {
            unpickleContext.skip_bytes(n4 * ((int)l - 1));
        }
        int n5 = unpickleContext.absolute_offset();
        byte[] byArray = unpickleContext.image();
        int n6 = 0;
        switch (n2) {
            case 4: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    n6 = n5 + i * n4;
                    if (n3 != 3 && (byArray[n6++] & 1) != 0) continue;
                    byte[] byArray2 = new byte[byArray[n6++]];
                    System.arraycopy(byArray, n6, byArray2, 0, byArray2.length);
                    nArray[i] = NUMBER.toInt(byArray2);
                }
                unpickleContext.skip_bytes(n4 * n);
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    n6 = n5 + i * n4;
                    if (n3 != 3 && (byArray[n6++] & 1) != 0) continue;
                    byte[] byArray3 = new byte[byArray[n6++]];
                    System.arraycopy(byArray, n6, byArray3, 0, byArray3.length);
                    dArray[i] = NUMBER.toDouble(byArray3);
                }
                unpickleContext.skip_bytes(n4 * n);
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    n6 = n5 + i * n4;
                    if (n3 != 3 && (byArray[n6++] & 1) != 0) continue;
                    byte[] byArray4 = new byte[byArray[n6++]];
                    System.arraycopy(byArray, n6, byArray4, 0, byArray4.length);
                    lArray[i] = NUMBER.toLong(byArray4);
                }
                unpickleContext.skip_bytes(n4 * n);
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    n6 = n5 + i * n4;
                    if (n3 != 3 && (byArray[n6++] & 1) != 0) continue;
                    byte[] byArray5 = new byte[byArray[n6++]];
                    System.arraycopy(byArray, n6, byArray5, 0, byArray5.length);
                    fArray[i] = NUMBER.toFloat(byArray5);
                }
                unpickleContext.skip_bytes(n4 * n);
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    n6 = n5 + i * n4;
                    if (n3 != 3 && (byArray[n6++] & 1) != 0) continue;
                    byte[] byArray6 = new byte[byArray[n6++]];
                    System.arraycopy(byArray, n6, byArray6, 0, byArray6.length);
                    sArray[i] = NUMBER.toShort(byArray6);
                }
                unpickleContext.skip_bytes(n4 * n);
                return sArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected static Object unpickle81_nativeArray(PickleContext pickleContext, long l, int n, int n2) throws SQLException {
        int n3 = 1;
        while ((long)n3 < l && n > 0) {
            pickleContext.skipDataValue_pctx();
            ++n3;
        }
        byte[] byArray = null;
        switch (n2) {
            case 4: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray == null) continue;
                    nArray[i] = NUMBER.toInt(byArray);
                }
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray == null) continue;
                    dArray[i] = NUMBER.toDouble(byArray);
                }
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray == null) continue;
                    lArray[i] = NUMBER.toLong(byArray);
                }
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray == null) continue;
                    fArray[i] = NUMBER.toFloat(byArray);
                }
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    byArray = pickleContext.readDataValue_pctx();
                    if (byArray == null) continue;
                    sArray[i] = NUMBER.toShort(byArray);
                }
                return sArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n, map);
    }

    static Object toNumericObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new NUMBER(byArray);
            }
            case 2: {
                return NUMBER.toBigDecimal(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER = null;
        if (object != null) {
            try {
                nUMBER = object instanceof NUMBER ? (NUMBER)object : new NUMBER(object);
            }
            catch (SQLException sQLException) {
                DatabaseError.check_error(59, object);
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                int n2 = (int)(n == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    datumArray[i] = OracleTypeNUMBER.toNUMBER(objectArray[(int)l + i - 1], oracleConnection);
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection, l, n);
            }
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n2 = (int)(n == -1 ? (long)sArray.length : Math.min((long)sArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    datumArray[i] = new NUMBER(sArray[(int)l + i - 1]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n3 = (int)(n == -1 ? (long)nArray.length : Math.min((long)nArray.length - l + 1L, (long)n));
                datumArray = new Datum[n3];
                for (int i = 0; i < n3; ++i) {
                    datumArray[i] = new NUMBER(nArray[(int)l + i - 1]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n4 = (int)(n == -1 ? (long)lArray.length : Math.min((long)lArray.length - l + 1L, (long)n));
                datumArray = new Datum[n4];
                for (int i = 0; i < n4; ++i) {
                    datumArray[i] = new NUMBER(lArray[(int)l + i - 1]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n5 = (int)(n == -1 ? (long)fArray.length : Math.min((long)fArray.length - l + 1L, (long)n));
                datumArray = new Datum[n5];
                for (int i = 0; i < n5; ++i) {
                    datumArray[i] = new NUMBER(fArray[(int)l + i - 1]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n6 = (int)(n == -1 ? (long)dArray.length : Math.min((long)dArray.length - l + 1L, (long)n));
                datumArray = new Datum[n6];
                for (int i = 0; i < n6; ++i) {
                    datumArray[i] = new NUMBER(dArray[(int)l + i - 1]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n7 = (int)(n == -1 ? (long)blArray.length : Math.min((long)blArray.length - l + 1L, (long)n));
                datumArray = new Datum[n7];
                for (int i = 0; i < n7; ++i) {
                    datumArray[i] = new NUMBER(new Boolean(blArray[(int)l + i - 1]));
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n8 = (int)(n == -1 ? (long)cArray.length : Math.min((long)cArray.length - l + 1L, (long)n));
                datumArray = new Datum[n8];
                for (int i = 0; i < n8; ++i) {
                    datumArray[i] = new NUMBER(new String(cArray[(int)l + i - 1]));
                }
            } else {
                DatabaseError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public int getScale() {
        return this.m_scale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_scale);
        objectOutputStream.writeInt(this.m_precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_scale = objectInputStream.readInt();
        this.m_precision = objectInputStream.readInt();
    }
}

