/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class Util {
    private static int[] LDSRoundtab = new int[]{0, 1, 0, 2, 0, 0, 0, 3, 0};
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    static void check_next_byte(InputStream inputStream, byte by) throws SQLException {
        try {
            if (inputStream.read() != by) {
                DatabaseError.check_error(47, "parseTDS");
            }
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
        }
    }

    public static int[] toJavaUnsignedBytes(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    static byte[] read_bytes(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        try {
            int n2 = inputStream.read(byArray);
            if (n2 != n) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
        }
        return byArray;
    }

    static void write_bytes(OutputStream outputStream, byte[] byArray) throws SQLException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
        }
    }

    static void skip_bytes(InputStream inputStream, int n) throws SQLException {
        try {
            inputStream.skip(n);
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
        }
    }

    static long read_long(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[4];
        try {
            inputStream.read(byArray);
            return (((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) * 256 + (byArray[2] & 0xFF)) * 256 + (byArray[3] & 0xFF);
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
            return 0L;
        }
    }

    static short read_short(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[2];
        try {
            inputStream.read(byArray);
            return (short)((byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF));
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
            return 0;
        }
    }

    static byte read_byte(InputStream inputStream) throws SQLException {
        try {
            return (byte)inputStream.read();
        }
        catch (IOException iOException) {
            DatabaseError.check_error(iOException);
            return 0;
        }
    }

    static byte FDO_get_size(byte[] byArray, int n) {
        byte by = Util.FDO_get_entry(byArray, n);
        return (byte)(by >> 3 & 0x1F);
    }

    static byte FDO_get_align(byte[] byArray, int n) {
        byte by = Util.FDO_get_entry(byArray, n);
        return (byte)(by & 7);
    }

    static int LDSRound(int n, int n2) {
        int n3 = LDSRoundtab[n2];
        return (n >> n3) + 1 << n3;
    }

    private static byte FDO_get_entry(byte[] byArray, int n) {
        short s = Util.getUnsignedByte(byArray[5]);
        byte by = byArray[6 + s + n];
        return by;
    }

    public static short getUnsignedByte(byte by) {
        return (short)(by & 0xFF);
    }

    public static byte[] serializeObject(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserializeObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new ObjectInputStream(byteArrayInputStream).readObject();
    }

    public static void printByteArray(byte[] byArray) {
        System.out.println("DONT CALL THIS -- oracle.jdbc.oracore.Util.printByteArray");
    }
}

