/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.BfileDBAccess;
import oracle.sql.DatumWithConnection;

public class BFILE
extends DatumWithConnection {
    public static final int MAX_CHUNK_SIZE = 32512;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BfileDBAccess m_dbaccess;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051213";

    protected BFILE() {
    }

    public BFILE(OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public BFILE(OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        this.setPhysicalConnectionOf(oracleConnection);
        this.m_dbaccess = this.getInternalConnection().createBfileDBAccess();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.check_error(68, null);
        }
        byte[] byArray = null;
        if (n == 0) {
            byArray = new byte[]{};
        } else {
            long l2 = 0L;
            byte[] byArray2 = new byte[n];
            l2 = this.getBytes(l, n, byArray2);
            if (l2 > 0L) {
                if (l2 == (long)n) {
                    byArray = byArray2;
                } else {
                    byArray = new byte[(int)l2];
                    System.arraycopy(byArray2, 0, byArray, 0, (int)l2);
                }
            } else {
                byArray = new byte[]{};
            }
        }
        return byArray;
    }

    public int getBytes(long l, int n, byte[] byArray) throws SQLException {
        int n2 = this.getDBAccess().getBytes(this, l, n, byArray);
        return n2;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = this.getDBAccess().newInputStream(this, 32512, 0L);
        return inputStream;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        long l2 = this.getDBAccess().position(this, byArray, l);
        return l2;
    }

    public long position(BFILE bFILE, long l) throws SQLException {
        long l2 = this.getDBAccess().position(this, bFILE, l);
        return l2;
    }

    public String getName() throws SQLException {
        String string = this.getDBAccess().getName(this);
        return string;
    }

    public String getDirAlias() throws SQLException {
        String string = this.getDBAccess().getDirAlias(this);
        return string;
    }

    public void openFile() throws SQLException {
        this.getDBAccess().openFile(this);
    }

    public boolean isFileOpen() throws SQLException {
        boolean bl = this.getDBAccess().isFileOpen(this);
        return bl;
    }

    public boolean fileExists() throws SQLException {
        boolean bl = this.getDBAccess().fileExists(this);
        return bl;
    }

    public void closeFile() throws SQLException {
        this.getDBAccess().closeFile(this);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public InputStream getBinaryStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, 32512, l);
    }

    public void open() throws SQLException {
        this.getDBAccess().open(this, 0);
    }

    public void open(int n) throws SQLException {
        if (n != 0) {
            DatabaseError.throwSqlException(102);
        }
        this.getDBAccess().open(this, n);
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        boolean bl = string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
        return bl;
    }

    public Reader characterStreamValue() throws SQLException {
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int n) {
        return new BFILE[n];
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            this.m_dbaccess = this.getInternalConnection().createBfileDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(8);
        }
        return this.m_dbaccess;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }
}

