/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.threaddump.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Segment;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;
import org.graalvm.visualvm.threaddump.ThreadDump;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.util.NbBundle;

class ThreadDumpView
extends SnapshotView {
    private static final Logger LOGGER = Logger.getLogger(ThreadDumpView.class.getName());

    ThreadDumpView(ThreadDump threadDump) {
        this(threadDump, DataSourceDescriptorFactory.getDescriptor((DataSource)threadDump));
    }

    private ThreadDumpView(ThreadDump threadDump, DataSourceDescriptor descriptor) {
        super((Snapshot)threadDump, descriptor.getName(), descriptor.getIcon(), 0);
    }

    protected DataViewComponent createComponent() {
        ThreadDump threadDump = (ThreadDump)this.getDataSource();
        DataViewComponent dvc = new DataViewComponent(new MasterViewSupport(threadDump).getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        return dvc;
    }

    private static class CustomHTMLDocument
    extends HTMLDocument {
        private static final int CACHE_BOUNDARY = 1000;
        private char[] segArray;
        private int segOffset;
        private int segCount;
        private boolean segPartialReturn;
        private int lastOffset = -1;
        private int lastLength = -1;

        private CustomHTMLDocument(StyleSheet ss) {
            super(ss);
            this.putProperty("multiByte", Boolean.TRUE);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            if (this.lastOffset == offset && this.lastLength == length) {
                txt.array = this.segArray;
                txt.offset = this.segOffset;
                txt.count = this.segCount;
                txt.setPartialReturn(this.segPartialReturn);
                return;
            }
            super.getText(offset, length, txt);
            if (length > 1000 || this.lastLength <= 1000) {
                this.segArray = Arrays.copyOf(txt.array, txt.array.length);
                this.segOffset = txt.offset;
                this.segCount = txt.count;
                this.segPartialReturn = txt.isPartialReturn();
                this.lastOffset = offset;
                this.lastLength = length;
            }
        }
    }

    private static class CustomHtmlEditorKit
    extends HTMLEditorKit {
        private CustomHtmlEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            CustomHTMLDocument doc = new CustomHTMLDocument(ss);
            doc.setParser(this.getParser());
            doc.setAsynchronousLoadPriority(4);
            doc.setTokenThreshold(100);
            return doc;
        }
    }

    private static class MasterViewSupport
    extends JPanel {
        private JLabel progressLabel;
        private JPanel contentsPanel;

        MasterViewSupport(ThreadDump threadDump) {
            this.initComponents();
            this.loadThreadDump(threadDump.getFile());
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ThreadDumpView.class, (String)"LBL_Thread_Dump"), null, (JComponent)this);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.progressLabel = new JLabel(NbBundle.getMessage(ThreadDumpView.class, (String)"MSG_Loading_Thread_Dump"), 0);
            this.contentsPanel = new JPanel(new BorderLayout());
            this.contentsPanel.add((Component)this.progressLabel, "Center");
            this.contentsPanel.setOpaque(false);
            this.add((Component)this.contentsPanel, "Center");
            this.setOpaque(false);
        }

        private static String htmlize(String value) {
            return value.replace("&", "&amp;").replace("<", "&lt;").replace("\t", "        ");
        }

        private static String transform(String value) {
            String alternateColor = !UISupport.isDarkResultsBackground() ? "#0033CC" : "#FFCC33";
            StringBuilder sb = new StringBuilder();
            String[] result = value.split("\\r?\\n");
            for (int i = 0; i < result.length; ++i) {
                String line = result[i];
                if (!line.isEmpty() && !Character.isWhitespace(line.charAt(0))) {
                    sb.append("<span style=\"color: ").append(alternateColor).append("\">");
                    sb.append(line);
                    sb.append("</span><br>");
                    continue;
                }
                sb.append(line);
                sb.append("<br>");
            }
            return sb.toString();
        }

        private void loadThreadDump(final File file) {
            VisualVM.getInstance().runTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(file);
                        byte[] data = new byte[(int)file.length()];
                        try {
                            ((InputStream)is).read(data);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, "Failed to read thread dump", ex);
                        }
                        try {
                            HTMLTextArea area = new HTMLTextArea();
                            area.setEditorKit((EditorKit)new CustomHtmlEditorKit());
                            area.setForeground(!UISupport.isDarkResultsBackground() ? new Color(204, 51, 0) : new Color(51, 204, 255));
                            area.setText("<pre>" + MasterViewSupport.transform(MasterViewSupport.htmlize(new String(data, "UTF-8"))) + "</pre>");
                            area.setCaretPosition(0);
                            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
                            contentsPanel.remove(progressLabel);
                            contentsPanel.add((Component)new ScrollableContainer((JComponent)area), "Center");
                            contentsPanel.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)area), "South");
                            contentsPanel.revalidate();
                            contentsPanel.repaint();
                        }
                        catch (Exception ex) {
                            LOGGER.throwing(ThreadDumpView.class.getName(), "loadThreadDump", ex);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.log(Level.INFO, "Failed to load thread dump", ex);
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
    }
}

