/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IMCClassLoader;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCModule;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectArray;
import org.openjdk.jmc.common.IMCOldObjectField;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.MethodToolkit;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

class StructTypes {
    private static final JfrMethod UNKNOWN_METHOD = new JfrMethod();
    private static final JfrJavaClass UNKNOWN_CLASS = new JfrJavaClass();
    private static final JfrJavaPackage UNKNOWN_PACKAGE = new JfrJavaPackage();

    StructTypes() {
    }

    static class JfrStackTrace
    implements IMCStackTrace {
        public Object frames;
        public Object truncated;

        JfrStackTrace() {
        }

        public List<? extends IMCFrame> getFrames() {
            List<Object> l = this.frames;
            if (!(l instanceof List)) {
                this.frames = l = Arrays.asList((Object[])l);
            }
            return l;
        }

        public IMCStackTrace.TruncationState getTruncationState() {
            return this.truncated == null ? IMCStackTrace.TruncationState.UNKNOWN : ((Boolean)this.truncated != false ? IMCStackTrace.TruncationState.TRUNCATED : IMCStackTrace.TruncationState.NOT_TRUNCATED);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.frames);
            result = 31 * result + Objects.hashCode(this.truncated);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrStackTrace) {
                JfrStackTrace ost = (JfrStackTrace)obj;
                return Objects.equals(ost.frames, this.frames) && Objects.equals(ost.truncated, this.truncated);
            }
            return false;
        }
    }

    static class JfrFrame
    implements IMCFrame {
        public Object method;
        public Object lineNumber;
        public Object bytecodeIndex;
        public Object type;

        JfrFrame() {
        }

        public Integer getFrameLineNumber() {
            return (Integer)this.lineNumber;
        }

        public Integer getBCI() {
            return (Integer)this.bytecodeIndex;
        }

        public IMCMethod getMethod() {
            if (this.method == null) {
                return UNKNOWN_METHOD;
            }
            return (IMCMethod)this.method;
        }

        public IMCFrame.Type getType() {
            Object t = this.type;
            if (!(t instanceof IMCFrame.Type)) {
                this.type = t = ParserToolkit.parseFrameType((String)t);
            }
            return (IMCFrame.Type)t;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.method);
            result = 31 * result + Objects.hashCode(this.type);
            result = 31 * result + Objects.hashCode(this.lineNumber);
            result = 31 * result + Objects.hashCode(this.bytecodeIndex);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrFrame) {
                JfrFrame of = (JfrFrame)obj;
                return Objects.equals(of.type, this.type) && Objects.equals(of.method, this.method) && Objects.equals(of.lineNumber, this.lineNumber) && Objects.equals(of.bytecodeIndex, this.bytecodeIndex);
            }
            return false;
        }
    }

    static class JfrMethod
    implements IMCMethod {
        public Object type;
        public Object name;
        public Object descriptor;
        public Object modifiers;
        public Object hidden;

        JfrMethod() {
        }

        public IMCType getType() {
            if (this.type == null) {
                return UNKNOWN_CLASS;
            }
            return (IMCType)this.type;
        }

        public String getMethodName() {
            return (String)this.name;
        }

        public String getFormalDescriptor() {
            return (String)this.descriptor;
        }

        public Integer getModifier() {
            return (Integer)this.modifiers;
        }

        public Boolean isNative() {
            return null;
        }

        public Boolean isHidden() {
            return (Boolean)this.hidden;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.type);
            result = 31 * result + Objects.hashCode(this.descriptor);
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JfrMethod) {
                JfrMethod om = (JfrMethod)obj;
                return Objects.equals(om.type, this.type) && Objects.equals(om.descriptor, this.descriptor) && Objects.equals(om.name, this.name);
            }
            return false;
        }
    }

    static class JfrOldObjectField
    implements IMCOldObjectField {
        public Object name;
        public Object modifiers;

        JfrOldObjectField() {
        }

        public String getName() {
            if (this.name instanceof String) {
                return (String)this.name;
            }
            return null;
        }

        public Integer getModifier() {
            if (this.modifiers instanceof IQuantity) {
                try {
                    this.modifiers = (int)((IQuantity)this.modifiers).longValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                }
                catch (QuantityConversionException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not convert modifier value to Integer", e);
                    this.modifiers = null;
                    return null;
                }
            }
            if (this.modifiers instanceof Integer) {
                return (Integer)this.modifiers;
            }
            return null;
        }
    }

    static class JfrOldObjectArray
    implements IMCOldObjectArray {
        public Object size;
        public Object index;

        JfrOldObjectArray() {
        }

        public Long getSize() {
            if (this.size instanceof IQuantity) {
                try {
                    this.size = ((IQuantity)this.size).longValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                }
                catch (QuantityConversionException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not convert array size", e);
                    this.size = null;
                    return null;
                }
            }
            if (this.size instanceof Long) {
                return (Long)this.size;
            }
            return null;
        }

        public Long getIndex() {
            if (this.index instanceof IQuantity) {
                try {
                    this.index = ((IQuantity)this.index).longValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                }
                catch (QuantityConversionException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not convert array index", e);
                    this.index = null;
                    return null;
                }
            }
            if (this.index instanceof Long) {
                return (Long)this.index;
            }
            return null;
        }

        public String toString() {
            return "[" + this.getIndex() + "/" + this.getSize() + "]";
        }
    }

    static class JfrOldObject
    implements IMCOldObject {
        private static final int referrerArrayIndex = 0;
        private static final int referrerFieldIndex = 1;
        private static final int referrerOldObjectIndex = 2;
        private static final int referrerSkipIndex = 3;
        public Object address;
        public Object type;
        public Object description;
        public Object referrer;

        JfrOldObject() {
        }

        public IQuantity getAddress() {
            if (this.address instanceof IQuantity) {
                return (IQuantity)this.address;
            }
            return null;
        }

        public IMCOldObjectArray getReferrerArray() {
            if (this.referrer != null && ((Object[])this.referrer)[0] instanceof IMCOldObjectArray) {
                return (IMCOldObjectArray)((Object[])this.referrer)[0];
            }
            return null;
        }

        public IMCOldObjectField getReferrerField() {
            if (this.referrer != null && ((Object[])this.referrer)[1] instanceof IMCOldObjectField) {
                return (IMCOldObjectField)((Object[])this.referrer)[1];
            }
            return null;
        }

        public IMCType getType() {
            if (this.type instanceof IMCType) {
                return (IMCType)this.type;
            }
            return null;
        }

        public String getDescription() {
            if (this.description instanceof String) {
                return (String)this.description;
            }
            return null;
        }

        public IMCOldObject getReferrer() {
            if (this.referrer != null && ((Object[])this.referrer)[2] instanceof IMCOldObject) {
                return (IMCOldObject)((Object[])this.referrer)[2];
            }
            return null;
        }

        public int getReferrerSkip() {
            if (this.referrer != null && ((Object[])this.referrer)[3] instanceof IQuantity) {
                return (int)((IQuantity)((Object[])this.referrer)[3]).longValue();
            }
            return 0;
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof IMCOldObject) {
                return ((IMCOldObject)o).getAddress().equals(this.getAddress());
            }
            return false;
        }

        public String toString() {
            Integer modifier;
            String s = this.getType().getFullName();
            if (this.getReferrerArray() != null) {
                s = s + this.getReferrerArray().toString();
            }
            if (this.getReferrerField() != null && (modifier = this.getReferrerField().getModifier()) != null) {
                s = modifier == 0 ? s + "." + this.getReferrerField().getName() : Modifier.toString(modifier) + " " + s + "." + this.getReferrerField().getName();
            }
            s = s + " @ " + this.getAddress().displayUsing("auto");
            if (this.getReferrerSkip() > 0) {
                s = s + MessageFormat.format(" ({0} skipped objects from referrer)", this.getReferrerSkip());
            }
            return s;
        }
    }

    static class JfrOldObjectGcRoot
    implements IMCOldObjectGcRoot {
        public Object system;
        public Object type;
        public Object description;

        JfrOldObjectGcRoot() {
        }

        public String getDescription() {
            return (String)this.description;
        }

        public String getSystem() {
            return (String)this.system;
        }

        public String getType() {
            return (String)this.type;
        }

        public String toString() {
            String rootDescription = this.getType() + " : " + this.getSystem();
            if (this.getDescription() != null) {
                rootDescription = rootDescription + " (" + this.getDescription() + ")";
            }
            return rootDescription;
        }
    }

    static class JfrJavaClass
    implements IMCType {
        public Object classLoader;
        public Object modifiers;
        public Object _package;
        public Object name;
        private boolean convertedNames;
        private String typeName;

        JfrJavaClass() {
        }

        public String getTypeName() {
            if (!this.convertedNames) {
                this.convertNames();
            }
            return this.typeName;
        }

        private String getPackageName() {
            if (this._package instanceof IMCPackage) {
                return ((IMCPackage)this._package).getName();
            }
            return "";
        }

        public IMCPackage getPackage() {
            if (this._package == null) {
                this._package = UNKNOWN_PACKAGE;
            }
            return (IMCPackage)this._package;
        }

        public String getFullName() {
            if (!this.convertedNames) {
                this.convertNames();
            }
            return (String)this.name;
        }

        private void convertNames() {
            if (!this.convertedNames) {
                if (this.name != null) {
                    this.name = MethodToolkit.refTypeToBinaryJLS((String)((String)this.name));
                }
                this.typeName = this.getPackageName() != null && this.getPackageName().length() > 0 ? ((String)this.name).substring(this.getPackageName().length() + 1) : (String)this.name;
                this.convertedNames = true;
            }
        }

        public int hashCode() {
            return Objects.hashCode(this.getFullName());
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaClass && Objects.equals(this.getFullName(), ((JfrJavaClass)obj).getFullName());
        }

        public String toString() {
            return this.getFullName();
        }
    }

    static class JfrJavaClassLoader
    implements IMCClassLoader {
        public Object type;
        public Object name;

        JfrJavaClassLoader() {
        }

        public IMCType getType() {
            if (this.type != null && !(this.type instanceof IMCType)) {
                this.type = MethodToolkit.typeFromReference((String)((String)this.type));
            }
            return (IMCType)this.type;
        }

        public String getName() {
            return (String)this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaClassLoader && Objects.equals(this.name, ((JfrJavaClassLoader)obj).name) && Objects.equals(this.type, ((JfrJavaClassLoader)obj).type);
        }

        public String toString() {
            return FormatToolkit.getHumanReadable((IMCClassLoader)this);
        }
    }

    static class JfrJavaModule
    implements IMCModule,
    IDescribable {
        public Object name;
        public Object version;
        public Object location;
        public Object classLoader;

        JfrJavaModule() {
        }

        public String getName() {
            return (String)this.name;
        }

        public String getVersion() {
            return (String)this.version;
        }

        public String getLocation() {
            return (String)this.location;
        }

        public IMCClassLoader getClassLoader() {
            return (IMCClassLoader)this.classLoader;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaModule && Objects.equals(this.name, ((JfrJavaModule)obj).name);
        }

        public String toString() {
            return "Module: " + this.getName();
        }

        public String getDescription() {
            return MessageFormat.format("{0} (version={1}, location={2}, class loader={3})", this.getName(), this.getVersion(), this.getLocation(), this.getClassLoader());
        }
    }

    static class JfrJavaPackage
    implements IMCPackage,
    IDescribable {
        public Object name;
        public Object module;
        public Object exported;
        private boolean convertedName = false;

        JfrJavaPackage() {
        }

        public String getName() {
            if (!this.convertedName) {
                if (this.name != null) {
                    this.name = MethodToolkit.refTypeToBinaryJLS((String)((String)this.name));
                }
                this.convertedName = true;
            }
            return (String)this.name;
        }

        public IMCModule getModule() {
            return (IMCModule)this.module;
        }

        public Boolean isExported() {
            return (Boolean)this.exported;
        }

        public int hashCode() {
            return Objects.hash(this.getName());
        }

        public boolean equals(Object obj) {
            return obj instanceof JfrJavaPackage && Objects.equals(this.getName(), ((JfrJavaPackage)obj).getName());
        }

        public String toString() {
            return "Package: " + this.getName();
        }

        public String getDescription() {
            return MessageFormat.format("{0} (module={1}, exported={2})", this.getName(), this.getModule() != null ? this.getModule().getName() : null, this.isExported());
        }
    }

    static class JfrThreadGroup
    implements IMCThreadGroup {
        public Object name;
        public Object parent;

        JfrThreadGroup() {
        }

        public String getName() {
            return (String)this.name;
        }

        public IMCThreadGroup getParent() {
            return (IMCThreadGroup)this.parent;
        }

        public String toString() {
            return this.getName();
        }
    }

    static class JfrThread
    implements IMCThread {
        public Object osName;
        public Object osThreadId;
        public Object javaThreadId;
        public Object javaName;
        public Object group;

        JfrThread() {
        }

        public Long getThreadId() {
            return (Long)this.javaThreadId;
        }

        public String getThreadName() {
            return (String)(this.javaName != null ? this.javaName : this.osName);
        }

        public IMCThreadGroup getThreadGroup() {
            Object threadGroup = this.group;
            return (IMCThreadGroup)threadGroup;
        }

        public String toString() {
            String name = this.getThreadName();
            return name == null ? "" : name;
        }

        public int hashCode() {
            return Objects.hashCode(this.osThreadId);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof JfrThread && Objects.equals(this.osThreadId, ((JfrThread)obj).osThreadId);
        }
    }
}

