/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.graalvm.visualvm.lib.jfluid.utils.FloatSorter;
import org.graalvm.visualvm.lib.jfluid.utils.IntSorter;
import org.graalvm.visualvm.lib.jfluid.utils.LongSorter;
import org.graalvm.visualvm.lib.jfluid.utils.StringSorter;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.ui.ResultsPanel;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.FilterComponent;
import org.graalvm.visualvm.lib.ui.components.JExtendedTable;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.ExtendedTableModel;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;

public abstract class MemoryResultsPanel
extends ResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String CLASS_NAME_FILTER = messages.getString("MemoryResultsPanel_ClassNameFilterHint");
    protected ArrayList filteredToFullIndexes;
    protected CustomBarCellRenderer barRenderer;
    protected ExtendedTableModel resTableModel;
    protected FilterComponent filterComponent;
    protected JButton cornerButton;
    protected JExtendedTable resTable;
    protected JPopupMenu headerPopup;
    protected JScrollPane jScrollPane;
    protected MemoryResUserActionsHandler actionsHandler;
    protected String filterString = "";
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    protected int[] sortedClassIds;
    protected String[] sortedClassNames;
    protected boolean registeredMouseListenerWithResTable;
    protected boolean sortOrder;
    protected double valueFilterValue = 0.0;
    protected int clickedLine;
    protected int filterType = 20;
    protected int nDisplayedItems;
    protected int nInfoLines;
    protected int nTrackedItems;
    protected int selectedClassId;
    protected int sortBy;
    protected long maxValue;
    protected long totalAllocations;

    public MemoryResultsPanel(MemoryResUserActionsHandler actionsHandler) {
        this.actionsHandler = actionsHandler;
        this.filteredToFullIndexes = new ArrayList();
        this.headerPopup = new JPopupMenu();
        this.jScrollPane = this.createScrollPaneVerticalScrollBarAlways();
        this.jScrollPane.setCorner("UPPER_RIGHT_CORNER", this.createHeaderPopupCornerButton(this.headerPopup));
        this.jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.initFilterPanel();
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.resTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setFindString(String findString) {
        this.resTable.setFindParameters(findString, 0);
    }

    public String getFindString() {
        return this.resTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.resTable.isFindStringDefined();
    }

    public boolean findFirst() {
        return this.resTable.findFirst();
    }

    public boolean findNext() {
        return this.resTable.findNext();
    }

    public boolean findPrevious() {
        return this.resTable.findPrevious();
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        final JExtendedTable table = this.getResultsTable();
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryResultsPanel.this.performDefaultAction(MemoryResultsPanel.this.selectedClassId);
            }
        });
        this.jScrollPane.setViewportView(table);
        this.jScrollPane.getViewport().setBackground(table.getBackground());
        if (!this.registeredMouseListenerWithResTable) {
            this.jScrollPane.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    table.mouseWheelMoved(e);
                }
            });
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selectedRow = table.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(selectedRow)];
                }
            });
            table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int selectedRow;
                    if ((e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) && (selectedRow = table.getSelectedRow()) != -1) {
                        MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(selectedRow)];
                        Rectangle cellRect = table.getCellRect(selectedRow, 0, false);
                        JPopupMenu popup = MemoryResultsPanel.this.getPopupMenu();
                        if (popup != null) {
                            popup.show(e.getComponent(), cellRect.x + table.getSize().width > 50 ? 50 : 5, cellRect.y);
                        }
                    }
                }
            });
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int line;
                    if (e.getModifiers() == 4 && (line = table.rowAtPoint(e.getPoint())) != -1) {
                        table.setRowSelectionInterval(line, line);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    MemoryResultsPanel.this.clickedLine = table.rowAtPoint(e.getPoint());
                    if (MemoryResultsPanel.this.clickedLine != -1) {
                        MemoryResultsPanel.this.resTable.getSelectionModel().setSelectionInterval(MemoryResultsPanel.this.clickedLine, MemoryResultsPanel.this.clickedLine);
                        MemoryResultsPanel.this.selectedClassId = MemoryResultsPanel.this.sortedClassIds[(Integer)MemoryResultsPanel.this.filteredToFullIndexes.get(MemoryResultsPanel.this.clickedLine)];
                        if (e.getModifiers() == 4) {
                            JPopupMenu popup = MemoryResultsPanel.this.getPopupMenu();
                            if (popup != null) {
                                popup.show(e.getComponent(), e.getX(), e.getY());
                            }
                        } else if (e.getModifiers() == 16 && e.getClickCount() == 2) {
                            MemoryResultsPanel.this.performDefaultAction(MemoryResultsPanel.this.selectedClassId);
                        }
                    }
                }
            });
            this.registeredMouseListenerWithResTable = true;
        }
    }

    @Override
    public void requestFocus() {
        if (this.resTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryResultsPanel.this.resTable.requestFocus();
                }
            });
        }
    }

    public void reset() {
        this.jScrollPane.setViewportView(null);
    }

    public void updateValueFilter(double value) {
        this.valueFilterValue = value / 3.0;
        this.createFilteredIndexes();
        this.resTable.invalidate();
        this.jScrollPane.revalidate();
        this.resTable.repaint();
    }

    protected abstract String getClassName(int var1);

    protected abstract String[] getClassNames();

    protected abstract JPopupMenu getPopupMenu();

    protected abstract JExtendedTable getResultsTable();

    protected void createFilteredIndexes() {
        this.filteredToFullIndexes.clear();
        for (int i = 0; i < this.nInfoLines; ++i) {
            if (!this.passesFilters(i) || !this.passesValueFilter(i)) continue;
            this.filteredToFullIndexes.add(i);
        }
        this.nDisplayedItems = this.filteredToFullIndexes.size();
    }

    protected final void doCreateClassNamesFromScratch() {
        String[] classNames = this.getClassNames();
        if (this.sortedClassNames == null || this.sortedClassNames.length < classNames.length) {
            this.sortedClassNames = new String[classNames.length];
            this.sortedClassIds = new int[classNames.length];
        }
        for (int i = 0; i < classNames.length; ++i) {
            this.sortedClassNames[i] = StringUtils.userFormClassName((String)classNames[i]);
            this.sortedClassIds[i] = i;
        }
    }

    protected void initDataUponResultsFetch() {
        this.doCreateClassNamesFromScratch();
    }

    protected boolean passesValueFilter(int i) {
        return true;
    }

    protected abstract void performDefaultAction(int var1);

    protected void showSourceForClass(int classId) {
        if (classId < 0) {
            return;
        }
        String className = StringUtils.userFormClassName((String)this.getClassName(classId));
        this.actionsHandler.showSourceForMethod(className, null, null);
    }

    protected int sortResults(final int[] results, final int[][] secondaryIntData, final long[][] secondaryLongData, final float[][] secondaryFloatData, int off, int len, boolean truncateZeroItems) {
        final int nSecIDataArrays = secondaryIntData != null ? secondaryIntData.length : 0;
        final int nSecLDataArrays = secondaryLongData != null ? secondaryLongData.length : 0;
        final int nSecFDataArrays = secondaryFloatData != null ? secondaryFloatData.length : 0;
        new IntSorter(results, off, len){

            protected void swap(int a, int b) {
                if (results[a] != results[b]) {
                    int i;
                    super.swap(a, b);
                    String tmp = MemoryResultsPanel.this.sortedClassNames[a];
                    MemoryResultsPanel.this.sortedClassNames[a] = MemoryResultsPanel.this.sortedClassNames[b];
                    MemoryResultsPanel.this.sortedClassNames[b] = tmp;
                    int tmpI = MemoryResultsPanel.this.sortedClassIds[a];
                    MemoryResultsPanel.this.sortedClassIds[a] = MemoryResultsPanel.this.sortedClassIds[b];
                    MemoryResultsPanel.this.sortedClassIds[b] = tmpI;
                    for (i = 0; i < nSecIDataArrays; ++i) {
                        tmpI = secondaryIntData[i][a];
                        secondaryIntData[i][a] = secondaryIntData[i][b];
                        secondaryIntData[i][b] = tmpI;
                    }
                    for (i = 0; i < nSecLDataArrays; ++i) {
                        long tmpL = secondaryLongData[i][a];
                        secondaryLongData[i][a] = secondaryLongData[i][b];
                        secondaryLongData[i][b] = tmpL;
                    }
                    for (i = 0; i < nSecFDataArrays; ++i) {
                        float tmpF = secondaryFloatData[i][a];
                        secondaryFloatData[i][a] = secondaryFloatData[i][b];
                        secondaryFloatData[i][b] = tmpF;
                    }
                }
            }
        }.sort(this.sortOrder);
        len = off + len;
        return len;
    }

    protected int sortResults(final long[] results, final int[][] secondaryIntData, final long[][] secondaryLongData, final float[][] secondaryFloatData, int off, int len, boolean truncateZeroItems) {
        final int nSecIDataArrays = secondaryIntData != null ? secondaryIntData.length : 0;
        final int nSecLDataArrays = secondaryLongData != null ? secondaryLongData.length : 0;
        final int nSecFDataArrays = secondaryFloatData != null ? secondaryFloatData.length : 0;
        new LongSorter(results, off, len){

            protected void swap(int a, int b) {
                if (results[a] != results[b]) {
                    int i;
                    super.swap(a, b);
                    String tmp = MemoryResultsPanel.this.sortedClassNames[a];
                    MemoryResultsPanel.this.sortedClassNames[a] = MemoryResultsPanel.this.sortedClassNames[b];
                    MemoryResultsPanel.this.sortedClassNames[b] = tmp;
                    int tmpI = MemoryResultsPanel.this.sortedClassIds[a];
                    MemoryResultsPanel.this.sortedClassIds[a] = MemoryResultsPanel.this.sortedClassIds[b];
                    MemoryResultsPanel.this.sortedClassIds[b] = tmpI;
                    for (i = 0; i < nSecIDataArrays; ++i) {
                        tmpI = secondaryIntData[i][a];
                        secondaryIntData[i][a] = secondaryIntData[i][b];
                        secondaryIntData[i][b] = tmpI;
                    }
                    for (i = 0; i < nSecLDataArrays; ++i) {
                        long tmpL = secondaryLongData[i][a];
                        secondaryLongData[i][a] = secondaryLongData[i][b];
                        secondaryLongData[i][b] = tmpL;
                    }
                    for (i = 0; i < nSecFDataArrays; ++i) {
                        float tmpF = secondaryFloatData[i][a];
                        secondaryFloatData[i][a] = secondaryFloatData[i][b];
                        secondaryFloatData[i][b] = tmpF;
                    }
                }
            }
        }.sort(this.sortOrder);
        len = off + len;
        return len;
    }

    protected int sortResults(final float[] results, final int[][] secondaryIntData, final long[][] secondaryLongData, int off, int len, boolean truncateZeroItems) {
        final int nSecIDataArrays = secondaryIntData != null ? secondaryIntData.length : 0;
        final int nSecLDataArrays = secondaryLongData != null ? secondaryLongData.length : 0;
        new FloatSorter(results, off, len){

            protected void swap(int a, int b) {
                if (results[a] != results[b]) {
                    int i;
                    super.swap(a, b);
                    String tmp = MemoryResultsPanel.this.sortedClassNames[a];
                    MemoryResultsPanel.this.sortedClassNames[a] = MemoryResultsPanel.this.sortedClassNames[b];
                    MemoryResultsPanel.this.sortedClassNames[b] = tmp;
                    int tmpI = MemoryResultsPanel.this.sortedClassIds[a];
                    MemoryResultsPanel.this.sortedClassIds[a] = MemoryResultsPanel.this.sortedClassIds[b];
                    MemoryResultsPanel.this.sortedClassIds[b] = tmpI;
                    for (i = 0; i < nSecIDataArrays; ++i) {
                        tmpI = secondaryIntData[i][a];
                        secondaryIntData[i][a] = secondaryIntData[i][b];
                        secondaryIntData[i][b] = tmpI;
                    }
                    for (i = 0; i < nSecLDataArrays; ++i) {
                        long tmpL = secondaryLongData[i][a];
                        secondaryLongData[i][a] = secondaryLongData[i][b];
                        secondaryLongData[i][b] = tmpL;
                    }
                }
            }
        }.sort(this.sortOrder);
        len = off + len;
        return len;
    }

    protected int sortResultsByClassName(final int[][] secondaryIntData, final long[][] secondaryLongData, final float[][] secondaryFloatData, int len, boolean truncateZeroItems) {
        int nSecFDataArrays;
        if (len == 0) {
            return 0;
        }
        final int nSecIDataArrays = secondaryIntData != null ? secondaryIntData.length : 0;
        final int nSecLDataArrays = secondaryLongData != null ? secondaryLongData.length : 0;
        int n = nSecFDataArrays = secondaryFloatData != null ? secondaryFloatData.length : 0;
        if (truncateZeroItems) {
            int head = 0;
            for (int tail = len - 1; head < tail; ++head, --tail) {
                int i;
                while (secondaryIntData[0][tail] == 0 && tail > head) {
                    --tail;
                }
                if (tail <= head) break;
                while (secondaryIntData[0][head] != 0 && head < tail) {
                    ++head;
                }
                if (head >= tail) break;
                String tmpS = this.sortedClassNames[head];
                this.sortedClassNames[head] = this.sortedClassNames[tail];
                this.sortedClassNames[tail] = tmpS;
                int tmpI = this.sortedClassIds[head];
                this.sortedClassIds[head] = this.sortedClassIds[tail];
                this.sortedClassIds[tail] = tmpI;
                for (i = 0; i < nSecIDataArrays; ++i) {
                    tmpI = secondaryIntData[i][head];
                    secondaryIntData[i][head] = secondaryIntData[i][tail];
                    secondaryIntData[i][tail] = tmpI;
                }
                for (i = 0; i < nSecLDataArrays; ++i) {
                    long tmpL = secondaryLongData[i][head];
                    secondaryLongData[i][head] = secondaryLongData[i][tail];
                    secondaryLongData[i][tail] = tmpL;
                }
                for (i = 0; i < nSecFDataArrays; ++i) {
                    float tmpF = secondaryFloatData[i][head];
                    secondaryFloatData[i][head] = secondaryFloatData[i][tail];
                    secondaryFloatData[i][tail] = tmpF;
                }
            }
            if (secondaryIntData[0][len = head] != 0) {
                ++len;
            }
        }
        new StringSorter(this.sortedClassNames, 0, len){

            protected void swap(int a, int b) {
                int i;
                super.swap(a, b);
                int tmpI = MemoryResultsPanel.this.sortedClassIds[a];
                MemoryResultsPanel.this.sortedClassIds[a] = MemoryResultsPanel.this.sortedClassIds[b];
                MemoryResultsPanel.this.sortedClassIds[b] = tmpI;
                for (i = 0; i < nSecIDataArrays; ++i) {
                    tmpI = secondaryIntData[i][a];
                    secondaryIntData[i][a] = secondaryIntData[i][b];
                    secondaryIntData[i][b] = tmpI;
                }
                for (i = 0; i < nSecLDataArrays; ++i) {
                    long tmpL = secondaryLongData[i][a];
                    secondaryLongData[i][a] = secondaryLongData[i][b];
                    secondaryLongData[i][b] = tmpL;
                }
                for (i = 0; i < nSecFDataArrays; ++i) {
                    float tmpF = secondaryFloatData[i][a];
                    secondaryFloatData[i][a] = secondaryFloatData[i][b];
                    secondaryFloatData[i][b] = tmpF;
                }
            }
        }.sort(this.sortOrder);
        return len;
    }

    protected boolean truncateZeroItems() {
        return true;
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        this.filterComponent.setHint(CLASS_NAME_FILTER);
        this.filterComponent.setFilter(this.filterString, this.filterType);
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String selectedRowContents = null;
                int selectedRow = MemoryResultsPanel.this.resTable.getSelectedRow();
                if (selectedRow != -1) {
                    selectedRowContents = (String)MemoryResultsPanel.this.resTable.getValueAt(selectedRow, 0);
                }
                MemoryResultsPanel.this.filterString = MemoryResultsPanel.this.filterComponent.getFilterValue();
                MemoryResultsPanel.this.filterType = MemoryResultsPanel.this.filterComponent.getFilterType();
                MemoryResultsPanel.this.createFilteredIndexes();
                MemoryResultsPanel.this.resTable.invalidate();
                MemoryResultsPanel.this.jScrollPane.revalidate();
                MemoryResultsPanel.this.resTable.repaint();
                if (selectedRowContents != null) {
                    MemoryResultsPanel.this.resTable.selectRowByContents(selectedRowContents, 0, true);
                }
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private boolean passesFilter(int idx, String filter) {
        String value = this.sortedClassNames[idx];
        if ("".equals(filter)) {
            return true;
        }
        switch (this.filterType) {
            case 20: {
                return value.toLowerCase().contains(filter);
            }
            case 25: {
                return !value.toLowerCase().contains(filter);
            }
            case 50: {
                try {
                    return value.matches(filter);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean passesFilters(int idx) {
        if (this.filterType == 0) {
            return true;
        }
        String[] filters = FilterComponent.getFilterValues(this.filterString);
        if (filters == null) {
            return true;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (!this.passesFilter(idx, filters[i])) continue;
            return true;
        }
        return false;
    }
}

