/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.reactivestreams.Publisher;

public class Closeables {
    private Closeables() {
    }

    public static <E> CloseableSpliterator<E> spliterator(CloseableIterator<? extends E> iterator, long size, int characteristics) {
        return new CloseableIteratorAsCloseableSpliterator<E>(iterator, size, characteristics);
    }

    public static <T> CloseableSpliterator<T> spliterator(Spliterator<T> spliterator) {
        if (spliterator instanceof CloseableSpliterator) {
            return (CloseableSpliterator)spliterator;
        }
        return new SpliteratorAsCloseableSpliterator<T>(spliterator);
    }

    public static <R> CloseableSpliterator<R> spliterator(BaseStream<R, Stream<R>> stream) {
        Spliterator<R> spliterator = stream.spliterator();
        if (spliterator instanceof CloseableSpliterator) {
            return (CloseableSpliterator)spliterator;
        }
        return new StreamToCloseableSpliterator<R>(stream, spliterator);
    }

    public static <R> CloseableIterator<R> iterator(BaseStream<R, Stream<R>> stream) {
        Iterator<R> iterator = stream.iterator();
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new StreamToCloseableIterator<R>(stream, iterator);
    }

    public static <E> CloseableIterator<E> iterator(Iterator<? extends E> iterator) {
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new IteratorAsCloseableIterator<E>(iterator);
    }

    public static <E> Stream<E> stream(CloseableSpliterator<E> spliterator, boolean parallel) {
        Stream<E> stream = StreamSupport.stream(spliterator, parallel);
        stream.onClose(spliterator::close);
        return stream;
    }

    public static <E> Stream<E> stream(CloseableIterator<E> iterator, boolean parallel, long size, int characteristics) {
        Stream<E> stream = StreamSupport.stream(Spliterators.spliterator(iterator, size, characteristics), parallel);
        stream.onClose(iterator::close);
        return stream;
    }

    public static <E> CloseableIterator<E> iterator(Publisher<E> publisher, int fetchSize) {
        Flowable flowable = Flowable.fromPublisher(publisher);
        Iterable iterable = flowable.blockingIterable(fetchSize);
        final Iterator iterator = iterable.iterator();
        return new CloseableIterator<E>(){

            @Override
            public void close() {
                ((Disposable)iterator).dispose();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }
        };
    }

    private static class CloseableIteratorAsCloseableSpliterator<E>
    extends SpliteratorAsCloseableSpliterator<E> {
        private final CloseableIterator<? extends E> iterator;

        CloseableIteratorAsCloseableSpliterator(CloseableIterator<? extends E> iterator, long size, int characteristics) {
            super(Spliterators.spliterator(iterator, size, characteristics));
            this.iterator = iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    private static class SpliteratorAsCloseableSpliterator<T>
    implements CloseableSpliterator<T> {
        private final Spliterator<T> spliterator;

        public SpliteratorAsCloseableSpliterator(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            return this.spliterator.trySplit();
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics();
        }
    }

    private static class StreamToCloseableSpliterator<T>
    extends SpliteratorAsCloseableSpliterator<T> {
        private final BaseStream<T, Stream<T>> stream;

        public StreamToCloseableSpliterator(BaseStream<T, Stream<T>> stream, Spliterator<T> spliterator) {
            super(spliterator);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class StreamToCloseableIterator<E>
    extends IteratorAsCloseableIterator<E> {
        private final BaseStream<E, Stream<E>> stream;

        public StreamToCloseableIterator(BaseStream<E, Stream<E>> stream, Iterator<E> iterator) {
            super(iterator);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class IteratorAsCloseableIterator<E>
    implements CloseableIterator<E> {
        private final Iterator<? extends E> iterator;

        public IteratorAsCloseableIterator(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

