/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.logging;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYPOJO", length=4)
public interface PojoLogger
extends BasicLogger {
    public static final PojoLogger ROOT_LOGGER = (PojoLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), PojoLogger.class, (String)"org.jboss.as.pojo");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Found legacy bean/pojo namespace: %s - might be missing some xml features (potential exceptions).")
    public void oldNamespace(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Ignoring uninstall action on target: %s")
    public void ignoreUninstallError(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Error invoking callback: %s")
    public void invokingCallback(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Error invoking incallback: %s")
    public void errorAtIncallback(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Error invoking uncallback: %s")
    public void errorAtUncallback(Object var1, @Cause Throwable var2);

    @Message(id=6, value="Failed to get module attachment for %s")
    public DeploymentUnitProcessingException noModuleFound(DeploymentUnit var1);

    @Message(id=7, value="Missing deployment reflection index for %s")
    public DeploymentUnitProcessingException missingReflectionIndex(DeploymentUnit var1);

    @Message(id=8, value="Failed to parse POJO xml [ %s ]")
    public DeploymentUnitProcessingException failedToParse(VirtualFile var1);

    @Message(id=10, value="Cannot instantiate new collection instance.")
    public IllegalArgumentException cannotInstantiateCollection(@Cause Throwable var1);

    @Message(id=11, value="Cannot instantiate new map instance.")
    public IllegalArgumentException cannotInstantiateMap(@Cause Throwable var1);

    @Message(id=12, value="Too dynamic to determine injected type from factory!")
    public IllegalArgumentException tooDynamicFromFactory();

    @Message(id=13, value="Too dynamic to determine injected type from dependency!")
    public IllegalArgumentException tooDynamicFromDependency();

    @Message(id=14, value="Previous node is not a value config: %s")
    public IllegalArgumentException notValueConfig(ConfigVisitorNode var1);

    @Message(id=15, value="Null factory method!")
    public IllegalArgumentException nullFactoryMethod();

    @Message(id=16, value="Null bean info!")
    public IllegalArgumentException nullBeanInfo();

    @Message(id=17, value="Invalid number of type instances match: %s, type: %s")
    public IllegalArgumentException invalidMatchSize(Set var1, Class var2);

    @Message(id=18, value="Cannot determine injected type: %s, try setting class attribute (if available).")
    public IllegalArgumentException cannotDetermineInjectedType(String var1);

    @Message(id=19, value="Null or empty alias.")
    public IllegalArgumentException nullOrEmptyAlias();

    @Message(id=20, value="Null or empty dependency.")
    public IllegalArgumentException nullOrEmptyDependency();

    @Message(id=21, value="Missing value")
    public String missingValue();

    @Message(id=22, value="Null value")
    public IllegalArgumentException nullValue();

    @Message(id=23, value="Null name")
    public IllegalArgumentException nullName();

    @Message(id=24, value="Null method name!")
    public IllegalArgumentException nullMethodName();

    @Message(id=25, value="Unknown type: %s")
    public IllegalArgumentException unknownType(Object var1);

    @Message(id=26, value="Illegal parameter length: %s")
    public IllegalArgumentException illegalParameterLength(Object var1);

    @Message(id=27, value="Missing factory method in ctor configuration: %s")
    public StartException missingFactoryMethod(BeanMetaDataConfig var1);

    @Message(id=28, value="Missing bean info, set bean's class attribute: %s")
    public String missingBeanInfo(BeanMetaDataConfig var1);

    @Message(id=29, value="Wrong types size, doesn't match parameters!")
    public IllegalArgumentException wrongTypeSize();

    @Message(id=30, value="Null ClassInfo!")
    public IllegalArgumentException nullClassInfo();

    @Message(id=31, value="No such constructor: %s for class %s.")
    public IllegalArgumentException ctorNotFound(Object var1, String var2);

    @Message(id=32, value="Method not found %s%s for class %s.")
    public IllegalArgumentException methodNotFound(String var1, Object var2, String var3);

    @Message(id=33, value="No such getter: %s on class %s.")
    public IllegalArgumentException getterNotFound(Class<?> var1, String var2);

    @Message(id=34, value="No such setter: %s on class %s.")
    public IllegalArgumentException setterNotFound(Class<?> var1, String var2);

    @Message(id=35, value="Ambiguous match %s.")
    public IllegalArgumentException ambiguousMatch(Object var1);

    @Message(id=36, value="Ambiguous match of %s for name %s on class %s.")
    public IllegalArgumentException ambiguousMatch(Object var1, String var2, String var3);

    @Message(id=37, value="Field not found %s for class %s.")
    public IllegalArgumentException fieldNotFound(String var1, String var2);

    @Message(id=38, value="Exception while parsing POJO descriptor file: %s")
    public DeploymentUnitProcessingException parsingException(VirtualFile var1, @Cause Throwable var2);

    @Message(id=39, value="Cannot determine type - insufficient info on configuration!")
    public IllegalArgumentException cannotDetermineType();
}

