/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;

public class ThreadLocalTransactionBatch<E extends RuntimeException>
implements TransactionBatch {
    private static final Batch NOOP_BATCH = (Batch)Batch.factory().get();
    private static final ThreadLocal<TransactionBatch> CURRENT_BATCH = new ThreadLocal();
    private final TransactionManager tm;
    private final Transaction tx;
    private final Logger logger;
    private final Function<Throwable, E> exceptionTransformer;
    private final AtomicInteger count = new AtomicInteger(0);
    private volatile boolean active = true;

    static TransactionBatch getCurrentBatch() {
        return CURRENT_BATCH.get();
    }

    static void setCurrentBatch(TransactionBatch batch) {
        if (batch != null) {
            CURRENT_BATCH.set(batch);
        } else {
            CURRENT_BATCH.remove();
        }
    }

    ThreadLocalTransactionBatch(TransactionManager tm, Transaction tx, Logger logger, Function<Throwable, E> exceptionTransformer) {
        this.tm = tm;
        this.tx = tx;
        this.logger = logger;
        this.exceptionTransformer = exceptionTransformer;
        this.logger.debugf("Started batch %s[%d]", (Object)this.tx, (Object)this.count.get());
    }

    private int getStatus() {
        try {
            return this.tx.getStatus();
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public boolean isActive() {
        int status = this.getStatus();
        return status == 0 && this.active;
    }

    public boolean isDiscarding() {
        int status = this.getStatus();
        return status == 0 && !this.active || status == 1;
    }

    public boolean isClosed() {
        int status = this.getStatus();
        return status != 0 && status != 1;
    }

    public SuspendedBatch suspend() {
        TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == null) {
            return NOOP_BATCH.suspend();
        }
        if (batch != this) {
            return this;
        }
        try {
            Transaction suspendedTx = this.tm.suspend();
            if (suspendedTx != this.tx) {
                throw new IllegalStateException();
            }
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
        ThreadLocalTransactionBatch.setCurrentBatch(null);
        return this;
    }

    public Batch resume() {
        TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == this) {
            return this;
        }
        if (batch != null) {
            batch.suspend();
        }
        if (this.isClosed()) {
            return NOOP_BATCH;
        }
        try {
            this.tm.resume(this.tx);
        }
        catch (InvalidTransactionException | SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
        ThreadLocalTransactionBatch.setCurrentBatch(this);
        return this;
    }

    public BatchContext<Batch> resumeWithContext() {
        final TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == this) {
            return new BatchContext<Batch>(this){
                final /* synthetic */ ThreadLocalTransactionBatch this$0;
                {
                    this.this$0 = this$0;
                }

                public Batch get() {
                    return batch;
                }

                public void close() {
                }
            };
        }
        final Batch resumed = this.resume();
        return new BatchContext<Batch>(this){
            final /* synthetic */ ThreadLocalTransactionBatch this$0;
            {
                this.this$0 = this$0;
            }

            public Batch get() {
                return resumed;
            }

            public void close() {
                resumed.suspend();
                if (batch != null) {
                    batch.resume();
                }
            }
        };
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    @Override
    public TransactionBatch interpose() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        int count = this.count.incrementAndGet();
        this.logger.debugf("Interposed batch %s[%d]", (Object)this.tx, (Object)count);
        return this;
    }

    public void discard() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        this.active = false;
    }

    public void close() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        int count = this.count.getAndDecrement();
        if (count == 0) {
            try {
                switch (this.tx.getStatus()) {
                    case 0: {
                        if (this.active) {
                            try {
                                this.logger.debugf("Committing batch %s[%d]", (Object)this.tx, (Object)count);
                                this.tx.commit();
                                break;
                            }
                            catch (RollbackException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (HeuristicMixedException | HeuristicRollbackException e) {
                                throw (RuntimeException)this.exceptionTransformer.apply(e);
                            }
                        }
                    }
                    case 1: {
                        this.logger.debugf("Rolling back batch %s[%d]", (Object)this.tx, (Object)count);
                        this.tx.rollback();
                        break;
                    }
                    default: {
                        this.logger.debugf("Closed batch %s[%d] with status = %d", (Object)this.tx, (Object)count, (Object)this.tx.getStatus());
                        break;
                    }
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
        } else {
            this.logger.debugf("Closed interposed batch %s[%d]", (Object)this.tx, (Object)count);
        }
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ThreadLocalTransactionBatch)) {
            return false;
        }
        ThreadLocalTransactionBatch batch = (ThreadLocalTransactionBatch)object;
        return this.tx.equals((Object)batch.tx);
    }

    public String toString() {
        return String.format("%s[%d]", this.tx, this.count.get());
    }
}

