/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.connection;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.connection.ConnectionTypeLoader;
import oracle.adf.share.connection.ManifestConnectionTypeLoader;

public class ConnectionTypeLoaderFactory {
    private static final Class RUNTIME_LOADER_CLASS = ManifestConnectionTypeLoader.class;
    private static final String DT_LOADER_CLASS = "oracle.jdevimpl.connection.model.hook.DTConnectionTypeLoader";
    private static final String SOURCE_CLASS = ConnectionTypeLoaderFactory.class.getName();
    private static final String GET_CONNECTION_TYPE_LOADER = "getExtensionLoader()";
    private static final String resourceBundle = "oracle.adf.share.connection.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.connection.resources.Messages");

    public static ConnectionTypeLoader getLoader() {
        Class loaderClass = null;
        ConnectionTypeLoader loader = null;
        try {
            loaderClass = ClassUtils.forName(DT_LOADER_CLASS, ConnectionTypeLoaderFactory.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (loaderClass == null) {
                loaderClass = RUNTIME_LOADER_CLASS;
            }
            loader = (ConnectionTypeLoader)loaderClass.newInstance();
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(e);
            Logger logger = Logger.getLogger("oracle.adf.share.connection");
            logger.logp(Level.SEVERE, SOURCE_CLASS, GET_CONNECTION_TYPE_LOADER, MessageFormat.format(resBundle.getString("CONNTYPE_NOTINITED"), loaderClass), re);
            throw re;
        }
        return loader;
    }

    private ConnectionTypeLoaderFactory() {
    }
}

