/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.metrics;

import java.util.logging.Level;
import oracle.adf.share.metrics.Metric;
import oracle.adf.share.metrics.MetricFactory;
import oracle.adf.share.metrics.TimerToken;

public abstract class Timer
extends Metric {
    public static final Timer DUMMY_TIMER = new DummyTimer();

    protected Timer(Level level, String fullName) {
        super(level, fullName);
    }

    public void start() {
    }

    public void stop() {
    }

    public void cleanup() {
    }

    public TimerToken startWithToken() {
        this.start();
        return null;
    }

    public void stopWithToken(TimerToken tt) {
        assert (tt == null);
        this.stop();
    }

    public void cleanupWithToken(TimerToken tt) {
        assert (tt == null);
        this.cleanup();
    }

    protected abstract long getElapsedTime();

    public static Timer createTimer(Level level, String groupName, String name, String desc) {
        return MetricFactory.FactoryHolder.INST.createTimer(level, groupName, name, null, desc);
    }

    public static Timer createTimer(Level level, String groupName, String name, String type, String desc) {
        return MetricFactory.FactoryHolder.INST.createTimer(level, groupName, name, type, desc);
    }

    public static Timer createTimer(Level level, String groupName, String name, String type, String desc, String tags) {
        return MetricFactory.FactoryHolder.INST.createTimer(level, groupName, name, type, desc, tags);
    }

    private static class DummyTimer
    extends Timer {
        private static final String sName = "Dummy Timer";

        public DummyTimer() {
            super(Level.ALL, sName);
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public String toString() {
            return sName;
        }

        @Override
        protected long getElapsedTime() {
            return 0L;
        }
    }
}

