/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignatureValue;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JSR105Util {
    public static Element signUsingJSR105(XSSignature sig, PrivateKey key, byte[] secret) throws SigningException {
        try {
            Vector refs = sig.getSignedInfo().getReferences();
            for (int i = 0; i < refs.size(); ++i) {
                XSReference ref = (XSReference)refs.get(i);
                ref.setDigestValue(new byte[0]);
            }
            if (sig.getSignatureValue() == null) {
                sig.setSignatureValue(new XSSignatureValue(sig.getOwnerDocument()));
            }
            sig.getSignatureValue().setSignatureBytes(new byte[0]);
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
            XMLSignature sig1 = sigFactory.unmarshalXMLSignature(new DOMStructure(sig.getElement()));
            Node parent = sig.getParentNode();
            Node nextSibling = sig.getNextSibling();
            Document ownerDoc = sig.getOwnerDocument();
            parent.removeChild(sig.getNode());
            DOMSignContext context = key != null ? new DOMSignContext(key, parent) : new DOMSignContext(new SecretKeySpec(secret, "Hmac"), parent);
            context.setURIDereferencer(new JSR105URIDereferencer(ownerDoc));
            if (nextSibling != null) {
                context.setNextSibling(nextSibling);
            }
            sig1.sign(context);
            Element sigNode = context.getNextSibling() == null ? (Element)context.getParent().getLastChild() : (Element)context.getNextSibling().getPreviousSibling();
            return sigNode;
        }
        catch (MarshalException ex) {
            throw new SigningException(ex);
        }
        catch (XMLSignatureException ex) {
            throw new SigningException(ex);
        }
    }

    public static boolean verifyUsingJSR105(XSSignature sig, PublicKey key, byte[] secret, boolean validateManifests) throws VerifyException {
        try {
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
            DOMValidateContext context = key != null ? new DOMValidateContext(key, (Node)sig.getElement()) : new DOMValidateContext(new SecretKeySpec(secret, "Hmac"), (Node)sig.getElement());
            context.setURIDereferencer(new JSR105URIDereferencer(sig.getOwnerDocument()));
            XMLSignature sig1 = sigFactory.unmarshalXMLSignature(context);
            if (validateManifests) {
                return sig1.validate(context);
            }
            return sig1.getSignatureValue().validate(context);
        }
        catch (MarshalException ex) {
            throw new VerifyException(ex);
        }
        catch (XMLSignatureException ex) {
            throw new VerifyException(ex);
        }
    }

    public static XMLContainer convertFromJSR105(Data data) throws IOException {
        if (data instanceof NodeSetData) {
            int size = 0;
            Iterator it = ((NodeSetData)data).iterator();
            while (it.hasNext()) {
                ++size;
                it.next();
            }
            final int size1 = size;
            final Data data1 = data;
            Collection c = new Collection(){

                public boolean add(Object o) {
                    return false;
                }

                public boolean addAll(Collection c) {
                    return false;
                }

                @Override
                public void clear() {
                }

                @Override
                public boolean contains(Object o) {
                    return false;
                }

                public boolean containsAll(Collection c) {
                    return false;
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    return false;
                }

                public boolean removeAll(Collection c) {
                    return false;
                }

                public boolean retainAll(Collection c) {
                    return false;
                }

                @Override
                public Object[] toArray() {
                    return null;
                }

                public Object[] toArray(Object[] a) {
                    return null;
                }

                @Override
                public int size() {
                    return size1;
                }

                @Override
                public Iterator iterator() {
                    return ((NodeSetData)data1).iterator();
                }
            };
            return new XMLContainer(c);
        }
        if (data instanceof OctetStreamData) {
            return new XMLContainer(((OctetStreamData)data).getOctetStream());
        }
        throw new IllegalArgumentException("data must be NodeSetData or OctetStreamData");
    }

    public static Data convertToJSR105(XMLContainer c) throws ReferenceException {
        if (c.subTreeAvailable() || c.nodeSetAvailable()) {
            return new OraNodeSetData(c);
        }
        try {
            return new OctetStreamData(c.getOctetStream());
        }
        catch (IOException ex) {
            throw new ReferenceException(ex);
        }
    }

    public static class JSR105URIDereferencer
    implements URIDereferencer {
        Document doc;

        public JSR105URIDereferencer(Document doc) {
            this.doc = doc;
        }

        @Override
        public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
            try {
                XMLContainer result = ObjectReference.dereference(uriReference.getURI(), this.doc, null, null);
                return JSR105Util.convertToJSR105(result);
            }
            catch (ReferenceException ex) {
                throw new URIReferenceException(ex);
            }
        }
    }

    public static class OraNodeSetData
    implements NodeSetData {
        XMLContainer c;

        public OraNodeSetData(XMLContainer c) {
            this.c = c;
        }

        @Override
        public Iterator iterator() {
            try {
                if (this.c.subTreeAvailable() || this.c.octetsAvailable()) {
                    return XMLContainer.subtreeToNodeList(this.c.getSubTree(), this.c.getWithComments(), true).iterator();
                }
                return this.c.getNodeSet().iterator();
            }
            catch (IOException ex) {
                IllegalStateException ex1 = new IllegalStateException();
                ex1.initCause(ex);
                throw ex1;
            }
            catch (SAXException ex) {
                IllegalStateException ex1 = new IllegalStateException();
                ex1.initCause(ex);
                throw ex1;
            }
            catch (XPathException ex) {
                IllegalStateException ex1 = new IllegalStateException();
                ex1.initCause(ex);
                throw ex1;
            }
        }

        public XMLContainer getXMLContainer() {
            return this.c;
        }
    }
}

