/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.ess.ESSSecurityLabel;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class EquivalentLabels
implements ASN1Object {
    private Vector vect;
    private ASN1Sequence contents;

    public EquivalentLabels(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public EquivalentLabels(CMSSignerInfo si) throws InvalidInputException {
        try {
            if (si == null) {
                throw new InvalidInputException("No SignerInfo Present");
            }
            Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_equivalentLabels);
            if (vals == null) {
                throw new InvalidInputException("EquivalentLabels Values is NULL");
            }
            if (vals.getValues().size() != 1) {
                throw new InvalidInputException("EquivalentLabels Must Be Single Valued");
            }
            this.vect = new Vector();
            try {
                this.input((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)((ASN1Sequence)vals.getValues().elementAt(0)))));
                this.contents = null;
            }
            catch (IOException ex) {
                throw new InvalidInputException(ex.toString());
            }
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public EquivalentLabels() {
        this.vect = new Vector();
        this.contents = null;
    }

    public EquivalentLabels(ESSSecurityLabel secLabel) {
        this.vect = new Vector();
        this.vect.addElement(secLabel);
        this.contents = null;
    }

    public EquivalentLabels(Vector secLabels) {
        this.vect = new Vector();
        int j = secLabels.size();
        for (int i = 0; i < j; ++i) {
            this.vect.addElement((ESSSecurityLabel)secLabels.elementAt(i));
        }
        this.contents = null;
    }

    public void addSecurityLabel(ESSSecurityLabel secLabel) {
        this.vect.addElement(secLabel);
        this.contents = null;
    }

    public Vector getSecurityLabels() {
        if (this.vect.size() > 0) {
            return this.vect;
        }
        return null;
    }

    public Enumeration labels() {
        return this.vect.elements();
    }

    public String toString() {
        return "Equivalent Labels contains " + this.vect.size() + " ESSSecurityLabels";
    }

    public boolean equals(Object o) {
        if (!(o instanceof EquivalentLabels)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((EquivalentLabels)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.vect = new Vector();
        if (seq.hasMoreData()) {
            while (seq.hasMoreData()) {
                this.vect.addElement(new ESSSecurityLabel((InputStream)seq));
            }
        }
        seq.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.vect);
        }
        return this.contents;
    }
}

