/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.common;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlIntegerMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetCostMatrixCountQuery
extends SqlBaseModelQuery<Integer, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetCostMatrixCountQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlIntegerMapper(), modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*)").from(GetCostMatrixCountQuery.this.getViewName("DM$VC")).where(Conditional.equals("PARTITION_NAME", GetCostMatrixCountQuery.this.getPartitionId()));
            String string = sqlBuilder.toString();
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetCostMatrixCountQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = "select COUNT(COST) from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(:model))";
            return string;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetCostMatrixCountQuery.this.getQualifiedName());
        }
    }
}

