/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.ar.filter;

import oracle.dmt.dataminer.core.model.ar.filter.FilterFor;
import oracle.dmt.dataminer.core.model.ar.filter.FilterOn;
import oracle.dmt.dataminer.core.model.ar.filter.FilterType;
import oracle.dmt.dataminer.core.model.common.Range;

public class FilterRule {
    private FilterType filterType;
    private FilterOn filterOn;
    private FilterFor filterFor;
    private Range range;
    private String value;

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterOn(FilterOn filterOn) {
        this.filterOn = filterOn;
    }

    public FilterOn getFilterOn() {
        return this.filterOn;
    }

    public void setFilterFor(FilterFor filterFor) {
        this.filterFor = filterFor;
    }

    public FilterFor getFilterFor() {
        return this.filterFor;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Range getRange() {
        return this.range;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isRuleOnlyFilter() {
        boolean bl = FilterOn.LIFT.equals(this.filterOn);
        boolean bl2 = FilterOn.CONFIDENCE.equals(this.filterOn);
        boolean bl3 = FilterOn.REV_CONFIDENCE.equals(this.filterOn);
        boolean bl4 = FilterOn.ITEMS_IN_RULE.equals(this.filterOn);
        boolean bl5 = bl || bl2 || bl3 || bl4;
        return bl5;
    }

    public boolean isAntConOnlyFilter() {
        boolean bl = !FilterType.METRIC.equals((Object)this.filterType);
        return bl;
    }

    public boolean isStickyFilter() {
        boolean bl = FilterOn.LIFT.equals(this.filterOn);
        boolean bl2 = FilterOn.CONFIDENCE.equals(this.filterOn);
        boolean bl3 = FilterOn.ITEMS_IN_RULE.equals(this.filterOn);
        boolean bl4 = FilterOn.SUPPORT.equals(this.filterOn) && FilterFor.RULE.equals((Object)this.filterFor);
        boolean bl5 = bl || bl2 || bl3 || bl4;
        return bl5;
    }

    public boolean isValid() {
        boolean bl = false;
        switch (this.filterType) {
            case ITEM_INCLUDE: 
            case ITEM_EXCLUDE: {
                bl = this.validateItemFilter();
                break;
            }
            case METRIC: {
                bl = this.validateMetricFilter();
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        return bl;
    }

    private boolean validateItemFilter() {
        boolean bl = this.filterOn != null && this.filterFor != null && this.value != null;
        return bl;
    }

    private boolean validateMetricFilter() {
        boolean bl = this.filterOn != null && this.filterFor != null && this.range != null;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof FilterRule) {
            FilterRule filterRule = (FilterRule)object;
            if (FilterType.METRIC.equals((Object)filterRule.filterType)) {
                boolean bl2 = this.filterType != null && this.filterType.equals((Object)filterRule.filterType);
                boolean bl3 = this.filterOn != null && this.filterOn.equals(filterRule.filterOn);
                boolean bl4 = this.filterFor != null && this.filterFor.equals((Object)filterRule.filterFor);
                bl = bl2 && bl3 && bl4;
            } else {
                boolean bl5 = this.filterType != null && this.filterType.equals((Object)filterRule.filterType);
                boolean bl6 = this.filterFor != null && this.filterFor.equals((Object)filterRule.filterFor);
                boolean bl7 = this.value != null && this.value.equals(filterRule.value);
                bl = bl5 && bl6 && bl7;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += this.filterType != null ? this.filterType.hashCode() : 0;
        n += this.filterOn != null ? this.filterOn.hashCode() : 0;
        return n += this.filterFor != null ? this.filterFor.hashCode() : 0;
    }
}

