/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import oracle.bali.ewt.graphics.ImageUtils;

class LineWidthIncludingNone
extends JComboBox {
    private ResourceBundle rBundle = null;
    private Filter _filter = new Filter();
    private CellRenderer renderer;
    private boolean superCalled = true;
    protected Color m_cellColor;
    protected Color m_background;

    public LineWidthIncludingNone() {
        this.updateResourceBundle(null);
        this.m_background = this.m_cellColor = this.getBackground();
        for (int i = 0; i <= 9; ++i) {
            this.addItem(new Integer(i).toString());
        }
        this.renderer = new CellRenderer();
        this.setRenderer(this.renderer);
        int width = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.rBundle.getString("NoLine"));
        this.setPreferredSize(new Dimension(width + 25, 25));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setUI(this.getComboBoxUI());
    }

    public void cleanUp() {
        this.removeAllItems();
        this.setRenderer(null);
        this.renderer = null;
        this._filter = null;
    }

    private ComboBoxUI getComboBoxUI() {
        ComboBoxUI cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof WindowsComboBoxUI) {
            return new MyWindowsComboBoxUI();
        }
        if (cui instanceof MotifComboBoxUI) {
            return new MyMotifComboBoxUI();
        }
        if (cui instanceof MetalComboBoxUI) {
            return new MyMetalComboBoxUI();
        }
        return cui;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    private Icon _getColorIcon(Image image, Color color) {
        this._filter.setColor(color);
        Image newImage = LineWidthIncludingNone._createFilteredImage(image, this._filter);
        return new ImageIcon(newImage);
    }

    private static Image _createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource prod = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.superCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        int width = this.getToolkit().getFontMetrics(this.getFont()).stringWidth(this.rBundle.getString("NoLine"));
        this.setPreferredSize(new Dimension(width + 25, 23));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public int getLineWidth() {
        return this.getSelectedIndex();
    }

    public void setLineWidth(int lineWidth) {
        this.setSelectedIndex(lineWidth);
    }

    public void setCellColor(Color color) {
        this.m_cellColor = color;
    }

    class MyComboPopup
    extends BasicComboPopup {
        JComboBox comboBox;

        public MyComboPopup(JComboBox cBox) {
            super(cBox);
            this.comboBox = cBox;
        }

        @Override
        public void show() {
            Dimension popupSize = this.comboBox.getSize();
            popupSize.setSize(130, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            this.scroller.setMaximumSize(popupSize);
            this.scroller.setPreferredSize(popupSize);
            this.scroller.setMinimumSize(popupSize);
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            this.show(this.comboBox, popupBounds.x, popupBounds.y);
        }
    }

    class MyMotifComboBoxUI
    extends MotifComboBoxUI {
        MyMotifComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new MyComboPopup(this.comboBox);
        }
    }

    class MyMetalComboBoxUI
    extends MetalComboBoxUI {
        MyMetalComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            return new MyComboPopup(this.comboBox);
        }
    }

    class MyWindowsComboBoxUI
    extends WindowsComboBoxUI {
        MyWindowsComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new MyComboPopup(this.comboBox);
        }
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
                return this;
            }
            int tmpIndex = 0;
            try {
                tmpIndex = new Integer((String)value);
            }
            catch (Exception exception) {
                this.setText("");
                this.setIcon(null);
                return this;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String gifFileName = "";
            gifFileName = "images/Line" + tmpIndex + ".gif";
            if (tmpIndex == 5) {
                gifFileName = "images/dot.gif";
            } else if (tmpIndex == 6) {
                gifFileName = "images/dash.gif";
            } else if (tmpIndex == 7) {
                gifFileName = "images/dashDot.gif";
            } else if (tmpIndex == 8) {
                gifFileName = "images/dashDotDot.gif";
            } else if (tmpIndex == 9) {
                gifFileName = "images/double.gif";
            }
            this.setText("");
            this.setIcon(null);
            if (tmpIndex == 0) {
                this.setText(LineWidthIncludingNone.this.rBundle.getString("NoLine"));
            } else {
                Color cellColor = this.getBackground() != null && this.getBackground().getRGB() == LineWidthIncludingNone.this.m_cellColor.getRGB() ? (this.getBackground().getRGB() != -16777216 ? Color.black : Color.white) : LineWidthIncludingNone.this.m_cellColor;
                this.setIcon(LineWidthIncludingNone.this._getColorIcon(ImageUtils.getImageResource(LineWidthIncludingNone.class, (String)gifFileName), cellColor));
            }
            if (tmpIndex == 0) {
                this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("NoLine"));
            } else if (tmpIndex == 5) {
                this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("LineWidthDottedLine"));
            } else {
                switch (tmpIndex) {
                    case 1: {
                        this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("LineWidth1"));
                        break;
                    }
                    case 2: {
                        this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("LineWidth2"));
                        break;
                    }
                    case 3: {
                        this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("LineWidth3"));
                        break;
                    }
                    case 4: {
                        this.getAccessibleContext().setAccessibleName(LineWidthIncludingNone.this.rBundle.getString("LineWidth4"));
                    }
                }
            }
            this.setMinimumSize(new Dimension(115, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(115, this.getPreferredSize().height));
            this.setMaximumSize(new Dimension(115, this.getMaximumSize().height));
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            Color c = color;
            this._color = c == null ? 0 : c.getRGB();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            if (rgb == this._sCOLOR) {
                return this._color;
            }
            return rgb;
        }
    }
}

