/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Hashtable;
import oracle.aurora.compiler.ClassFinder;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FwdFinder;
import oracle.aurora.compiler.QName;

public class MemoizedFinder
extends FwdFinder
implements ClassFinder {
    Hashtable cache = new Hashtable(31);

    public MemoizedFinder(ClassFinder original) {
        super(original);
    }

    public ExternalEntity find(QName name) {
        Key key = new Key(name, -1);
        ExternalEntity file = (ExternalEntity)this.cache.get(key);
        if (file == null && (file = this.farFinder.find(name)) != null) {
            this.cache.put(key, file);
        }
        return file;
    }

    public ExternalEntity find(QName name, int kind) {
        Key key = new Key(name, kind);
        ExternalEntity file = (ExternalEntity)this.cache.get(key);
        if (file == null && (file = this.farFinder.find(name, kind)) != null) {
            this.cache.put(key, file);
        }
        return file;
    }

    public void close() {
        this.farFinder.close();
        this.cache = new Hashtable(31);
    }

    public String toString() {
        return "memoized " + this.farFinder.toString();
    }

    class Key {
        QName name;
        int kind;

        Key(QName name, int kind) {
            this.name = name;
            this.kind = kind;
        }

        public int hashCode() {
            return this.name.toString().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                Key otherKey = (Key)other;
                return this.name.equals(otherKey.name) && this.kind == otherKey.kind;
            }
            return false;
        }
    }
}

