/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.DecimalFormat;
import oracle.aurora.server.tools.loadjava.ConnectionError;
import oracle.aurora.server.tools.loadjava.LogOptions;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.msg.Msg;

public class LoadJavaLog {
    private Msg mkMsg = MkMsg.mkMsg;
    private LogOptions opts;
    private long startTime;
    private long lastTime;
    private boolean connectionFailure;

    public LoadJavaLog() {
        this(new LogOptions());
    }

    public LoadJavaLog(LogOptions opts) {
        this.opts = opts;
    }

    public LogOptions getOpts() {
        return this.opts;
    }

    private boolean getVerbose() {
        return this.opts.getVerbose();
    }

    private boolean getTime() {
        return this.opts.getTime();
    }

    private boolean getDebug() {
        return this.opts.getDebug();
    }

    PrintWriter getWriter() {
        return this.opts.getWriter();
    }

    void println(String msg) {
        if (this.getTime()) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long t = System.currentTimeMillis() - this.startTime;
            msg = "[" + (double)(t - this.lastTime) / 1000.0 + " sec, " + (double)t / 1000.0 + " sec] " + msg;
            this.lastTime = t;
        }
        this.getWriter().println(msg);
        this.getWriter().flush();
    }

    public void msg(String m) {
        if (this.getVerbose()) {
            this.println(m);
        }
    }

    public void warn(String m) {
        if (!this.getOpts().getBoolean("-nowarn")) {
            this.println("Warning: " + m);
        }
    }

    public void warn(Exception ex, String when) {
        this.err(ex, when, true);
    }

    public void err(String m) {
        this.println(m);
    }

    public void failErr(String m) {
        if (!this.getOpts().getBoolean("-compat817")) {
            this.println(m);
        }
    }

    public void err(Exception ex, String what) {
        this.err(ex, what, false);
    }

    void err(Exception ex, String what, boolean warning) {
        if (ex instanceof SQLException) {
            SQLException sex = (SQLException)ex;
            if (this.checkCode(sex, 1013)) {
                throw new ConnectionError("interrupted by user");
            }
            if (this.checkCode(sex, 3113) || this.checkCode(sex, 3114) || sex.getErrorCode() == 0) {
                this.connectionFailure = true;
            } else if (this.checkCode(sex, 29552)) {
                warning = true;
            }
        }
        if (!warning || !this.getOpts().getBoolean("-nowarn")) {
            String tag = warning ? "Warning" : "Error";
            this.println(this.mkMsg.m("{0} while {1}", tag, what));
            if (ex instanceof SQLException && ((SQLException)ex).getErrorCode() != 0) {
                this.println("    " + ex.getMessage());
            } else {
                this.println("    Exception " + ex.toString());
            }
            if (this.getOpts().getBoolean("-debug")) {
                Exception exForTrace = ex;
                if (ex instanceof ToolsException && ((ToolsException)ex).getChain() != null) {
                    exForTrace = ((ToolsException)ex).getChain();
                }
                exForTrace.printStackTrace(this.getWriter());
            }
            this.getWriter().flush();
        }
    }

    public boolean checkCode(SQLException ex, int code) {
        int count;
        boolean result = false;
        boolean found = false;
        SQLException next = ex;
        for (count = 0; next != null && !found && count < 100; ++count) {
            found = ex.getErrorCode() == code || this.checkCode(ex.getMessage(), code);
            next = ex.getNextException();
        }
        if (count > 100) {
            System.out.println("loop in SQLException next chain");
            SQLException s = ex;
            for (int x = 0; x < 100 && s != null; s = s.getNextException(), ++x) {
                System.out.println("    " + s);
            }
        }
        return found;
    }

    boolean checkCode(String msg, int code) {
        String pat = "ORA-" + new DecimalFormat("00000").format(code);
        boolean found = msg != null && msg.indexOf(pat) >= 0;
        return found;
    }

    public boolean getConnectionFailure() {
        return this.connectionFailure;
    }

    public void setConnectionFailure(boolean cf) {
        this.connectionFailure = cf;
    }

    public void setWriter(PrintWriter output) {
        this.getOpts().setOut(output);
    }
}

