/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.xclass;

public class XBytes {
    private byte[] bytes;
    private byte[] array;
    private int beg;
    private int end;

    public XBytes(byte[] bytes, int beg, int end) {
        if (end < beg) {
            throw new NegativeArraySizeException("beg = " + beg + ", end = " + end);
        }
        if (beg < 0 || end > bytes.length) {
            String msg = "beg = " + beg + ", end = " + end + ", array length = " + bytes.length;
            throw new IllegalArgumentException(msg);
        }
        this.bytes = bytes;
        this.beg = beg;
        this.end = end;
    }

    public XBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
        this.array = bytes;
    }

    public final void set(int index, byte b) {
        if (index > this.end - this.beg) {
            String msg = "index " + index + " when length is " + (this.end - this.beg);
            throw new IndexOutOfBoundsException(msg);
        }
        this.bytes[this.beg + index] = b;
    }

    public final byte at(int index) {
        if (index > this.end - this.beg) {
            String msg = "index " + index + " when length is " + (this.end - this.beg);
            throw new IndexOutOfBoundsException(msg);
        }
        return this.bytes[this.beg + index];
    }

    public final int length() {
        return this.end - this.beg;
    }

    public final byte[] array() {
        if (this.array != null) {
            this.array = new byte[this.end - this.beg];
            System.arraycopy(this.bytes, this.beg, this.array, 0, this.end - this.beg);
        }
        return this.array;
    }

    public int hashCode() {
        return this.bytes.hashCode() + this.beg * this.end;
    }

    public boolean equals(Object other) {
        boolean eq = false;
        if (other instanceof XBytes) {
            XBytes oBytes = (XBytes)other;
            eq = this.bytes == oBytes.bytes && this.beg == oBytes.beg && this.end == oBytes.end;
        }
        return eq;
    }
}

