/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.header;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.header.Provider;
import oracle.cloudstorage.api.request.IAttribute;
import oracle.cloudstorage.text.Strings;

public enum Header implements IAttribute
{
    accept("Accept"),
    contentType("Content-Type"),
    lastModified("Last-Modified"),
    status("Status"),
    contentLength("Content-Length"),
    transferEncoding("Transfer-Encoding"){

        @Override
        public Provider provide() {
            return this.provide("chunked");
        }
    }
    ,
    eTag("ETag"),
    range("Range"),
    stripedObjectPutLock(Prefix.stripe, "Put-Lock"),
    stripedObjectMd5(Prefix.stripe, "Md5"),
    stripedObjectUuid(Prefix.stripe, "UUID"),
    stripedSegmentWidth(Prefix.segment, "Width"),
    stripedSegmentCount(Prefix.segment, "Count"),
    stripeSegment(Prefix.object, Prefix.segment.name()),
    storageUser("X-Storage-User"),
    storagePassword("X-Storage-Pass", true),
    storageUrl("X-Storage-Url"),
    storageToken("X-Storage-Token", true),
    authToken("X-Auth-Token", true),
    transId("X-Trans-Id"),
    deleteAt("X-Delete-At"),
    deleteAfter("X-Delete-After"),
    expect("Expect"){

        @Override
        public Provider provide() {
            return this.provide("100-continue");
        }
    }
    ,
    consistencyLevel("X-Consistency-Level"),
    envelopeKey1(Prefix.object, "EnvelopeKey1"),
    envelopeKey2(Prefix.object, "EnvelopeKey2"),
    digestKey1(Prefix.object, "DigestKey1"),
    digestKey2(Prefix.object, "DigestKey2"),
    digest(Prefix.object, "Digest"),
    dynamicLargeObjectManifest("X-Object-Manifest"),
    dynamicLargeObjectMd5(Prefix.object, "DLO-Md5"),
    copyFrom("X-Copy-From"),
    containerQuotaBytes(Prefix.container, "Quota-Bytes"),
    containerQuotaCount(Prefix.container, "Quota-Count");

    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    public static final java.util.Map<String, List<Object>> NONE;
    public static final Iterable<Map.Entry<String, String>> empty;
    public final String key;

    private Header(String key) {
        this(key, false);
    }

    private Header(Prefix prefix, String key) {
        this(prefix.prefix + "-" + key.toLowerCase());
    }

    private Header(String key, boolean maskValue) {
        this.key = key.toLowerCase();
        if (maskValue) {
            Map.addMaskedKey(this.key);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Provider provide() {
        throw new UnsupportedOperationException();
    }

    public Provider provide(Object value) {
        return Header.provide(this.key, value);
    }

    public void put(java.util.Map<String, List<Object>> headers, Object ... values) {
        if (values == null || values.length <= 0) {
            headers.remove(this.key.toLowerCase());
            return;
        }
        List<Object> value = Arrays.asList(values);
        headers.put(this.key.toLowerCase(), value);
    }

    public int getInt(IReply reply) {
        String rawValue = this.get(reply);
        int value = rawValue == null ? Integer.MIN_VALUE : Integer.parseInt(rawValue);
        return value;
    }

    public String get(IReply reply) {
        if (reply == null) {
            return null;
        }
        return this.get(reply.getHeaders());
    }

    public String get(Map headers) {
        String value = headers == null ? null : headers.get(this.key);
        return value;
    }

    public String get(java.util.Map<String, List<Object>> headers) {
        String value = headers == null ? null : Strings.join(headers.get(this.key)).with(",");
        return value;
    }

    public String toString() {
        return this.key;
    }

    public static Provider value(Map.Entry<String, ?> entry) {
        return Header.provide(entry.getKey(), entry.getValue());
    }

    public static Provider provide(String key, Object value) {
        Provider header = new Provider(key, value == null ? null : value.toString());
        return header;
    }

    public static Provider container(String containerKeySuffix, Object value) {
        String key = Prefix.container.key(containerKeySuffix);
        Provider header = Header.provide(key, value);
        return header;
    }

    public static String container(java.util.Map<String, ?> headers, String containerKeySuffix) {
        Object value;
        String key = Prefix.container.key(containerKeySuffix);
        Object object = value = headers == null ? null : (Object)headers.get(key);
        if (value instanceof Iterable) {
            value = Strings.join((Iterable)value).with(",");
        }
        return value == null ? null : value.toString();
    }

    public static Provider object(String objectKeySuffix, Object value) {
        String key = Prefix.object.key(objectKeySuffix);
        Provider header = Header.provide(key, value);
        return header;
    }

    public static Provider stripeSegment(Object stripeSegmetnKeySuffix, Object value) {
        String objectKeySuffix = Prefix.segment.key(stripeSegmetnKeySuffix);
        Provider header = Header.object(objectKeySuffix, value);
        return header;
    }

    public static String object(java.util.Map<String, ?> headers, String objectKeySuffix) {
        Object value;
        String key = Prefix.object.key(objectKeySuffix);
        Object object = value = headers == null ? null : (Object)headers.get(key);
        if (value instanceof Iterable) {
            value = Strings.join((Iterable)value).with(",");
        }
        return value == null ? null : value.toString();
    }

    public static String stripeSegment(Map headers, Object stripeSegmentKeySuffix) {
        String objectKeySuffix = Prefix.segment.key(stripeSegmentKeySuffix);
        String value = Header.object(headers, objectKeySuffix);
        return value;
    }

    public static <K, V> Iterable<Map.Entry<String, String>> normalize(Iterable<Map.Entry<K, V>> genericIterable) {
        final Iterator<Map.Entry<K, V>> generic = genericIterable.iterator();
        Iterable<Map.Entry<String, String>> iterable = new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                Iterator<Map.Entry<String, String>> iterator = new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = generic.hasNext();
                        return hasNext;
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry genericEntry = (Map.Entry)generic.next();
                        Map.Entry<String, String> entry = new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                String key = genericEntry.getKey() == null ? null : genericEntry.getKey().toString().toLowerCase();
                                return key;
                            }

                            @Override
                            public String getValue() {
                                String value = Strings.join(genericEntry.getValue()).with(",");
                                return value;
                            }

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                        return entry;
                    }

                    @Override
                    public void remove() {
                        generic.remove();
                    }
                };
                return iterator;
            }
        };
        return iterable;
    }

    static {
        NONE = Collections.emptyMap();
        empty = new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return Collections.emptyMap().entrySet().iterator();
            }
        };
    }

    public static enum ConsistencyLevel {
        strong,
        quorum;

    }

    public static enum Prefix {
        container("x-container-meta"),
        object("x-object-meta"),
        stripe(object),
        segment(stripe);

        private final String prefix;

        private Prefix(String prefix) {
            this.prefix = prefix.toLowerCase();
        }

        private Prefix(Prefix parent) {
            this.prefix = parent.prefix + '-' + this.name().toLowerCase();
        }

        public String key(Object suffix) {
            String key = this.prefix + '-' + (suffix == null ? "null" : suffix.toString().toLowerCase());
            return key;
        }

        public Provider provide(String suffix, Object value) {
            String key = this.key(suffix);
            Provider provider = new Provider(key, value == null ? null : value.toString());
            return provider;
        }
    }
}

