/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatedialogimpl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperImpl;
import oracle.olap.app.templates.templateview.BaseTemplateHyperView;
import oracle.olap.app.templates.templateview.TemplateGroupHyperView;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperView;

public class TemplateGUIImpl
extends TemplateGUI {
    private static final Logger LOG = Logger.getLogger(TemplateGUIImpl.class.getName());
    private final BaseTemplateHyperView view;
    private boolean valid;
    private final TemplateHelperImpl templateHelper;
    private Map<String, String> paramValues;
    private JPanel message;
    private volatile int ignoreChanges = 0;
    private List<TemplateHyperParam> pendingHyperParams;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TemplateGUIImpl.this.ignoreChanges == 0 && "VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                try {
                    TemplateGUIImpl.this.fireSyntaxChanged(propertyChangeEvent.getSource());
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }
    };
    private List<TemplateHyperParam> nonOptionals;

    public TemplateGUIImpl(TemplateHelperImpl templateHelperImpl, BaseTemplateHyperView baseTemplateHyperView) {
        this.view = baseTemplateHyperView;
        this.templateHelper = templateHelperImpl;
    }

    @Override
    public String getSyntax() throws SQLException, IOException {
        if (this.valid) {
            return this.view.getExpression();
        }
        return null;
    }

    @Override
    public void loadParseNode(ParseNode parseNode, String string) {
        if (this.templateHelper.getParsePatternMatcher() == null) {
            return;
        }
        this.ignoreChanges = 1;
        this.getComponent();
        this.pendingHyperParams = new ArrayList<TemplateHyperParam>();
        TemplateGUIImpl.getAllHyperParams(this.view, this.pendingHyperParams);
        this.templateHelper.getParsePatternMatcher().loadParseNodes(parseNode, this.pendingHyperParams);
        this.ignoreChanges = 0;
    }

    @Override
    public TemplateData getSyntax(TemplateData.Mode mode) throws SQLException, IOException {
        ++this.ignoreChanges;
        LinkedList<TemplateHyperParam> linkedList = new LinkedList<TemplateHyperParam>();
        TemplateGUIImpl.getAllHyperParams(this.view, linkedList);
        String string = null;
        if (mode == TemplateData.Mode.WRAP && this.paramValues != null && this.paramValues.get("selection") != null) {
            for (TemplateHyperParam templateHyperParam : linkedList) {
                if (!templateHyperParam.isCanWrap()) continue;
                templateHyperParam.setValue(this.paramValues.get("selection"));
            }
        }
        string = this.getSyntax();
        --this.ignoreChanges;
        return new TemplateData(string, mode);
    }

    public void createAllTemplateParams() {
        this.getComponent();
    }

    @Override
    public Component getComponent() {
        if (this.message == null) {
            try {
                Serializable serializable;
                this.message = new JPanel(new BorderLayout(0, 0));
                this.message.setName("TEMPLATEGUI_CONTAINER");
                this.message.add(Box.createVerticalStrut(3), "South");
                this.message.add(Box.createHorizontalStrut(3), "West");
                this.message.add(Box.createHorizontalStrut(3), "East");
                ++this.ignoreChanges;
                JPanel jPanel = this.view.getPanel(0);
                --this.ignoreChanges;
                this.view.addPropertyChangeListener(this.changeListener);
                if (this.nonOptionals == null) {
                    this.nonOptionals = new LinkedList<TemplateHyperParam>();
                    TemplateGUIImpl.getAllHyperParams(this.view, this.nonOptionals);
                    serializable = new LinkedList();
                    for (TemplateHyperParam templateHyperParam : this.nonOptionals) {
                        serializable.addAll(templateHyperParam.getOptionalHyperParams());
                    }
                    this.nonOptionals.removeAll((Collection<?>)((Object)serializable));
                }
                this.valid = true;
                serializable = new StringBuilder("<html><body>");
                for (TemplateHyperParam templateHyperParam : this.nonOptionals) {
                    if (templateHyperParam.isValid()) continue;
                    this.valid = false;
                    ((StringBuilder)serializable).append("<p>");
                    ((StringBuilder)serializable).append(templateHyperParam.getErrorMessage());
                    ((StringBuilder)serializable).append("</p>");
                }
                ((StringBuilder)serializable).append("</body></html>");
                if (this.valid) {
                    this.message.add(jPanel);
                } else {
                    this.message.add(new JLabel(((StringBuilder)serializable).toString()));
                }
            }
            catch (Exception exception) {
                if (this.templateHelper.getTemplate() != null) {
                    LOG.log(Level.SEVERE, String.format("Error creating %s template", this.templateHelper.getTemplate().getName()), exception);
                }
                LOG.log(Level.SEVERE, String.format("Error creating %s template", this.view.getName()), exception);
            }
        }
        return this.message;
    }

    static void getAllHyperParams(BaseTemplateHyperView baseTemplateHyperView, List<TemplateHyperParam> list) {
        if (baseTemplateHyperView instanceof TemplateGroupHyperView) {
            TemplateGroupHyperView templateGroupHyperView = (TemplateGroupHyperView)baseTemplateHyperView;
            try {
                for (BaseTemplateHyperView baseTemplateHyperView2 : templateGroupHyperView.getAllTemplateViews()) {
                    TemplateGUIImpl.getAllHyperParams(baseTemplateHyperView2, list);
                }
            }
            catch (Exception exception) {
                LOG.warning(String.format("Could not get views for group", templateGroupHyperView.getName()));
            }
        } else if (baseTemplateHyperView instanceof TemplateHyperView) {
            for (TemplateHyperParam templateHyperParam : baseTemplateHyperView.getHyperParams()) {
                list.add(templateHyperParam);
            }
        }
    }

    @Override
    public void setValueMap(Map<String, String> map) {
        this.getComponent();
        ++this.ignoreChanges;
        LinkedList<TemplateHyperParam> linkedList = new LinkedList<TemplateHyperParam>();
        TemplateGUIImpl.getAllHyperParams(this.view, linkedList);
        for (TemplateHyperParam templateHyperParam : linkedList) {
            try {
                templateHyperParam.setValueMap(map);
            }
            catch (Exception exception) {
                LOG.warning(String.format("Error trying to load parameter values for %s", templateHyperParam.getName()));
            }
        }
        this.paramValues = map;
        --this.ignoreChanges;
    }

    @Override
    public void dispose() {
        this.message = null;
        this.view.removePropertyChangeListener(this.changeListener);
    }
}

