/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryTableCellViewer;
import oracle.olap.app.table.TableLabelCellRenderer;
import oracle.olap.app.tree.model.TreeTableModel;
import oracle.olap.app.tree.view.JTreeTable;
import oracle.olap.buildreports.BuildNode;
import oracle.olap.buildreports.BuildTreeTableModel;
import oracle.olap.navigator.OLAPNavigatorResource;

public class BuildStepPanel
extends JPanel {
    private int m_buildid;
    private JScrollPane topScrollPane;
    private GridBagConstraints topConstraints;
    private JTableHeader m_stepTabHeader;
    private JProgressBar m_progressBar = new JProgressBar();
    private JTreeTable m_treeTable;
    private BuildTreeTableModel m_treeTableModel;
    private Connection m_connection;
    private DefaultTableColumnModel m_tableStepColumnModel;
    private Query m_stepQuery;
    private Map<String, Object> m_stepQueryParams;
    private Query m_statusQuery;

    public BuildStepPanel(Connection connection, Query query, Map<String, Object> map, Query query2, int n) {
        this.m_connection = connection;
        this.m_stepQuery = query;
        this.m_stepQueryParams = map;
        this.m_statusQuery = query2;
        this.m_buildid = n;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = null;
            String string2 = exception.getLocalizedMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = exception.getClass().toString();
            }
            String string3 = OLAPArb.get("BUILD_ERROR_DLG_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string);
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_STEPS"));
        this.topConstraints = new GridBagConstraints();
        this.topConstraints.gridx = 0;
        this.topConstraints.gridy = 0;
        this.topConstraints.gridwidth = 1;
        this.topConstraints.gridheight = 1;
        this.topConstraints.weightx = 0.0;
        this.topConstraints.weighty = 0.0;
        this.topConstraints.fill = 1;
        this.topConstraints.anchor = 10;
        this.topConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jLabel, this.topConstraints);
        this.topConstraints.gridx = 1;
        this.topConstraints.weightx = 1.0;
        this.topConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setMinimum(0);
        this.m_progressBar.setStringPainted(true);
        this.add((Component)this.m_progressBar, this.topConstraints);
        this.m_treeTableModel = new BuildTreeTableModel(this.m_connection, this.m_stepQuery, this.m_stepQueryParams, this.m_statusQuery, this.m_buildid);
        this.m_treeTableModel.populateTableDataModel();
        this.m_tableStepColumnModel = new DefaultTableColumnModel();
        this.m_treeTable = new JTreeTable(this.m_treeTableModel);
        this.m_treeTable.setMinimumSize(new Dimension(100, 100));
        this.m_treeTable.setAutoResizeMode(0);
        this.m_treeTable.setDefaultRenderer(Object.class, new BuildStepCellRenderer());
        this.m_treeTable.setDefaultEditor(Object.class, new QueryTableCellViewer(null, this.m_stepQuery.getView()));
        this.setColumnWidths();
        JTreeTable.TreeTableCellRenderer treeTableCellRenderer = (JTreeTable.TreeTableCellRenderer)this.m_treeTable.getDefaultRenderer(TreeTableModel.class);
        treeTableCellRenderer.setCellRenderer(new DefaultTreeCellRenderer(){
            private Icon m_pendingIcon = OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_PENDING");
            private Icon m_progressIcon = OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_INPROGRESS");
            private Icon m_successIcon = OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_SUCCESS");
            private Icon m_errorIcon = OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_FAILURE");
            private Icon m_dimensionIcon = OLAPNavigatorResource.getIcon("OLAPDIMENSION_ICON");
            private Icon m_cubeIcon = OLAPNavigatorResource.getIcon("OLAPCUBE_ICON");
            private Icon m_buildprocIcon = OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_BUILDPROCESS");

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (bl3) {
                    BuildNode buildNode = (BuildNode)object;
                    if (buildNode.status.equalsIgnoreCase("Succeeded")) {
                        this.setIcon(this.m_successIcon);
                    } else if (buildNode.status.equalsIgnoreCase("Pending")) {
                        this.setIcon(this.m_pendingIcon);
                    } else if (buildNode.status.equalsIgnoreCase("In Progress")) {
                        this.setIcon(this.m_progressIcon);
                    } else {
                        this.setIcon(this.m_errorIcon);
                    }
                } else {
                    BuildNode buildNode = (BuildNode)object;
                    if (buildNode.getObjType().equalsIgnoreCase("DIMENSION")) {
                        this.setIcon(this.m_dimensionIcon);
                    } else if (buildNode.getObjType().equalsIgnoreCase("CUBE")) {
                        this.setIcon(this.m_cubeIcon);
                    } else {
                        this.setIcon(this.m_buildprocIcon);
                    }
                }
                return this;
            }
        });
        this.m_stepTabHeader = this.m_treeTable.getTableHeader();
        this.topScrollPane = new JScrollPane();
        this.topScrollPane.getViewport().add(this.m_treeTable, 30, 20);
        this.topScrollPane.setLocation(0, 0);
        this.topScrollPane.setSize(300, 300);
        this.topScrollPane.setPreferredSize(new Dimension(300, 300));
        this.topConstraints.gridx = 0;
        this.topConstraints.gridy = 1;
        this.topConstraints.gridwidth = 2;
        this.topConstraints.gridheight = 1;
        this.topConstraints.weightx = 1.0;
        this.topConstraints.weighty = 1.0;
        this.topConstraints.insets = new Insets(0, 0, 0, 0);
        this.topConstraints.fill = 1;
        this.add((Component)this.topScrollPane, this.topConstraints);
    }

    private void updateProgressBar() {
        this.m_progressBar.setMaximum(this.m_treeTableModel.getRowCount());
        this.m_progressBar.setValue(this.m_treeTableModel.getNumOfCompleted());
        String string = OLAPArb.format("BUILD_WIZARD.STATUS.BUILD_PROGRESSBAR_MESSAGE", Integer.toString(this.m_treeTableModel.getNumOfCompleted()), Integer.toString(this.m_treeTableModel.getRowCount()));
        this.m_progressBar.setString(string);
    }

    public synchronized void populateBuildStepModel() throws Exception {
        this.m_treeTableModel.populateTableDataModel();
        this.m_treeTable.updateUI();
        this.m_treeTable.validate();
        this.m_stepTabHeader = this.m_treeTable.getTableHeader();
        BuildNode buildNode = (BuildNode)this.m_treeTableModel.getRoot();
        if (buildNode.getStatus() == null || buildNode.getStatus() != "") {
            // empty if block
        }
        this.m_treeTable.expandAll(true);
        this.updateProgressBar();
    }

    public Connection getConnectionInfo() {
        return this.m_connection;
    }

    public int getBuildId() {
        return this.m_buildid;
    }

    public synchronized void changeAllPendingToSucceeded() throws Exception {
        this.m_treeTableModel.changeAllPendingToSucceeded();
        this.m_treeTable.updateUI();
        this.m_treeTable.validate();
        this.m_stepTabHeader = this.m_treeTable.getTableHeader();
        this.m_treeTable.expandAll(true);
        this.updateProgressBar();
    }

    public void cleanup() {
        this.topScrollPane = null;
        this.topConstraints = null;
        this.m_stepTabHeader = null;
        this.m_progressBar = null;
        this.m_treeTable = null;
        this.m_treeTableModel = null;
        this.m_connection = null;
        this.m_tableStepColumnModel = null;
        this.m_stepQuery = null;
        this.m_stepQueryParams = null;
        this.m_statusQuery = null;
    }

    private void setColumnWidths() {
        for (int i = 0; i < this.m_treeTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this.m_treeTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(175);
                continue;
            }
            tableColumn.setPreferredWidth(75);
        }
    }

    private class BuildStepCellRenderer
    extends TableLabelCellRenderer {
        private BuildStepCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = (String)object;
            if (string != null) {
                if (string.equalsIgnoreCase("COMPLETED") || string.equalsIgnoreCase("SUCCEEDED")) {
                    Font font = this.getFont();
                    Font font2 = new Font(string, 1, font.getSize());
                    this.setFont(font2);
                    this.setForeground(Color.black);
                } else if (string.startsWith("Failed") || string.equalsIgnoreCase("FAILED")) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(Color.black);
                }
            }
            if (n2 == 3 || n2 == 4 || n2 == 5) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

