/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.util.OLAPListTableModel;

public class CubeSparsityTableModel<T>
extends OLAPListTableModel<CubeDimensionality>
implements TableModelListener {
    public static final int ORDER = 0;
    public static final int DIMENSION = 1;
    public static final int SPARSE = 2;
    private static final String[] COL_NAMES = new String[]{OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.ORDER.COLUMN.LABEL"), OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.DIMENSION.COLUMN.LABEL"), OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.SPARSE.COLUMN.LABEL")};
    private static final String[] COL_TIPS = new String[]{OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.ORDER.COLUMN.LABEL"), OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.DIMENSION.COLUMN.LABEL"), OLAPArb.get("CUBE.STORAGE.DIMENSION.GRID.SPARSE.COLUMN.LABEL")};

    public CubeSparsityTableModel() {
        super(COL_NAMES, COL_TIPS);
        this.addTableModelListener(this);
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    protected Object getValueAt(CubeDimensionality cubeDimensionality, int n) {
        switch (n) {
            case 0: {
                return cubeDimensionality.getPhysicalOrder();
            }
            case 1: {
                String string = cubeDimensionality.getName();
                return string;
            }
            case 2: {
                Boolean bl = cubeDimensionality.isSparse();
                return bl;
            }
        }
        return null;
    }

    @Override
    protected void setValueAt(Object object, CubeDimensionality cubeDimensionality, int n) {
        switch (n) {
            case 0: {
                cubeDimensionality.setPhysicalOrder((Integer)object);
                break;
            }
            case 1: {
                cubeDimensionality.setName((String)object);
                break;
            }
            case 2: {
                cubeDimensionality.setSparse((Boolean)object);
                break;
            }
        }
    }

    @Override
    protected boolean isCellEditable(CubeDimensionality cubeDimensionality, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        List list = this.getRowList();
        int n = 0;
        for (Object e : list) {
            if (!(e instanceof CubeDimensionality)) continue;
            CubeDimensionality cubeDimensionality = (CubeDimensionality)((Object)e);
            this.setValueAt((Object)(++n), cubeDimensionality, 0);
        }
    }
}

