/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.diagram.measure;

import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.bus.IlvBusLayout;
import ilog.views.graphlayout.circular.IlvCircularLayout;
import ilog.views.graphlayout.grid.IlvGridLayout;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.swing.IlvJManagerViewControlBar;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.diagram.sdm.editor.SDMDiagram;
import oracle.diagram.sdm.editor.SDMDiagramEditor;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.diagram.ManagerViewReadyCallback;
import oracle.olap.diagram.measure.MeasureDependenciesDiagram;

public class MeasureDependenciesEditor
extends SDMDiagramEditor {
    private IlvJManagerViewControlBar toolbar;
    private JCheckBox measureRelationships = new JCheckBox(OLAPArb.getString("CALCULATED_MEASURES_DEPENDENCIES_MAP_FULL_CUBE_OPTION"));
    private ManagerViewReadyCallback managerViewReady;
    private boolean aditionalToolsAdded;
    private JComboBox diagramLayoutsCombo;
    private static final String[] layouts = new String[]{OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_LTR"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_RTL"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_TTB"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_BTT"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_SYM"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_GRID"), OLAPArb.getString("DEPENDENCIES_DIAGRAM_HIERARCHICAL_LAYOUT_ROW")};
    private static final int LAYOUT_LTR = 0;
    private static final int LAYOUT_RTL = 1;
    private static final int LAYOUT_TTB = 2;
    private static final int LAYOUT_BTT = 3;
    private static final int LAYOUT_SYM = 4;
    private static final int LAYOUT_GRID = 5;
    private static final int LAYOUT_ROW = 6;

    public MeasureDependenciesEditor() {
        super((SDMDiagram)new MeasureDependenciesDiagram());
        this.measureRelationships.setSelected(false);
        this.measureRelationships.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureDependenciesDiagram measureDependenciesDiagram = (MeasureDependenciesDiagram)MeasureDependenciesEditor.this.getDiagram();
                measureDependenciesDiagram.switchDiagram(MeasureDependenciesEditor.this.measureRelationships.isSelected());
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        Integer[] integerArray = new Integer[]{0, 1, 2, 3, 4, 5, 6};
        this.diagramLayoutsCombo = new JComboBox<Integer>(integerArray);
        this.diagramLayoutsCombo.setRenderer(new LayoutRenderer());
        this.diagramLayoutsCombo.setSelectedIndex(0);
        this.diagramLayoutsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureDependenciesDiagram measureDependenciesDiagram = (MeasureDependenciesDiagram)MeasureDependenciesEditor.this.getDiagram();
                switch (MeasureDependenciesEditor.this.diagramLayoutsCombo.getSelectedIndex()) {
                    case 0: {
                        measureDependenciesDiagram.setDiagramLayout(MeasureDependenciesEditor.this.createHierarchicalLayout(2));
                        break;
                    }
                    case 1: {
                        measureDependenciesDiagram.setDiagramLayout(MeasureDependenciesEditor.this.createHierarchicalLayout(1));
                        break;
                    }
                    case 2: {
                        measureDependenciesDiagram.setDiagramLayout(MeasureDependenciesEditor.this.createHierarchicalLayout(8));
                        break;
                    }
                    case 3: {
                        measureDependenciesDiagram.setDiagramLayout(MeasureDependenciesEditor.this.createHierarchicalLayout(4));
                        break;
                    }
                    case 4: {
                        measureDependenciesDiagram.setDiagramLayout((IlvGraphLayout)new IlvCircularLayout());
                        break;
                    }
                    case 5: {
                        measureDependenciesDiagram.setDiagramLayout((IlvGraphLayout)new IlvGridLayout());
                        break;
                    }
                    case 6: {
                        measureDependenciesDiagram.setDiagramLayout((IlvGraphLayout)new IlvBusLayout());
                        break;
                    }
                }
                measureDependenciesDiagram.layoutDiagram();
            }
        });
        jPanel.add(this.diagramLayoutsCombo);
        jPanel.add(this.measureRelationships);
        final IlvJManagerViewControlBar ilvJManagerViewControlBar = this.getFixedTopMargin();
        MeasureDependenciesDiagram measureDependenciesDiagram = (MeasureDependenciesDiagram)this.getDiagram();
        this.managerViewReady = new ManagerViewReadyCallback(){

            @Override
            public void setManagerView(IlvManagerView ilvManagerView) {
                ilvJManagerViewControlBar.setView(ilvManagerView);
            }

            @Override
            public void registerViewToPopupManager(IlvManagerView ilvManagerView) {
                IlvPopupMenuManager.registerView((IlvManagerView)ilvManagerView);
            }
        };
        measureDependenciesDiagram.setManagerViewCallback(this.managerViewReady);
        if (!this.aditionalToolsAdded) {
            ilvJManagerViewControlBar.add((Action)new RefreshAction());
            ilvJManagerViewControlBar.add((Component)jPanel);
            this.aditionalToolsAdded = true;
        }
    }

    private IlvGraphLayout createHierarchicalLayout(int n) {
        IlvHierarchicalLayout ilvHierarchicalLayout = new IlvHierarchicalLayout();
        ilvHierarchicalLayout.setBacktrackCrossingReductionEnabled(true);
        ilvHierarchicalLayout.setGlobalLinkStyle(2);
        ilvHierarchicalLayout.setFlowDirection(n);
        return ilvHierarchicalLayout;
    }

    public IlvJManagerViewControlBar getFixedTopMargin() {
        if (this.toolbar == null) {
            this.toolbar = new IlvJManagerViewControlBar();
            this.toolbar.setZoomInIcon(OracleIcons.getIcon((String)"zoomin.png"));
            this.toolbar.setZoomOutIcon(OracleIcons.getIcon((String)"zoomout.png"));
            this.toolbar.setFitToContentsIcon(OracleIcons.getIcon((String)"fit_to_window.png"));
        }
        return this.toolbar;
    }

    class LayoutRenderer
    extends JLabel
    implements ListCellRenderer {
        private Icon[] icons = new Icon[]{OracleIcons.getIcon((String)"bmj_layout_ltr.png"), OracleIcons.getIcon((String)"bmj_layout_rtl.png"), OracleIcons.getIcon((String)"bmj_layout_ttb.png"), OracleIcons.getIcon((String)"bmj_layout_btt.png"), OracleIcons.getIcon((String)"bmj_layout_symm.png"), OracleIcons.getIcon((String)"bmj_layout_grid.png"), OracleIcons.getIcon((String)"bmj_layout_row.png")};

        LayoutRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n >= 0) {
                this.setIconAndText(this.icons[n], layouts[n]);
            } else {
                int n2 = (Integer)object;
                this.setIcon(this.icons[n2]);
                this.setToolTipText(layouts[n2]);
            }
            return this;
        }

        private void setIconAndText(Icon icon, String string) {
            this.setIcon(icon);
            this.setText(string);
            this.setToolTipText(string);
        }
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            this.setEnabled(true);
            this.putValue("Name", Messages.getString((String)"Refresh"));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("SmallIcon", OracleIcons.getIcon((String)"refresh.png"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MeasureDependenciesDiagram measureDependenciesDiagram = (MeasureDependenciesDiagram)MeasureDependenciesEditor.this.getDiagram();
            measureDependenciesDiagram.refreshDiagram();
        }
    }
}

