/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measure;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Measure;

public class MeasureDetailsDialog
extends JDialog {
    private Measure measure;
    private JLabel measureNameLabel;
    private JLabel measureShortLabel;
    private JLabel measureLongLabel;
    private JLabel measureDescription;
    private JTextField measureNameTF;
    private JTextField measureShortLabelTF;
    private JTextField measureLongLabelTF;
    private JTextField measureDescriptionTF;
    private final String CANCEL_COMMAND = "CANCEL_ID";

    public MeasureDetailsDialog(Measure measure) {
        super((Frame)Ide.getMainWindow(), measure.getName());
        this.measure = measure;
        this.initComponents();
        int n = this.layoutDescriptionFields();
        this.layoutOKButton(n);
        this.setMinimumSize(new Dimension(300, 150));
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.setModal(true);
        this.registerKeyboardActions();
    }

    protected void initComponents() {
        this.measureNameLabel = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_NAME_LABEL"));
        this.measureNameTF = new JTextField(this.measure.getName());
        this.measureNameTF.setEditable(false);
        this.measureShortLabel = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_SHORT_LABEL"));
        this.measureShortLabelTF = new JTextField(this.measure.getShortDescription());
        this.measureShortLabelTF.setEditable(false);
        this.measureLongLabel = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_LONG_LABEL"));
        this.measureLongLabelTF = new JTextField(this.measure.getLongDescription());
        this.measureLongLabelTF.setEditable(false);
        this.measureDescription = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_DESCRIPTION"));
        this.measureDescriptionTF = new JTextField(this.measure.getDescription());
        this.measureDescriptionTF.setEditable(false);
    }

    protected int layoutDescriptionFields() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.measureNameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureNameTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureShortLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureShortLabelTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureLongLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureLongLabelTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureDescription, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.measureDescriptionTF, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 19, 2, new Insets(5, 5, 0, 0), 0, 0));
        return ++n;
    }

    protected void layoutOKButton(int n) {
        JButton jButton = new JButton(OLAPArb.getString("DIALOG_OK_BUTTON_TEXT"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureDetailsDialog.this.close();
            }
        });
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        this.add((Component)buttonBar, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected Measure getMeasure() {
        return this.measure;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MeasureDetailsDialog.this.close();
            }
        };
        jRootPane.registerKeyboardAction(actionListener, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
    }
}

