/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.olap.app.Resources;
import oracle.olap.app.searchbar.SearchOptions;

public abstract class TextHighlighter {
    private BasicEditorPane textPane;
    private int highlightStart = 0;
    private Resources resources;
    private HighlightLayer highlightLayer;
    private final int SEARCH_FWD = 1;
    private final int SEARCH_BCK = 2;
    private int lastSearchDir = 0;
    private final String WORD_MATCH = "(\\W*)\\w(\\W)";
    public static final String SEARCH_FORWARD = "searchfwd";
    public static final String SEARCH_BACKWARD = "searchbck";
    private static final String HIGHLIGHT = "editor";
    private SearchOptions searchOptions;
    private final HighlightStyle highlightStyle;

    public TextHighlighter(BasicEditorPane basicEditorPane, SearchOptions searchOptions, Resources resources) {
        this.textPane = basicEditorPane;
        this.resources = resources;
        this.searchOptions = searchOptions;
        this.highlightLayer = this.textPane.createHighlightLayer();
        this.highlightStyle = CodeEditor.createHighlightStyle((String)HIGHLIGHT, (String)HIGHLIGHT, (int)100, (Color)new Color(255, 255, 255), (Color)new Color(51, 102, 153));
    }

    public abstract void showPopupMessage(String var1);

    public abstract void updateScrollPosition(int var1);

    public void highlightText(AWTEvent aWTEvent, String string) throws BadLocationException {
        String string2 = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        if (string.length() == 0) {
            this.highlightLayer.removeAllHighlights();
            this.highlightStart = 0;
            this.textPane.setSelectionStart(this.highlightStart);
            this.textPane.unselect();
            return;
        }
        this.highlightLayer.removeAllHighlights();
        if (aWTEvent instanceof KeyEvent) {
            int n;
            this.textPane.setSelectionStart(0);
            int n2 = this.textPane.getSelectionStart();
            if (n2 > 0) {
                n2 += string.length();
            }
            int n3 = n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.indexOf(string, n2) : string2.toLowerCase().indexOf(string.toLowerCase(), n2);
            if (n == -1) {
                n2 = 0;
                int n4 = n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.indexOf(string, n2) : string2.toLowerCase().indexOf(string.toLowerCase(), n2);
            }
            if (n >= 0) {
                this.highlightStart = n + string.length();
                if (this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD")).booleanValue()) {
                    String string3 = n - 1 >= 0 ? string2.substring(n - 1, n + string.length() + 1) : string2.substring(n, n + string.length() + 1);
                    Pattern pattern = Pattern.compile("(\\W*)\\w(\\W)");
                    Matcher matcher = pattern.matcher(string3);
                    if (matcher.find()) {
                        HighlightedText highlightedText = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                    }
                } else {
                    HighlightedText highlightedText = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                }
            } else {
                this.highlightStart = 0;
                this.highlightLayer.removeAllHighlights();
                this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
            }
        } else if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            this.textPane.setSelectionStart(this.highlightStart);
            if (actionEvent.getActionCommand().equalsIgnoreCase(SEARCH_FORWARD)) {
                int n = 0;
                n = this.lastSearchDir == 2 ? (this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")).booleanValue() ? string2.indexOf(string, this.highlightStart + 2 * string.length()) : string2.toLowerCase().indexOf(string.toLowerCase(), this.highlightStart + 2 * string.length())) : (this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.indexOf(string, this.highlightStart) : string2.toLowerCase().indexOf(string.toLowerCase(), this.highlightStart));
                if (n == -1) {
                    this.highlightStart = 0;
                    int n5 = n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.indexOf(string) : string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n >= 0) {
                        this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_WRAP_DOWN"));
                        this.lastSearchDir = 1;
                        return;
                    }
                }
                if (n >= 0) {
                    this.highlightStart = n + string.length();
                    this.highlightLayer.removeAllHighlights();
                    HighlightedText highlightedText = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                    if (this.highlightStart >= 0) {
                        this.textPane.setCaretPosition(this.highlightStart);
                        if (!this.textPane.isOffsetVisible(this.textPane.getCaretPosition())) {
                            double d = 100.0 * ((double)this.textPane.getLineFromOffset(this.textPane.getCaretPosition()) / (double)this.textPane.getLineCount());
                            this.updateScrollPosition((int)d);
                        }
                    } else {
                        this.textPane.setCaretPosition(0);
                    }
                } else {
                    this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
                }
                this.lastSearchDir = 1;
            } else if (actionEvent.getActionCommand().equalsIgnoreCase(SEARCH_BACKWARD)) {
                int n = 0;
                if (this.highlightStart <= 0) {
                    n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.lastIndexOf(string, string2.length()) : string2.toLowerCase().lastIndexOf(string.toLowerCase(), string2.length());
                } else {
                    int n6 = n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.lastIndexOf(string, this.highlightStart - string.length() - 1) : string2.toLowerCase().lastIndexOf(string.toLowerCase(), this.highlightStart - string.length() - 1);
                }
                if (n == -1) {
                    this.highlightStart = 0;
                    int n7 = n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.lastIndexOf(string) : string2.toLowerCase().lastIndexOf(string.toLowerCase());
                    if (n >= 0) {
                        this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_WRAP_UP"));
                        return;
                    }
                }
                if (n >= 0) {
                    this.highlightStart = n - string.length() - 1;
                    HighlightedText highlightedText = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                    if (this.highlightStart >= 0) {
                        this.textPane.setCaretPosition(this.highlightStart);
                    } else {
                        this.textPane.setCaretPosition(0);
                        this.highlightStart = 1;
                    }
                    if (!this.textPane.isOffsetVisible(this.textPane.getCaretPosition())) {
                        double d = 100.0 * ((double)this.textPane.getLineFromOffset(this.textPane.getCaretPosition()) / (double)this.textPane.getLineCount());
                        this.updateScrollPosition((int)d);
                    }
                } else {
                    this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
                }
                this.lastSearchDir = 2;
            }
        }
        this.textPane.unselect();
    }

    public void highlightAllOccurrences(String string) throws BadLocationException {
        String string2 = this.textPane.getDocument().getText(0, this.textPane.getDocument().getLength());
        if (string.length() == 0) {
            this.highlightLayer.removeAllHighlights();
            this.highlightStart = 0;
            this.textPane.setSelectionStart(this.highlightStart);
            this.textPane.unselect();
            return;
        }
        int n = 0;
        this.highlightStart = 0;
        this.textPane.setSelectionStart(0);
        this.highlightLayer.removeAllHighlights();
        ArrayList<HighlightedText> arrayList = new ArrayList<HighlightedText>();
        while (n >= 0) {
            Object object;
            n = this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_CASE")) != false ? string2.indexOf(string, this.highlightStart) : string2.toLowerCase().indexOf(string.toLowerCase(), this.highlightStart);
            if (n < 0) continue;
            if (this.searchOptions.getMap().get(this.resources.getString("SEARCHOPTIONS.MATCH_WHOLE_WORD")).booleanValue()) {
                object = n - 1 > 0 ? string2.substring(n - 1, n + string.length() + 1) : string2.substring(n, n + string.length() + 1);
                Pattern pattern = Pattern.compile("(\\W*)\\w(\\W)");
                Matcher matcher = pattern.matcher((CharSequence)object);
                if (matcher.find()) {
                    HighlightedText highlightedText = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                    arrayList.add(highlightedText);
                }
            } else {
                object = this.highlightLayer.addHighlight(this.highlightStyle, n, n + string.length());
                arrayList.add((HighlightedText)object);
            }
            this.highlightStart = n + string.length();
        }
        if (arrayList.isEmpty()) {
            this.showPopupMessage(this.resources.getString("TEXTVIEWER_DIALOG_SEARCH_TEXT_NOT_FOUND"));
        } else {
            arrayList.clear();
        }
        this.textPane.unselect();
    }

    public void dispose() {
        this.textPane.destroyHighlightLayer(this.highlightLayer);
    }
}

