/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.viewer;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.oviewer.table.GridDataEditor;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.model.Element;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templateview.TemplateListHyperView;
import oracle.olap.app.templates.templateview.TemplateMetadata;
import oracle.olap.app.templates.view.TemplateContext;
import oracle.olap.app.templates.view.TemplateHyperContextImpl;
import oracle.olap.cubeviewer.CubeDataViewerPanel;
import oracle.olap.data.CubeMetadataContextImpl;

public class OLAPGridDataEditor
extends GridDataEditor {
    private static final Logger LOG = Logger.getLogger(OLAPGridDataEditor.class.getName());
    private String where;

    protected String getSql() {
        this.where = null;
        DBObject dBObject = new DBObject((Element)this.getViewerNode());
        if (dBObject.getObjectType().equals("CUBE")) {
            return this.getCubeSql(dBObject);
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        String string = dBUtil.addDbQuotes(dBObject.getSchemaName());
        String string2 = dBObject.getObjectName();
        string2 = this.getViewName(dBObject);
        String string3 = dBUtil.addDbQuotes(string2);
        String string4 = MessageFormat.format("SELECT * FROM {0}.{1}", string, string3);
        return string4;
    }

    private String getViewName(DBObject dBObject) {
        String string;
        String string2;
        String string3 = dBObject.getObjectName();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        String string4 = dBObject.getSchemaName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string4);
        hashMap.put("name", string3);
        if (dBObject.getObjectType().equals("CUBE DIMENSION")) {
            string2 = "select view_name from all_cube_dim_views where owner = :owner and dimension_name = :name";
            string3 = string = dBUtil.executeReturnOneCol(string2, hashMap);
        }
        if (dBObject.getObjectType().equals("CUBE")) {
            string2 = "select view_name from all_cube_views where owner = :owner and cube_name = :name";
            string3 = string = dBUtil.executeReturnOneCol(string2, hashMap);
        }
        return string3;
    }

    private String getCubeSql(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        if (oracleDatabaseImpl != null) {
            DatabaseImpl databaseImpl = new DatabaseImpl(connection);
            Schema schema = new Schema(string);
            OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
            try {
                oLAPMetadataReader.loadCube(string2);
                boolean bl = true;
                CubeMetadataContextImpl cubeMetadataContextImpl = new CubeMetadataContextImpl(oracleDatabaseImpl, schema.findCube(string2), bl);
                OLAPResources oLAPResources = new OLAPResources("/oracle/olap/cubeviewer/dimcondition.xml");
                TemplateHyperContextImpl templateHyperContextImpl = new TemplateHyperContextImpl(cubeMetadataContextImpl.getDatabase().getConnection(), oLAPResources, null);
                cubeMetadataContextImpl.getCube().getSchema().setLoaded(true);
                TemplateContext templateContext = new TemplateContext(databaseImpl, new TemplateMetadata(cubeMetadataContextImpl.getCube()));
                TemplateListHyperView templateListHyperView = new TemplateListHyperView(templateContext, templateHyperContextImpl, CubeDataViewerPanel.class, "dimcondition.xml");
                int n = -1;
                String string3 = templateListHyperView.getExpression();
                return string3;
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return null;
    }
}

