/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.dbtools.auth.challenges.Challenges;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.locale.LocalePreferences;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.http.HttpHeader;
import oracle.dbtools.http.errors.ServletResponseException;
import oracle.dbtools.http.servlet.UriRequest;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.plugin.api.servlet.EntityTag;
import oracle.dbtools.rt.authentication.AuthenticationException;
import oracle.dbtools.rt.web.HasSessionAttributes;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.WebException;

class ResourceTemplatesException
extends ServletResponseException {
    private final EntityTag entityTag;
    private final AuthenticationChallenge challenge;
    private final String redirectLocation;
    private final Map<String, Object> session;
    private static final long serialVersionUID = 22594325184309882L;

    ResourceTemplatesException(URI contextPath, WebException cause) {
        super(cause.statusCode().statusCode(), (Throwable)cause, ResourceTemplatesException.adapt(cause.reasons()));
        this.entityTag = cause.statusCode() == HttpStatusCode.NOT_MODIFIED ? cause.entityTag() : null;
        this.challenge = cause instanceof AuthenticationException ? ((AuthenticationException)cause).challenge() : null;
        if (cause instanceof RedirectException) {
            this.session = ((HasSessionAttributes)((Object)cause)).session();
            String location = ((RedirectException)cause).redirectLocation();
            this.redirectLocation = URIs.resolve((URI)contextPath, (String)location).toASCIIString();
        } else {
            this.session = null;
            this.redirectLocation = null;
        }
    }

    ResourceTemplatesException(WebException cause) {
        super(cause.statusCode().statusCode(), (Throwable)cause, ResourceTemplatesException.adapt(cause.reasons()));
        this.entityTag = cause.statusCode() == HttpStatusCode.NOT_MODIFIED ? cause.entityTag() : null;
        this.challenge = cause instanceof AuthenticationException ? ((AuthenticationException)cause).challenge() : null;
        if (cause instanceof RedirectException) {
            this.session = ((HasSessionAttributes)((Object)cause)).session();
            this.redirectLocation = ((RedirectException)cause).redirectLocation();
        } else {
            this.session = null;
            this.redirectLocation = null;
        }
    }

    public boolean service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        LocalePreference localePreference = LocalePreferences.INSTANCE.preference(req);
        if (this.challenge != null && !Challenges.NO_CHALLENGE.equals(this.challenge)) {
            resp.setHeader(HttpHeader.WWW_AUTHENTICATE.text(), this.challenge.toString((Iterable)localePreference));
        }
        if (this.redirectLocation != null) {
            UriRequest uri = UriRequest.uriRequest((HttpServletRequest)req);
            String absUri = URIs.resolve((URI)uri.getBaseURI(), (String)this.redirectLocation).toASCIIString();
            resp.setHeader(HttpHeader.LOCATION.text(), absUri);
        }
        if (this.entityTag != null) {
            resp.setHeader(HttpHeader.ETAG.text(), this.entityTag.toString());
        }
        if (this.session != null) {
            HttpSession existing = req.getSession(false);
            if (existing != null) {
                existing.invalidate();
            }
            HttpSession httpSession = req.getSession(true);
            for (Map.Entry<String, Object> entry : this.session.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                httpSession.setAttribute(name, value);
            }
        }
        return super.service(request, response);
    }

    private static Iterable<oracle.dbtools.http.errors.Reason> adapt(Iterable<Reason> reasons) {
        ArrayList<oracle.dbtools.http.errors.Reason> adapted = new ArrayList<oracle.dbtools.http.errors.Reason>();
        for (Reason reason : reasons) {
            adapted.add(oracle.dbtools.http.errors.Reason.reason((String)reason.target(), (Translatable)reason.reason()));
        }
        return adapted;
    }
}

