/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.AuthenticationScope;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.timing.ExecutionTimer;
import oracle.dbtools.common.timing.ExecutionTimers;
import oracle.dbtools.common.timing.ExecutionTiming;
import oracle.dbtools.common.timing.TimingPoint;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.http.auth.AuthenticationScopeHandler;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationException;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.HttpAuthorizationHandler;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authorization.PrivilegeIdCallbackHandler;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

@Service
public class AuthenticationService {
    private ExecutionTimer authenticationTimer;
    private ExecutionTimer authorizationTimer;
    private MultiAssociativeArray<AuthenticationRealm, RealmAuthenticator> authenticators;
    private static final TimingPoint AUTHENTICATION_TIMING = new TimingPoint(TimingPoint.FINE_TIMING, "legacy authentication");
    private static final TimingPoint AUTHORIZATION_TIMING = new TimingPoint(TimingPoint.FINE_TIMING, "legacy authorization");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(SecurityConfig scope, CallbackHandler cb) {
        ExecutionTiming timer = this.authenticationTimer.start();
        try {
            RealmAuthenticator authenticator;
            AuthenticationRealm realm = scope.realm();
            PrivilegeIdCallbackHandler callbackHandler = new PrivilegeIdCallbackHandler(cb, scope);
            AuthenticationResult result = AuthenticationResult.unknown();
            Iterable realmAuthenticators = this.authenticators.values((Object)realm);
            if (NullOrEmpty.nullOrEmpty((Iterable)realmAuthenticators)) {
                throw WebException.internalError(new IllegalStateException(), new Reason[0]);
            }
            Iterator i$ = realmAuthenticators.iterator();
            while (i$.hasNext() && AuthenticationStatus.UNKNOWN.equals((Object)(result = (authenticator = (RealmAuthenticator)i$.next()).authenticate(callbackHandler)).status())) {
            }
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
        finally {
            timer.stop();
        }
    }

    public CompoundPrincipal verify(SecurityConfig scope, RequestEntity request) {
        CallbackHandler cb = this.callbackHandler(scope, request);
        AuthenticationResult result = this.authenticate(scope, cb);
        if (result.isPublic()) {
            return null;
        }
        if (result.isValid()) {
            return this.authorize(scope, request, result);
        }
        throw this.invalidSession(request, scope, result.challenge(), result.status());
    }

    private CompoundPrincipal authorize(SecurityConfig scope, RequestEntity request, AuthenticationResult result) {
        ExecutionTiming timer = this.authorizationTimer.start();
        try {
            CompoundPrincipal principal = CompoundPrincipal.compound((Iterable)result);
            AuthenticationStatus status = scope.authorize(principal);
            if (AuthenticationStatus.VALID == status) {
                CompoundPrincipal compoundPrincipal = principal;
                return compoundPrincipal;
            }
            throw this.invalidSession(request, scope, result.challenge(), status);
        }
        finally {
            timer.stop();
        }
    }

    private CallbackHandler callbackHandler(SecurityConfig scope, RequestEntity request) {
        AuthenticationScope authScope = scope.realm().authScope();
        return new AuthenticationScopeHandler(authScope, (CallbackHandler)new HttpAuthorizationHandler(request));
    }

    public static Iterable<Principal> principals(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Principal first = (Principal)Iterables.first(principals);
        if (first instanceof CompoundPrincipal) {
            return (CompoundPrincipal)first;
        }
        return principals;
    }

    protected void activate(ServiceProperties properties) throws Exception {
        MultiAssociativeArrays.Builder authenticators = MultiAssociativeArrays.builder();
        for (RealmAuthenticator authenticator : ServiceLocator.acquireAll(RealmAuthenticator.class, (String[])new String[0])) {
            Authenticates target = authenticator.getClass().getAnnotation(Authenticates.class);
            if (target == null) continue;
            authenticators.add((Object)target.value(), (Object)authenticator);
        }
        this.authenticators = authenticators.build();
        ExecutionTimers timers = (ExecutionTimers)ServiceLocator.acquire(ExecutionTimers.class);
        this.authenticationTimer = timers.timer(AUTHENTICATION_TIMING);
        this.authorizationTimer = timers.timer(AUTHORIZATION_TIMING);
    }

    private WebException invalidSession(RequestEntity request, SecurityConfig scope, AuthenticationChallenge challenge, AuthenticationStatus status) {
        WebException exception = scope.logonRealm().notAuthorized(request, status);
        return AuthenticationException.authenticationException(exception, challenge, status);
    }
}

