/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.apex;

import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.Authenticator;
import oracle.dbtools.auth.AuthenticatorBase;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;

@Service(provides={Authenticator.class})
public class ApexAuthenticator
extends AuthenticatorBase {
    private static final String _DEFAULT_PREFIX = "apex.security.";
    private static final String APEX_ADMINISTRATOR = "Administrator";
    private static final String APEX_DEVELOPER = "Developer";
    private static final String DEFAULT_ADMIN_ROLES = "apex.security.administrator.roles";
    private static final String DEFAULT_DEV_ROLES = "apex.security.developer.roles";
    private static final String DEFAULT_USER_ROLES = "apex.security.user.roles";
    private static final Log LOG = Log.get(ApexAuthenticator.class);
    private static final Iterable<String> PROHIBITED_ROLES = Iterables.iterable((Object[])new String[]{"Listener Administrator"});
    private static final String VERIFY = "declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles       varchar2(32767) := '';\nuser_type   varchar2(100) := 'User';\nauthenticated varchar2(1) := 'N';\nbegin\n if wwv_flow_listener.authenticate(:tenant_id,:user_id,:password) then \n  authenticated := 'Y';\n  select column_value\n   bulk collect into roles_array\n   from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n  for role in 1 .. roles_array.count loop\n   roles := roles || roles_array(role) || ', ';\n  end loop;\n  user_type := wwv_flow_listener.get_workspace_user_type(:tenant_id,:user_id);\n else\n  authenticated := 'N';\n  roles := null;\n  user_type := null;\n end if;\n :authenticated := authenticated;\n :roles := roles;\n :user_type := user_type;\nend;\n";
    private static final Statement VERIFY_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.call().append((CharSequence)"declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles       varchar2(32767) := '';\nuser_type   varchar2(100) := 'User';\nauthenticated varchar2(1) := 'N';\nbegin\n if wwv_flow_listener.authenticate(:tenant_id,:user_id,:password) then \n  authenticated := 'Y';\n  select column_value\n   bulk collect into roles_array\n   from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n  for role in 1 .. roles_array.count loop\n   roles := roles || roles_array(role) || ', ';\n  end loop;\n  user_type := wwv_flow_listener.get_workspace_user_type(:tenant_id,:user_id);\n else\n  authenticated := 'N';\n  roles := null;\n  user_type := null;\n end if;\n :authenticated := authenticated;\n :roles := roles;\n :user_type := user_type;\nend;\n")).parameter("user_id", String.class, ParameterAccess.IN).parameter("password", String.class, ParameterAccess.IN).parameter("authenticated", String.class, ParameterAccess.OUT).parameter("roles", String.class, ParameterAccess.OUT).parameter("user_type", String.class, ParameterAccess.OUT).build();

    /*
     * Exception decompiling
     */
    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addDefaultRoles(Set<String> allRoles, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.addDefaultRoles(allRoles, propertyName);
        }
    }

    private void addDefaultRoles(Set<String> allRoles, String propertyName) {
        Iterable defaultRoles = Iterables.iterable((Object[])Text.commaDelimited((String)GlobalConfiguration.globalConfiguration().get(propertyName, "")));
        Iterables.add(allRoles, (Iterable)defaultRoles);
    }

    private void addUserTypeRoles(Set<String> allRoles, String userType) {
        if (APEX_DEVELOPER.equals(userType)) {
            this.addDefaultRoles(allRoles, DEFAULT_USER_ROLES, DEFAULT_DEV_ROLES);
        } else if (APEX_ADMINISTRATOR.equals(userType)) {
            this.addDefaultRoles(allRoles, DEFAULT_USER_ROLES, DEFAULT_DEV_ROLES, DEFAULT_ADMIN_ROLES);
        } else {
            this.addDefaultRoles(allRoles, DEFAULT_USER_ROLES);
        }
    }

    private JDBCCallProvider jdbc() {
        return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
    }
}

