/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.csv;

import java.io.IOException;
import java.io.Reader;
import java.sql.Timestamp;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public abstract class CommaSeparatedValues {
    private CommaSeparatedValues() {
    }

    public static String string(String ... values) {
        return CommaSeparatedValues.string((Object[])values);
    }

    public static String string(Object ... values) {
        StringBuilder b = new StringBuilder();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value != null) {
                    if (value instanceof Timestamp) {
                        value = Timestamps.toString((long)((Timestamp)value).getTime());
                    }
                    if (value instanceof Reader) {
                        try {
                            value = StreamCopy.string((Readable)((Reader)value));
                        }
                        catch (IOException e) {
                            throw WebException.internalError(e, new Reason[0]);
                        }
                    }
                    value = CommaSeparatedValues.escape(value);
                    b.append(value);
                }
                if (i >= values.length - 1) continue;
                b.append(',');
            }
        }
        b.append('\n');
        return b.toString();
    }

    private static String escape(Object value) {
        String text = value.toString();
        if (CommaSeparatedValues.needsEscaping(text)) {
            text = text.replace("\"", "\"\"");
            text = "\"" + text + "\"";
        }
        return text;
    }

    private static boolean needsEscaping(String text) {
        return text.matches(".*[,\"].*");
    }
}

