/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class EntityStores {
    public void delete(Transaction txn, CompoundPrincipal principal, Class<?> type, TenantIdentifier entityId) {
        EntityStorage<Object> storage = this.storage(type);
        storage.delete(txn, principal, entityId);
    }

    public Object entity(Transaction txn, CompoundPrincipal principal, Class<?> type, TenantIdentifier entityId) {
        EntityStorage<Object> storage = this.storage(type);
        return storage.entity(txn, principal, entityId);
    }

    public Transaction newTransaction(CompoundPrincipal principal, Object instance) {
        return this.storage(instance).newTransaction(principal);
    }

    public Object insert(Transaction txn, CompoundPrincipal principal, Object instance) {
        return this.storage(instance).insert(txn, principal, instance);
    }

    public Object update(Transaction txn, CompoundPrincipal principal, Object instance) {
        return this.storage(instance).update(txn, principal, instance);
    }

    private EntityStorage<Object> storage(Class<?> type) {
        EntityStorage storage = (EntityStorage)ServiceLocator.acquire(EntityStorage.class, (String[])new String[]{"oracle.dbtools.rt.home.EntityStorage", type.getName()});
        if (storage == null) {
            throw WebException.internalError(new IllegalStateException("No Service found to store instance of: " + type), new Reason[0]);
        }
        return storage;
    }

    private EntityStorage<Object> storage(Object instance) {
        Class<?> type = instance.getClass();
        return this.storage(type);
    }
}

