/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.timing.ExecutionTimer;
import oracle.dbtools.common.timing.ExecutionTimers;
import oracle.dbtools.common.timing.ExecutionTiming;
import oracle.dbtools.common.timing.TimingPoint;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.FilePathSyntax;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.dispatch.DispatchableResourceType;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticationService;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.cors.CrossOriginResourceSharing;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesDispatcher;
import oracle.dbtools.rt.web.ETags;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

@Service(provides={RequestDispatchers.class})
public class RequestDispatchers
implements ResourceDispatcher {
    private ExecutionTimer canDispatchTimer;
    private ExecutionTimer dispatchTimer;
    @Reference
    private AuthenticationService auth;
    @Reference
    private CrossOriginResourceSharing cors;
    @Reference
    private ExecutionTimers timers;
    private final ETags etags = new ETags();
    private static final EntityHeaders GENERATE_ETAG = Entities.headers(HttpHeader.ETAG, "");
    private static final TimingPoint CAN_DISPATCH = new TimingPoint(TimingPoint.FINE_TIMING, "legacy canDispatch");
    private static final TimingPoint DISPATCH = new TimingPoint(TimingPoint.TIMING, "legacy Dispatch");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        ExecutionTiming timer = this.canDispatchTimer.start();
        try {
            ResourceDispatcher.Score score = this.choose(request);
            return score;
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        ExecutionTiming timer = this.dispatchTimer.start();
        try {
            String requestPath;
            block13: {
                if (score == null) {
                    score = this.choose(request);
                }
                if (!ResourceDispatcher.Score.isMatch(score)) {
                    throw WebException.notFound();
                }
                Pair target = (Pair)score.handle();
                score = (ResourceDispatcher.Score)target.first();
                ResourceDispatcher dispatcher = (ResourceDispatcher)target.second();
                if (dispatcher == null) {
                    Requests.log(request, request.base() + request.path() + " not found");
                    throw WebException.notFound();
                }
                try {
                    RequestEntity authenticatedRequest = this.authenticate(score, request);
                    requestPath = URLEncoding.decode((String)QueryString.parse((String)request.path()).path());
                    if (!FilePathSyntax.isValid((CharSequence)requestPath, (boolean)true)) break block13;
                    HttpResource resource = dispatcher.dispatch(score, authenticatedRequest);
                    Entity response = resource.response(authenticatedRequest);
                    HttpResource forwarded = this.forward(dispatcher, authenticatedRequest, response);
                    if (forwarded == null) {
                        Entity corsReponse = this.cors.simpleRequest(authenticatedRequest, response, score);
                        NotForwarded notForwarded = new NotForwarded(resource, corsReponse);
                        return notForwarded;
                    }
                    HttpResource httpResource = forwarded;
                    return httpResource;
                }
                catch (WebException e) {
                    e.publicResource(RequestDispatchers.isPublicResource(score));
                    throw e;
                }
            }
            WebException unboundParameters = ResourceTemplatesDispatcher.checkForUnboundParameters(requestPath);
            if (unboundParameters == null) {
                throw WebException.badRequest(Reason.reason("request_path", (Translatable)new TranslatableMessage(ResourceTemplateMessages.class, "HttpEndpointBase.1", "The request path contains illegal characters", new Object[0])));
            }
            throw unboundParameters;
        }
        finally {
            timer.stop();
        }
    }

    protected void activate(ServiceProperties props) {
        this.canDispatchTimer = this.timers.timer(CAN_DISPATCH);
        this.dispatchTimer = this.timers.timer(DISPATCH);
    }

    private RequestEntity authenticate(ResourceDispatcher.Score score, RequestEntity request) {
        if (RequestDispatchers.isPublicResource(score)) {
            Requests.log(request, request.path() + " is a public resource");
            return request;
        }
        try {
            CompoundPrincipal user = this.auth.verify(score.securityRealm(), request);
            if (user == null) {
                Requests.log(request, "Authenticator asserts " + request.path() + " is a public resource");
                return request;
            }
            Requests.log(request, request.path() + " authorized as: " + user.getName());
            return Requests.principal(request, user);
        }
        catch (WebException e) {
            Requests.log(request, request.path() + " failed authentication");
            throw e;
        }
    }

    private ResourceDispatcher.Score choose(RequestEntity request) {
        Iterable dispatchers = ServiceLocator.acquireAll(ResourceDispatcher.class, (String[])new String[0]);
        Object candidate = null;
        ResourceDispatcher.Score score = ResourceDispatcher.NO_MATCH;
        for (ResourceDispatcher dispatcher : dispatchers) {
            DispatchableResourceType scoreType;
            ResourceDispatcher.Score weighting = dispatcher.canDispatch(request);
            DispatchableResourceType weightingType = weighting.type();
            int diff = DispatchableResourceType.compare((DispatchableResourceType)weightingType, (DispatchableResourceType)(scoreType = score.type()));
            if (diff <= 0 && (diff != 0 || weighting.score() <= score.score())) continue;
            Requests.log(request, "Choosing: " + dispatcher.getClass().getName() + " as current candidate with score: " + weighting);
            candidate = dispatcher;
            score = weighting;
        }
        if (ResourceDispatcher.Score.isMatch(score) && candidate != null) {
            Requests.log(request, "Chose " + candidate.getClass().getName() + " as the final candidate with score: " + score + " for: " + request.method() + " " + request.path());
            return this.score(score, (ResourceDispatcher)candidate);
        }
        Requests.log(request, "No candidate found for: " + request.method() + " " + request.path() + " in context: " + request.base());
        return ResourceDispatcher.NO_MATCH;
    }

    private HttpResource forward(ResourceDispatcher dispatcher, RequestEntity request, Entity response) throws IOException {
        EntityHeader forwardTo = response.headers().header("X-APEX-FORWARD");
        EntityHeadersBuilder additionalHeaders = Entities.headers();
        EntityHeader statusCode = response.headers().header("X-APEX-STATUS-CODE");
        if (statusCode != null) {
            additionalHeaders.header((CharSequence)"X-APEX-STATUS-CODE", statusCode.value());
        }
        if (forwardTo != null) {
            String forwardedLocation = forwardTo.value();
            URI resolved = URIs.resolve((URI)URIs.create((String)Requests.documentBase(request)), (String)forwardedLocation);
            URI baseUri = URIs.create((String)request.base());
            String relativePath = URIs.relativeTo((URI)baseUri, (URI)resolved);
            if (null != relativePath) {
                Closeables.close((Object)response);
                Requests.log(request, dispatcher.getClass().getName() + " forwarded request to: " + relativePath);
                HttpResource forwarded = this.dispatch(null, Requests.forward(request, relativePath, true, null));
                return new Forwarded(relativePath, request, forwarded, additionalHeaders.build());
            }
            Requests.log(request, "Not forwarding to: " + resolved + " which falls outside of this context: " + request.base());
        }
        return null;
    }

    private ResourceDispatcher.Score score(ResourceDispatcher.Score score, ResourceDispatcher candidate) {
        return new ResourceDispatcher.Score(score.type(), score.score(), score.securityRealm(), (Object)Pair.pair((Object)score, (Object)candidate), score.originsAllowed(), score.isCorsEnabled());
    }

    public static boolean isPublicResource(ResourceDispatcher.Score score) {
        SecurityConfig securityRealm = score.securityRealm();
        if (securityRealm == null) {
            return true;
        }
        AuthenticationRealm authRealm = securityRealm.realm();
        boolean isPublic = AuthenticationRealm.NONE.equals((Object)authRealm);
        return isPublic;
    }

    private final class NotForwarded
    implements HttpResource,
    Closeable {
        private final HttpResource resource;
        private final Entity response;

        private NotForwarded(HttpResource resource, Entity response) {
            this.resource = resource;
            this.response = response;
        }

        @Override
        public void close() throws IOException {
            Closeables.close((Object)this.response);
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return this.response;
        }

        @Override
        public String version() {
            return this.resource.version();
        }
    }

    private final class Forwarded
    implements HttpResource {
        private final EntityHeaders addtionalHeaders;
        private final HttpResource forwarded;
        private final String forwardTo;
        private final RequestEntity request;

        private Forwarded(String forwardTo, RequestEntity request, HttpResource forwarded, EntityHeaders additionalHeaders) {
            this.forwardTo = forwardTo;
            this.request = request;
            this.forwarded = forwarded;
            this.addtionalHeaders = additionalHeaders;
        }

        @Override
        public Entity response(RequestEntity notUsed) throws IOException {
            String version = this.forwarded.version();
            Entity entity = this.forwarded.response(this.request);
            if (version != null && version.isEmpty()) {
                entity = this.etag(entity);
            }
            URI baseURI = URIs.create((String)this.request.base());
            URI absoluteLocation = URIs.resolve((URI)baseURI, (String)this.forwardTo);
            return Entities.entity(entity.body(), Entities.merge(Entities.merge(entity.headers(), this.addtionalHeaders), Entities.headers(HttpHeader.LOCATION, absoluteLocation.toASCIIString())));
        }

        @Override
        public String version() {
            return this.forwarded.version();
        }

        private Entity etag(Entity response) throws IOException {
            return RequestDispatchers.this.etags.etag(Entities.merge(response, GENERATE_ETAG));
        }
    }
}

