/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MissingIconException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.controller.DialogFactoryArb;

class DialogFactory
implements ComponentListener,
WindowListener {
    private boolean modal = true;
    private String title;
    private boolean defaultCloseButtonIgnored;
    private String description;
    private boolean resizable = true;
    private float expansionFactor = 1.0f;
    private Component content;
    private JButton applyButton;
    private ActionListener applyAction;
    private JButton cancelButton;
    private ActionListener cancelAction;
    private JButton closeButton;
    private ActionListener closeAction;
    private JButton helpButton;
    private String helpTopic;
    private JButton okButton;
    private ActionListener okAction;
    private List<JButton> customButtons = new ArrayList<JButton>();
    private JButton defaultButton;
    private Component initialComponent;
    private JDialog dialog;
    private volatile JButton terminatingButton = null;

    DialogFactory() {
    }

    JButton addCancelButton(JButton button) {
        if (this.closeButton != null) {
            throw new IllegalStateException("close button added");
        }
        if (button == null) {
            button = this.createDefaultButton(1);
        }
        this.cancelButton = button;
        return button;
    }

    JButton addCancelAction(ActionListener action) {
        if (this.closeButton != null) {
            throw new IllegalStateException("close button added");
        }
        if (this.cancelButton == null) {
            this.cancelButton = this.createDefaultButton(1);
        }
        this.cancelAction = action;
        return this.cancelButton;
    }

    JButton addOkButton(JButton button) {
        if (button == null) {
            button = this.createDefaultButton(4);
        }
        this.okButton = button;
        return button;
    }

    void hide() {
        if (this.dialog != null) {
            this.dialog.removeWindowListener(this);
            this.dialog.removeComponentListener(this);
            WindowUtils.unregisterWindow((Window)this.dialog);
            this.dialog.dispose();
        }
        this.dialog = null;
    }

    void setContent(Component content) {
        this.content = content;
    }

    void setDefaultCloseButtonIgnored(boolean ignored) {
        this.defaultCloseButtonIgnored = ignored;
    }

    void setInitialFocus(Component component) {
        this.initialComponent = component;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    JButton show() {
        return this.show(null);
    }

    private JButton show(Component parent) {
        AbstractAction action;
        Window window;
        this.dialog = parent != null ? ((window = SwingUtilities.getWindowAncestor(parent)) instanceof Frame ? new JDialog((Frame)window, this.title, this.modal) : new JDialog((Dialog)window, this.title, this.modal)) : new JDialog((Frame)Ide.getMainWindow(), this.title, this.modal);
        WindowUtils.registerWindow((Window)this.dialog);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setResizable(this.resizable);
        DialogButtonBar buttons = new DialogButtonBar();
        ComponentInputMap inputMap = new ComponentInputMap((JComponent)buttons);
        ActionMap actionMap = new ActionMap();
        if (this.applyButton != null) {
            buttons.add((Component)this.applyButton, DialogButtonBar.CONSTRAINT_APPLY);
            if (this.applyAction != null) {
                this.applyButton.addActionListener(this.applyAction);
            }
            this.applyButton.setDefaultCapable(this.defaultButton == this.applyButton);
        }
        if (this.cancelButton != null) {
            buttons.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            action = new TerminatingAction(this.cancelButton, this.cancelAction);
            this.cancelButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", action);
            this.cancelButton.setDefaultCapable(this.defaultButton == this.cancelButton);
        }
        if (this.helpButton != null) {
            buttons.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
            action = new HelpAction();
            this.helpButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(112, 0), "help");
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(156, 0), "help");
            actionMap.put("help", action);
            this.helpButton.setDefaultCapable(false);
        }
        if (this.okButton != null) {
            buttons.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            action = new TerminatingAction(this.okButton, this.okAction);
            this.okButton.addActionListener(action);
            if (this.cancelButton == null) {
                ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "ok");
                actionMap.put("ok", action);
            }
            this.okButton.setDefaultCapable(this.defaultButton == this.okButton);
        }
        for (JButton button : this.customButtons) {
            buttons.add((Component)button);
            button.setDefaultCapable(this.defaultButton == button);
        }
        if (buttons.getComponentCount() <= (this.helpTopic == null ? 0 : 1)) {
            this.closeButton = this.createDefaultButton(3);
        }
        if (this.closeButton != null) {
            buttons.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_CANCEL);
            action = new TerminatingAction(this.closeButton, this.closeAction);
            this.closeButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "close");
            actionMap.put("close", action);
            this.closeButton.setDefaultCapable(this.defaultButton == this.closeButton);
        }
        if (this.defaultButton != null) {
            this.dialog.getRootPane().setDefaultButton(this.defaultButton);
        }
        SwingUtilities.replaceUIInputMap((JComponent)buttons, 2, inputMap);
        SwingUtilities.replaceUIActionMap((JComponent)buttons, actionMap);
        DialogHeader descriptionPanel = null;
        if (this.description != null) {
            Image image;
            try {
                URL url = ProductInformation.getProductInformation().getIcon().getURL();
                image = new ImageIcon(url).getImage();
            }
            catch (MissingIconException e) {
                image = null;
            }
            descriptionPanel = new DialogHeader(this.description, image);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.insets.bottom = 16;
        if (descriptionPanel != null) {
            panel.add((Component)descriptionPanel, constraints);
        }
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets.top = 16;
        constraints.insets.right = 16;
        constraints.insets.left = 16;
        panel.add(this.content, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.anchor = 13;
        panel.add((Component)buttons, constraints);
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Insets screenInsets = toolkit.getScreenInsets(this.dialog.getGraphicsConfiguration());
        screenSize.width = Math.min(screenSize.width - screenInsets.left - screenInsets.right, 800);
        screenSize.height = Math.min(screenSize.height - screenInsets.top - screenInsets.bottom, 600);
        Dimension size = new Dimension(Math.min(this.dialog.getWidth(), screenSize.width), Math.min(this.dialog.getHeight(), screenSize.height));
        Dimension expandedSize = new Dimension(size.width, Math.min((int)((float)size.height * this.expansionFactor), screenSize.height));
        this.dialog.setSize(expandedSize);
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setSize(size);
        this.dialog.addWindowListener(this);
        this.dialog.addComponentListener(this);
        this.dialog.setVisible(true);
        return this.terminatingButton;
    }

    private JButton createDefaultButton(int index) {
        JButton button = new JButton();
        ResourceUtils.resButton((AbstractButton)button, (String)DialogFactoryArb.getString(index));
        return button;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension min = this.dialog.getMinimumSize();
        if (this.dialog.getWidth() < min.width || this.dialog.getHeight() < min.height) {
            this.dialog.setSize(Math.max(min.width, this.dialog.getWidth()), Math.max(min.height, this.dialog.getHeight()));
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!this.defaultCloseButtonIgnored) {
            this.terminatingButton = null;
            this.hide();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.initialComponent != null) {
            this.initialComponent.requestFocus();
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpSystem.getHelpSystem().showHelp(new HelpInfo(DialogFactory.this.helpTopic));
        }
    }

    private class TerminatingAction
    extends AbstractAction {
        private JButton button;
        private ActionListener action;

        private TerminatingAction(JButton button, ActionListener action) {
            this.button = button;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogFactory.this.terminatingButton = this.button;
            if (this.action != null) {
                this.action.actionPerformed(e);
            } else {
                DialogFactory.this.hide();
            }
        }
    }
}

