/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ModelViewerPreferenceSettings
extends DataMinerPreferenceSettings {
    protected static final String DATA_KEY = "oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings";
    public static final String NUMERIC_PRECISION_LEVEL = "numerical_precision_level";
    public static final String PERCENTAGE_PRECISION_LEVEL = "percentage_precision_level";
    public static final String FETCH_SIZE_AR_MODEL = "fetch_size_ar_model";
    public static final String FETCH_SIZE_CLUSTERING_MODEL = "fetch_size_clustering_model";
    public static final String FETCH_SIZE_OTHER_MODELS = "fetch_size_other_models";

    public static ModelViewerPreferenceSettings getInstance() {
        return ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private ModelViewerPreferenceSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ModelViewerPreferenceSettings getInstance(PropertyStorage propertyStorage) {
        return new ModelViewerPreferenceSettings(ModelViewerPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setPercentagePrecisionLevel(int n) {
        this._hash.putInt(PERCENTAGE_PRECISION_LEVEL, n);
    }

    public int getPercentagePrecisionLevel() {
        return this._hash.getInt(PERCENTAGE_PRECISION_LEVEL, 4);
    }

    public void setNumericalPrecisionLevel(int n) {
        this._hash.putInt(NUMERIC_PRECISION_LEVEL, n);
    }

    public int getNumericalPrecisionLevel() {
        return this._hash.getInt(NUMERIC_PRECISION_LEVEL, 8);
    }

    public void setFetchSizeARModel(int n) {
        this._hash.putInt(FETCH_SIZE_AR_MODEL, n);
    }

    public int getFetchSizeARModel() {
        return this._hash.getInt(FETCH_SIZE_AR_MODEL, 1000);
    }

    public void setFetchSizeClusteringModel(int n) {
        this._hash.putInt(FETCH_SIZE_CLUSTERING_MODEL, n);
    }

    public int getFetchSizeClusteringModel() {
        return this._hash.getInt(FETCH_SIZE_CLUSTERING_MODEL, 20);
    }

    public void setFetchSizeOtherModels(int n) {
        this._hash.putInt(FETCH_SIZE_OTHER_MODELS, n);
    }

    public int getFetchSizeOtherModels() {
        return this._hash.getInt(FETCH_SIZE_OTHER_MODELS, 1000);
    }
}

