/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.details;

import java.text.NumberFormat;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.mviewer.clustering.details.DetailsLrb;
import oracle.dmt.dataminer.utils.Formats;

public class DetailsTableModel
extends ODMrTableModel<NameValuePair> {
    public static final int SETTING_NAME = 0;
    public static final int SETTING_VALUE = 1;
    private NumberFormat numericFormat;
    private NumberFormat percentageFormat = Formats.ModelViewer.getPercentage();
    private static String[] _columnNames = new String[]{DetailsLrb.get("DETAILS_NAME"), DetailsLrb.get("DETAILS_VALUE")};

    public DetailsTableModel(List<NameValuePair> list) {
        super(_columnNames, list);
        this.numericFormat = Formats.ModelViewer.getNumeric();
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        NameValuePair nameValuePair = (NameValuePair)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = nameValuePair.getName();
                String string = MiningModelSettings.translateModelSettingsName((String)object.toString());
                if (string == null) break;
                object = string;
                break;
            }
            case 1: {
                object = nameValuePair.getValue();
                if (object instanceof Double) {
                    if (nameValuePair.getName().equals("EMCS_LOGLIKE_IMPROVEMENT")) {
                        object = this.percentageFormat.format(100.0 * (Double)object) + "%";
                        break;
                    }
                    if (nameValuePair.getName().equals("LOGLIKELIHOOD")) {
                        object = this.numericFormat.format((Double)object) + "%";
                        break;
                    }
                    object = this.numericFormat.format((Double)object);
                    break;
                }
                String string = MiningModelSettings.translateModelSettingsValue((String)object.toString());
                if (string == null) break;
                object = string;
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }
}

