/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.DataProfilePhysicalNode;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.DataViewerPanel;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModelBase;
import oracle.dmt.dataminer.teditor.data.SortDialog;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class DataEditor
extends AbstractDataEditor {
    private static final String DEFAULT_FILTER_TEXT = DataLrb.get("DATA_VIEWER_FILTER_WHERE_CLAUSE");
    private Toolbar toolBar;
    private JComboBox<DataSourceViewOption> dataSourceComboBox;
    private ModelViewerPartitionToolbar partitionToolbar;
    private JButton parallelViewDialog = new JButton();
    private JButton refreshButton = new JButton();
    private JButton sortButton = new JButton();
    private JLabel dataSourceLabel;
    private JLabel filterLabel = new JLabel();
    private JTextField filter = new JTextField(DEFAULT_FILTER_TEXT);
    private SortDialog sortDlg;

    public DataEditor() {
        this.filter.setForeground(this.filter.getDisabledTextColor());
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filter, (String)DataLrb.get("DATA_VIEWER_FILTER_LABEL"));
        this.filterLabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filterLabel.setToolTipText(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' && DataEditor.this._gui != null) {
                    ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere(DataEditor.this.filter.getText());
                    ((DataViewerPanel)DataEditor.this._gui).sort2();
                }
            }
        });
        this.filter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DataEditor.this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase())) {
                    DataEditor.this.filter.setText("");
                    DataEditor.this.filter.setForeground(DataEditor.this.filter.getCaretColor());
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ODMrResultSetTableModelBase oDMrResultSetTableModelBase;
                if (StringUtils.isEmpty((String)DataEditor.this.filter.getText())) {
                    DataEditor.this.filter.setText(DEFAULT_FILTER_TEXT);
                    DataEditor.this.filter.setForeground(DataEditor.this.filter.getDisabledTextColor());
                    if (DataEditor.this._gui != null) {
                        ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere("");
                        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                        if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                            ((DataViewerPanel)DataEditor.this._gui).sort2();
                        }
                    }
                } else if (!DEFAULT_FILTER_TEXT.toUpperCase().equals(DataEditor.this.filter.getText().trim().toUpperCase()) && DataEditor.this._gui != null && (oDMrResultSetTableModelBase = ((DataViewerPanel)DataEditor.this._gui).getTableData().getTableModel()) != null && !oDMrResultSetTableModelBase.isErrorCondition()) {
                    ((DataViewerPanel)DataEditor.this._gui).getTableData().setWhere(DataEditor.this.filter.getText());
                    Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                    if (editor != null && editor.getContext() != null && editor instanceof DataEditor) {
                        ((DataViewerPanel)DataEditor.this._gui).sort2();
                    }
                }
            }
        });
    }

    public void initialize() {
        this._context = this.getContext();
    }

    @Override
    public void open() {
        super.open();
        this.updateParallelViewBtnTitle();
    }

    @Override
    public void editorShown() {
        super.editorShown();
        this.updateParallelViewBtnTitle();
    }

    @Override
    public void close() {
        super.close();
        ((DataViewerPanel)this._gui).close();
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
        if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.refreshEditor(object);
        }
    }

    private void refreshEditor(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this.getContext().getNode();
        if (bl) {
            if (this.getGUI().isShowing()) {
                this.refresh();
            } else {
                this.setNeedsRefresh(true);
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (DataViewerState.contextHasValidModelNodeForDataViewing(this.getContext())) {
            this.partitionToolbar.load(this);
        }
        if (this._gui != null) {
            if (this.isCacheTableAvailable()) {
                String string = GraphUtils.getSampleTableName(this.getContext());
                if (StringUtils.isNotEmpty((String)string)) {
                    ((DataViewerPanel)this._gui).getState().setCacheTableName(string);
                    this.dataSourceComboBox.setSelectedItem((Object)DataSourceViewOption.CACHE);
                    this.dataSourceComboBox.setEnabled(true);
                }
            } else if (this.showCombo()) {
                this.dataSourceComboBox.setSelectedItem((Object)DataSourceViewOption.ACTUAL);
                this.dataSourceComboBox.setEnabled(false);
            }
        }
    }

    @Override
    public Component getGUI() {
        if (this._gui == null) {
            this._gui = this.getViewer();
            this._overLayPanel = new BlockingComponent((JComponent)this._gui);
            this._gui.setBlockingComponent(this._overLayPanel);
            this._gui.load();
        }
        return this._overLayPanel.getBlockingComponent();
    }

    @Override
    public DataMinerViewGUI getViewer() {
        return new DataViewerPanel(this, this.getContext());
    }

    public Toolbar getToolbar() {
        return this.toolBar;
    }

    private boolean showCombo() {
        Node node = this._context.getNode();
        return !(node instanceof DataProfilePhysicalNode);
    }

    private boolean isCacheTableAvailable() {
        DataNode dataNode;
        boolean bl = false;
        Node node = this._context.getNode();
        if (node instanceof DataNode && (dataNode = (DataNode)node).getCacheTableName().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public Component getFixedTopMargin() {
        if (this.toolBar == null) {
            this.toolBar = new Toolbar();
            if (DataViewerState.contextHasValidModelNodeForDataViewing(this.getContext())) {
                this.addPartitionToolbar();
            }
            this.refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            this.refreshButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this.refreshButton.setToolTipText(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((DataViewerPanel)DataEditor.this._gui).getTableData().isOperationInprogress();
                    if (!bl) {
                        ((DataViewerPanel)DataEditor.this._gui).reloadUI();
                        DataEditor.this.filter.setText("");
                    }
                }
            });
            this.toolBar.add((Component)this.refreshButton);
            this.toolBar.addSeparator();
            if (this.showCombo()) {
                this.dataSourceLabel = new JLabel();
                this.dataSourceComboBox = new JComboBox();
                ResourceUtils.resLabel((JLabel)this.dataSourceLabel, this.dataSourceComboBox, (String)DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL"));
                this.dataSourceLabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL_ADA"));
                this.dataSourceComboBox.setToolTipText(DataLrb.get("DATA_VIEWER_DATASOURCE_SELECTION_LABEL_ADA"));
                this.toolBar.add((Component)this.dataSourceLabel);
                this.dataSourceComboBox.setModel(new DefaultComboBoxModel<DataSourceViewOption>(DataSourceViewOption.values()));
                if (this.isCacheTableAvailable()) {
                    this.dataSourceComboBox.setSelectedItem((Object)DataSourceViewOption.CACHE);
                    this.dataSourceComboBox.setEnabled(true);
                } else {
                    this.dataSourceComboBox.setSelectedItem((Object)DataSourceViewOption.ACTUAL);
                    this.dataSourceComboBox.setEnabled(false);
                }
                this.toolBar.add(this.dataSourceComboBox);
                this.toolBar.addSeparator();
                this.dataSourceComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataEditor.this.updateViewOption();
                    }
                });
            }
            ResourceUtils.resButton((AbstractButton)this.sortButton, (String)DataLrb.get("DATA_VIEWER_SORT_BUTTON"));
            this.sortButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_SORT_BUTTON_ADA"));
            this.sortButton.setToolTipText(DataLrb.get("DATA_VIEWER_SORT_BUTTON_ADA"));
            this.sortButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((DataViewerPanel)DataEditor.this._gui).getTableData().isOperationInprogress();
                    if (!bl) {
                        DataEditor.this.sortData2();
                    }
                }
            });
            this.updateParallelViewBtnTitle();
            this.parallelViewDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final ViewDataParallelPanel viewDataParallelPanel = new ViewDataParallelPanel(DataLrb.get("DATA_VIEWER_PARALLEL_DIALOG_TITLE"));
                    DialogHelper dialogHelper = new DialogHelper(viewDataParallelPanel);
                    dialogHelper.setDialogOkExecutor(new DialogOkExecutor(){

                        @Override
                        public void onOK() throws DialogExecutionException {
                            viewDataParallelPanel.updatePreferences();
                            DataEditor.this.updateParallelViewBtnTitle();
                        }
                    });
                    dialogHelper.showAsDialog();
                }
            });
            this.toolBar.add((Component)this.sortButton);
            this.toolBar.addSeparator();
            this.toolBar.add((Component)this.parallelViewDialog);
            this.toolBar.addSeparator();
            this.toolBar.add((Component)this.filterLabel);
            this.toolBar.add((Component)this.filter);
            this.filter.setSize(200, 0);
        }
        return this.toolBar;
    }

    private void addPartitionToolbar() {
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this.partitionToolbar.load(this);
        this.toolBar.add((Component)this.partitionToolbar);
        this.toolBar.addSeparator();
    }

    @Override
    public void updateParallelViewBtnTitle() {
        String string = parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        if (string == null || !Boolean.parseBoolean(string)) {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_OFF"));
        } else {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_ON"));
        }
        if (this._gui != null && ((DataViewerPanel)this._gui).getState() != null) {
            Object object = ((DataViewerPanel)this._gui).getState().getQuery();
            if (object == null) {
                object = "SELECT '" + DataLrb.get("DATA_VIEWER_ACTUAL_NO_QUERY_AVAILABLE") + "' as MESSAGE FROM DUAL";
            }
            if (((DataViewerPanel)this._gui).getState().getResultSetModel() != null) {
                ((DataViewerPanel)this._gui).getState().getResultSetModel().setSql((String)object);
            }
        }
    }

    private void updateViewOption() {
        if (this._overLayPanel != null) {
            this._overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        DataSourceViewOption dataSourceViewOption = (DataSourceViewOption)((Object)this.dataSourceComboBox.getSelectedItem());
        try {
            ((DataViewerPanel)this._gui).setDataSourceViewOption(dataSourceViewOption);
        }
        catch (Exception exception) {
            if (this._overLayPanel != null) {
                this._overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }
        boolean bl = ((DataViewerPanel)this._gui).getTableData().isOperationInprogress();
        if (!bl) {
            ((DataViewerPanel)this._gui).reloadUI();
        }
    }

    public void updateToolbar() {
        View.updateToolbarActions((Toolbar)this.toolBar);
    }

    private void sortData2() {
        ArrayList arrayList = this.sortDlg != null ? this.sortDlg.getFromList() : null;
        ArrayList arrayList2 = this.sortDlg != null ? this.sortDlg.getToList() : null;
        this.sortDlg = arrayList == null || arrayList2 == null ? new SortDialog(((DataViewerPanel)this._gui).getTableData()) : new SortDialog(((DataViewerPanel)this._gui).getTableData(), arrayList, arrayList2);
        if (this.sortDlg.showAsDialog()) {
            this.applySort(this.sortDlg);
        }
    }

    private void applySort(SortDialog sortDialog) {
        if (sortDialog != null) {
            ((DataViewerPanel)this._gui).getTableData().setOrderBy(sortDialog.getOrderBy());
        }
        ((DataViewerPanel)this._gui).getTableData().setWhere(this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase()) ? "" : this.filter.getText());
        ((DataViewerPanel)this._gui).sort2();
    }

    public String getPartitionId() {
        String string = null;
        if (DataViewerState.contextHasValidModelNodeForDataViewing(this.getContext())) {
            string = this.partitionToolbar.getSelectedPartitionID();
        }
        return string;
    }
}

