/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.TransferableRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.EditChangeListener;
import oracle.dmt.dataminer.workflow.dialog.build.HeuristicsResultDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.MainAlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelGLMBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningData;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformsNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.TriStateCellEditor;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.TriStateTableRenderer;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.RolloverTableRenderer;
import oracle.javatools.util.Version;

public class DataUsagePanel
extends AbstractSettingsPanel
implements EditChangeListener {
    private static final String MULTI_SELECT_RES = BuildEditorLrb.get("BUILD_DATA_USAGE_MULTI_SELECT");
    private static final String CATEGORICAL = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_CAT");
    private static final String NUMERICAL = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_NUM");
    private static final String TEXT = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_TXT");
    private static final String TEXT_CUSTOM = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_TXTCUST");
    private static final String TEXT_CUSTOM_EDIT = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_TXTEDIT");
    public static final String INPUT = "Yes";
    public static final String IGNORE = "No";
    public static final String FORCE = "Force";
    private static final String ADP_ON = "Yes";
    private static final String ADP_OFF = "No";
    public static final int OPTIONAL_FEATURES_NONE = 0;
    public static final int OPTIONAL_FEATURES_ADP = 2;
    public static final int OPTIONAL_FEATURES_TEXT = 4;
    private RowFilter<UsageTableModel, Integer> rowFilter;
    private DataMinerTablePanel dataMinerTablePanel = new DataMinerTablePanel();
    private DataUsageTable jDataUsageTable = new DataUsageTable();
    private UsageTableModel usagesTblModel;
    private JCheckBox autoBtn;
    private JButton inputBtn;
    private JButton ignoreBtn;
    private JButton importBtn;
    private DropDownMenuButton autoPrepBtn;
    private DropDownMenuButton miningTypeBtn;
    private JPanel infoPanel;
    private JLabel infoMsg;
    private JLabel showLink;
    private Map<String, String> nodeRules;
    private Map<String, ModelHeuristicRules> modelRules;
    private Boolean allModelsAutomatic = null;
    private Boolean multipleModelsSelected = false;
    private Boolean oneModelSelected = false;
    private boolean isDirty = false;
    private Version dbVersion;
    private boolean isAdpVisible = true;
    private boolean isTextVisible = true;
    private boolean isStandalone = false;
    private MiningAttributes miningAttributes = null;
    private Map<String, AttributeType> targetAttributes;
    private Map<String, AttributeType> caseAttributes;
    private Map<String, AttributeType> partitionAttributes;
    private int parentWidthSize = 0;
    private boolean originalAutoValue = true;
    private AttributeType oldCaseId;
    int colCount = 0;
    int USAGE_ATTRIBUTE_NAME = 0;
    int USAGE_DATA_TYPE = 1;
    int USAGE_INPUT = 2;
    int USAGE_MINING_TYPE = 3;
    int USAGE_ADP = 4;
    int RULES_COLUMN = 5;

    public DataUsageTable getJDataUsageTable() {
        return this.jDataUsageTable;
    }

    public DataUsagePanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, Map<String, ModelEditRecord> map) {
        super(advancedSettingsPanel, context, abstractBuildNode, (NodeType)buildNodeType);
        AttributeType attributeType;
        PartitionExpressionType partitionExpressionType;
        Object object;
        this.targetAttributes = new HashMap<String, AttributeType>();
        this.caseAttributes = new HashMap<String, AttributeType>();
        this.partitionAttributes = new HashMap<String, AttributeType>();
        if (buildNodeType.getCaseAttributes().getAttribute().size() > 0) {
            object = buildNodeType.getCaseAttributes().getAttribute();
            partitionExpressionType = object.iterator();
            while (partitionExpressionType.hasNext()) {
                attributeType = (AttributeType)partitionExpressionType.next();
                this.caseAttributes.put(attributeType.getName(), attributeType);
            }
        }
        if (buildNodeType.getPartitionExpressions() != null && buildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
            object = buildNodeType.getPartitionExpressions().getPartitionExpression().iterator();
            while (object.hasNext()) {
                partitionExpressionType = (PartitionExpressionType)object.next();
                if (partitionExpressionType.getSQLExpression() != null) continue;
                attributeType = partitionExpressionType.getPartitionAttribute();
                this.partitionAttributes.put(attributeType.getName(), attributeType);
            }
        }
        if (buildNodeType instanceof SuperviseBuildNodeType && (object = ((SuperviseBuildNodeType)buildNodeType).getTargetAttribute()) != null) {
            this.targetAttributes.put(object.getName(), (AttributeType)object);
        }
        this.modelRules = advancedSettingsPanel.getCopyOfModelRules();
        this.initRes();
        this.initUI();
    }

    public DataUsagePanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, MiningAttributes miningAttributes, Map<String, AttributeType> map, Map<String, AttributeType> map2, Map<String, AttributeType> map3, int n) {
        super(null, context, abstractBuildNode, (NodeType)buildNodeType);
        this.miningAttributes = miningAttributes;
        this.isStandalone = true;
        this.isAdpVisible = (n & 2) > 0;
        this.isTextVisible = (n & 4) > 0;
        this.originalAutoValue = this.miningAttributes.getAutoSpec() == null || this.miningAttributes.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.targetAttributes = map;
        this.caseAttributes = map2;
        this.partitionAttributes = map3;
        this.nodeRules = MetaDataHelper.getHeuristicsRules(buildNodeType);
        this.initRes();
        this.initUI();
    }

    public DataUsagePanel(Context context, DynamicNode dynamicNode, TransformsNodeType transformsNodeType, MiningAttributes miningAttributes, Map<String, AttributeType> map, Map<String, AttributeType> map2, Map<String, AttributeType> map3, int n, Map<String, ModelHeuristicRules> map4) {
        super(null, context, dynamicNode, transformsNodeType);
        this.modelRules = map4;
        this.miningAttributes = miningAttributes;
        this.isStandalone = true;
        this.isAdpVisible = (n & 2) > 0;
        this.isTextVisible = (n & 4) > 0;
        this.originalAutoValue = this.miningAttributes.getAutoSpec() == null || this.miningAttributes.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.targetAttributes = map;
        this.caseAttributes = map2;
        this.partitionAttributes = map3;
        this.getModelRules();
        if (map4.size() == 0) {
            this.nodeRules = new HashMap<String, String>();
        } else {
            for (Map.Entry<String, ModelHeuristicRules> entry : this.modelRules.entrySet()) {
                this.nodeRules = entry.getValue().modelRules;
            }
        }
        this.initRes();
        this.initUI();
    }

    public void resizeTable(Dimension dimension) {
        if (this.jDataUsageTable.getColumnCount() >= this.RULES_COLUMN) {
            if (this.parentWidthSize == 0) {
                this.parentWidthSize = (int)dimension.getWidth();
            }
            int n = (int)dimension.getWidth();
            if (!this.multipleModelsSelected.booleanValue()) {
                this.jDataUsageTable.getFullColumnModel().getColumn(this.RULES_COLUMN).setPreferredWidth(315 + (n - this.parentWidthSize));
            }
        }
    }

    public void setOldCaseId(AttributeType attributeType) {
        this.oldCaseId = attributeType;
    }

    private boolean isStandalone() {
        return this.isStandalone;
    }

    public JCheckBox getAutoBtn() {
        return this.autoBtn;
    }

    public boolean isValidRowWeightColumn(ModelType modelType, String string) {
        boolean bl = false;
        if (modelType instanceof CGeneralizedLinearModelType) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType = (CGeneralizedLinearModelType)modelType;
            String string2 = string != null && !string.equals("") ? string : cGeneralizedLinearModelType.getCGeneralizedLinearAlgo().getODMSROWWEIGHTCOLUMNNAME();
            if (string2 == null || string2.equals("")) {
                return true;
            }
            for (Object object : cGeneralizedLinearModelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
                if (!object.getName().equals(string2)) continue;
                bl = true;
                if (object.getInput().equals("No")) {
                    bl = false;
                    break;
                }
                if (object.getMiningType().equals(NUMERICAL)) break;
                String string3 = AlgSettingsLrb.get("GLMS_ROW_WEIGHT_COLUMN_INVALID_MINING_TYPE");
                String string4 = MessageFormat.format(string3, string2, cGeneralizedLinearModelType.getName());
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string4, (String)string4, null)) {
                    object.setMiningType(NUMERICAL);
                    UsageTableModel usageTableModel = (UsageTableModel)((Object)this.jDataUsageTable.getModel());
                    for (MiningAttributeType miningAttributeType : usageTableModel.getMiningAttributes()) {
                        if (!miningAttributeType.getName().equals(object.getName())) continue;
                        MetaDataHelper.copyMiningAttributeType(object, miningAttributeType, true);
                        break;
                    }
                    this.usagesTblModel.updateModelAttributes((MiningAttributeType)object, (ModelType)cGeneralizedLinearModelType);
                    return true;
                }
                return false;
            }
            if (!bl) {
                Object object;
                String string5 = AlgSettingsLrb.get("GLMS_ROW_WEIGHT_COLUMN_INVALID_INPUT");
                object = MessageFormat.format(string5, string2, cGeneralizedLinearModelType.getName());
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)object, null);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canProceed(ListSelectionModel listSelectionModel) {
        if (!this.autoBtn.isSelected()) {
            HashMap hashMap = (HashMap)this.getEnclosingPanel().getModelEdits();
            for (Map.Entry entry : hashMap.entrySet()) {
                MainAlgorithmSettingsPanel mainAlgorithmSettingsPanel;
                String string = "";
                AlgorithmSettingsPanel algorithmSettingsPanel = this.getEnclosingPanel().getAlgoSettingsDialog();
                if (algorithmSettingsPanel != null && (mainAlgorithmSettingsPanel = algorithmSettingsPanel.getHost()).getContentPanel() instanceof ModelGLMBuildSettingsPanel) {
                    ModelGLMBuildSettingsPanel modelGLMBuildSettingsPanel = (ModelGLMBuildSettingsPanel)mainAlgorithmSettingsPanel.getContentPanel();
                    if (!modelGLMBuildSettingsPanel.isRowWeightsSelected()) continue;
                    string = modelGLMBuildSettingsPanel.getRowWeightsCol();
                }
                if (this.isValidRowWeightColumn(((ModelEditRecord)entry.getValue()).getModel(), string)) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, ModelHeuristicRules> getModelRules() {
        if (this.modelRules == null) {
            this.modelRules = this.isStandalone() ? (this.isPredictiveQuery() ? MetaDataHelper.getHeuristicsRulesModels(this.getContext(), this.getDynamicWorkflowNode()) : MetaDataHelper.getHeuristicsRulesModels(this.getContext(), this.getMetadataCopy())) : this.getEnclosingPanel().getCopyOfModelRules();
        }
        return this.modelRules;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    protected void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
    }

    protected void initIconResources() {
    }

    public void parseInput(JTable jTable) {
        List<ModelType> list;
        if (this.isStandalone && (list = MetaDataHelper.getModelsCollection(this.getMetadataCopy())) != null && list.size() > 0) {
            for (int i = 0; i < jTable.getModel().getRowCount(); ++i) {
                MiningAttributeType miningAttributeType = (MiningAttributeType)jTable.getModel().getValueAt(i, 0);
                if (DataUsagePanel.attributesHaveInputValue(list, "No", miningAttributeType.getName(), false)) {
                    this.nodeRules.put(miningAttributeType.getName(), BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_ALL_EXCLUDED"));
                    continue;
                }
                if (DataUsagePanel.attributesHaveInputValue(list, "Yes", miningAttributeType.getName(), false)) {
                    this.nodeRules.put(miningAttributeType.getName(), BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_ALL_INCLUDED"));
                    continue;
                }
                this.nodeRules.put(miningAttributeType.getName(), BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_SOME_INCLUDED"));
            }
        }
    }

    protected void initUI() {
        if (this.isStandalone()) {
            this.jDataUsageTable.setNoEntryInstructionText("No data available");
        } else {
            this.jDataUsageTable.setNoEntryInstructionText(BuildEditorLrb.get("BUILD_USAGE_DEF_TABLE_TXT"));
        }
        this.initIconResources();
        this.jDataUsageTable.setFixedColumns(1, 130);
        this.dataMinerTablePanel.setTable(this.jDataUsageTable);
        Dimension dimension = new Dimension(850, 450);
        this.dataMinerTablePanel.setPreferredSize(dimension);
        this.installDataUsageActions();
        this.jDataUsageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                DataUsagePanel.this.handleUsageSelectionChanged(listSelectionModel);
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.dataMinerTablePanel);
        this.autoBtn = new JCheckBox();
        this.autoBtn.setBorder(BorderFactory.createEmptyBorder(3, 0, 1, 1));
        this.autoBtn.setSelected(true);
        if (this.importBtn != null) {
            this.importBtn.setEnabled(false);
        }
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                DataUsagePanel.this.setAutoUsage(jCheckBox.isSelected());
                if (DataUsagePanel.this.importBtn != null) {
                    DataUsagePanel.this.importBtn.setEnabled(!jCheckBox.isSelected());
                }
            }
        });
        JPanel jPanel = new JPanel();
        this.showLink = new JLabel(BuildEditorLrb.get("BUILD_DATA_USAGE_SHOW_LABEL"));
        this.showLink.setForeground(Color.blue);
        this.showLink.setMaximumSize(new Dimension(50, 50));
        this.showLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                String string = null;
                if (!DataUsagePanel.this.isStandalone() && (object = DataUsagePanel.this.getSelectedModels()).size() == 1) {
                    string = object.get(0).getName();
                }
                object = new DialogHelper(new HeuristicsResultDetailsPanel(DataUsagePanel.this.getModelRules(), string));
                ((DialogHelper)object).showAsDialog(DataUsagePanel.this);
            }
        });
        jPanel.setLayout(new GridLayout(1, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.autoBtn);
        jPanel2.add(this.showLink);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        this.infoMsg = new JLabel();
        this.infoMsg.setIcon(null);
        this.infoMsg.setVerticalTextPosition(1);
        this.infoMsg.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.infoPanel = new JPanel();
        this.infoPanel.setVisible(false);
        this.infoPanel.setMaximumSize(new Dimension(100, 50));
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.add(this.infoMsg);
        this.add((Component)this.infoPanel, "South");
        if (this.isStandalone()) {
            this.initAttributesTable();
            this.generateUIRulesMessages();
            this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
            this.dataMinerTablePanel.getTable().setAutoscrolls(false);
        }
    }

    private int addRulesMessages(ModelType modelType, Map<String, String> map, boolean bl) {
        int n = 0;
        for (MiningAttributeType miningAttributeType : modelType.getInputMiningData().getMiningAttributes().getMiningAttribute()) {
            if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, this.getDbVersion()) || map == null || map.containsKey(miningAttributeType.getName())) continue;
            if (miningAttributeType.getMiningType().equals(CATEGORICAL) && (modelType instanceof PCAModelType || modelType instanceof SVDModelType)) {
                if (bl) {
                    map.put(miningAttributeType.getName(), MessageFormat.format(BuildEditorLrb.get("DATA_USAGE_EXCLUDE_CATEGORICAL"), DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier())));
                }
            } else if (miningAttributeType.getMiningType().equals(TEXT) && modelType instanceof OClusterModelType) {
                if (bl) {
                    map.put(miningAttributeType.getName(), MessageFormat.format(BuildEditorLrb.get("DATA_USAGE_EXCLUDE_TEXT"), DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier())));
                }
            } else if (bl) {
                map.put(miningAttributeType.getName(), MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_DATA_TYPE_NOT_SUPPORT"), DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier())));
            }
            ++n;
        }
        return n;
    }

    public int getModelRulesCount(ModelType modelType) {
        int n = 0;
        ModelHeuristicRules modelHeuristicRules = this.modelRules.get(modelType.getName());
        if (modelHeuristicRules != null) {
            n = modelHeuristicRules.countExcluded;
        }
        return n;
    }

    public void generateUIRulesMessages() {
        if (this.isStandalone()) {
            Object object;
            if (!this.isPredictiveQuery()) {
                this.nodeRules = MetaDataHelper.getHeuristicsRules(this.getMetadataCopy());
            }
            MiningAttributes miningAttributes = null;
            if (this.isPredictiveQuery()) {
                object = this.getDynamicMetadataCopy();
                if (object instanceof DynamicClusterNodeType) {
                    miningAttributes = ((DynamicClusterNodeType)object).getDynamicNodeBaseSettings().getMiningAttributes();
                } else if (object instanceof DynamicAnomalyNodeType) {
                    miningAttributes = ((DynamicAnomalyNodeType)object).getDynamicNodeBaseSettings().getMiningAttributes();
                } else if (object instanceof DynamicFeatureNodeType) {
                    miningAttributes = ((DynamicFeatureNodeType)object).getDynamicNodeBaseSettings().getMiningAttributes();
                } else if (object instanceof DynamicPredictionNodeType) {
                    miningAttributes = ((DynamicPredictionNodeType)object).getDynamicNodeBaseSettings().getMiningAttributes();
                }
            } else {
                object = this.getMetadataCopy();
                miningAttributes = object.getMiningAttributes();
            }
            object = (UsageTableModel)((Object)this.jDataUsageTable.getModel());
            for (int i = 0; i < object.getRowCount(); ++i) {
                MiningAttributeType miningAttributeType = (MiningAttributeType)((UsageTableModel)((Object)object)).getValueAt(i, 0);
                if (AbstractBuildNode.isInputAllowed(miningAttributeType, null, this.getDbVersion())) continue;
                this.nodeRules.put(miningAttributeType.getName(), MessageFormat.format(BuildEditorLrb.get("HEURISTIC_DETAILS_DATA_TYPE_NOT_SUPPORT"), DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier())));
                miningAttributeType.setInput("No");
                for (MiningAttributeType miningAttributeType2 : miningAttributes.getMiningAttribute()) {
                    if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
                    miningAttributeType2.setInput("No");
                }
            }
        } else {
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.getMetadataCopy());
            this.modelRules = this.getEnclosingPanel().getCopyOfModelRules();
            for (ModelType modelType : list) {
                HashMap<String, String> hashMap;
                ModelHeuristicRules modelHeuristicRules;
                InputMiningDataType inputMiningDataType = modelType.getInputMiningData().getDataUsage();
                if (inputMiningDataType == null || inputMiningDataType.equals((Object)InputMiningDataType.AUTO)) {
                    modelHeuristicRules = this.modelRules.get(modelType.getName());
                    if (modelHeuristicRules != null) {
                        modelHeuristicRules.countExcluded += this.addRulesMessages(modelType, modelHeuristicRules.modelRules, true);
                        continue;
                    }
                    modelHeuristicRules = new ModelHeuristicRules();
                    hashMap = new HashMap<String, String>();
                    modelHeuristicRules.countExcluded = this.addRulesMessages(modelType, hashMap, true);
                    modelHeuristicRules.modelRules = hashMap;
                    this.modelRules.put(modelType.getName(), modelHeuristicRules);
                    continue;
                }
                this.modelRules.remove(modelType.getName());
                modelHeuristicRules = new ModelHeuristicRules();
                hashMap = new HashMap();
                modelHeuristicRules.countExcluded = this.addRulesMessages(modelType, hashMap, true);
                modelHeuristicRules.modelRules = hashMap;
                this.modelRules.put(modelType.getName(), modelHeuristicRules);
            }
        }
    }

    private boolean isCompatibleAttributesSelected() {
        boolean bl = true;
        List<MiningAttributeType> list = this.getSelectedAttributes();
        String string = list.get(0).getDataType();
        String string2 = DatabaseMetadataUtils.getDefaultMiningType(string);
        for (MiningAttributeType miningAttributeType : list) {
            if (DatabaseMetadataUtils.getDefaultMiningType(miningAttributeType.getDataType()).equals(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private TextSettingsPanel getTextSettingsPanel() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getParent();
        Component[] componentArray = jTabbedPane.getComponents();
        TextSettingsPanel textSettingsPanel = null;
        for (Component component : componentArray) {
            if (!(component instanceof TextSettingsPanel)) continue;
            textSettingsPanel = (TextSettingsPanel)component;
            break;
        }
        return textSettingsPanel;
    }

    private void installDataUsageActions() {
        ListSelectionModel listSelectionModel;
        this.autoPrepBtn = new DropDownMenuButton();
        this.autoPrepBtn.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_ADP"));
        this.dataMinerTablePanel.addControlBarComponents(new Component[]{this.autoPrepBtn});
        this.autoPrepBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JMenuItem jMenuItem = new JMenuItem();
                    jMenuItem.setEnabled(true);
                    jMenuItem.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_AUTO_PREP_ON"));
                    DataUsagePanel.this.autoPrepBtn.addPopupItem(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DataUsagePanel.this.setAutoPrep(true);
                        }
                    });
                    JMenuItem jMenuItem2 = new JMenuItem();
                    jMenuItem2.setEnabled(true);
                    jMenuItem2.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_AUTO_PREP_OFF"));
                    DataUsagePanel.this.autoPrepBtn.addPopupItem(jMenuItem2);
                    jMenuItem2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DataUsagePanel.this.setAutoPrep(false);
                        }
                    });
                } else {
                    DataUsagePanel.this.autoPrepBtn.removeAllPopupItems();
                }
            }
        });
        this.miningTypeBtn = new DropDownMenuButton();
        if (this.isStandalone()) {
            this.miningTypeBtn.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE"));
            this.miningTypeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!DataUsagePanel.this.isCompatibleAttributesSelected()) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)BuildEditorLrb.get("BUILD_DATA_USAGE_MULTISELECT_COMPATIBLE_MSG"), (String)BuildEditorLrb.get("BUILD_DATA_USAGE_MULTISELECT_COMPATIBLE_TITLE"), null);
                    }
                }
            });
            this.miningTypeBtn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        boolean bl = DataUsagePanel.this.isCompatibleAttributesSelected();
                        List<MiningAttributeType> list = DataUsagePanel.this.getSelectedAttributes();
                        String string = list.get(0).getDataType();
                        List<String> list2 = DataUsagePanel.this.getAvailableMiningTypes(string);
                        for (String string2 : list2) {
                            if (string2.equals(TEXT) && !DataUsagePanel.this.isTextVisible) continue;
                            JMenuItem jMenuItem = new JMenuItem();
                            jMenuItem.setEnabled(bl);
                            jMenuItem.setText(string2);
                            if (string2.equals(NUMERICAL)) {
                                jMenuItem.setIcon(DataMinerIcons.get(Icons.MTYPE_NUMERICAL));
                            } else if (string2.equals(CATEGORICAL)) {
                                jMenuItem.setIcon(DataMinerIcons.get(Icons.MTYPE_CATEGORICAL));
                            } else if (string2.equals(TEXT)) {
                                jMenuItem.setIcon(OracleIcons.getIcon((String)"openbook.png"));
                            }
                            DataUsagePanel.this.miningTypeBtn.addPopupItem(jMenuItem);
                            jMenuItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    int[] nArray;
                                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                                    String string = jMenuItem.getText();
                                    for (int n : nArray = DataUsagePanel.this.jDataUsageTable.getSelectedRowsInModel()) {
                                        UsageTableModel usageTableModel = (UsageTableModel)((Object)DataUsagePanel.this.jDataUsageTable.getModel());
                                        usageTableModel.setValueAt(string, n, DataUsagePanel.this.USAGE_MINING_TYPE);
                                    }
                                }
                            });
                        }
                    } else {
                        DataUsagePanel.this.miningTypeBtn.removeAllPopupItems();
                    }
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(new Component[]{this.miningTypeBtn});
        }
        this.inputBtn = new JButton(OracleIcons.getIcon((String)"messageAsync.png"));
        this.inputBtn.setToolTipText(BuildEditorLrb.get("BUILD_DATA_USAGE_SET_TO_INPUT"));
        this.inputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.setInputs(true);
            }
        });
        this.ignoreBtn = new JButton(DataMinerIcons.get(Icons.ATTR_IGNORE));
        this.ignoreBtn.setToolTipText(BuildEditorLrb.get("BUILD_DATA_USAGE_SET_TO_IGNORE"));
        this.ignoreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataUsagePanel.this.setInputs(false);
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this.inputBtn, this.ignoreBtn);
        if (DbVersionHelper.isDB121Up((Version)this.getDbVersion()) && this.isStandalone() && this.isTextVisible) {
            this.importBtn = new JButton(OracleIcons.getIcon((String)"import.png"));
            this.importBtn.setToolTipText(BuildEditorLrb.get("BUILD_DATA_USAGE_IMPORT_TIP"));
            this.importBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataUsagePanel.this.getTextSettingsPanel().handleImportTextSettings();
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this.importBtn);
        }
        this.inputBtn.setEnabled(!(listSelectionModel = this.jDataUsageTable.getSelectionModel()).isSelectionEmpty());
        this.ignoreBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.miningTypeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.autoPrepBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this.rowFilter = new RowFilter<UsageTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends UsageTableModel, ? extends Integer> entry) {
                Integer n = entry.getIdentifier();
                UsageTableModel usageTableModel = entry.getModel();
                MiningAttributeType miningAttributeType = usageTableModel.getRowData(n);
                String string = DataUsagePanel.this.dataMinerTablePanel.getSearchField().getText();
                return string != null && miningAttributeType.getName().toLowerCase().contains(string.toLowerCase());
            }
        };
        this.dataMinerTablePanel.getSearchField().setPrompt(BuildEditorLrb.get("BUILD_DATA_USAGE_ATTRS"));
        this.dataMinerTablePanel.getSearchField().addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.jDataUsageTable, this.rowFilter));
    }

    public List<MiningAttributeType> getSelectedAttributes() {
        int[] nArray;
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (int n : nArray = this.jDataUsageTable.getSelectedRowsInModel()) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)this.jDataUsageTable.getModel().getValueAt(n, 0);
            arrayList.add(miningAttributeType);
        }
        return arrayList;
    }

    private void setAutoUsage(boolean bl) {
        this.allModelsAutomatic = bl;
        UsageTableModel usageTableModel = (UsageTableModel)((Object)this.jDataUsageTable.getModel());
        if (!this.isStandalone()) {
            int[] nArray = this.jDataUsageTable.getSelectedRowsInModel();
            List<? extends Object> list = usageTableModel.getDataList();
            for (ModelType modelType : list) {
                ModelType modelType2 = this.findEditedModel(modelType);
                if (modelType2 == null) {
                    modelType2 = this.addEditedModelRecord(modelType, 1).getModel();
                }
                InputMiningData inputMiningData = modelType2.getInputMiningData();
                if (bl) {
                    inputMiningData.setDataUsage(InputMiningDataType.AUTO);
                    inputMiningData.setMiningUsage(InputMiningDataType.AUTO);
                    modelType.getInputMiningData().setDataUsage(InputMiningDataType.AUTO);
                    modelType.getInputMiningData().setMiningUsage(InputMiningDataType.AUTO);
                    continue;
                }
                inputMiningData.setDataUsage(InputMiningDataType.MANUAL);
                inputMiningData.setMiningUsage(InputMiningDataType.MANUAL);
                modelType.getInputMiningData().setDataUsage(InputMiningDataType.MANUAL);
                modelType.getInputMiningData().setMiningUsage(InputMiningDataType.MANUAL);
            }
            this.getEnclosingPanel().refreshTable();
            this.jDataUsageTable.setSelectedRowsInModel(nArray);
        } else {
            this.miningAttributes.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
            ((AbstractTableModel)this.jDataUsageTable.getModel()).fireTableDataChanged();
        }
        this.generateUIRulesMessages();
        this.setDirty();
    }

    private void setAutoPrep(boolean bl) {
        Object object;
        UsageTableModel usageTableModel = (UsageTableModel)((Object)this.jDataUsageTable.getModel());
        List<MiningAttributeType> list = this.getSelectedAttributes();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        for (MiningAttributeType object2 : list) {
            if (this.usagesTblModel.isCaseIdAttribute(object2) || this.usagesTblModel.isTargetAttribute(object2) || this.usagesTblModel.isPartitionAttribute(object2)) continue;
            arrayList.add(object2);
        }
        if (!this.isStandalone()) {
            object = usageTableModel.getDataList();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ModelType modelType = (ModelType)iterator.next();
                ModelType modelType2 = this.findEditedModel(modelType);
                if (modelType2 == null) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    modelType2 = this.addEditedModelRecord(modelType, 1).getModel();
                } else if (MetaDataHelper.isAutomatic(modelType2)) continue;
                usageTableModel.updateAttributesInModel(arrayList, modelType2, this.USAGE_ADP, bl ? "Yes" : "No");
                for (MiningAttributeType miningAttributeType : arrayList) {
                    miningAttributeType.setAutoPrep(bl ? "Yes" : "No");
                }
            }
        } else {
            for (MiningAttributeType miningAttributeType : arrayList) {
                miningAttributeType.setAutoPrep(bl ? "Yes" : "No");
                if (this.getMetadataCopy() == null) continue;
                usageTableModel.updateModelAttributes(miningAttributeType);
            }
        }
        object = this.jDataUsageTable.getSelectedRowsInModel();
        usageTableModel.fireTableDataChanged();
        this.jDataUsageTable.setSelectedRowsInModel((int[])object);
        this.setDirty();
    }

    private void setInputs(boolean bl) {
        Object object;
        String string = bl ? "Yes" : "No";
        UsageTableModel usageTableModel = (UsageTableModel)((Object)this.jDataUsageTable.getModel());
        List<MiningAttributeType> list = this.getSelectedAttributes();
        if (!this.isStandalone()) {
            object = usageTableModel.getDataList();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ModelType modelType = (ModelType)iterator.next();
                ModelType modelType2 = this.findEditedModel(modelType);
                if (modelType2 == null) {
                    if (MetaDataHelper.isAutomatic(modelType)) continue;
                    modelType2 = this.addEditedModelRecord(modelType, 1).getModel();
                } else if (MetaDataHelper.isAutomatic(modelType2)) continue;
                usageTableModel.updateAttributesInModel(list, modelType2, this.USAGE_INPUT, string);
                for (MiningAttributeType miningAttributeType : list) {
                    miningAttributeType.setInput(bl ? "Yes" : "No");
                }
            }
        } else {
            for (MiningAttributeType miningAttributeType : list) {
                miningAttributeType.setInput(bl ? "Yes" : "No");
                if (this.getMetadataCopy() == null) continue;
                usageTableModel.updateModelAttributes(miningAttributeType);
            }
        }
        object = this.jDataUsageTable.getSelectedRowsInModel();
        usageTableModel.fireTableDataChanged();
        this.jDataUsageTable.setSelectedRowsInModel((int[])object);
        this.setDirty();
    }

    private void initStandaloneInfoPanel() {
        this.infoPanel.setVisible(false);
        List<ModelType> list = MetaDataHelper.getModelsCollection(this.getMetadataCopy());
        for (ModelType modelType : list) {
            InputMiningData inputMiningData = modelType.getInputMiningData();
            if (!inputMiningData.getDataUsage().equals((Object)InputMiningDataType.MANUAL)) continue;
            this.infoPanel.setVisible(true);
            this.infoMsg.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_INFO_CUSTOM_MODELS"));
            this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.infoMsg.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Container container = DataUsagePanel.this.getParent();
                    if (container instanceof JTabbedPane) {
                        ((JTabbedPane)container).setSelectedIndex(0);
                    }
                }
            });
            break;
        }
    }

    public boolean getOriginalAutoValue() {
        return this.originalAutoValue;
    }

    private void initAttributesTable() {
        Object object;
        TableColumn tableColumn;
        this.usagesTblModel = this.isPredictiveQuery() ? new UsageTableModel(this.getContext(), this.miningAttributes, null) : new UsageTableModel(this.getContext(), this.miningAttributes, this.getMetadataCopy());
        this.jDataUsageTable.setModel((TableModel)((Object)this.usagesTblModel));
        this.jDataUsageTable.setSorted(true);
        this.jDataUsageTable.setSortColumn(0, true);
        this.updateComponetTitle();
        this.usagesTblModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                DataUsagePanel.this.updateComponetTitle();
            }
        });
        this.initStandaloneInfoPanel();
        TableColumn tableColumn2 = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_INPUT);
        TableColumn tableColumn3 = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_MINING_TYPE);
        tableColumn2.setCellEditor(new InputTypeEditor());
        tableColumn2.setCellRenderer(new InputTypeRenderer());
        if (this.isAdpVisible) {
            tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_ADP);
            object = new TriStateCheckBox();
            tableColumn.setCellEditor((TableCellEditor)((Object)new TriStateCheckCellEditor((TriStateCheckBox)object)));
            tableColumn.setCellRenderer((TableCellRenderer)((Object)new TriStateCheckCellRenderer()));
        }
        tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(this.RULES_COLUMN);
        object = new InputTypeEditor();
        ((InputTypeEditor)object).setEditable(false);
        tableColumn.setCellEditor((TableCellEditor)object);
        tableColumn3.setCellEditor(new MiningTypeEditor());
        tableColumn3.setCellRenderer(new MiningTypeRenderer());
        TableColumn tableColumn4 = this.jDataUsageTable.getFullColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn4.setCellRenderer(attributeNameCellRenderer);
        attributeNameCellRenderer.setTargets(this.targetAttributes);
        attributeNameCellRenderer.setKeys(this.caseAttributes);
        attributeNameCellRenderer.setPartitionKeys(this.partitionAttributes);
        boolean bl = this.miningAttributes.getAutoSpec() == null || this.miningAttributes.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.autoBtn.setSelected(bl);
        this.autoBtn.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_CHKLBL"));
        this.jDataUsageTable.autoSizeColumnsToFit();
    }

    private void updateComponetTitle() {
        int n = 0;
        int n2 = this.jDataUsageTable.getModel().getRowCount();
        for (int i = 0; i < n2; ++i) {
            Object object = this.jDataUsageTable.getModel().getValueAt(i, 2);
            if (!object.equals("No")) continue;
            ++n;
        }
        String string = MessageFormat.format(BuildEditorLrb.get("BUILD_DATA_USAGE_COLUMN_COUNT"), n2 - n, n2);
        this.dataMinerTablePanel.setTitle(string);
    }

    public void disableAutoSelection() {
        this.autoBtn.setEnabled(false);
        this.autoBtn.setText(MessageFormat.format(BuildEditorLrb.get("BUILD_DATA_USAGE_ADV_CHKLBL_SINGLE"), ""));
        this.showLink.setEnabled(false);
    }

    private void initModelAttributesTable() {
        Object[] objectArray;
        int[] nArray = null;
        nArray = this.jDataUsageTable.getSelectedRowsInModel();
        this.usagesTblModel = new UsageTableModel(this.getContext(), this.getSelectedModels(), this.getMetadataCopy());
        this.jDataUsageTable.setModel((TableModel)((Object)this.usagesTblModel));
        this.jDataUsageTable.setSorted(true);
        this.jDataUsageTable.setSortColumn(0, true);
        this.updateComponetTitle();
        this.usagesTblModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                DataUsagePanel.this.updateComponetTitle();
            }
        });
        List<? extends Object> list = this.usagesTblModel.getDataList();
        this.multipleModelsSelected = list.size() > 1;
        this.oneModelSelected = list.size() == 1;
        this.allModelsAutomatic = this.isAllModelsAutomatic(list);
        if (this.multipleModelsSelected.booleanValue()) {
            objectArray = this.dataMinerTablePanel.getTitle();
            this.dataMinerTablePanel.setTitle((String)objectArray + "  " + BuildEditorLrb.get("BUILD_DATA_USAGE_LBL_MULT"));
        }
        this.autoBtn.setSelected(this.allModelsAutomatic);
        this.autoBtn.setEnabled(true);
        this.showLink.setEnabled(this.allModelsAutomatic);
        this.infoPanel.setVisible(this.oneModelSelected != false || this.multipleModelsSelected != false || this.allModelsAutomatic != false);
        if (this.multipleModelsSelected.booleanValue()) {
            this.autoBtn.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_ADV_CHKLBL_MULTI"));
            if (this.allModelsAutomatic.booleanValue()) {
                this.infoPanel.setVisible(false);
                this.infoMsg.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_INFO_MULT_AUTO"));
                this.infoMsg.setIcon(OracleIcons.getIcon((String)"info.png"));
            } else if (this.isAllModelsCustom(list)) {
                this.infoPanel.setVisible(true);
                this.infoMsg.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_INFO_MULT_MANUAL"));
                this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                this.infoPanel.setVisible(true);
                this.infoMsg.setText(BuildEditorLrb.get("BUILD_DATA_USAGE_INFO_MULT_MIXED"));
                this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
        } else if (this.oneModelSelected.booleanValue()) {
            objectArray = new Object[]{((ModelType)list.get(0)).getName()};
            this.autoBtn.setText(MessageFormat.format(BuildEditorLrb.get("BUILD_DATA_USAGE_ADV_CHKLBL_SINGLE"), objectArray));
            if (this.allModelsAutomatic.booleanValue()) {
                this.infoPanel.setVisible(false);
                this.infoMsg.setText(MessageFormat.format(BuildEditorLrb.get("BUILD_DATA_USAGE_ADV_CHKLBL_SINGLE"), objectArray));
                this.infoMsg.setIcon(OracleIcons.getIcon((String)"info.png"));
            } else {
                this.infoPanel.setVisible(true);
                this.infoMsg.setText(MessageFormat.format(BuildEditorLrb.get("BUILD_DATA_USAGE_INFO_ONE_MANUAL"), objectArray));
                this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            this.generateUIRulesMessages();
        } else {
            this.disableAutoSelection();
        }
        objectArray = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_INPUT);
        TableColumn tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_ADP);
        TableColumn tableColumn2 = this.jDataUsageTable.getFullColumnModel().getColumn(this.USAGE_MINING_TYPE);
        objectArray.setCellEditor(new InputTypeEditor());
        objectArray.setCellRenderer(new InputTypeRenderer());
        TriStateCheckBox triStateCheckBox = new TriStateCheckBox();
        tableColumn.setCellEditor((TableCellEditor)((Object)new TriStateCheckCellEditor(triStateCheckBox)));
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new TriStateCheckCellRenderer()));
        tableColumn2.setCellEditor(new MiningTypeEditor());
        tableColumn2.setCellRenderer(new MiningTypeRenderer());
        TableColumn tableColumn3 = this.jDataUsageTable.getFullColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn3.setCellRenderer(attributeNameCellRenderer);
        attributeNameCellRenderer.setTargets(this.targetAttributes);
        attributeNameCellRenderer.setKeys(this.caseAttributes);
        attributeNameCellRenderer.setPartitionKeys(this.partitionAttributes);
        this.jDataUsageTable.autoSizeColumnsToFit();
        if (!this.isStandalone()) {
            this.jDataUsageTable.setSelectedRowsInModel(nArray);
        }
    }

    @Override
    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        if (!super.handleModelSelectionChanged(listSelectionModel)) {
            return false;
        }
        if (this.isStandalone()) {
            this.initAttributesTable();
        } else {
            this.initModelAttributesTable();
        }
        return true;
    }

    private boolean isAllModelsAutomatic(List<ModelType> list) {
        boolean bl = true;
        for (ModelType modelType : list) {
            ModelType modelType2 = this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            if (MetaDataHelper.isAutomatic(modelType2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isAllModelsCustom(List<ModelType> list) {
        boolean bl = true;
        for (ModelType modelType : list) {
            ModelType modelType2 = this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            if (!MetaDataHelper.isAutomatic(modelType2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void handleUsageSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl = true;
        if (listSelectionModel.isSelectionEmpty()) {
            bl = false;
        } else if (!this.isStandalone()) {
            List<ModelType> list = this.getSelectedModels();
            if (this.isAllModelsAutomatic(list)) {
                bl = false;
            }
        } else {
            int[] nArray = this.jDataUsageTable.getSelectedRowsInModel();
            boolean bl2 = false;
            for (int n : nArray) {
                boolean bl3 = this.jDataUsageTable.getModel().isCellEditable(n, this.USAGE_INPUT);
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                bl = false;
            }
        }
        this.inputBtn.setEnabled(bl);
        this.ignoreBtn.setEnabled(bl);
        this.miningTypeBtn.setEnabled(bl);
        this.autoPrepBtn.setEnabled(bl);
    }

    private Version getDbVersion() {
        if (this.dbVersion == null) {
            this.dbVersion = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        }
        return this.dbVersion;
    }

    @Override
    public void targetsChanged(Map<String, AttributeType> map) {
        TableColumn tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(0);
        RolloverTableRenderer rolloverTableRenderer = (RolloverTableRenderer)tableColumn.getCellRenderer();
        AttributeNameCellRenderer attributeNameCellRenderer = (AttributeNameCellRenderer)rolloverTableRenderer.getBaseRenderer();
        this.targetAttributes = map;
        attributeNameCellRenderer.setTargets(this.targetAttributes);
        ((AbstractTableModel)this.jDataUsageTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void partitionKeysChanged(Map<String, AttributeType> map) {
        TableColumn tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(0);
        RolloverTableRenderer rolloverTableRenderer = (RolloverTableRenderer)tableColumn.getCellRenderer();
        AttributeNameCellRenderer attributeNameCellRenderer = (AttributeNameCellRenderer)rolloverTableRenderer.getBaseRenderer();
        this.partitionAttributes = map;
        attributeNameCellRenderer.setPartitionKeys(map);
        ((AbstractTableModel)this.jDataUsageTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void caseIdsChanged(Map<String, AttributeType> map) {
        MiningAttributeType miningAttributeType2;
        for (MiningAttributeType miningAttributeType2 : this.getMetadataCopy().getMiningAttributes().getMiningAttribute()) {
            if (this.oldCaseId != null && miningAttributeType2.getName().equals(this.oldCaseId.getName())) {
                miningAttributeType2.setInput("Yes");
            }
            if (!map.containsKey(miningAttributeType2.getName())) continue;
            miningAttributeType2.setInput("No");
        }
        TableColumn tableColumn = this.jDataUsageTable.getFullColumnModel().getColumn(0);
        miningAttributeType2 = (RolloverTableRenderer)tableColumn.getCellRenderer();
        AttributeNameCellRenderer attributeNameCellRenderer = (AttributeNameCellRenderer)miningAttributeType2.getBaseRenderer();
        this.caseAttributes = map;
        attributeNameCellRenderer.setKeys(this.caseAttributes);
        ((AbstractTableModel)this.jDataUsageTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void textSettingsImported() {
        ((AbstractTableModel)this.jDataUsageTable.getModel()).fireTableDataChanged();
    }

    @Override
    public void modelsDataUsageChanged() {
        this.initStandaloneInfoPanel();
    }

    private List<String> getAvailableMiningTypes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = DatabaseMetadataUtils.getDefaultMiningType(string);
        if (string2.equals("Numerical")) {
            arrayList.add(NUMERICAL);
            arrayList.add(CATEGORICAL);
        } else if (string2.equals("Categorical")) {
            arrayList.add(CATEGORICAL);
            if (DbVersionHelper.isDB121Up((Version)this.getDbVersion())) {
                arrayList.add(TEXT);
            }
        } else if (string2.equals("Text")) {
            arrayList.add(TEXT);
        }
        return arrayList;
    }

    public static boolean attributesHaveInputValue(List<ModelType> list, String string, String string2, boolean bl) {
        boolean bl2 = false;
        block0: for (ModelType modelType : list) {
            List list2 = modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
            if (bl && modelType.getInputMiningData().getMiningUsage().equals((Object)InputMiningDataType.AUTO)) {
                bl2 = true;
                continue;
            }
            for (MiningAttributeType miningAttributeType : list2) {
                if (!miningAttributeType.getName().equals(string2)) continue;
                if (!miningAttributeType.getInput().equals(string)) {
                    return false;
                }
                bl2 = true;
                continue block0;
            }
        }
        return bl2;
    }

    @Override
    protected void loadEmptySelectionUI() {
        this.jDataUsageTable.setModel((TableModel)((Object)new UsageTableModel(this.getContext(), new ArrayList<ModelType>(), this.getMetadataCopy())));
        this.jDataUsageTable.setRowSorter(null);
    }

    public boolean doWork() {
        TableCellEditor tableCellEditor;
        return !this.jDataUsageTable.isEditing() || (tableCellEditor = this.jDataUsageTable.getCellEditor()).stopCellEditing();
    }

    public class DataUsageTable
    extends DataMinerTable {
        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Object object = null;
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n2 < 0) {
                return null;
            }
            int n3 = this.convertColumnIndexToModel(n);
            int n4 = this.convertRowIndexToModel(n2);
            TableModel tableModel = this.getModel();
            String string = tableModel.getColumnName(n3);
            if (string.equals(BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT"))) {
                String string2 = (String)tableModel.getValueAt(n4, n3);
                if (DataUsagePanel.this.isStandalone) {
                    List<ModelType> list = MetaDataHelper.getModelsCollection(DataUsagePanel.this.getMetadataCopy());
                    if (list == null || list.size() < 1) {
                        object = BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_ALL_INCLUDED");
                        return object;
                    }
                    MiningAttributeType miningAttributeType = (MiningAttributeType)tableModel.getValueAt(n4, 0);
                    boolean bl = DataUsagePanel.attributesHaveInputValue(list, "Yes", miningAttributeType.getName(), false);
                    boolean bl2 = DataUsagePanel.attributesHaveInputValue(list, "No", miningAttributeType.getName(), false);
                    object = bl ? BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_ALL_INCLUDED") : (bl2 ? BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_ALL_EXCLUDED") : BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT_SOME_INCLUDED"));
                    return object;
                }
                if (string2.equals("Yes")) {
                    object = BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO");
                } else if (string2.equals("No")) {
                    object = BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE");
                } else if (string2.equals(DataUsagePanel.FORCE)) {
                    object = BuildEditorLrb.get("DATA_USAGE_INPUT_FORCE");
                } else if (string2.equals(MULTI_SELECT_RES)) {
                    object = MULTI_SELECT_RES;
                }
            } else if (string.equals(BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE"))) {
                String string3 = (String)tableModel.getValueAt(n4, n3);
                if (string3.equals("Categorical")) {
                    object = CATEGORICAL;
                } else if (string3.equals("Numerical")) {
                    object = NUMERICAL;
                } else if (string3.equals("Text")) {
                    object = TEXT;
                } else if (string3.equals("TextCustom")) {
                    object = TEXT_CUSTOM;
                } else if (string3.equals(MULTI_SELECT_RES)) {
                    object = MULTI_SELECT_RES;
                }
            } else {
                if (string.equals(BuildEditorLrb.get("BUILD_DATA_USAGE_ADP"))) {
                    if (!tableModel.isCellEditable(n4, n3)) {
                        MiningAttributeType miningAttributeType = (MiningAttributeType)tableModel.getValueAt(n4, DataUsagePanel.this.USAGE_ATTRIBUTE_NAME);
                        object = BuildEditorLrb.get(DbVersionHelper.isDB122Up((Version)DataUsagePanel.this.getDbVersion()) ? "DATA_USAGE_ADP_NOT_EDITABLE_2" : "DATA_USAGE_ADP_NOT_EDITABLE");
                        if (miningAttributeType.getMiningType().equals(TEXT) || miningAttributeType.getMiningType().equals(TEXT_CUSTOM)) {
                            object = BuildEditorLrb.get("DATA_USAGE_TEXT_ADP_NOT_EDITABLE");
                        }
                    }
                    return object;
                }
                return super.getToolTipText(mouseEvent);
            }
            if (!tableModel.isCellEditable(n4, n3)) {
                object = (String)object + " " + BuildEditorLrb.get(DbVersionHelper.isDB122Up((Version)DataUsagePanel.this.getDbVersion()) ? "DATA_USAGE_NOT_EDITABLE_2" : "DATA_USAGE_NOT_EDITABLE");
            }
            return object;
        }
    }

    public class UsageTableModel
    extends SimpleBaseTableModel {
        private List<ModelType> models;
        private Map<String, ModelType> cachedModels;
        private Map<String, Boolean> allowedAdpPartial = new HashMap<String, Boolean>();
        private Context context = null;
        private MiningAttributes miningAttributes = null;
        private boolean isStandalone;
        private BuildNodeType metadataCopy;

        private boolean isStandalone() {
            return this.isStandalone;
        }

        private List<MiningAttributeType> getMiningAttributes() {
            if (this.isStandalone()) {
                return this.miningAttributes.getMiningAttribute();
            }
            List<? extends Object> list = this.getDataList();
            ModelType modelType = (ModelType)list.get(0);
            if (modelType == null) {
                return null;
            }
            return modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
        }

        public UsageTableModel(Context context, MiningAttributes miningAttributes, BuildNodeType buildNodeType) {
            this.context = context;
            this.miningAttributes = miningAttributes;
            this.metadataCopy = buildNodeType;
            this.isStandalone = true;
            this.initTableColumns();
            List<MiningAttributeType> list = this.getMiningAttributes();
            if (list == null) {
                this.setRowCount(0);
                return;
            }
            this.setRowCount(list.size());
        }

        public UsageTableModel(Context context, List<ModelType> list, BuildNodeType buildNodeType) {
            Object object;
            this.models = list;
            this.cachedModels = new HashMap<String, ModelType>();
            this.metadataCopy = buildNodeType;
            this.context = context;
            this.isStandalone = false;
            this.initTableColumns();
            if (list.size() == 0) {
                this.setRowCount(0);
                return;
            }
            List<MiningAttributeType> list2 = this.getMiningAttributes();
            for (ModelType modelType : this.models) {
                object = DataUsagePanel.this.findEditedModel(modelType);
                if (object == null) {
                    object = modelType;
                }
                ModelType modelType2 = (ModelType)MetaDataHelper.copyMetadataObject(object);
                this.cachedModels.put(modelType.getId(), modelType2);
            }
            if (this.models.size() > 1) {
                for (MiningAttributeType miningAttributeType : list2) {
                    object = this.getCommonAttrValue(DataUsagePanel.this.USAGE_ADP, miningAttributeType, this.cachedModels.values());
                    if (object == null || !((String)object).equals(MULTI_SELECT_RES)) continue;
                    this.allowedAdpPartial.put(miningAttributeType.getName(), Boolean.TRUE);
                }
            }
            if (list2 == null) {
                this.setRowCount(0);
            } else {
                this.setRowCount(list2.size());
            }
        }

        private void initTableColumns() {
            Vector<String> vector = new Vector<String>();
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_ATTRS"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_DATA_TYPE"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_INPUT"));
            vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE"));
            if (DataUsagePanel.this.isAdpVisible) {
                vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_ADP"));
            } else {
                --DataUsagePanel.this.RULES_COLUMN;
            }
            if (this.models == null || this.models.size() == 1) {
                vector.add(BuildEditorLrb.get("BUILD_DATA_USAGE_RULES"));
            }
            this.setColumnIdentifiers(vector);
            this.setColumnCount(vector.size());
        }

        public boolean isAllowedAdpPartial(String string) {
            return this.allowedAdpPartial.containsKey(string);
        }

        private boolean isTargetAttribute(MiningAttributeType miningAttributeType) {
            boolean bl = false;
            if (DataUsagePanel.this.targetAttributes.containsKey(miningAttributeType.getName())) {
                bl = true;
            }
            return bl;
        }

        private boolean isCaseIdAttribute(MiningAttributeType miningAttributeType) {
            boolean bl = false;
            if (DataUsagePanel.this.caseAttributes.containsKey(miningAttributeType.getName())) {
                bl = true;
            }
            return bl;
        }

        private boolean isPartitionAttribute(MiningAttributeType miningAttributeType) {
            boolean bl = false;
            if (DataUsagePanel.this.partitionAttributes.containsKey(miningAttributeType.getName())) {
                bl = true;
            }
            return bl;
        }

        public boolean isCellEditable(int n, int n2) {
            block17: {
                MiningAttributeType miningAttributeType = (MiningAttributeType)this.getValueAt(n, 0);
                boolean bl = this.isTargetAttribute(miningAttributeType);
                boolean bl2 = this.isCaseIdAttribute(miningAttributeType);
                boolean bl3 = this.isPartitionAttribute(miningAttributeType);
                if (n2 == DataUsagePanel.this.USAGE_ADP) {
                    return !DataUsagePanel.this.autoBtn.isSelected() && !this.isTargetAttribute(miningAttributeType) && !bl2 && !bl3 && !miningAttributeType.getMiningType().equals(TEXT) && !miningAttributeType.getMiningType().equals(TEXT_CUSTOM);
                }
                if (n2 == DataUsagePanel.this.USAGE_INPUT || n2 == DataUsagePanel.this.USAGE_MINING_TYPE) {
                    if (bl || bl2 || bl3) {
                        return false;
                    }
                    if (this.isStandalone() ? this.miningAttributes.getAutoSpec() == null || this.miningAttributes.getAutoSpec().equals((Object)AutoSpecType.YES) : DataUsagePanel.this.allModelsAutomatic != false) {
                        return false;
                    }
                    if (n2 == DataUsagePanel.this.USAGE_INPUT) {
                        if (this.isStandalone()) {
                            if (AbstractBuildNode.isInputAllowed(miningAttributeType, null, DataUsagePanel.this.dbVersion)) {
                                return true;
                            }
                        } else {
                            for (ModelType modelType : this.models) {
                                ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
                                if (modelType2 == null) {
                                    modelType2 = modelType;
                                }
                                if (!modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.MANUAL) || !AbstractBuildNode.isInputAllowed(miningAttributeType, modelType2, DataUsagePanel.this.dbVersion)) continue;
                                return true;
                            }
                        }
                    } else {
                        String string = (String)this.getValueAt(n, n2);
                        if (string.equals(RepositoryLrb.get("NOT_APPLICABLE")) || DatabaseMetadataUtils.isNestedType(miningAttributeType.getDataType())) {
                            return false;
                        }
                        if (this.isStandalone()) {
                            if (this.metadataCopy instanceof AnomalyDetectionBuildNodeType || this.metadataCopy instanceof ClassificationBuildNodeType || this.metadataCopy instanceof ClusteringBuildNodeType || this.metadataCopy instanceof FeatureExtractionBuildNodeType || this.metadataCopy instanceof RegressionBuildNodeType || this.metadataCopy instanceof ExplicitFeatureExtractionBuildNodeType || this.metadataCopy instanceof RBuildNodeType) {
                                return true;
                            }
                            try {
                                if (!DatabaseMetadataUtils.isACustomDataType(this.context, miningAttributeType.getDataType()) && AbstractBuildNode.isInputAllowed(miningAttributeType, null, DataUsagePanel.this.dbVersion)) {
                                    return true;
                                }
                                break block17;
                            }
                            catch (Exception exception) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                                return false;
                            }
                        }
                        return false;
                    }
                }
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            object = this.isStandalone() ? this.getAttributeValueAt(n, n2) : this.getModelAttributeValueAt(n, n2);
            return object;
        }

        private Object getAttributeValueAt(int n, int n2) {
            Object object = null;
            List<MiningAttributeType> list = this.getMiningAttributes();
            MiningAttributeType miningAttributeType = list.get(n);
            if (DataUsagePanel.this.USAGE_ATTRIBUTE_NAME == n2) {
                object = miningAttributeType;
            } else if (DataUsagePanel.this.USAGE_INPUT == n2) {
                object = miningAttributeType.getInput();
            } else if (DataUsagePanel.this.isAdpVisible && DataUsagePanel.this.USAGE_ADP == n2) {
                object = "Yes".equals(miningAttributeType.getAutoPrep()) ? TriStateCheckBox.State.TRUE : TriStateCheckBox.State.FALSE;
            } else if (DataUsagePanel.this.USAGE_DATA_TYPE == n2) {
                object = DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier());
            } else if (DataUsagePanel.this.USAGE_MINING_TYPE == n2) {
                object = miningAttributeType.getMiningType();
            } else if (DataUsagePanel.this.RULES_COLUMN == n2) {
                String string = miningAttributeType.getName();
                object = DataUsagePanel.this.nodeRules.get(string);
            }
            return object;
        }

        private Object getModelAttributeValueAt(int n, int n2) {
            Object object = null;
            List<MiningAttributeType> list = this.getMiningAttributes();
            MiningAttributeType miningAttributeType = list.get(n);
            ModelType modelType = null;
            ModelType modelType2 = null;
            modelType = this.models.get(0);
            modelType2 = DataUsagePanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            if (DataUsagePanel.this.USAGE_ATTRIBUTE_NAME == n2) {
                object = miningAttributeType;
            } else if (DataUsagePanel.this.USAGE_INPUT == n2) {
                object = this.getCommonAttrValue(DataUsagePanel.this.USAGE_INPUT, miningAttributeType, this.models);
            } else if (DataUsagePanel.this.USAGE_ADP == n2) {
                MiningAttributeType miningAttributeType2;
                String string;
                String string2 = this.getCommonAttrValue(DataUsagePanel.this.USAGE_ADP, miningAttributeType, this.models);
                object = this.models.size() > 1 && string2.equals(MULTI_SELECT_RES) ? TriStateCheckBox.State.PARTIAL : ("Yes".equals(string = (miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2)).getAutoPrep()) ? TriStateCheckBox.State.TRUE : TriStateCheckBox.State.FALSE);
            } else if (DataUsagePanel.this.USAGE_DATA_TYPE == n2) {
                object = DatabaseMetadataUtils.getJSONDataType(miningAttributeType.getDataType(), miningAttributeType.getDataTypeQualifier());
            } else if (DataUsagePanel.this.USAGE_MINING_TYPE == n2) {
                object = this.getCommonAttrValue(DataUsagePanel.this.USAGE_MINING_TYPE, miningAttributeType, this.models);
            } else if (DataUsagePanel.this.RULES_COLUMN == n2) {
                String string = modelType2.getName();
                String string3 = miningAttributeType.getName();
                if (DataUsagePanel.this.modelRules.get(string) != null) {
                    object = DataUsagePanel.this.modelRules.get((Object)string).modelRules.get(string3);
                }
            }
            return object;
        }

        public void setModelAttributeValue(Object object, int n, MiningAttributeType miningAttributeType) {
            ModelType modelType = null;
            for (ModelType modelType2 : this.models) {
                MiningAttributeType miningAttributeType2;
                Object object2;
                Object object3;
                modelType = DataUsagePanel.this.findEditedModel(modelType2);
                if (modelType == null) {
                    modelType = DataUsagePanel.this.addEditedModelRecord(modelType2, 1).getModel();
                }
                MiningAttributeType miningAttributeType3 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType);
                if (n == DataUsagePanel.this.USAGE_ADP) {
                    object3 = (TriStateCheckBox.State)object;
                    if (object3 == TriStateCheckBox.State.TRUE) {
                        miningAttributeType3.setAutoPrep("Yes");
                    } else if (object3 == TriStateCheckBox.State.FALSE) {
                        miningAttributeType3.setAutoPrep("No");
                    } else if (object3 == TriStateCheckBox.State.PARTIAL) {
                        object2 = this.cachedModels.get(modelType2.getId());
                        miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, (ModelType)object2);
                        miningAttributeType3.setAutoPrep(miningAttributeType2.getAutoPrep());
                    }
                }
                if (MetaDataHelper.isAutomatic(modelType)) continue;
                if (n == DataUsagePanel.this.USAGE_INPUT) {
                    object3 = (String)object;
                    if (((String)object3).equals(BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO"))) {
                        miningAttributeType3.setInput("Yes");
                    } else if (((String)object3).equals(BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE"))) {
                        miningAttributeType3.setInput("No");
                    } else if (((String)object3).equals(BuildEditorLrb.get("DATA_USAGE_INPUT_FORCE")) && modelType instanceof CGeneralizedLinearModelType) {
                        miningAttributeType3.setInput(DataUsagePanel.FORCE);
                    } else if (((String)object3).equals(MULTI_SELECT_RES)) {
                        object2 = this.cachedModels.get(modelType2.getId());
                        miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, (ModelType)object2);
                        miningAttributeType3.setInput(miningAttributeType2.getInput());
                    }
                } else if (n == DataUsagePanel.this.USAGE_MINING_TYPE) {
                    object3 = (String)object;
                    if (((String)object3).equals(CATEGORICAL)) {
                        miningAttributeType3.setMiningType("Categorical");
                        if (modelType instanceof PCAModelType) {
                            miningAttributeType3.setInput("No");
                        }
                    } else if (((String)object3).equals(NUMERICAL)) {
                        miningAttributeType3.setMiningType("Numerical");
                    } else if (((String)object3).equals(TEXT)) {
                        miningAttributeType3.setMiningType("Text");
                        if (modelType instanceof OClusterModelType) {
                            miningAttributeType3.setInput("No");
                        }
                    } else if (((String)object3).equals(TEXT_CUSTOM) || ((String)object3).equals(TEXT_CUSTOM_EDIT)) {
                        TextTransColumnSettingPanel textTransColumnSettingPanel;
                        object2 = DataUsagePanel.this;
                        miningAttributeType2 = DataUsagePanel.this.getMetadataCopy();
                        List<MiningAttributeType> list = ((DataUsagePanel)object2).getSelectedAttributes();
                        if (list.size() > 0 && (textTransColumnSettingPanel = new TextTransColumnSettingPanel(this.context, DataUsagePanel.this.getWorkflowNode(), (BuildNodeType)miningAttributeType2, list.get(0).getName())).showAsDialog(DataUsagePanel.this) && textTransColumnSettingPanel.isDirty()) {
                            BuildNodeType.Stoplists stoplists = textTransColumnSettingPanel.getStoplists();
                            TransformedAttributesType transformedAttributesType = textTransColumnSettingPanel.getTextAttributes();
                            miningAttributeType2.setStoplists(stoplists);
                            miningAttributeType2.setTextAttributes(transformedAttributesType);
                            miningAttributeType3.setMiningType("TextCustom");
                            DataUsagePanel.this.isDirty = true;
                        }
                    } else if (((String)object3).equals(MULTI_SELECT_RES)) {
                        object2 = this.cachedModels.get(modelType2.getId());
                        miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, (ModelType)object2);
                        miningAttributeType3.setMiningType(miningAttributeType2.getMiningType());
                    }
                }
                if (this.isStandalone()) {
                    MetaDataHelper.copyMiningAttributeType(miningAttributeType3, miningAttributeType, true);
                    continue;
                }
                this.updateModelAttributes(miningAttributeType3, modelType2);
            }
        }

        public void updateModelAttributes(MiningAttributeType miningAttributeType, ModelType modelType) {
            if (this.metadataCopy instanceof ClusteringBuildNodeType) {
                ClusteringBuildNodeType.Models models = ((ClusteringBuildNodeType)this.metadataCopy).getModels();
                if (modelType instanceof ExpectationMaximizationModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getExpectationMaximizationModel(), miningAttributeType);
                } else if (modelType instanceof KMeansModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getKMeansModel(), miningAttributeType);
                } else if (modelType instanceof OClusterModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getOClusterModel(), miningAttributeType);
                }
            } else if (this.metadataCopy instanceof AnomalyDetectionBuildNodeType) {
                AnomalyDetectionBuildNodeType.Models models = ((AnomalyDetectionBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getAnomalyDetectionModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof AssociationBuildNodeType) {
                AssociationBuildNodeType.Models models = ((AssociationBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getAprioriModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof FeatureExtractionBuildNodeType) {
                FeatureExtractionBuildNodeType.Models models = ((FeatureExtractionBuildNodeType)this.metadataCopy).getModels();
                if (modelType instanceof NonNegativeMatrixFactorModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getNonNegativeMatrixFactorModel(), miningAttributeType);
                } else if (modelType instanceof PCAModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getPCAModel(), miningAttributeType);
                } else if (modelType instanceof SVDModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getSVDModel(), miningAttributeType);
                }
            } else if (this.metadataCopy instanceof ClassificationBuildNodeType) {
                ClassificationBuildNodeType.Models models = ((ClassificationBuildNodeType)this.metadataCopy).getModels();
                if (modelType instanceof CGeneralizedLinearModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getCGeneralizedLinearModel(), miningAttributeType);
                } else if (modelType instanceof CSupportVectorMachineModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getCSupportVectorMachineModel(), miningAttributeType);
                } else if (modelType instanceof DecisionTreeModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getDecisionTreeModel(), miningAttributeType);
                } else if (modelType instanceof NaiveBayesModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getNaiveBayesModel(), miningAttributeType);
                }
            } else if (this.metadataCopy instanceof RegressionBuildNodeType) {
                RegressionBuildNodeType.Models models = ((RegressionBuildNodeType)this.metadataCopy).getModels();
                if (modelType instanceof RGeneralizedLinearModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getRGeneralizedLinearModel(), miningAttributeType);
                } else if (modelType instanceof RSupportVectorMachineModelType) {
                    MetaDataHelper.replaceAttributeInModel(models.getRSupportVectorMachineModel(), miningAttributeType);
                }
            } else if (this.metadataCopy instanceof ExplicitFeatureExtractionBuildNodeType) {
                ExplicitFeatureExtractionBuildNodeType.Models models = ((ExplicitFeatureExtractionBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getExplicitSemanticAnalysisModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof RBuildNodeType) {
                RBuildNodeType.Models models = ((RBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getRModel(), miningAttributeType);
            }
        }

        private void updateModelAttributes(MiningAttributeType miningAttributeType) {
            if (this.metadataCopy instanceof ClusteringBuildNodeType) {
                ClusteringBuildNodeType.Models models = ((ClusteringBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getExpectationMaximizationModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getKMeansModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getOClusterModel(), miningAttributeType);
                if (models.getOClusterModel() != null) {
                    MetaDataHelper.disableModelInputsWithMiningType(models.getOClusterModel(), "Text");
                }
            } else if (this.metadataCopy instanceof AnomalyDetectionBuildNodeType) {
                AnomalyDetectionBuildNodeType.Models models = ((AnomalyDetectionBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getAnomalyDetectionModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof AssociationBuildNodeType) {
                AssociationBuildNodeType.Models models = ((AssociationBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getAprioriModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof FeatureExtractionBuildNodeType) {
                FeatureExtractionBuildNodeType.Models models = ((FeatureExtractionBuildNodeType)this.metadataCopy).getModels();
                String string = miningAttributeType.getInput();
                if (miningAttributeType.getMiningType().equals("Categorical") && (miningAttributeType.getDataType().equals("CHAR") || miningAttributeType.getDataType().equals("VARCHAR2"))) {
                    miningAttributeType.setInput("No");
                }
                MetaDataHelper.replaceAttributeInModel(models.getNonNegativeMatrixFactorModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getPCAModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getSVDModel(), miningAttributeType);
                if (this.isStandalone()) {
                    miningAttributeType.setInput(string);
                }
            } else if (this.metadataCopy instanceof ClassificationBuildNodeType) {
                ClassificationBuildNodeType.Models models = ((ClassificationBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getCGeneralizedLinearModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getCSupportVectorMachineModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getDecisionTreeModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getNaiveBayesModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof RegressionBuildNodeType) {
                RegressionBuildNodeType.Models models = ((RegressionBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getRGeneralizedLinearModel(), miningAttributeType);
                MetaDataHelper.replaceAttributeInModel(models.getRSupportVectorMachineModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof ExplicitFeatureExtractionBuildNodeType) {
                ExplicitFeatureExtractionBuildNodeType.Models models = ((ExplicitFeatureExtractionBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getExplicitSemanticAnalysisModel(), miningAttributeType);
            } else if (this.metadataCopy instanceof RBuildNodeType) {
                RBuildNodeType.Models models = ((RBuildNodeType)this.metadataCopy).getModels();
                MetaDataHelper.replaceAttributeInModel(models.getRModel(), miningAttributeType);
            }
        }

        private void setAttributeValue(Object object, int n, MiningAttributeType miningAttributeType) {
            Object object2;
            if (n == DataUsagePanel.this.USAGE_ADP) {
                object2 = (TriStateCheckBox.State)object;
                if (object2 == TriStateCheckBox.State.TRUE) {
                    miningAttributeType.setAutoPrep("Yes");
                } else if (object2 == TriStateCheckBox.State.FALSE) {
                    miningAttributeType.setAutoPrep("No");
                }
            }
            if (this.miningAttributes.getAutoSpec() == null || this.miningAttributes.getAutoSpec().value().equals(AutoSpecType.YES.value())) {
                return;
            }
            if (n == DataUsagePanel.this.USAGE_INPUT) {
                object2 = (String)object;
                if (((String)object2).equals(BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO"))) {
                    miningAttributeType.setInput("Yes");
                } else if (((String)object2).equals(BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE"))) {
                    miningAttributeType.setInput("No");
                }
            } else if (n == DataUsagePanel.this.USAGE_MINING_TYPE) {
                object2 = (String)object;
                if (((String)object2).equals(CATEGORICAL)) {
                    miningAttributeType.setMiningType("Categorical");
                } else if (((String)object2).equals(NUMERICAL)) {
                    miningAttributeType.setMiningType("Numerical");
                } else if (((String)object2).equals(TEXT)) {
                    miningAttributeType.setMiningType("Text");
                } else if (((String)object2).equals(TEXT_CUSTOM) || ((String)object2).equals(TEXT_CUSTOM_EDIT)) {
                    TextTransColumnSettingPanel textTransColumnSettingPanel;
                    DataUsagePanel dataUsagePanel = DataUsagePanel.this;
                    BuildNodeType buildNodeType = DataUsagePanel.this.getMetadataCopy();
                    List<MiningAttributeType> list = dataUsagePanel.getSelectedAttributes();
                    if (list.size() > 0 && (textTransColumnSettingPanel = new TextTransColumnSettingPanel(this.context, DataUsagePanel.this.getWorkflowNode(), buildNodeType, list.get(0).getName())).showAsDialog(DataUsagePanel.this) && textTransColumnSettingPanel.isDirty()) {
                        BuildNodeType.Stoplists stoplists = textTransColumnSettingPanel.getStoplists();
                        TransformedAttributesType transformedAttributesType = textTransColumnSettingPanel.getTextAttributes();
                        buildNodeType.setStoplists(stoplists);
                        buildNodeType.setTextAttributes(transformedAttributesType);
                        miningAttributeType.setMiningType("TextCustom");
                        DataUsagePanel.this.isDirty = true;
                    }
                }
                if (AbstractBuildNode.isInputAllowed(miningAttributeType, null, DataUsagePanel.this.getDbVersion())) {
                    miningAttributeType.setInput("Yes");
                } else {
                    miningAttributeType.setInput("No");
                }
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != DataUsagePanel.this.USAGE_INPUT && n2 != DataUsagePanel.this.USAGE_ADP && n2 != DataUsagePanel.this.USAGE_MINING_TYPE) {
                assert (false) : "Unexpected column";
                return;
            }
            List<MiningAttributeType> list = this.getMiningAttributes();
            MiningAttributeType miningAttributeType = list.get(n);
            if (n2 == DataUsagePanel.this.USAGE_INPUT) {
                if (object.equals(BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO")) && miningAttributeType.getInput().equals("Yes")) {
                    return;
                }
                if (object.equals(BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE")) && miningAttributeType.getMiningType().equals("No")) {
                    return;
                }
            } else if (n2 == DataUsagePanel.this.USAGE_MINING_TYPE && miningAttributeType.getMiningType().equals(object)) {
                return;
            }
            if (this.isStandalone()) {
                this.setAttributeValue(object, n2, miningAttributeType);
                if (this.metadataCopy != null) {
                    this.updateModelAttributes(miningAttributeType);
                }
            } else {
                this.setModelAttributeValue(object, n2, miningAttributeType);
            }
            if (n2 == DataUsagePanel.this.USAGE_MINING_TYPE) {
                DataUsagePanel.this.generateUIRulesMessages();
            }
            this.fireTableCellUpdated(n, n2);
            DataUsagePanel.this.setDirty();
        }

        public MiningAttributeType getRowData(int n) {
            List<MiningAttributeType> list = this.getMiningAttributes();
            MiningAttributeType miningAttributeType = list.get(n);
            return miningAttributeType;
        }

        public void updateAttributesInModel(List<MiningAttributeType> list, ModelType modelType, int n, String string) {
            assert (!this.isStandalone());
            for (MiningAttributeType miningAttributeType : list) {
                MiningAttributeType miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType);
                String string2 = string;
                if (string.equalsIgnoreCase("Yes") && !AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, DataUsagePanel.this.getDbVersion())) {
                    string2 = "No";
                } else if (string.equalsIgnoreCase("No")) {
                    if (DataUsagePanel.this.targetAttributes.containsKey(miningAttributeType.getName()) && MetaDataHelper.isTargetInputAllowed(modelType)) {
                        string2 = "Yes";
                    }
                    if (DataUsagePanel.this.partitionAttributes.containsKey(miningAttributeType.getName())) {
                        string2 = "Yes";
                    }
                } else if (string.equalsIgnoreCase("Yes") && DataUsagePanel.this.caseAttributes.containsKey(miningAttributeType.getName()) && !MetaDataHelper.isCaseIdInputAllowed(modelType)) {
                    string2 = "No";
                }
                if (n == DataUsagePanel.this.USAGE_INPUT) {
                    miningAttributeType2.setInput(string2);
                }
                if (n != DataUsagePanel.this.USAGE_ADP) continue;
                miningAttributeType2.setAutoPrep(string2);
            }
        }

        public List<? extends Object> getDataList() {
            if (this.isStandalone()) {
                return this.miningAttributes.getMiningAttribute();
            }
            return this.models;
        }

        private String getCommonAttrValue(int n, MiningAttributeType miningAttributeType, Collection<ModelType> collection) {
            String string = null;
            boolean bl = true;
            for (ModelType modelType : collection) {
                MiningAttributeType miningAttributeType2;
                ModelType modelType2 = DataUsagePanel.this.findEditedModel(modelType);
                if (modelType2 == null) {
                    modelType2 = modelType;
                }
                if ((miningAttributeType2 = MetaDataHelper.findModelAttribute(miningAttributeType, modelType2)) == null) {
                    return null;
                }
                if (n == DataUsagePanel.this.USAGE_INPUT) {
                    if (null == string) {
                        string = miningAttributeType2.getInput();
                    }
                    if (!miningAttributeType2.getInput().equals(string)) {
                        bl = false;
                        break;
                    }
                } else if (n == DataUsagePanel.this.USAGE_ADP) {
                    if (null == string) {
                        string = miningAttributeType2.getAutoPrep();
                    }
                    if (!miningAttributeType2.getAutoPrep().equals(string)) {
                        bl = false;
                        break;
                    }
                }
                if (n != DataUsagePanel.this.USAGE_MINING_TYPE) continue;
                if (null == string) {
                    string = miningAttributeType2.getMiningType();
                }
                if (miningAttributeType2.getMiningType().equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return string;
            }
            return MULTI_SELECT_RES;
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return AttributeTypeComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        @Override
        public int getColumnAutoSizeMaximum(int n) {
            int n2 = super.getColumnAutoSizeMaximum(n);
            if (n == DataUsagePanel.this.USAGE_ATTRIBUTE_NAME) {
                n2 = 300;
            }
            return n2;
        }
    }

    private static class TriStateCheckCellRenderer
    extends TriStateTableRenderer
    implements TransferableRenderer {
        private String transferableStringValue;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof TriStateCheckBox.State) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = jTable.convertRowIndexToModel(n);
                int n4 = jTable.convertColumnIndexToModel(n2);
                boolean bl3 = jTable.getModel().isCellEditable(n3, n4);
                component.setEnabled(bl3);
                TriStateCheckBox.State state = (TriStateCheckBox.State)object;
                if (state == TriStateCheckBox.State.TRUE) {
                    this.transferableStringValue = BuildEditorLrb.get("DATA_USAGE_ADP_YES");
                } else if (state == TriStateCheckBox.State.FALSE) {
                    this.transferableStringValue = BuildEditorLrb.get("DATA_USAGE_ADP_NO");
                } else if (state == TriStateCheckBox.State.PARTIAL) {
                    this.transferableStringValue = MULTI_SELECT_RES;
                }
                return component;
            }
            JLabel jLabel = new JLabel((String)object);
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        @Override
        public String getTransferrableStringValue() {
            return this.transferableStringValue;
        }
    }

    class TriStateCheckCellEditor
    extends TriStateCellEditor {
        public TriStateCheckCellEditor() {
            this(new TriStateCheckBox());
        }

        public TriStateCheckCellEditor(TriStateCheckBox triStateCheckBox) {
            super(triStateCheckBox);
            triStateCheckBox.setOpaque(true);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            UsageTableModel usageTableModel = (UsageTableModel)((Object)jTable.getModel());
            MiningAttributeType miningAttributeType = (MiningAttributeType)usageTableModel.getValueAt(n, 0);
            if (n2 == DataUsagePanel.this.USAGE_ADP) {
                ((TriStateCheckBox)component).setCanUserSetPartial(usageTableModel.isAllowedAdpPartial(miningAttributeType.getName()));
            }
            component.setBackground(jTable.getSelectionBackground());
            component.setForeground(jTable.getSelectionForeground());
            return component;
        }
    }

    private static class MiningTypeRenderer
    extends DefaultTableCellRenderer
    implements TransferableRenderer {
        private String transferableStringValue;

        public MiningTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            String string = (String)object;
            int n3 = jTable.convertRowIndexToModel(n);
            int n4 = jTable.convertColumnIndexToModel(n2);
            boolean bl3 = jTable.getModel().isCellEditable(n3, n4);
            this.setEnabled(bl3);
            if (string.equals("Categorical")) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CATEGORICAL));
                this.transferableStringValue = CATEGORICAL;
            } else if (string.equals("Numerical")) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_NUMERICAL));
                this.transferableStringValue = NUMERICAL;
            } else if (string.equals("Text")) {
                this.setIcon(OracleIcons.getIcon((String)"openbook.png"));
                this.transferableStringValue = TEXT_CUSTOM_EDIT;
            } else if (string.equals("TextCustom")) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CUSTOM_TEXT));
                this.transferableStringValue = TEXT_CUSTOM;
            } else if (string.equals(MULTI_SELECT_RES)) {
                this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
                this.transferableStringValue = MULTI_SELECT_RES;
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }

        @Override
        public String getTransferrableStringValue() {
            return this.transferableStringValue;
        }
    }

    private static class MiningTypeComboRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (string.equals(NUMERICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_NUMERICAL));
            } else if (string.equals(CATEGORICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CATEGORICAL));
            } else if (string.equals(TEXT)) {
                this.setIcon(OracleIcons.getIcon((String)"openbook.png"));
            } else if (string.equals(TEXT_CUSTOM)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CUSTOM_TEXT));
            } else if (string.equals(MULTI_SELECT_RES)) {
                this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    class MiningTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private String currentValue;
        private JComboBox<String> comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public MiningTypeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
            this.comboComponent.setRenderer(new MiningTypeComboRenderer());
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (String)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = (String)object;
            boolean bl2 = this.currentValue.equals(MULTI_SELECT_RES);
            TableModel tableModel = jTable.getModel();
            MiningAttributeType miningAttributeType = (MiningAttributeType)tableModel.getValueAt(jTable.convertRowIndexToModel(n), 0);
            this.comboComponent.removeAllItems();
            List<String> list = DataUsagePanel.this.getAvailableMiningTypes(miningAttributeType.getDataType());
            for (String string : list) {
                if (string.equals(TEXT) && !DataUsagePanel.this.isTextVisible) continue;
                this.comboComponent.addItem(string);
            }
            if (list.contains(TEXT) && DataUsagePanel.this.isTextVisible) {
                if (miningAttributeType.getMiningType().equals("TextCustom")) {
                    this.comboComponent.addItem(TEXT_CUSTOM_EDIT);
                } else {
                    this.comboComponent.addItem(TEXT_CUSTOM);
                }
            }
            if (miningAttributeType.getMiningType().equals("TextCustom")) {
                this.comboComponent.setSelectedItem(TEXT_CUSTOM_EDIT);
            } else if (!bl2) {
                if (miningAttributeType.getMiningType().equals("Numerical")) {
                    this.comboComponent.setSelectedItem(NUMERICAL);
                } else if (miningAttributeType.getMiningType().equals("Categorical")) {
                    this.comboComponent.setSelectedItem(CATEGORICAL);
                } else if (miningAttributeType.getMiningType().equals("Text")) {
                    this.comboComponent.setSelectedItem(TEXT);
                }
            }
            if (bl2) {
                this.comboComponent.addItem(MULTI_SELECT_RES);
                this.comboComponent.setSelectedItem(MULTI_SELECT_RES);
            }
            return this.comboComponent;
        }
    }

    class InputTypeRenderer
    extends DefaultTableCellRenderer
    implements TransferableRenderer {
        private String transferableString;

        public InputTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            MiningAttributeType miningAttributeType;
            List<ModelType> list;
            if (object == null) {
                return this;
            }
            String string = (String)object;
            int n3 = jTable.convertRowIndexToModel(n);
            int n4 = jTable.convertColumnIndexToModel(n2);
            boolean bl3 = jTable.getModel().isCellEditable(n3, n4);
            this.setEnabled(bl3);
            boolean bl4 = false;
            if (DataUsagePanel.this.isStandalone && (list = MetaDataHelper.getModelsCollection(DataUsagePanel.this.getMetadataCopy())) != null && list.size() > 0 && !DataUsagePanel.attributesHaveInputValue(list, string, (miningAttributeType = (MiningAttributeType)jTable.getModel().getValueAt(n3, 0)).getName(), true)) {
                this.setIcon(OracleIcons.getIcon((String)"dependency.png"));
                this.transferableString = BuildEditorLrb.get("DATA_USAGE_INPUT_SOME");
                bl4 = true;
            }
            if (!bl4) {
                if (string.equals("Yes")) {
                    this.setIcon(OracleIcons.getIcon((String)"messageAsync.png"));
                    this.transferableString = BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO");
                } else if (string.equals("No")) {
                    this.setIcon(DataMinerIcons.get(Icons.ATTR_IGNORE));
                    this.transferableString = BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE");
                } else if (string.equals(DataUsagePanel.FORCE)) {
                    this.setIcon(DataMinerIcons.get(Icons.FILTER_ATTR_INCLUDE_FORCE));
                    this.transferableString = BuildEditorLrb.get("DATA_USAGE_INPUT_FORCE");
                } else if (string.equals(MULTI_SELECT_RES)) {
                    this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
                    this.transferableString = MULTI_SELECT_RES;
                }
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }

        @Override
        public String getTransferrableStringValue() {
            return this.transferableString;
        }
    }

    class InputTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private String currentValue;
        private JComboBox<String> comboComponent = new JComboBox();
        protected static final String EDIT = "edit";
        private boolean bEditable = true;

        public InputTypeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
            this.comboComponent.setRenderer(new InputEditComboRenderer());
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public void setEditable(boolean bl) {
            this.bEditable = bl;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return this.bEditable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (String)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = (String)object;
            boolean bl2 = this.currentValue.equals(MULTI_SELECT_RES);
            UsageTableModel usageTableModel = (UsageTableModel)((Object)jTable.getModel());
            boolean bl3 = false;
            if (DbVersionHelper.isDB121Up((Version)DataUsagePanel.this.getDbVersion()) && !DataUsagePanel.this.isStandalone()) {
                List<? extends Object> list = usageTableModel.getDataList();
                for (ModelType modelType : list) {
                    if (!(modelType instanceof CGeneralizedLinearModelType)) continue;
                    bl3 = true;
                    break;
                }
            }
            this.comboComponent.removeAllItems();
            this.comboComponent.addItem(BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO"));
            this.comboComponent.addItem(BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE"));
            if (bl3) {
                this.comboComponent.addItem(BuildEditorLrb.get("DATA_USAGE_INPUT_FORCE"));
            }
            if (bl2 && !DataUsagePanel.this.isStandalone()) {
                this.comboComponent.addItem(MULTI_SELECT_RES);
            }
            return this.comboComponent;
        }

        class InputEditComboRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                this.setText(string);
                if (string.equals(BuildEditorLrb.get("DATA_USAGE_INPUT_AUTO"))) {
                    this.setIcon(OracleIcons.getIcon((String)"messageAsync.png"));
                } else if (string.equals(BuildEditorLrb.get("DATA_USAGE_INPUT_IGNORE"))) {
                    this.setIcon(DataMinerIcons.get(Icons.ATTR_IGNORE));
                } else if (string.equals(BuildEditorLrb.get("DATA_USAGE_INPUT_FORCE"))) {
                    this.setIcon(DataMinerIcons.get(Icons.FILTER_ATTR_INCLUDE_FORCE));
                } else if (string.equals(MULTI_SELECT_RES)) {
                    this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
                }
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                return this;
            }
        }
    }
}

