/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class AddTargetsPanel
extends DialogDisplayer<AbstractNode> {
    private List<MiningAttributeType> availAttrsCache;
    private List<MiningAttributeType> selectedAttrsCache;
    private boolean _dirty = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jSelectedLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;

    public AddTargetsPanel(Context context, AbstractNode abstractNode, MiningAttributes miningAttributes, TargetAttributes targetAttributes, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions) {
        super(context, abstractNode);
        MiningAttributeType miningAttributeType;
        Object object2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (caseAttributes != null && !caseAttributes.getAttribute().isEmpty()) {
            for (Object object2 : caseAttributes.getAttribute()) {
                hashMap.put(object2.getName(), (AttributeType)object2);
            }
        }
        if (partitionExpressions != null && !partitionExpressions.getPartitionExpression().isEmpty()) {
            for (Object object2 : partitionExpressions.getPartitionExpression()) {
                if (null != object2.getSQLExpression()) continue;
                hashMap.put(object2.getPartitionAttribute().getName(), object2.getPartitionAttribute());
            }
        }
        this.availAttrsCache = new ArrayList<MiningAttributeType>();
        List list = miningAttributes.getMiningAttribute();
        object2 = list.iterator();
        while (object2.hasNext()) {
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)object2.next();
            if (!DbMetadataUtils.isDynamicTargetDataTypeSupported((String)miningAttributeType2.getDataType()) && !DatabaseMetadataUtils.isDynamicPredictionNodeTypeSupported(this.getContext(), miningAttributeType2.getDataType()) || !hashMap.isEmpty() && null != hashMap.get(miningAttributeType2.getName())) continue;
            miningAttributeType = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType2);
            this.availAttrsCache.add(miningAttributeType);
        }
        Collections.sort(this.availAttrsCache, AttributeTypeComparator.getComparator());
        this.selectedAttrsCache = new ArrayList<MiningAttributeType>();
        for (MiningAttributeType miningAttributeType2 : targetAttributes.getMiningAttribute()) {
            miningAttributeType = (MiningAttributeType)MetaDataHelper.copyMetadataObject(miningAttributeType2);
            this.selectedAttrsCache.add(miningAttributeType);
        }
        Collections.sort(this.selectedAttrsCache, AttributeTypeComparator.getComparator());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jAvailableLabel.setLabelFor(this.jAvailAttrsScrollPane);
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setLabelFor(this.jSelectedAttrsScrollPane);
        this.jSelectedLabel.setText("Selected Attributes");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 277, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 289, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 289, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 210, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 210, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DataDialogsLrb.get("AVAILABLE_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DataDialogsLrb.get("SELECTED_LABEL"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"apply_supplemental");
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        AttrTableModel<MiningAttributeType> attrTableModel = new AttrTableModel<MiningAttributeType>(this.availAttrsCache);
        this.jAvailAttrs.setModel((TableModel)((Object)attrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        AttrTableModel<MiningAttributeType> attrTableModel2 = new AttrTableModel<MiningAttributeType>(this.selectedAttrsCache);
        this.jSelectedAttrs.setModel((TableModel)((Object)attrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTargetsPanel.this.moveItems(AddTargetsPanel.this.jAvailAttrs, AddTargetsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTargetsPanel.this.moveItems(AddTargetsPanel.this.jAvailAttrs, AddTargetsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTargetsPanel.this.moveItems(AddTargetsPanel.this.jSelectedAttrs, AddTargetsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddTargetsPanel.this.moveItems(AddTargetsPanel.this.jSelectedAttrs, AddTargetsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = (MiningAttributeType)list.get(nArray[n2]);
                arrayList.add((MiningAttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add((MiningAttributeType)list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (MiningAttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<MiningAttributeType> list, List<MiningAttributeType> list2) {
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        Iterator<MiningAttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            MiningAttributeType miningAttributeType;
            miningAttributeType = iterator.next();
            MiningAttributeType miningAttributeType2 = (MiningAttributeType)hashMap.get(miningAttributeType.getName());
            if (miningAttributeType2 == null || !miningAttributeType2.getName().equals(miningAttributeType.getName()) || !miningAttributeType2.getDataType().equals(miningAttributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<MiningAttributeType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return PredictionLrb.get("PREDICTION_ADD_TARGET_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "dynamic_prediction_node_add_target";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(650, 300));
    }
}

