/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.NumberCellEditor;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.model.clas.common.PriorsInfo;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTableHeaderRenderer;

public class PerformancePriorsPanel
extends AbstractPropertiesDialogPanel
implements ActionListener {
    private DataMinerTable coefficienstTable;
    private JButton jBtnBalanced;
    private JButton jBtnNatural;
    private JCheckBox jChkBoxUsePriors;
    private JPanel jContent;
    private JLabel jLblGenerate;
    private JRadioButton jRadioBtnBalanced;
    private JRadioButton jRadioBtnCustom;
    private JRadioButton jRadioBtnMaxOverall;
    private JScrollPane jScrollPaneCoeffis;
    private String _displayAlgorithm;
    private static final int PERFORMANCE_COLUMN_COUNT = 2;
    private static final int PERFORMANCE_TARGET_VALUE = 0;
    private static final int PERFORMANCE_DISTRIBUTION = 1;
    private static String[] _performance_columnNames = new String[]{DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), DialogsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};
    private static final int WEIGHT_COLUMN_COUNT = 2;
    private static final int WEIGHT_TARGET_VALUE = 0;
    private static final int WEIGHT_VALUE = 1;
    private static String[] _weight_columnNames = new String[]{DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), DialogsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};

    public PerformancePriorsPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioBtnBalanced = new JRadioButton();
        this.jRadioBtnMaxOverall = new JRadioButton();
        this.jRadioBtnCustom = new JRadioButton();
        this.jContent = new JPanel();
        this.jChkBoxUsePriors = new JCheckBox();
        this.jScrollPaneCoeffis = new JScrollPane();
        this.coefficienstTable = new DataMinerTable();
        this.jLblGenerate = new JLabel();
        this.jBtnBalanced = new JButton();
        this.jBtnNatural = new JButton();
        buttonGroup.add(this.jRadioBtnBalanced);
        buttonGroup.add(this.jRadioBtnMaxOverall);
        buttonGroup.add(this.jRadioBtnCustom);
        this.jRadioBtnBalanced.setText("Balanced");
        this.jRadioBtnBalanced.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnBalanced.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioBtnMaxOverall.setText("Natural");
        this.jRadioBtnMaxOverall.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnMaxOverall.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioBtnCustom.setText("Custom");
        this.jRadioBtnCustom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioBtnCustom.setMargin(new Insets(0, 0, 0, 0));
        this.jContent.setBorder(BorderFactory.createTitledBorder("Weights"));
        this.jChkBoxUsePriors.setText("Use Priors");
        this.jChkBoxUsePriors.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkBoxUsePriors.setMargin(new Insets(0, 0, 0, 0));
        this.coefficienstTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneCoeffis.setViewportView((Component)((Object)this.coefficienstTable));
        this.jLblGenerate.setText("Generate");
        this.jBtnBalanced.setText("jButton1");
        this.jBtnBalanced.setActionCommand("Balanced");
        this.jBtnNatural.setText("Natural");
        GroupLayout groupLayout = new GroupLayout(this.jContent);
        this.jContent.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jScrollPaneCoeffis, -1, 373, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChkBoxUsePriors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE).addComponent(this.jLblGenerate, -2, 57, -2).addGap(19, 19, 19).addComponent(this.jBtnBalanced).addGap(17, 17, 17).addComponent(this.jBtnNatural))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jChkBoxUsePriors)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnNatural).addComponent(this.jBtnBalanced).addComponent(this.jLblGenerate)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCoeffis, -1, 216, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioBtnBalanced, -2, 171, -2).addComponent(this.jRadioBtnMaxOverall, -2, 171, -2).addComponent(this.jRadioBtnCustom, -2, 171, -2).addComponent(this.jContent, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.linkSize(0, this.jRadioBtnBalanced, this.jRadioBtnCustom, this.jRadioBtnMaxOverall);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRadioBtnBalanced).addGap(16, 16, 16).addComponent(this.jRadioBtnMaxOverall).addGap(14, 14, 14).addComponent(this.jRadioBtnCustom).addGap(14, 14, 14).addComponent(this.jContent, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.linkSize(1, this.jRadioBtnBalanced, this.jRadioBtnCustom, this.jRadioBtnMaxOverall);
    }

    protected final ModelPropertiesState getState() {
        return (ModelPropertiesState)super.getDialogState();
    }

    private void initUI() {
        this._displayAlgorithm = this.getState().getAlgorithm();
        String string = this.getState().getOriginalPerformanceOption();
        this.jRadioBtnBalanced.setText(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_BALANCED"));
        this.jRadioBtnMaxOverall.setText(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_NATURAL"));
        this.jRadioBtnCustom.setText(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_CUSTOM"));
        this.jRadioBtnBalanced.addActionListener(this);
        this.jRadioBtnCustom.addActionListener(this);
        this.jRadioBtnMaxOverall.addActionListener(this);
        this.jLblGenerate.setText(DialogsLrb.get("PERFORMANCE_WEIGHTS_GENERATE_BUTTON"));
        this.jBtnBalanced.setText(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_BALANCED"));
        this.jBtnBalanced.addActionListener(this);
        this.jBtnNatural.setText(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_NATURAL"));
        this.jBtnNatural.addActionListener(this);
        this.jChkBoxUsePriors.setText(DialogsLrb.get("PRIORS_PANEL_USE_PRIORS_FOR_MODEL_BUILD"));
        this.jChkBoxUsePriors.addActionListener(this);
        if (ServerConstants.BuildSettingPerformanceOption.isBalanced((String)string)) {
            this.jRadioBtnBalanced.setSelected(true);
            this.balancedOptionSelected();
        } else if (ServerConstants.BuildSettingPerformanceOption.isNatural((String)string)) {
            this.jRadioBtnMaxOverall.setSelected(true);
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
                this.jLblGenerate.setVisible(false);
                this.jBtnBalanced.setVisible(false);
                this.jBtnNatural.setVisible(false);
                this.jContent.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("PERFORMANCE_PRIORS_BORDER_TITLE")));
                if (this.getState().hasPriors()) {
                    this.jChkBoxUsePriors.setSelected(true);
                    this.loadPriorsTable();
                    this.coefficienstTable.setEnabled(true);
                } else {
                    this.jChkBoxUsePriors.setSelected(false);
                    this.loadPriorsTable();
                    this.coefficienstTable.setEnabled(false);
                }
            } else {
                this.balancedOptionSelected();
            }
        } else if (ServerConstants.BuildSettingPerformanceOption.isCustom((String)string)) {
            this.jRadioBtnCustom.setSelected(true);
            this.jLblGenerate.setVisible(false);
            this.jBtnBalanced.setVisible(false);
            this.jBtnNatural.setVisible(false);
            this.jBtnBalanced.setEnabled(this.getState().isDataSourcePresent());
            this.jBtnNatural.setEnabled(this.getState().isDataSourcePresent());
            this.loadWeightTable();
            this.jChkBoxUsePriors.setVisible(false);
            this.jContent.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
        }
        this.getState().setBackupValue("BUILD_SETTING_PERFORM_OPTION", string);
    }

    private void loadPriorsTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new PriorsStatisticsModel(this.getState().getResultPriorsInfo())));
        GenericTableHeaderRenderer genericTableHeaderRenderer = (GenericTableHeaderRenderer)this.coefficienstTable.getTableHeader().getDefaultRenderer();
        genericTableHeaderRenderer.setHorizontalAlignment(0);
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    private void loadWeightTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new WeightSettingsModel(this.getState().getResultPerformanceInfo())));
        GenericTableHeaderRenderer genericTableHeaderRenderer = (GenericTableHeaderRenderer)this.coefficienstTable.getTableHeader().getDefaultRenderer();
        genericTableHeaderRenderer.setHorizontalAlignment(0);
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    private void loadEmptyWeightTable() {
        this.coefficienstTable.setModel((TableModel)((Object)new WeightSettingsModel(null)));
        GenericTableHeaderRenderer genericTableHeaderRenderer = (GenericTableHeaderRenderer)this.coefficienstTable.getTableHeader().getDefaultRenderer();
        genericTableHeaderRenderer.setHorizontalAlignment(0);
        this.coefficienstTable.setSorted(false);
        this.coefficienstTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = this.coefficienstTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new NumberCellEditor());
    }

    @Override
    public void processInput() {
        if (this.jRadioBtnBalanced.isSelected()) {
            this.getState().setBalancedPerformanceInfo();
        } else if (this.jRadioBtnMaxOverall.isSelected()) {
            this.getState().setNaturalPerformanceInfo();
        } else {
            this.getState().setCustomPerformanceInfo();
        }
        PerformanceInfo performanceInfo = this.getState().getResultPerformanceInfo();
        if (performanceInfo.isCustom() && (null == performanceInfo.getValues() || performanceInfo.getValues().isEmpty())) {
            this.getState().setValidationError(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
            return;
        }
        this.getState().setValue("BUILD_SETTING_PERFORM_OPTION", performanceInfo.getPerformanceOption());
    }

    @Override
    public boolean isNewDataInput(boolean bl) throws ValidationException {
        String string = this.getState().getOriginalPerformanceOption();
        String string2 = null;
        AbstractTableModel abstractTableModel = null;
        if (this.jRadioBtnBalanced.isSelected()) {
            string2 = "BUILD_SETTING_PERFORM_OP_AVG";
        } else if (this.jRadioBtnMaxOverall.isSelected()) {
            string2 = "BUILD_SETTING_PERFORM_OP_OVRL";
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm) && (abstractTableModel = (AbstractTableModel)this.coefficienstTable.getModel()).getRowCount() < 1) {
                throw new ValidationException(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
            }
        } else {
            string2 = "BUILD_SETTING_PERFORM_OP_CUST";
            abstractTableModel = (AbstractTableModel)this.coefficienstTable.getModel();
            if (abstractTableModel.getRowCount() < 1) {
                throw new ValidationException(DialogsLrb.get("MODEL_PROPERTY_DLG_PERFORMANCE_EMPTY"));
            }
        }
        if (!bl) {
            return bl;
        }
        if (0 != string.compareTo(string2)) {
            return true;
        }
        PerformanceInfo performanceInfo = null;
        if (ServerConstants.BuildSettingPerformanceOption.isNatural((String)string)) {
            if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
                performanceInfo = this.getState().getOriginalPriorsInfo();
            }
        } else if (ServerConstants.BuildSettingPerformanceOption.isCustom((String)string)) {
            performanceInfo = this.getState().getOriginalPerformanceInfo();
        }
        if (performanceInfo == null) {
            return false;
        }
        List list = null;
        list = performanceInfo.getValues();
        if (list == null) {
            return false;
        }
        for (int i = 0; i < abstractTableModel.getRowCount(); ++i) {
            BigDecimal bigDecimal;
            String string3;
            NameValuePair nameValuePair = (NameValuePair)list.get(i);
            String string4 = (String)abstractTableModel.getValueAt(i, 0);
            if (0 != string4.compareTo(nameValuePair.getName())) {
                return true;
            }
            string4 = (String)abstractTableModel.getValueAt(i, 1);
            if (0 == string4.compareTo(string3 = NumericFormat.format((double)(bigDecimal = (BigDecimal)nameValuePair.getValue()).doubleValue(), (boolean)true, (int)8))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (jRadioButton.equals(this.jRadioBtnBalanced)) {
                this.balancedOptionSelected();
            } else if (jRadioButton.equals(this.jRadioBtnMaxOverall)) {
                this.naturalOptionSelected();
            } else if (jRadioButton.equals(this.jRadioBtnCustom)) {
                this.customOptionSelected();
            }
        } else if (object instanceof JCheckBox) {
            if (object.equals(this.jChkBoxUsePriors)) {
                if (this.jChkBoxUsePriors.isSelected()) {
                    this.getState().createCustomPriorsInfo();
                    this.loadPriorsTable();
                    this.coefficienstTable.setEnabled(true);
                } else if (this.getState().hasPriors()) {
                    if (MessageDialog.confirm((Component)this, (Object)DialogsLrb.get("PRIORS_PANEL_VALUE_REGENERATE"), (String)DialogsLrb.get("PRIORS_PANEL_VALUE_REGENERATE_CONFIRM"), null)) {
                        this.getState().clearPriors();
                        this.loadPriorsTable();
                        this.coefficienstTable.setEnabled(false);
                    } else {
                        this.jChkBoxUsePriors.setSelected(true);
                        this.coefficienstTable.setEnabled(true);
                    }
                }
            }
        } else if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            Boolean bl = null;
            if (jButton.equals(this.jBtnBalanced)) {
                bl = Boolean.TRUE;
            } else if (jButton.equals(this.jBtnNatural)) {
                bl = Boolean.FALSE;
            }
            if (bl != null) {
                boolean bl2 = true;
                if (this.getState().hasWeights()) {
                    bl2 = MessageDialog.confirm((Component)this, (Object)DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE_REGENERATE"), (String)DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE_REGENERATE_CONFIRM"), null);
                }
                if (bl2) {
                    this.getState().createCustomPerformanceInfo(bl);
                    this.loadWeightTable();
                    this.coefficienstTable.setEnabled(true);
                }
            }
        }
    }

    private void balancedOptionSelected() {
        this.loadEmptyWeightTable();
        this.coefficienstTable.setEnabled(false);
        this.jLblGenerate.setVisible(true);
        this.jBtnBalanced.setVisible(true);
        this.jBtnNatural.setVisible(true);
        this.jBtnBalanced.setEnabled(false);
        this.jBtnNatural.setEnabled(false);
        this.jChkBoxUsePriors.setVisible(false);
        this.jContent.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
    }

    private void naturalOptionSelected() {
        if (ServerConstants.Algorithm.isNB((String)this._displayAlgorithm)) {
            this.jLblGenerate.setVisible(false);
            this.jBtnBalanced.setVisible(false);
            this.jBtnNatural.setVisible(false);
            this.jChkBoxUsePriors.setVisible(true);
            this.jContent.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("PERFORMANCE_PRIORS_BORDER_TITLE")));
            if (this.getState().hasPriors()) {
                this.jChkBoxUsePriors.setSelected(true);
                this.loadPriorsTable();
                this.coefficienstTable.setEnabled(true);
            } else {
                this.jChkBoxUsePriors.setSelected(false);
                this.loadPriorsTable();
                this.coefficienstTable.setEnabled(false);
            }
        } else {
            this.balancedOptionSelected();
        }
    }

    private void customOptionSelected() {
        this.coefficienstTable.setEnabled(true);
        this.jLblGenerate.setVisible(true);
        this.jBtnBalanced.setVisible(true);
        this.jBtnNatural.setVisible(true);
        this.jBtnBalanced.setEnabled(this.getState().isDataSourcePresent());
        this.jBtnNatural.setEnabled(this.getState().isDataSourcePresent());
        this.loadWeightTable();
        this.jChkBoxUsePriors.setVisible(false);
        this.jContent.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("PERFORMANCE_WEIGHTS_BORDER_TITLE")));
    }

    class WeightSettingsModel
    extends SimpleBaseTableModel {
        public WeightSettingsModel(PerformanceInfo performanceInfo) {
            this.setColumnIdentifiers(_weight_columnNames);
            this.setRowCount(performanceInfo != null ? performanceInfo.getRowCount() : 0);
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            PerformanceInfo performanceInfo = PerformancePriorsPanel.this.getState().getResultPerformanceInfo();
            if (performanceInfo == null) {
                return null;
            }
            Object object = null;
            List list = performanceInfo.getValues();
            if (list == null) {
                return object;
            }
            switch (n2) {
                case 0: {
                    object = ((NameValuePair)list.get(n)).getName();
                    break;
                }
                case 1: {
                    object = NumericFormat.format((double)((BigDecimal)((NameValuePair)list.get(n)).getValue()).doubleValue(), (boolean)true, (int)8);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            PerformanceInfo performanceInfo = PerformancePriorsPanel.this.getState().getResultPerformanceInfo();
            List list = performanceInfo.getValues();
            if (list == null) {
                return;
            }
            NameValuePair nameValuePair = (NameValuePair)list.get(n);
            nameValuePair.setValue(object);
        }
    }

    class PriorsStatisticsModel
    extends SimpleBaseTableModel {
        public PriorsStatisticsModel(PriorsInfo priorsInfo) {
            this.setColumnIdentifiers(_performance_columnNames);
            this.setRowCount(priorsInfo != null ? priorsInfo.getRowCount() : 0);
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            PriorsInfo priorsInfo = PerformancePriorsPanel.this.getState().getResultPriorsInfo();
            if (priorsInfo == null) {
                return null;
            }
            Object object = null;
            List list = priorsInfo.getValues();
            if (list == null) {
                return object;
            }
            switch (n2) {
                case 0: {
                    object = ((NameValuePair)list.get(n)).getName();
                    break;
                }
                case 1: {
                    object = NumericFormat.format((double)((BigDecimal)((NameValuePair)list.get(n)).getValue()).doubleValue(), (boolean)true, (int)8);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            PriorsInfo priorsInfo = PerformancePriorsPanel.this.getState().getResultPriorsInfo();
            List list = priorsInfo.getValues();
            if (list == null) {
                return;
            }
            NameValuePair nameValuePair = (NameValuePair)list.get(n);
            nameValuePair.setValue(object);
        }
    }
}

