/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.SQLQuery;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.SQLQueryEditorPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;

public class SQLQuerySQLPanel
extends PIComponentPanel {
    private SQLQueryNode _targetNode;
    private String _SQL;
    private JButton _addBtn;
    private SearchField _jFilterCtl = new SearchField();
    private Component _findPane;
    private TextComponentSearchSupport _textSearchComponent;
    private ComponentWithTitlebar<JComponent> SQLComponentWithTitlebar;
    private TransparentPanel SQLTransparentPanel;
    private JLabel lblIncludeAllAvailableColumns;
    protected JTextPane _SQLTextArea = new JTextPane();

    public SQLQuerySQLPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
    }

    private void initUI() {
        SQLQueryNodeType sQLQueryNodeType;
        this._targetNode = (SQLQueryNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        SQLQueryNodeType sQLQueryNodeType2 = (SQLQueryNodeType)nodeType;
        this._SQL = sQLQueryNodeType2.getSQLQueryExpression();
        this._textSearchComponent = new TextComponentSearchSupport((JTextComponent)this._SQLTextArea);
        ControlBar controlBar = new ControlBar();
        this._addBtn = new JButton(InspectorArb.getIcon((int)24));
        controlBar.add((Component)this._addBtn);
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(CoreCommonLrb.get((String)"FIND"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                SQLQuerySQLPanel.this._textSearchComponent.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this._SQLTextArea.setText(this._SQL);
        this._SQLTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._SQLTextArea);
        this.SQLComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.SQLComponentWithTitlebar.setControlBar(controlBar);
        this.SQLComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("SQLQUERY_QUERY_DEFINITION_PI")));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQuerySQLPanel.this.processAdd();
            }
        });
        this._addBtn.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_EDIT"));
        this.lblIncludeAllAvailableColumns.setVisible(false);
        if (this._targetNode != null && this._targetNode.getData() instanceof SQLQueryNodeType && (sQLQueryNodeType = (SQLQueryNodeType)this._targetNode.getData()).isIncludeAllAvailableAttributes()) {
            this.lblIncludeAllAvailableColumns.setText(DialogsLrb.get("SQLQUERY_QUERY_INCLUDE_ALL_AVAILABLE_COLUMNS"));
            this.lblIncludeAllAvailableColumns.setVisible(true);
        }
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.initUI();
    }

    protected void processAdd() {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this._targetNode.getData();
        SQLContext sQLContext = new SQLContext(this.getContext((PropertyModel)this._model), this._targetNode.findSourceNodes(), this._targetNode, sQLQueryNodeType.getSQLQueryExpression(), false);
        sQLContext.setHasWithClause(sQLQueryNodeType.isHasWithClause());
        sQLContext.setGenerateView(sQLQueryNodeType.isGenerateView());
        sQLContext.setName(sQLQueryNodeType.getViewName());
        SQLQueryEditorPanel sQLQueryEditorPanel = new SQLQueryEditorPanel(sQLContext, (PropertyModel)this._model);
        sQLQueryEditorPanel.showAsDialog(this);
        if (sQLQueryEditorPanel.isDirty()) {
            String string = sQLQueryEditorPanel.getSqlExpression();
            this._SQLTextArea.setText(string);
        }
    }

    private void enableControls() {
        this._addBtn.setEnabled(this.isWritable());
    }

    private void initComponents() {
        this.SQLTransparentPanel = new TransparentPanel();
        this.SQLComponentWithTitlebar = new ComponentWithTitlebar();
        this.lblIncludeAllAvailableColumns = new JLabel();
        GroupLayout groupLayout = new GroupLayout((Container)this.SQLTransparentPanel);
        this.SQLTransparentPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.SQLComponentWithTitlebar, -1, 472, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.SQLComponentWithTitlebar, -1, 168, Short.MAX_VALUE)));
        this.lblIncludeAllAvailableColumns.setText("Datasource includes all available columns");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.lblIncludeAllAvailableColumns, -2, 331, -2).addContainerGap(151, Short.MAX_VALUE)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent((Component)this.SQLTransparentPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.lblIncludeAllAvailableColumns).addGap(0, 186, Short.MAX_VALUE)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(0, 21, Short.MAX_VALUE).addComponent((Component)this.SQLTransparentPanel, -2, -1, -2))));
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._jFilterCtl);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 150);
        Dimension dimension3 = this.derive(dimension, 100);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }
}

