/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.awt.Component;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.ar.ARNodeSettings;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsPreferenceSettings;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ASSOAGGREGATES;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.Version;

public final class ModelDetailsDataNode
extends AbstractTransformNode
implements ModelConsumer {
    public final String INFORMATIONAL_KEY_AUTOMATIC_SETTING = this.getClass().getName();
    public static final String MODEL_DETAILS_MODELS = "modelDetailsModels";
    public static final String MODEL_DETAILS_OUTPUT_COLUMNS = "modelDetailsOutputColumns";
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String SQL_EXPRESSION_GENERATE = "SQL_EXPRESSION_GENERATE";
    private static Preferences _p = Preferences.getPreferences();
    private static final Pattern SELECT_FROM_DUAL_PATTERN = Pattern.compile("^SELECT\\s+(.+)\\s+FROM\\s+DUAL$");
    private static final Pattern VARCHAR2_TOKEN_PATTERN_1 = Pattern.compile("^CAST\\s*\\(\\s*'.*'\\s+AS\\s+VARCHAR2\\s*\\((\\d+)\\)\\s*\\)\\s+([a-zA-Z]+[a-zA-Z0-9_]*)$");
    private static final Pattern VARCHAR2_TOKEN_PATTERN_2 = Pattern.compile("^'.*'\\s+(AS\\s+)?([a-zA-Z]+[a-zA-Z0-9_]*)$");
    private static final Pattern NUMBER_TOKEN_PATTERN = Pattern.compile("^(\\d+[.]?\\d*)\\s+(AS\\s+)?([a-zA-Z]+[a-zA-Z0-9_]*)$");
    private Version dbVersion;
    private List<RModelType.DetailFunction.Output.Column> rModelOutputDefinition;
    private ARNodeSettings associationRulesSettings;
    private ModelDetailsPreferenceSettings _modelDetailsPreferenceSettings = ModelDetailsPreferenceSettings.getInstance((PropertyStorage)_p);

    public ModelDetailsDataNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this.associationRulesSettings = new ARNodeSettings();
        this.rModelOutputDefinition = new ArrayList<RModelType.DetailFunction.Output.Column>();
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        Attributes attributes = new Attributes();
        modelDetailsOutputType.setAttributes(attributes);
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setType(null);
        modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        if (this._modelDetailsPreferenceSettings.getAutomaticSetting()) {
            modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
        } else {
            modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_MODEL_DETAILS_NODE_NAME");
    }

    public boolean areNodesCompatible(Node node) {
        ModelProvider modelProvider;
        ModelProvider modelProvider2;
        MiningFunctionType miningFunctionType;
        boolean bl = false;
        List<AbstractNode> list = this.findParentNodes();
        bl = list.isEmpty() ? true : (miningFunctionType = (modelProvider2 = (ModelProvider)((Object)list.get(0))).getMiningFunctionTypeSupported()).equals((Object)(modelProvider = (ModelProvider)((Object)node)).getMiningFunctionTypeSupported());
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = false;
        bl = node instanceof ModelProvider ? this.areNodesCompatible(node) : false;
        return bl;
    }

    public String generateSQLExpressionCodeGenVersion() {
        return this.generateSQLExpressionCommon(true);
    }

    @Override
    public String generateSQLExpression() {
        return this.generateSQLExpressionCommon(false);
    }

    public String generateSQLExpressionCommon(boolean bl) {
        ModelDetailsQuery modelDetailsQuery;
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        HashMap<String, RowDiagnosticTableDetails> hashMap = new HashMap<String, RowDiagnosticTableDetails>();
        if (ModelDetailType.GLMC_ROW_DIAGNOSTICS.equals((Object)modelDetailsDataNodeType.getModelDetailsOutput().getType()) || ModelDetailType.GLMR_ROW_DIAGNOSTICS.equals((Object)modelDetailsDataNodeType.getModelDetailsOutput().getType())) {
            modelDetailsQuery = this.findParentNodes();
            for (AbstractNode abstractNode : modelDetailsQuery) {
                if (!(abstractNode instanceof RowDiagnosticsProvider)) continue;
                hashMap.putAll(((RowDiagnosticsProvider)((Object)abstractNode)).getRowDiagnosticTables());
            }
        }
        return (modelDetailsQuery = ExtractQueryFactory.createModelQuery(this, modelDetailsDataNodeType.getModelDetailsOutput().getType(), modelDetailsDataNodeType.getModelDetailsOutput().getModels().getModel(), hashMap, bl, this.dbVersion)).hasWithBlock() ? StringUtils.getReplacedString((String)modelDetailsQuery.getSQLCommand(), (String)StringUtils.formatReplacement((String)"NODE_SQL_NAME"), (String)this.getNodeNameForSQLExpression(false)) : this.wrapExpressionInWithClause(modelDetailsQuery.getSQLCommand());
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = CodeTemplate.updateBodyTemplate(string, "<SQL_EXPRESSION>", StringUtils.removeBlankLines((String)this.getCodeGenSQL()));
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        String string3 = this.getCodeGenOutputType();
        for (RefModelType refModelType : modelDetailsDataNodeType.getModelDetailsOutput().getModels().getModel()) {
            String string4 = "\"" + refModelType.getSchema() + "\".\"" + refModelType.getName() + "\"";
            String string5 = "''" + refModelType.getName() + "''";
            String string6 = "''SCHEMA_ONLY:" + string4 + "''";
            String string7 = "ROW_DIAGNOSTICS:" + string4 + "CODE_GEN_WF_NODE_ID:" + refModelType.getNodeId();
            String string8 = parameterizedSourceDefinitions.getParmNameWithAmpersand(refModelType.getNodeId(), refModelType.getSchema(), refModelType.getName(), DatabaseObjectType.MODEL);
            if (string8 == null) continue;
            String string9 = "'" + string8 + "'";
            String string10 = "'''|| extractName(" + string9 + ",1)||'''";
            string2 = string2.replaceAll(string6, string10);
            if (this.isRowDiagnostics()) {
                string10 = "'|| getInputSource('" + refModelType.getNodeId() + "','" + string3 + "',extractName(" + string9 + ",2)) ||'";
                string2 = string2.replaceAll(string7, string10);
            }
            string2 = string2.replaceAll(string4, string8);
            string10 = "'''|| extractName(" + string9 + ",2)||'''";
            string2 = string2.replaceAll(string5, string10);
        }
        return string2;
    }

    private String getCodeGenOutputType() {
        if (this.isRowDiagnostics()) {
            return "GLM Diagnostics Table";
        }
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Script generation for Model Details Node unable to dtermin output type.");
        return "";
    }

    private boolean isRowDiagnostics() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        return ModelDetailType.GLMC_ROW_DIAGNOSTICS.equals((Object)modelDetailsDataNodeType.getModelDetailsOutput().getType()) || ModelDetailType.GLMR_ROW_DIAGNOSTICS.equals((Object)modelDetailsDataNodeType.getModelDetailsOutput().getType());
    }

    @Override
    protected String getCodeGenSQL() {
        boolean bl;
        WorkflowModel workflowModel = this.getModel();
        StringBuilder stringBuilder = new StringBuilder(32000);
        if (workflowModel == null) {
            return null;
        }
        if (this.parentContainsIncompleteModel(workflowModel)) {
            return null;
        }
        NodeStatusType nodeStatusType = this.getState();
        boolean bl2 = bl = NodeStatusType.COMPLETE.equals((Object)nodeStatusType) || NodeStatusType.READY.equals((Object)nodeStatusType) || NodeStatusType.WARNING.equals((Object)nodeStatusType) || !NodeStatusType.FAILURE.equals((Object)nodeStatusType) || !NodeStatusType.INVALID.equals((Object)nodeStatusType);
        if (!bl) {
            return null;
        }
        stringBuilder.append(this.getSQLNodeComment(this, true));
        stringBuilder.append(StringUtils.escapeSingleQuotesForSQL((String)this.generateSQLExpressionCodeGenVersion()));
        stringBuilder.append(this.getSQLNodeComment(this, false));
        stringBuilder.append("SELECT * FROM ");
        stringBuilder.append(this.getNodeNameForSQLExpression(true));
        stringBuilder.insert(0, "WITH ");
        return stringBuilder.toString();
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        stringBuffer.setLength(0);
        ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        ModelDetailType modelDetailType = modelDetailsOutputType.getType();
        if (!DbVersionHelper.isDB122Up((Version)version)) {
            switch (modelDetailType) {
                case AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION: 
                case AR_RULES_AGGREGATES_STRING_VERSION: {
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_AR_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
                case EM_CLUSTERS: 
                case EM_PRIORS: 
                case EM_GAUSSIAN_DETAILS: 
                case EM_BERNOULLI_DETAILS: {
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_EM_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
                case NMF_DETAILS_TRANSACTIONAL_VERSION: {
                    if (!MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS.equals((Object)modelDetailsOutputType.getMiningAlgorithm())) break;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_ESA_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        if (!DbVersionHelper.isDB121Up((Version)version)) {
            switch (modelDetailType) {
                case FEATURE_PROJECTIONS: 
                case SVD_SINGULAR_VALUES: {
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_SVD_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
                case PCA_EIGENVALUES: {
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_PCA_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
                case EM_COMPONENTS: 
                case EM_PROJECTIONS: {
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_EM_MODEL_DETAILS_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        return true;
    }

    public ModelDetailsOutputType validateModelCompatibilityNotAuto(ModelDetailsOutputType modelDetailsOutputType) throws Exception {
        ModelDetailsOutputType.Models models = modelDetailsOutputType.getModels();
        List list = models.getModel();
        List<RefModelType> list2 = this.getCompatibleModels(modelDetailsOutputType);
        for (RefModelType refModelType : list) {
            boolean bl = false;
            if (refModelType.getModelId() != null) {
                bl = list2.stream().anyMatch(refModelType2 -> refModelType.getNodeId().equals(refModelType2.getNodeId()) && refModelType.getModelId().equals(refModelType2.getModelId()) && refModelType.getName().equals(refModelType2.getName()));
            }
            refModelType.setStatus(bl ? RefModelStatusType.VALID : RefModelStatusType.INVALID);
        }
        return modelDetailsOutputType;
    }

    public ModelDetailsOutputType addCompatibleModels(ModelDetailsOutputType modelDetailsOutputType) throws Exception {
        List<RefModelType> list = this.getCompatibleModels(modelDetailsOutputType);
        if (list.isEmpty()) {
            modelDetailsOutputType.getAttributes().getAttribute().clear();
            modelDetailsOutputType.setMiningAlgorithm(null);
            modelDetailsOutputType.setMiningFunction(null);
            modelDetailsOutputType.setType(null);
        }
        return modelDetailsOutputType;
    }

    public List<RefModelType> getCompatibleModels(ModelDetailsOutputType modelDetailsOutputType) throws Exception {
        List<RefModelType> list;
        switch (modelDetailsOutputType.getType()) {
            case AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION: 
            case AR_RULES_AGGREGATES_STRING_VERSION: {
                list = this.getCompatibleARModels(true);
                break;
            }
            case AR_RULES_STRING_VERSION: 
            case AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION: {
                if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
                    list = this.getCompatibleARModels(false);
                    break;
                }
                list = this.getOutputCompatibleModels(modelDetailsOutputType);
                break;
            }
            case SVMC_COEFFICIENTS: 
            case SVMR_COEFFICIENTS: {
                list = this.getCompatibleModelsForSVMCoefficients();
                break;
            }
            case GLMR_ROW_DIAGNOSTICS: 
            case GLMC_ROW_DIAGNOSTICS: {
                list = this.getCompatibleModelsForRowDiagnostics();
                break;
            }
            case R_MODEL_DETAILS: {
                list = this.getCompatibleRModels();
                break;
            }
            default: {
                list = this.getOutputCompatibleModels(modelDetailsOutputType);
            }
        }
        return list;
    }

    private List<RefModelType> getOutputCompatibleModels(ModelDetailsOutputType modelDetailsOutputType) {
        MultiMap multiMap;
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<MiningAlgorithmType> arrayList = new ArrayList<MiningAlgorithmType>();
        if (!MiningAlgorithmType.ALL.equals((Object)modelDetailsOutputType.getMiningAlgorithm()) && ModelDetailType.MODEL_SIGNATURE.equals((Object)modelDetailsOutputType.getType())) {
            arrayList.add(modelDetailsOutputType.getMiningAlgorithm());
        } else if (MiningAlgorithmType.ALL.equals((Object)modelDetailsOutputType.getMiningAlgorithm())) {
            multiMap = MiningDetailsOutputType.getMiningAlgorithms(modelDetailsOutputType.getType());
            arrayList.addAll((Collection<MiningAlgorithmType>)multiMap);
        } else {
            arrayList.add(modelDetailsOutputType.getMiningAlgorithm());
        }
        multiMap = new MultiMap();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<RefModelType> list2 = modelProvider.getOutputModels();
            for (RefModelType refModelType : list2) {
                String string = "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                multiMap.add((Object)string, (Object)refModelType);
            }
        }
        return this.getModelsContains((MultiMap<String, RefModelType>)multiMap, arrayList);
    }

    private List<RefModelType> getCompatibleModelsForSVMCoefficientsFromNode(Node node) {
        ArrayList<RefModelType> arrayList = new ArrayList();
        try {
            arrayList = ((ModelProvider)((Object)node)).getSVMLinearModels();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private List<RefModelType> getCompatibleModelsForSVMCoefficients() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<RefModelType> list2 = modelProvider.getSVMLinearModels();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private List<RefModelType> getCompatibleARModels(boolean bl) {
        MiningAlgorithmType miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
        MiningFunctionType miningFunctionType = MiningFunctionType.ASSOCIATION;
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        boolean bl2 = true;
        boolean bl3 = false;
        this.associationRulesSettings.clear();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof AssociationBuildNode) && !(abstractNode instanceof ModelNode)) continue;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (abstractNode instanceof ModelNode) {
                if (!MiningFunctionType.ASSOCIATION.equals((Object)((ModelNodeType)abstractNode.getData()).getMiningFunction())) continue;
                bl2 = this.validateARModelsSettings(abstractNode, arrayList2, bl2);
                bl3 = true;
            } else {
                bl2 = this.validateARModelsSettings(abstractNode, arrayList2, bl2);
                bl3 = false;
            }
            if (arrayList2.isEmpty()) continue;
            if (bl) {
                this.validateARModelAggregates(abstractNode, arrayList2, bl3);
                if (arrayList2.isEmpty()) continue;
            }
            String string = ConnectionFolder.getUserAccountName(abstractNode.getContext());
            string = StringUtils.trimDoubleQuotes((String)string).toUpperCase();
            String string2 = abstractNode.getData().getId();
            if (bl3) {
                ArrayList<ModelNodeType.Models.Model> arrayList3 = new ArrayList<ModelNodeType.Models.Model>();
                for (Object e : arrayList2) {
                    arrayList3.add((ModelNodeType.Models.Model)e);
                }
                arrayList.addAll(MetaDataHelper.createRefModelTypeCollection(miningFunctionType, miningAlgorithmType, arrayList3, string2, string));
                continue;
            }
            ArrayList<AprioriModelType> arrayList4 = new ArrayList<AprioriModelType>();
            for (Object e : arrayList2) {
                arrayList4.add((AprioriModelType)e);
            }
            arrayList.addAll(MetaDataHelper.createRefModelTypeCollection(miningFunctionType, arrayList4, string2, string));
        }
        return arrayList;
    }

    private List<RefModelType> getCompatibleRModels() {
        MiningAlgorithmType miningAlgorithmType = MiningAlgorithmType.R_EXTENSIBLE;
        MiningFunctionType miningFunctionType = this.getMiningFunctionType();
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        boolean bl = false;
        for (AbstractNode abstractNode : list) {
            boolean bl2;
            if (!(abstractNode instanceof RBuildNode) && !(abstractNode instanceof ModelNode)) continue;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (abstractNode instanceof ModelNode) {
                boolean bl3 = this.modelNodeContainsAnyRModel((ModelNodeType)abstractNode.getData());
                if (!bl3) continue;
                bl = this.validateRModelDetailFormat(abstractNode, arrayList2, bl);
                bl2 = true;
            } else {
                bl = this.validateRModelDetailFormat(abstractNode, arrayList2, bl);
                bl2 = false;
            }
            if (arrayList2.isEmpty()) continue;
            String string = ConnectionFolder.getUserAccountName(abstractNode.getContext());
            string = StringUtils.trimDoubleQuotes((String)string).toUpperCase();
            String string2 = abstractNode.getData().getId();
            if (bl2) {
                ArrayList<ModelNodeType.Models.Model> arrayList3 = new ArrayList<ModelNodeType.Models.Model>();
                for (Object e : arrayList2) {
                    ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)e;
                    if (!MiningAlgorithmType.R_EXTENSIBLE.equals((Object)model.getMiningAlgorithm())) continue;
                    arrayList3.add(model);
                }
                arrayList.addAll(MetaDataHelper.createRefModelTypeCollection(miningFunctionType, miningAlgorithmType, arrayList3, string2, string));
                continue;
            }
            ArrayList<RModelType> arrayList4 = new ArrayList<RModelType>();
            for (Object e : arrayList2) {
                arrayList4.add((RModelType)e);
            }
            arrayList.addAll(MetaDataHelper.createRefModelTypeCollection(miningFunctionType, arrayList4, string2, string));
        }
        return arrayList;
    }

    private MiningFunctionType getMiningFunctionType() {
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (abstractNode instanceof AbstractBuildNode) {
                return ((AbstractBuildNode)abstractNode).getMiningFunctionType();
            }
            if (!(abstractNode instanceof AbstractModelNode)) continue;
            return ((AbstractModelNode)abstractNode).getMiningFunctionTypeSupported();
        }
        return null;
    }

    private boolean modelNodeContainsAnyRModel(ModelNodeType modelNodeType) {
        List list = modelNodeType.getModels().getModel();
        boolean bl = list.stream().anyMatch(model -> MiningAlgorithmType.R_EXTENSIBLE.equals((Object)model.getMiningAlgorithm()));
        return bl;
    }

    private boolean validateRModelDetailFormat(AbstractNode abstractNode, List<Object> list, boolean bl) {
        ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
        if (abstractNode instanceof ModelNode) {
            ArrayList<ModelNodeType.Models.Model> arrayList = new ArrayList<ModelNodeType.Models.Model>();
            arrayList.addAll(modelProvider.getModelNodeType().getModels().getModel());
            arrayList.removeIf(model -> {
                String string = this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "RALG_DETAILS_FORMAT");
                return StringUtils.isEmpty((String)string);
            });
            if (!arrayList.isEmpty()) {
                if (!bl) {
                    this.setRModelOutputDefinition(null, (ModelNodeType.Models.Model)arrayList.get(0));
                    bl = !this.rModelOutputDefinition.isEmpty();
                }
                arrayList.removeIf(model -> this.rModelOutputDefinition.isEmpty() || !this.equivalentROutputSignatures(this.rModelOutputDefinition, this.getRModelOutputSignature(null, (ModelNodeType.Models.Model)model)));
            }
            list.addAll(arrayList);
        } else {
            ArrayList<RModelType> arrayList = new ArrayList<RModelType>();
            RBuildNodeType rBuildNodeType = (RBuildNodeType)abstractNode.getData();
            arrayList.addAll(rBuildNodeType.getModels().getRModel());
            arrayList.removeIf(rModelType -> rModelType.getDetailFunction() == null || rModelType.getDetailFunction().getOutput() == null || rModelType.getDetailFunction().getOutput().getColumn().isEmpty());
            if (!arrayList.isEmpty()) {
                if (!bl) {
                    this.setRModelOutputDefinition((RModelType)arrayList.get(0), null);
                    bl = !this.rModelOutputDefinition.isEmpty();
                } else {
                    arrayList.removeIf(rModelType -> this.rModelOutputDefinition.isEmpty() || !this.equivalentROutputSignatures(this.rModelOutputDefinition, this.getRModelOutputSignature((RModelType)rModelType, null)));
                }
                if (!arrayList.isEmpty()) {
                    list.addAll(arrayList);
                }
            }
        }
        return bl;
    }

    private boolean equivalentROutputSignatures(List<RModelType.DetailFunction.Output.Column> list, List<RModelType.DetailFunction.Output.Column> list2) {
        return list.size() == list2.size() && list.stream().allMatch(column -> list2.stream().anyMatch(column2 -> column.getName().toUpperCase().equals(column2.getName().toUpperCase()) && column.getType().equals((Object)column2.getType())));
    }

    private boolean validateARModelsSettings(AbstractNode abstractNode, List<Object> list, boolean bl) {
        ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
        if (abstractNode instanceof ModelNode) {
            ArrayList<ModelNodeType.Models.Model> arrayList = new ArrayList<ModelNodeType.Models.Model>();
            arrayList.addAll(modelProvider.getModelNodeType().getModels().getModel());
            if (!arrayList.isEmpty()) {
                if (bl) {
                    this.setARItemDetails(null, (ModelNodeType.Models.Model)arrayList.get(0));
                    bl = false;
                }
                arrayList.removeIf(model -> {
                    String string = this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "ODMS_ITEM_ID_COLUMN_NAME");
                    if (StringUtils.isNotEmpty((String)string) ? !StringUtils.trimDoubleQuotes((String)string).toUpperCase().equals(this.associationRulesSettings.getItemID()) : StringUtils.isNotEmpty((String)this.associationRulesSettings.getItemID())) {
                        return true;
                    }
                    string = this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "ODMS_ITEM_VALUE_COLUMN_NAME");
                    if (string == null) {
                        return !ARNodeSettings.ARItemValueType.NOT_SET.equals((Object)this.associationRulesSettings.getItemValueType());
                    }
                    return ARNodeSettings.ARItemValueType.NOT_SET.equals((Object)this.associationRulesSettings.getItemValueType());
                });
            }
            list.addAll(arrayList);
        } else {
            List<ModelType> list2 = ((AssociationBuildNode)abstractNode).getModels();
            if (!list2.isEmpty()) {
                if (bl) {
                    this.setARItemDetails((AssociationBuildNodeType)abstractNode.getData(), null);
                    bl = false;
                } else {
                    String string;
                    AttributeType attributeType = ((AssociationBuildNodeType)abstractNode.getData()).getItemID();
                    String string2 = attributeType == null ? null : attributeType.getName();
                    attributeType = ((AssociationBuildNodeType)abstractNode.getData()).getItemValue();
                    String string3 = string = attributeType == null ? null : attributeType.getName();
                    if (StringUtils.isNotEmpty((String)string2)) {
                        if (!string2.toUpperCase().equals(this.associationRulesSettings.getItemID())) {
                            list2.clear();
                        }
                    } else if (StringUtils.isNotEmpty((String)this.associationRulesSettings.getItemID())) {
                        list2.clear();
                    }
                    if (string == null) {
                        if (!ARNodeSettings.ARItemValueType.NOT_SET.equals((Object)this.associationRulesSettings.getItemValueType())) {
                            list2.clear();
                        }
                    } else if (ARNodeSettings.ARItemValueType.NOT_SET.equals((Object)this.associationRulesSettings.getItemValueType())) {
                        list2.clear();
                    }
                }
                if (!list2.isEmpty()) {
                    list.addAll(list2);
                }
            }
        }
        return bl;
    }

    private void validateARModelAggregates(AbstractNode abstractNode, List<Object> list, boolean bl) {
        if (!bl) {
            ASSOAGGREGATES aSSOAGGREGATES = ((AssociationBuildNodeType)abstractNode.getData()).getASSOAGGREGATES();
            if (aSSOAGGREGATES == null || aSSOAGGREGATES.getAttribute().isEmpty()) {
                list.clear();
            } else {
                List list2 = aSSOAGGREGATES.getAttribute().stream().map(attributeType -> attributeType.getName()).sorted().collect(Collectors.toList());
                if (this.associationRulesSettings.getAggregates().isEmpty()) {
                    this.associationRulesSettings.setAggregates(list2);
                } else if (!list2.equals(this.associationRulesSettings.getAggregates())) {
                    list.clear();
                }
            }
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Object object = list.get(i);
            String string = this.getModelSettingByName(((ModelNodeType.Models.Model)object).getModelSettingsODM().getModelSettingODM(), "ASSO_AGGREGATES");
            if (StringUtils.isEmpty((String)string)) {
                list.remove(object);
                continue;
            }
            List list3 = Arrays.stream(string.toUpperCase().split(",")).sorted().collect(Collectors.toList());
            if (this.associationRulesSettings.getAggregates().isEmpty()) {
                this.associationRulesSettings.setAggregates(list3);
                continue;
            }
            if (list3.isEmpty()) {
                list.remove(object);
                continue;
            }
            if (list3.equals(this.associationRulesSettings.getAggregates())) continue;
            list.remove(object);
        }
    }

    public String getModelPartitionKey(String string, String string2, String string3) {
        for (AbstractNode abstractNode : this.findParentNodes()) {
            if (abstractNode instanceof ModelNode) {
                Optional<ModelNodeType.Models.Model> optional = ((ModelNodeType)abstractNode.getData()).getModels().getModel().stream().filter(model -> model.getName().equals(string2) && model.getSchema().equals(string3)).findAny();
                if (!optional.isPresent()) continue;
                return MetaDataHelper.getPartitionKey(optional.get().getPartitionExpressions());
            }
            if (!abstractNode.getData().getId().equals(string)) continue;
            return MetaDataHelper.getPartitionKey(((BuildNodeType)abstractNode.getData()).getPartitionExpressions());
        }
        return "";
    }

    private String getModelSettingByName(List<ModelSettingODMType> list, String string) {
        for (ModelSettingODMType modelSettingODMType : list) {
            if (!modelSettingODMType.getName().equals(string)) continue;
            return modelSettingODMType.getValue();
        }
        return null;
    }

    private List<RefModelType> getCompatibleModelsForRowDiagnostics() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<RefModelType> list2 = modelProvider.getGLMRowDiagnosticModels();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private ModelDetailsOutputType findIncompatibleModels() throws Exception {
        List<Object> list;
        Object object;
        ModelDetailsOutputType modelDetailsOutputType = this.createDuplicateOutputType();
        List<AbstractNode> list2 = this.findParentNodes();
        ModelDetailsOutputType.Models models = modelDetailsOutputType.getModels();
        List list3 = models.getModel();
        HashMap<CallSite, RefModelType> hashMap = new HashMap<CallSite, RefModelType>();
        HashMap<CallSite, RefModelType> hashMap2 = new HashMap<CallSite, RefModelType>();
        for (AbstractNode abstractNode : list2) {
            object = (ModelProvider)((Object)abstractNode);
            list = new ArrayList();
            list = object.getOutputModels();
            for (RefModelType refModelType : list) {
                String string = "NODE_ID:" + abstractNode.getMetadataId() + "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                hashMap.put((CallSite)((Object)string), refModelType);
                String string2 = "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                hashMap2.put((CallSite)((Object)string2), refModelType);
            }
        }
        for (AbstractNode abstractNode : list3) {
            object = "NODE_ID:" + abstractNode.getNodeId() + "MODEL_NAME:" + abstractNode.getSchema() + ":" + abstractNode.getName() + "FUNCTION:" + abstractNode.getMiningFunction().value() + "ALGORITHM:" + abstractNode.getMiningAlgorithm().value();
            list = (RefModelType)hashMap.get(object);
            if (list != null) {
                abstractNode.setStatus(RefModelStatusType.VALID);
                abstractNode.setModelId(list.getModelId());
            } else {
                abstractNode.setStatus(RefModelStatusType.INVALID);
            }
            if (abstractNode.getNodeId() != null) continue;
            String string = "MODEL_NAME:" + abstractNode.getSchema() + ":" + abstractNode.getName() + "FUNCTION:" + abstractNode.getMiningFunction().value() + "ALGORITHM:" + abstractNode.getMiningAlgorithm().value();
            RefModelType refModelType = (RefModelType)hashMap2.get(string);
            if (refModelType != null) {
                abstractNode.setStatus(RefModelStatusType.VALID);
                abstractNode.setIsModelBuilt(refModelType.isIsModelBuilt());
                abstractNode.setNodeId(refModelType.getNodeId());
                abstractNode.setModelId(refModelType.getModelId());
                continue;
            }
            abstractNode.setStatus(RefModelStatusType.INVALID);
        }
        return this.validateModelCompatibilityNotAuto(modelDetailsOutputType);
    }

    /*
     * WARNING - void declaration
     */
    public boolean validateNodeRemoval(Node node, boolean bl) {
        void var12_22;
        boolean bl2 = super.validate(bl);
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)MetaDataHelper.copyMetadataObject(this.getData());
        ModelDetailsOutputType.Models models = modelDetailsDataNodeType.getModelDetailsOutput().getModels();
        List list = models.getModel();
        Attributes attributes = modelDetailsDataNodeType.getModelDetailsOutput().getAttributes();
        List list2 = attributes.getAttribute();
        boolean bl3 = false;
        if ("No".equals(modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec().value())) {
            boolean bl4 = false;
            if (node != null) {
                for (RefModelType object2 : list) {
                    if (object2.getNodeId() == null || node.getData().getId() == null || object2.getNodeId().compareTo(node.getData().getId()) != 0) continue;
                    object2.setStatus(RefModelStatusType.INVALID);
                    bl4 = true;
                }
            }
            if (bl4) {
                this.addMessage("MODEL_DETAIL_INVALID_MODELS", MessageEnumType.WARNING, new String[0]);
            }
        }
        List<AbstractNode> list3 = this.findParentNodes();
        if (node != null) {
            list3.remove(node);
        }
        if (list3.isEmpty()) {
            this.addMessage("MODEL_DETAIL_NO_LINKS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
        } else {
            bl3 = true;
        }
        if (bl2 && list.isEmpty()) {
            this.addMessage("MODEL_DETAIL_NO_MODELS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
        }
        for (RefModelType refModelType : list) {
            if (RefModelStatusType.VALID.equals((Object)refModelType.getStatus())) continue;
            this.addMessage("MODEL_DETAIL_INVALID_MODELS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
            break;
        }
        if (bl3 && !list.isEmpty()) {
            if (list2.isEmpty()) {
                this.addMessage("MODEL_DETAIL_NO_OUTPUT_COLUMNS", MessageEnumType.WARNING, new String[0]);
                bl2 = false;
            } else {
                for (AttributeType attributeType : list2) {
                    if (!AttributeStatus.INVALID.equals((Object)attributeType.getStatus())) continue;
                    this.addMessage("MODEL_DETAIL_INVALID_OUTPUT_COLUMNS", MessageEnumType.WARNING, new String[0]);
                    bl2 = false;
                    break;
                }
            }
        }
        list3 = this.findParentNodes();
        for (AbstractNode abstractNode : list3) {
            ModelProvider modelProvider;
            if (!(abstractNode instanceof ModelProvider) || (modelProvider = (ModelProvider)((Object)abstractNode)).getTargetAttribute() != null || !(modelProvider instanceof SupervisedBuildNode)) continue;
            this.addMessage("TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
            break;
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (modelDetailsDataNodeType.getModelDetailsOutput() != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsDataNodeType.getModelDetailsOutput());
        }
        String string = "";
        if (bl2) {
            ((ModelDetailsDataNodeType)this.getData()).setSQLExpression(this.generateSQLExpression());
            String string2 = this.getSQLExpression();
        } else {
            ((ModelDetailsDataNodeType)this.getData()).setSQLExpression(string);
        }
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SQL_EXPRESSION, var12_22);
        return bl2;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        Object object;
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        ModelDetailsOutputType modelDetailsOutputType2 = (ModelDetailsOutputType)MetaDataHelper.copyMetadataObject(modelDetailsOutputType);
        List list = modelDetailsOutputType2.getModels().getModel();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (RefModelType)iterator.next();
            RefModelType refModelType = map.get(object.getName());
            if (refModelType == null) continue;
            iterator.remove();
            arrayList.add(refModelType);
        }
        list.addAll(arrayList);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsOutputType2);
        object = new HashMap();
        this.refactorChildrenAttributes(this, (Map<String, AttributeType>)object);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean validate(boolean var1_1) {
        var2_2 = null;
        var3_3 = this.isNodeUndefined();
        var4_4 = (ModelDetailsDataNodeType)this.getData();
        if (!var3_3) {
            var5_5 = (OdmrSDMUndoFilter)this.getUndoFilter();
            if ("Yes".equals(var4_4.getModelDetailsOutput().getAutoSpec().value())) {
                var6_7 = this.createDuplicateOutputType();
                try {
                    var2_2 = this.addCompatibleModels(var6_7);
                    if (!var2_2.getModels().getModel().isEmpty() || (var7_10 = this.autoProcessingUndefined()) == null) ** GOTO lbl22
                    var2_2 = var7_10;
                }
                catch (Exception var7_11) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var7_11, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                    return false;
                }
            } else {
                try {
                    var2_2 = this.findIncompatibleModels();
                }
                catch (Exception var6_8) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var6_8, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                    return false;
                }
            }
lbl22:
            // 3 sources

            if (var2_2 != null) {
                var5_5.prepareUndo(this, this.getContext(), "modelDetailsModels", var2_2);
            }
        } else if ("Yes".equals(var4_4.getModelDetailsOutput().getAutoSpec().value())) {
            var5_6 = (OdmrSDMUndoFilter)this.getUndoFilter();
            try {
                var2_2 = this.autoProcessingUndefined();
            }
            catch (Exception var6_9) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var6_9, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                return false;
            }
            if (var2_2 != null) {
                var5_6.prepareUndo(this, this.getContext(), "modelDetailsModels", var2_2);
            }
        }
        return this.validateNodeRemoval(null, var1_1);
    }

    private ModelDetailsOutputType autoProcessingUndefined() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<Object> list2 = new ArrayList();
            list2 = modelProvider.getOutputModels();
            if (list2.isEmpty()) continue;
            modelDetailsOutputType = this.getDefaultModelDetailOutputType(abstractNode);
            break;
        }
        if (modelDetailsOutputType != null) {
            modelDetailsOutputType = this.addCompatibleModels(modelDetailsOutputType);
        }
        return modelDetailsOutputType;
    }

    private boolean anyModelAlgorithmMatches(List<RefModelType> list, MiningAlgorithmType miningAlgorithmType) {
        boolean bl = list.stream().anyMatch(refModelType -> miningAlgorithmType.equals((Object)refModelType.getMiningAlgorithm()));
        return bl;
    }

    private boolean anyModelAlgorithmMatches(List<RefModelType> list, MiningAlgorithmType ... miningAlgorithmTypeArray) {
        boolean bl = list.stream().anyMatch(refModelType -> Arrays.stream(miningAlgorithmTypeArray).anyMatch(miningAlgorithmType -> refModelType.getMiningAlgorithm().equals(miningAlgorithmType)));
        return bl;
    }

    public List<RefModelType> getModelsFilteredByAlgorithm(List<RefModelType> list, MiningAlgorithmType miningAlgorithmType) {
        List<RefModelType> list2 = list.stream().filter(refModelType -> miningAlgorithmType.equals((Object)refModelType.getMiningAlgorithm())).collect(Collectors.toList());
        return list2;
    }

    public List<RefModelType> getModelsFilteredByFunction(List<RefModelType> list, MiningFunctionType miningFunctionType) {
        List<RefModelType> list2 = list.stream().filter(refModelType -> miningFunctionType.equals((Object)refModelType.getMiningFunction())).collect(Collectors.toList());
        return list2;
    }

    public List<RefModelType> getModelsContains(MultiMap<String, RefModelType> multiMap, List<MiningAlgorithmType> list) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (ArrayList arrayList2 : multiMap.values()) {
            for (RefModelType refModelType : arrayList2) {
                if (!list.contains(refModelType.getMiningAlgorithm())) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    private ModelDetailsOutputType createDuplicateOutputType() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        ModelDetailsOutputType modelDetailsOutputType2 = new ModelDetailsOutputType();
        modelDetailsOutputType2.setMiningAlgorithm(modelDetailsOutputType.getMiningAlgorithm());
        modelDetailsOutputType2.setMiningFunction(modelDetailsOutputType.getMiningFunction());
        modelDetailsOutputType2.setAutoSpec(modelDetailsOutputType.getAutoSpec());
        modelDetailsOutputType2.setType(modelDetailsOutputType.getType());
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        models.getModel().addAll(modelDetailsOutputType.getModels().getModel());
        modelDetailsOutputType2.setModels(models);
        Attributes attributes = new Attributes();
        attributes.getAttribute().addAll(modelDetailsOutputType.getAttributes().getAttribute());
        modelDetailsOutputType2.setAttributes(attributes);
        return modelDetailsOutputType2;
    }

    private ModelDetailsOutputType getDefaultModelDetailOutputType(Node node) {
        ModelDetailType modelDetailType = null;
        MiningAlgorithmType miningAlgorithmType = null;
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        modelDetailsOutputType.setAttributes(new Attributes());
        ModelProvider modelProvider = (ModelProvider)((Object)node);
        MiningFunctionType miningFunctionType = modelProvider.getMiningFunctionTypeSupported();
        List<RefModelType> list = modelProvider.getOutputModels();
        if (list.isEmpty()) {
            modelDetailType = null;
            miningAlgorithmType = null;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.DECISION_TREE)) {
            miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
            modelDetailType = ModelDetailType.DT_LEAF_NODES_ONLY;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            modelDetailType = miningFunctionType == MiningFunctionType.CLASSIFICATION ? ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS : ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.NAIVE_BAYES)) {
            miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
            modelDetailType = ModelDetailType.NB_PAIR_PROBABILITIES;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            if (this.getCompatibleModelsForSVMCoefficientsFromNode(node).isEmpty()) {
                miningAlgorithmType = MiningAlgorithmType.ALL;
                modelDetailType = ModelDetailType.MODEL_SIGNATURE;
            } else {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                if (MiningFunctionType.CLASSIFICATION.equals((Object)miningFunctionType)) {
                    modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
                } else if (MiningFunctionType.REGRESSION.equals((Object)miningFunctionType)) {
                    modelDetailType = ModelDetailType.SVMR_COEFFICIENTS;
                } else if (MiningFunctionType.ANOMALY_DETECTION.equals((Object)miningFunctionType)) {
                    modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
                }
            }
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
            modelDetailType = ModelDetailType.AR_RULES_STRING_VERSION;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.KMEANS, MiningAlgorithmType.O_CLUSTER, MiningAlgorithmType.EXPECTATION_MAXIMIZATION)) {
            miningAlgorithmType = MiningAlgorithmType.ALL;
            modelDetailType = ModelDetailType.CLUSTER_DETAILS;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR, MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS, MiningAlgorithmType.SINGULAR_VALUE_DECOMP, MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS)) {
            miningAlgorithmType = MiningAlgorithmType.ALL;
            modelDetailType = ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION;
        } else if (this.anyModelAlgorithmMatches(list, MiningAlgorithmType.R_EXTENSIBLE)) {
            miningAlgorithmType = MiningAlgorithmType.R_EXTENSIBLE;
            modelDetailType = ModelDetailType.R_MODEL_DETAILS;
        }
        if (miningFunctionType != null) {
            list = MiningFunctionType.CLUSTERING.equals((Object)miningFunctionType) ? this.getModelsFilteredByFunction(list, MiningFunctionType.CLUSTERING) : this.getModelsFilteredByAlgorithm(list, miningAlgorithmType);
            List<OutputAttributeType> list2 = ExtractQueryFactory.getModelColumnList(this, modelDetailType, this.dbVersion);
            models.getModel().addAll(list);
            modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(list2));
        }
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setType(modelDetailType);
        modelDetailsOutputType.setMiningFunction(miningFunctionType);
        modelDetailsOutputType.setMiningAlgorithm(miningAlgorithmType);
        modelDetailsOutputType.setAutoSpec(modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec());
        return modelDetailsOutputType;
    }

    private boolean isNodeUndefined() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType.Models models = modelDetailsDataNodeType.getModelDetailsOutput().getModels();
        List list = models.getModel();
        return list.isEmpty();
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        for (AttributeType attributeType : modelDetailsDataNodeType.getModelDetailsOutput().getAttributes().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
            attributeType2.setName(string);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    private ModelDetailsOutputType removeModels(Node node) {
        ModelDetailsOutputType modelDetailsOutputType = this.createDuplicateOutputType();
        List list = modelDetailsOutputType.getModels().getModel();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (RefModelType refModelType : list) {
            if (!refModelType.getNodeId().equals(node.getMetadataId())) continue;
            arrayList.add(refModelType);
        }
        list.removeAll(arrayList);
        return modelDetailsOutputType;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        ModelDetailsOutputType modelDetailsOutputType;
        super.handleRemoveConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)MetaDataHelper.copyMetadataObject(this.getData());
        if ("Yes".equals(modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec().value()) && (modelDetailsOutputType = this.removeModels(node)) != null) {
            if (modelDetailsOutputType.getModels().getModel().isEmpty()) {
                modelDetailsOutputType.setMiningAlgorithm(null);
                modelDetailsOutputType.setMiningFunction(null);
                modelDetailsOutputType.setType(null);
                modelDetailsOutputType.getAttributes().getAttribute().clear();
            }
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsOutputType);
        }
        this.validateNodeRemoval(node, false);
    }

    @Override
    public void setProperty(String string, Object object) {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        if (MODEL_DETAILS_MODELS.equals(string)) {
            ModelDetailsOutputType modelDetailsOutputType = (ModelDetailsOutputType)object;
            modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        } else if (MODEL_DETAILS_OUTPUT_COLUMNS.equals(string)) {
            ModelDetailsOutputType modelDetailsOutputType = (ModelDetailsOutputType)object;
            modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        } else if (SQL_EXPRESSION.equals(string)) {
            if (object != null && object.equals(SQL_EXPRESSION_GENERATE)) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (SQL_EXPRESSION.equals(complexProperty.getPropertyName())) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        if (MODEL_DETAILS_MODELS.equals(string)) {
            ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
            return modelDetailsOutputType;
        }
        if (MODEL_DETAILS_OUTPUT_COLUMNS.equals(string)) {
            ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
            return modelDetailsOutputType;
        }
        if (SQL_EXPRESSION.equals(string)) {
            String string2 = modelDetailsDataNodeType.getSQLExpression();
            return string2;
        }
        return super.getProperty(string);
    }

    @Override
    public String getHelpTopic() {
        return "modeldetails_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_MODEL_DETAILS_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_ICON"));
    }

    private void setARItemDetails(AssociationBuildNodeType associationBuildNodeType, ModelNodeType.Models.Model model) {
        if (model != null) {
            this.associationRulesSettings.setItemID(this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "ODMS_ITEM_ID_COLUMN_NAME"));
            if (StringUtils.isEmpty((String)this.associationRulesSettings.getItemID())) {
                this.associationRulesSettings.setItemValueType(ARNodeSettings.ARItemValueType.NOT_SET);
            } else {
                this.associationRulesSettings.setItemID(this.associationRulesSettings.getItemID().toUpperCase());
                String string = this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "ODMS_ITEM_VALUE_COLUMN_NAME");
                if (string != null) {
                    this.associationRulesSettings.setItemValueType(ARNodeSettings.ARItemValueType.CATEGORICAL);
                }
            }
        } else if (associationBuildNodeType != null) {
            this.associationRulesSettings.setItemID(associationBuildNodeType.getItemID().getName());
            if (StringUtils.isEmpty((String)this.associationRulesSettings.getItemID())) {
                this.associationRulesSettings.setItemValueType(ARNodeSettings.ARItemValueType.NOT_SET);
            } else {
                this.associationRulesSettings.setItemID(this.associationRulesSettings.getItemID().toUpperCase());
                AttributeType attributeType = associationBuildNodeType.getItemValue();
                this.associationRulesSettings.setItemValueType(attributeType == null ? ARNodeSettings.ARItemValueType.NOT_SET : ("NUMBER".equals(attributeType.getDataType()) ? ARNodeSettings.ARItemValueType.NUMERICAL : ARNodeSettings.ARItemValueType.CATEGORICAL));
            }
        }
    }

    public ARNodeSettings getARNodeSettings() {
        return this.associationRulesSettings;
    }

    private void setRModelOutputDefinition(RModelType rModelType, ModelNodeType.Models.Model model) {
        List<RModelType.DetailFunction.Output.Column> list = this.getRModelOutputSignature(rModelType, model);
        this.rModelOutputDefinition.clear();
        if (!list.isEmpty()) {
            this.rModelOutputDefinition.addAll(list);
        }
    }

    private List<RModelType.DetailFunction.Output.Column> getRModelOutputSignature(RModelType rModelType, ModelNodeType.Models.Model model) {
        String string2;
        Matcher matcher;
        if (rModelType != null && rModelType.getDetailFunction() != null && rModelType.getDetailFunction().getOutput() != null) {
            return rModelType.getDetailFunction().getOutput().getColumn();
        }
        if (model != null && (matcher = SELECT_FROM_DUAL_PATTERN.matcher(string2 = this.getModelSettingByName(model.getModelSettingsODM().getModelSettingODM(), "RALG_DETAILS_FORMAT"))).find()) {
            String string3 = matcher.group(1);
            List<RModelType.DetailFunction.Output.Column> list = Arrays.stream(string3.split(",")).filter(StringUtils::isNotEmpty).map(string -> {
                String string2 = string.trim();
                RModelType.DetailFunction.Output.Column column = null;
                Matcher matcher = VARCHAR2_TOKEN_PATTERN_1.matcher(string2);
                if (matcher.find()) {
                    column = new RModelType.DetailFunction.Output.Column();
                    column.setName(matcher.group(2));
                    column.setType(MiningDataType.VARCHAR_2);
                    column.setLength(new BigInteger(matcher.group(1)));
                } else {
                    matcher = VARCHAR2_TOKEN_PATTERN_2.matcher(string2);
                    if (matcher.find()) {
                        column = new RModelType.DetailFunction.Output.Column();
                        column.setName(matcher.group(2));
                        column.setType(MiningDataType.VARCHAR_2);
                    } else {
                        matcher = NUMBER_TOKEN_PATTERN.matcher(string2);
                        if (matcher.find()) {
                            column = new RModelType.DetailFunction.Output.Column();
                            column.setName(matcher.group(3));
                            column.setType(MiningDataType.NUMBER);
                        }
                    }
                }
                return column;
            }).filter(column -> column != null).collect(Collectors.toList());
            return list;
        }
        return Collections.emptyList();
    }

    public List<RModelType.DetailFunction.Output.Column> getRModelOutputDefinition() {
        return this.rModelOutputDefinition;
    }
}

