/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlCreatePgUtils {
    static List<String> getColumns(PgqlConnection pgqlConn, String tableOwner, String tableName) {
        ArrayList<String> columns = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT column_name FROM sys.all_tab_columns \nWHERE owner = ?\n AND table_name= ?";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, tableOwner);
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    columns.add(rs.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return columns;
    }

    static List<String> getPrimaryKey(PgqlConnection pgqlConn, ElementTable et) {
        SchemaQualifiedName tableName = et.getTableName();
        ArrayList<String> primaryKey = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT cls.column_name\nFROM sys.all_cons_columns cls, sys.all_constraints cst\nWHERE cls.owner = ?\n  AND cls.table_name = ?\n  AND cls.owner = cst.owner\n  AND cls.constraint_name = cst.constraint_name\n  AND cst.constraint_type = 'P'\nORDER BY 1";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, tableName.getSchemaName());
            ps.setString(2, tableName.getName());
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                primaryKey = new ArrayList<String>();
                do {
                    primaryKey.add(rs.getString(1));
                } while (rs.next());
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return primaryKey;
    }

    static List<List<String>> getForeignKeys(PgqlConnection pgqlConn, EdgeTable et, VertexTable vt) {
        SchemaQualifiedName vtName = vt.getTableName();
        SchemaQualifiedName etName = et.getTableName();
        ArrayList foreignKeys = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT edge_cols.constraint_name, edge_cols.column_name\nFROM sys.all_constraints vertex_cst, sys.all_constraints edge_cst, sys.all_cons_columns edge_cols\nWHERE vertex_cst.owner = ?\n  AND vertex_cst.table_name = ?\n  AND vertex_cst.owner=edge_cst.r_owner\n  AND vertex_cst.constraint_name=edge_cst.r_constraint_name\n  AND edge_cst.constraint_type='R'\n  AND edge_cst.constraint_name=edge_cols.constraint_name\n  AND edge_cols.owner = ?\n  AND edge_cst.table_name = ?\nORDER BY edge_cols.constraint_name, edge_cols.position";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, vtName.getSchemaName());
            ps.setString(2, vtName.getName());
            ps.setString(3, etName.getSchemaName());
            ps.setString(4, etName.getName());
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                foreignKeys = new ArrayList();
                String previousConstraint = "";
                ArrayList<String> currentForeignKey = null;
                do {
                    String currentConstraint;
                    if (!(currentConstraint = rs.getString(1)).equals(previousConstraint)) {
                        currentForeignKey = new ArrayList<String>();
                        foreignKeys.add(currentForeignKey);
                        previousConstraint = currentConstraint;
                    }
                    currentForeignKey.add(rs.getString(2));
                } while (rs.next());
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return foreignKeys;
    }

    static boolean existsGraph(PgqlConnection pgqlConn, String graphOwner, String graphName) {
        return PgqlUtils.getGraphType(pgqlConn.getJdbcConnection(), graphOwner, graphName, false) != null;
    }

    /*
     * Loose catch block
     */
    static boolean existsTableOrView(PgqlConnection pgqlConn, String objectOwner, String objectName) {
        boolean bl;
        PreparedStatement ps;
        ResultSet rs;
        block10: {
            String query = "SELECT count(*) FROM SYS.ALL_OBJECTS\nWHERE OWNER = ?\n  AND OBJECT_TYPE IN ('TABLE', 'VIEW')  AND OBJECT_NAME = ?";
            rs = null;
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, objectOwner);
            ps.setString(2, objectName);
            rs = ps.executeQuery();
            rs.next();
            boolean bl2 = bl = rs.getInt(1) > 0;
            if (ps == null) break block10;
            ps.close();
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new PgqlToSqlException(ex);
                    }
                }
                catch (Throwable throwable3) {
                    DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
                    throw throwable3;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    static boolean existsColumn(PgqlConnection pgqlConn, String tableOwner, String tableName, String columnName) {
        boolean bl;
        PreparedStatement ps;
        ResultSet rs;
        block10: {
            String query = "SELECT count(*) FROM SYS.ALL_TAB_COLS\nWHERE OWNER = ?\n  AND TABLE_NAME = ?\n  AND COLUMN_NAME = ?";
            rs = null;
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, tableOwner);
            ps.setString(2, tableName);
            ps.setString(3, columnName);
            rs = ps.executeQuery();
            rs.next();
            boolean bl2 = bl = rs.getInt(1) > 0;
            if (ps == null) break block10;
            ps.close();
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new PgqlToSqlException(ex);
                    }
                }
                catch (Throwable throwable3) {
                    DbmsUtils.quietlyCloseResultSetAndStmt(rs, null);
                    throw throwable3;
                }
            }
        }
    }
}

